/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.Profiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Clock;
import jpcsp.Debugger.InstructionCounter;
import jpcsp.Debugger.StepLogger;
import jpcsp.GUI.IMainGUI;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.Loader;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.Processor;
import jpcsp.Resource;
import jpcsp.State;
import jpcsp.graphics.GEProfiler;
import jpcsp.graphics.RE.software.BasePrimitiveRenderer;
import jpcsp.graphics.RE.software.BaseRenderer;
import jpcsp.graphics.RE.software.RendererExecutor;
import jpcsp.graphics.VertexCache;
import jpcsp.hardware.Battery;
import jpcsp.hardware.Interrupts;
import jpcsp.hardware.Wlan;
import jpcsp.memory.MemorySections;
import jpcsp.scheduler.Scheduler;
import jpcsp.sound.SoundChannel;
import jpcsp.util.JpcspDialogManager;
import org.apache.log4j.Logger;

public class Emulator
implements Runnable {
    private static Emulator instance;
    private static Processor processor;
    private static Clock clock;
    private static Scheduler scheduler;
    private boolean moduleLoaded;
    private Thread mainThread;
    public static boolean run;
    public static boolean pause;
    private static IMainGUI gui;
    private InstructionCounter instructionCounter;
    public static Logger log;
    private SceModule module;
    private int firmwareVersion = 150;
    private String[] bootModuleBlackList = new String[]{"Prometheus Loader"};
    public static final int EMU_STATUS_OK = 0;
    public static final int EMU_STATUS_UNKNOWN = -1;
    public static final int EMU_STATUS_WDT_IDLE = 1;
    public static final int EMU_STATUS_WDT_HOG = 2;
    public static final int EMU_STATUS_WDT_ANY = 3;
    public static final int EMU_STATUS_MEM_READ = 4;
    public static final int EMU_STATUS_MEM_WRITE = 8;
    public static final int EMU_STATUS_MEM_ANY = 12;
    public static final int EMU_STATUS_BREAKPOINT = 16;
    public static final int EMU_STATUS_UNIMPLEMENTED = 32;
    public static final int EMU_STATUS_PAUSE = 64;
    public static final int EMU_STATUS_JUMPSELF = 128;

    public Emulator(IMainGUI gui) {
        Emulator.gui = gui;
        processor = new Processor();
        clock = new Clock();
        scheduler = Scheduler.getInstance();
        this.moduleLoaded = false;
        this.mainThread = new Thread((Runnable)this, "Emu");
        instance = this;
    }

    public Thread getMainThread() {
        return this.mainThread;
    }

    public static void exit() {
        RendererExecutor.exit();
        VertexCache.getInstance().exit();
        Compiler.exit();
        RuntimeContext.exit();
        Profiler.exit();
        GEProfiler.exit();
        BaseRenderer.exit();
        BasePrimitiveRenderer.exit();
        SoundChannel.exit();
    }

    private boolean isBootModuleBad(String name) {
        for (String moduleName : this.bootModuleBlackList) {
            if (!name.equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    public SceModule load(String pspfilename, ByteBuffer f) throws IOException, GeneralJpcspException {
        return this.load(pspfilename, f, false);
    }

    public SceModule load(String pspfilename, ByteBuffer f, boolean fromSyscall) throws IOException, GeneralJpcspException {
        this.initNewPsp();
        this.module = Loader.getInstance().LoadModule(pspfilename, f, 0x8804000, false);
        if ((this.module.fileFormat & 1) != 1) {
            throw new GeneralJpcspException(Resource.get("FileFormatNotSupported"));
        }
        if (this.isBootModuleBad(this.module.modname)) {
            JpcspDialogManager.showError(null, Resource.get("prometheusLoader"));
        }
        this.moduleLoaded = true;
        this.initCpu(fromSyscall);
        if (State.debugger != null) {
            State.debugger.resetDebugger();
        }
        if (this.instructionCounter != null) {
            this.instructionCounter.setModule(this.module);
        }
        return this.module;
    }

    private void initCpu(boolean fromSyscall) {
        RuntimeContext.update();
        CpuState cpu = Emulator.processor.cpu;
        int entryAddr = this.module.entry_addr;
        if (Memory.isAddressGood(this.module.module_start_func) && this.module.module_start_func != entryAddr) {
            log.warn((Object)String.format("Using the module start function as module entry: 0x%08X instead of 0x%08X", this.module.module_start_func, entryAddr));
            entryAddr = this.module.module_start_func;
        }
        cpu.pc = entryAddr;
        cpu.npc = cpu.pc + 4;
        cpu.gpr[27] = 0;
        cpu.gpr[28] = this.module.gp_value;
        HLEModuleManager.getInstance().startModules();
        Modules.ThreadManForUserModule.Initialise(this.module, cpu.pc, this.module.attribute, this.module.pspfilename, this.module.modid, fromSyscall);
        if (State.memoryViewer != null) {
            State.memoryViewer.RefreshMemory();
        }
    }

    private void initNewPsp() {
        this.moduleLoaded = false;
        HLEModuleManager.getInstance().stopModules();
        RuntimeContext.reset();
        Profiler.reset();
        GEProfiler.reset();
        Emulator.getClock().reset();
        Emulator.getProcessor().reset();
        Emulator.getScheduler().reset();
        Memory.getInstance().Initialise();
        Battery.initialize();
        Interrupts.initialize();
        Wlan.initialize();
        SceModule.ResetAllocator();
        SceUidManager.reset();
        HLEUidObjectMapping.reset();
        NIDMapper.getInstance().Initialise();
        Loader.getInstance().reset();
        State.fileLogger.resetLogging();
        MemorySections.getInstance().reset();
        HLEModuleManager.getInstance().Initialise(this.firmwareVersion);
        Managers.reset();
        Modules.SysMemUserForUserModule.start();
        Modules.SysMemUserForUserModule.setFirmwareVersion(this.firmwareVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RuntimeContext.start();
        GEProfiler.initialise();
        clock.resume();
        while (true) {
            if (pause) {
                clock.pause();
                try {
                    Emulator emulator = this;
                    synchronized (emulator) {
                        while (pause) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                clock.resume();
            }
            if (RuntimeContext.isCompilerEnabled()) {
                RuntimeContext.run();
                continue;
            }
            processor.step();
            Modules.sceGe_userModule.step();
            Modules.ThreadManForUserModule.step();
            scheduler.step();
            Modules.sceDisplayModule.step();
            if (State.debugger == null) continue;
            State.debugger.step();
        }
    }

    public synchronized void RunEmu() {
        if (!this.moduleLoaded) {
            log.debug((Object)"Nothing loaded, can't run...");
            gui.RefreshButtons();
            return;
        }
        if (pause) {
            pause = false;
            this.notifyAll();
        } else if (!run) {
            run = true;
            this.mainThread.start();
        }
        Modules.sceDisplayModule.setGeDirty(true);
        gui.RefreshButtons();
        if (State.debugger != null) {
            State.debugger.RefreshButtons();
        }
    }

    private static void PauseEmu(boolean hasStatus, int status) {
        if (run && !pause) {
            pause = true;
            gui.RefreshButtons();
            if (State.debugger != null) {
                State.debugger.RefreshButtons();
                State.debugger.SafeRefreshDebugger(true);
            }
            if (State.memoryViewer != null) {
                State.memoryViewer.RefreshMemory();
            }
            if (State.imageViewer != null) {
                State.imageViewer.refreshImage();
            }
            if (hasStatus) {
                StepLogger.setStatus(status);
            }
            StepLogger.flush();
        }
    }

    public static synchronized void PauseEmu() {
        Emulator.PauseEmu(false, 0);
    }

    public static synchronized void PauseEmuWithStatus(int status) {
        Emulator.PauseEmu(true, status);
    }

    public static void setFpsTitle(String fps) {
        gui.setMainTitle(fps);
    }

    public static Processor getProcessor() {
        return processor;
    }

    public static Memory getMemory() {
        return Memory.getInstance();
    }

    public static Clock getClock() {
        return clock;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public static IMainGUI getMainGUI() {
        return gui;
    }

    public static Emulator getInstance() {
        return instance;
    }

    public void setInstructionCounter(InstructionCounter instructionCounter) {
        this.instructionCounter = instructionCounter;
        instructionCounter.setModule(this.module);
    }

    public int getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(int firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        NIDMapper.getInstance().Initialise();
        HLEModuleManager.getInstance().Initialise(this.firmwareVersion);
        Modules.SysMemUserForUserModule.setFirmwareVersion(this.firmwareVersion);
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.setFirmwareVersion(HLEModuleManager.psfFirmwareVersionToInt(firmwareVersion));
    }

    static {
        run = false;
        pause = false;
        log = Logger.getLogger((String)"emu");
    }
}

