/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.connector.AtracCodec;
import jpcsp.settings.AbstractBoolSettingsListener;
import org.apache.log4j.Logger;

public class sceAtrac3plus
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceAtrac3plus");
    protected static final String idPurpose = "sceAtrac3plus";
    protected static final int AT3_MAGIC = 624;
    protected static final int AT3_PLUS_MAGIC = 65534;
    public static final int RIFF_MAGIC = 1179011410;
    protected static final int WAVE_MAGIC = 1163280727;
    public static final int FMT_CHUNK_MAGIC = 544501094;
    protected static final int FACT_CHUNK_MAGIC = 1952670054;
    protected static final int SMPL_CHUNK_MAGIC = 1819307379;
    public static final int DATA_CHUNK_MAGIC = 1635017060;
    public static final int PSP_ATRAC_ALLDATA_IS_ON_MEMORY = -1;
    public static final int PSP_ATRAC_NONLOOP_STREAM_DATA_IS_ON_MEMORY = -2;
    public static final int PSP_ATRAC_LOOP_STREAM_DATA_IS_ON_MEMORY = -3;
    protected static final int PSP_ATRAC_STATUS_NONLOOP_STREAM_DATA = 0;
    protected static final int PSP_ATRAC_STATUS_LOOP_STREAM_DATA = 1;
    protected static final int PSP_MODE_AT_3_PLUS = 4096;
    protected static final int PSP_MODE_AT_3 = 4097;
    protected int atrac3MaxIDsCount = 2;
    protected int atrac3plusMaxIDsCount = 2;
    protected int atrac3Num;
    protected int atrac3plusNum;
    protected static final int atracDecodeDelay = 2300;
    public static boolean useAtracCodec = false;
    protected HashMap<Integer, AtracID> atracIDs;
    protected static final int atracIDMask = 255;

    @Override
    public String getName() {
        return idPurpose;
    }

    @Override
    public void start() {
        this.atracIDs = new HashMap();
        this.setSettingsListener("emu.useConnector", new EnableConnectorSettingsListener());
        super.start();
    }

    public static boolean isEnableConnector() {
        return useAtracCodec;
    }

    private static void setEnableConnector(boolean useConnector) {
        useAtracCodec = useConnector;
    }

    protected String getStringFromInt32(int n) {
        char c1 = (char)(n & 0xFF);
        char c2 = (char)(n >> 8 & 0xFF);
        char c3 = (char)(n >> 16 & 0xFF);
        char c4 = (char)(n >> 24 & 0xFF);
        return String.format("%c%c%c%c", Character.valueOf(c1), Character.valueOf(c2), Character.valueOf(c3), Character.valueOf(c4));
    }

    public int getBytesPerFrame(int atID) {
        return this.atracIDs.get(atID).getAtracBytesPerFrame();
    }

    protected int getRemainFrames(AtracID id) {
        return this.getRemainFrames(id, id.getMaxSamples());
    }

    protected int getRemainFrames(AtracID id, int samples) {
        id.update();
        int remainFrames = id.getRemainFrames();
        if (id.getInputFileOffset() < id.getInputFileSize()) {
            if (remainFrames > 0 && samples < id.getMaxSamples()) {
                id.setInputBufferOffset(id.getInputBufferSize());
                remainFrames = 0;
            } else if (id.getAtracCodec().getChannelLength() <= 0) {
                id.setInputBufferOffset(id.getInputBufferSize());
                remainFrames = 0;
            }
        }
        return remainFrames;
    }

    protected void hleAtracReinit(int newAT3IdCount, int newAT3plusIdCount) {
        this.atrac3MaxIDsCount = newAT3IdCount;
        this.atrac3plusMaxIDsCount = newAT3plusIdCount;
    }

    protected int hleCreateAtracID(int codecType) {
        AtracCodec atracCodec;
        int atracID = SceUidManager.getNewId(idPurpose, 0, 255);
        AtracID id = new AtracID(atracID, codecType, atracCodec = new AtracCodec());
        if (id.getAtracId() >= 0) {
            this.atracIDs.put(atracID, id);
            return atracID;
        }
        return -2140995581;
    }

    protected void hleReleaseAtracID(int atracID) {
        AtracID id = this.atracIDs.remove(atracID);
        SceUidManager.releaseId(atracID, idPurpose);
        id.release();
    }

    public static int getCodecType(int address) {
        int at3magic = Memory.getInstance().read16(address + 20);
        if (at3magic == 624) {
            return 4097;
        }
        if (at3magic == 65534) {
            return 4096;
        }
        return 0;
    }

    @HLEFunction(nid=-772431909, version=150, checkInsideInterrupt=true)
    public void sceAtracStartEntry(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceAtracStartEntry [0xD1F59FDB]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-708670272, version=150, checkInsideInterrupt=true)
    public void sceAtracEndEntry(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceAtracEndEntry [0xD5C28CC0]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=2014283985, version=150, checkInsideInterrupt=true)
    public void sceAtracGetAtracID(Processor processor) {
        CpuState cpu = processor.cpu;
        int codecType = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceAtracGetAtracID: codecType = 0x" + Integer.toHexString(codecType)));
        }
        cpu.gpr[2] = this.hleCreateAtracID(codecType);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetAtracID: returning atracID=0x%08X", cpu.gpr[2]));
        }
    }

    @HLEFunction(nid=1642804213, version=150, checkInsideInterrupt=true)
    public void sceAtracReleaseAtracID(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceAtracReleaseAtracID: atracID = " + atID));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracReleaseAtracID: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            AtracCodec atracCodec = this.atracIDs.get(atID).getAtracCodec();
            if (atracCodec != null) {
                atracCodec.finish();
            }
            this.hleReleaseAtracID(atID);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=237663147, version=150, checkInsideInterrupt=true)
    public void sceAtracSetData(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        int buffer = cpu.gpr[5];
        int bufferSize = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetData: atID = %d, buffer = 0x%08X, bufferSize = 0x%08X", atID, buffer, bufferSize));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracSetData: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            this.atracIDs.get(atID).setData(buffer, bufferSize, bufferSize, false);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1064183477, version=150, checkInsideInterrupt=true)
    public void sceAtracSetHalfwayBuffer(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        int halfBuffer = cpu.gpr[5];
        int readSize = cpu.gpr[6];
        int halfBufferSize = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetHalfwayBuffer: atID = %d, buffer = 0x%08X, readSize = 0x%08X, bufferSize = 0x%08X", atID, halfBuffer, readSize, halfBufferSize));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracSetHalfwayBuffer: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            this.atracIDs.get(atID).setData(halfBuffer, readSize, halfBufferSize, false);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=2048976815, version=150, checkInsideInterrupt=true)
    public void sceAtracSetDataAndGetID(Processor processor) {
        int codecType;
        CpuState cpu = processor.cpu;
        int buffer = cpu.gpr[4];
        int bufferSize = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetDataAndGetID buffer = 0x%08X, bufferSize = 0x%08X", buffer, bufferSize));
        }
        int atID = 0;
        if (Memory.isAddressGood(buffer) && this.atracIDs.containsKey(atID = this.hleCreateAtracID(codecType = sceAtrac3plus.getCodecType(buffer)))) {
            this.atracIDs.get(atID).setData(buffer, bufferSize, bufferSize, false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetDataAndGetID returning atracID=0x%08X", atID));
        }
        cpu.gpr[2] = atID;
    }

    @HLEFunction(nid=263075598, version=150, checkInsideInterrupt=true)
    public void sceAtracSetHalfwayBufferAndGetID(Processor processor) {
        int codecType;
        CpuState cpu = processor.cpu;
        int halfBuffer = cpu.gpr[4];
        int readSize = cpu.gpr[5];
        int halfBufferSize = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetHalfwayBufferAndGetID buffer = 0x%08X, readSize = 0x%08X, bufferSize = 0x%08X", halfBuffer, readSize, halfBufferSize));
        }
        int atID = 0;
        if (Memory.isAddressGood(halfBuffer) && this.atracIDs.containsKey(atID = this.hleCreateAtracID(codecType = sceAtrac3plus.getCodecType(halfBuffer)))) {
            this.atracIDs.get(atID).setData(halfBuffer, readSize, halfBufferSize, false);
        }
        cpu.gpr[2] = atID;
    }

    @HLEFunction(nid=1787575509, version=150, checkInsideInterrupt=true)
    public void sceAtracDecodeData(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int atID = cpu.gpr[4] & 0xFF;
        int samplesAddr = cpu.gpr[5];
        int samplesNbrAddr = cpu.gpr[6];
        int outEndAddr = cpu.gpr[7];
        int remainFramesAddr = cpu.gpr[8];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracDecodeData: atracID=%d, samplesAddr=0x%08X, samplesNbrAddr=0x%08X, outEndAddr=0x%08X, remainFramesAddr=0x%08X", atID, samplesAddr, samplesNbrAddr, outEndAddr, remainFramesAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracDecodeData: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else if (this.atracIDs.get(atID).isSecondBufferNeeded() && !this.atracIDs.get(atID).isSecondBufferSet()) {
            log.warn((Object)("sceAtracDecodeData: atracID= " + atID + ", needs second buffer!"));
            cpu.gpr[2] = -2140995566;
        } else {
            AtracID id = this.atracIDs.get(atID);
            int result = 0;
            AtracCodec atracCodec = id.getAtracCodec();
            int samples = 0;
            int end = 1;
            if (id.isForceReloadOfData()) {
                result = -2140995549;
                end = 0;
            } else if (atracCodec != null) {
                samples = atracCodec.atracDecodeData(atID, samplesAddr);
                if (samples < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"sceAtracDecodeData faked samples");
                    }
                    samples = id.getMaxSamples();
                    if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
                        samples = 0;
                        result = -2140995548;
                        end = 1;
                    } else {
                        end = 0;
                    }
                    if (Memory.isAddressGood(samplesAddr)) {
                        mem.memset(samplesAddr, (byte)0, samples * 4);
                    }
                } else if (samples == 0) {
                    result = -2140995548;
                    end = 1;
                } else {
                    end = atracCodec.getAtracEnd();
                }
            }
            if (samples > 0) {
                int consumedInputBytes = id.getAtracBytesPerFrame();
                if (consumedInputBytes < 0) {
                    consumedInputBytes = 0;
                } else if (id.getInputBufferOffset() + consumedInputBytes > id.getInputBufferSize()) {
                    consumedInputBytes = id.getInputBufferSize() - id.getInputBufferOffset();
                }
                id.setInputBufferOffset(id.getInputBufferOffset() + consumedInputBytes);
            }
            if (samples > 0) {
                id.setDecodedSamples(samples);
                if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
                    end = 1;
                }
            }
            int remainFrames = end == 1 ? -1 : this.getRemainFrames(id, samples);
            if (Memory.isAddressGood(samplesNbrAddr)) {
                mem.write32(samplesNbrAddr, samples);
            }
            if (Memory.isAddressGood(outEndAddr)) {
                mem.write32(outEndAddr, end);
            }
            if (Memory.isAddressGood(remainFramesAddr)) {
                mem.write32(remainFramesAddr, remainFrames);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAtracDecodeData returning 0x%08X, samples=%d, end=%d, remainFrames=%d, currentSample=%d/%d, %s", result, samples, end, remainFrames, id.getAtracCurrentSample(), id.getAtracEndSample(), id.toString()));
            }
            cpu.gpr[2] = result;
            if (result == 0) {
                Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
            }
        }
    }

    @HLEFunction(nid=-1696052825, version=150, checkInsideInterrupt=true)
    public void sceAtracGetRemainFrame(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int atID = cpu.gpr[4] & 0xFF;
        int remainFramesAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetRemainFrame: atracID = %d, remainFramesAddr = 0x%08X", atID, remainFramesAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetRemainFrame: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            AtracID id = this.atracIDs.get(atID);
            int remainFrames = this.getRemainFrames(id);
            if (Memory.isAddressGood(remainFramesAddr)) {
                mem.write32(remainFramesAddr, remainFrames);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAtracGetRemainFrame: returning %d, %s", remainFrames, id.toString()));
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1562806023, version=150, checkInsideInterrupt=true)
    public void sceAtracGetStreamDataInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int atID = cpu.gpr[4] & 0xFF;
        int writeAddr = cpu.gpr[5];
        int writableBytesAddr = cpu.gpr[6];
        int readOffsetAddr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetStreamDataInfo: atID=%d, writeAddr=0x%08X, writableBytesAddr=0x%08X, readOffsetAddr=0x%08X", atID, writeAddr, writableBytesAddr, readOffsetAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetStreamDataInfo: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            AtracID id = this.atracIDs.get(atID);
            id.update();
            if (Memory.isAddressGood(writeAddr)) {
                mem.write32(writeAddr, id.getInputBufferAddr());
            }
            if (Memory.isAddressGood(writableBytesAddr)) {
                mem.write32(writableBytesAddr, id.getInputBufferWritableBytes());
            }
            if (Memory.isAddressGood(readOffsetAddr)) {
                mem.write32(readOffsetAddr, id.getInputFileOffset());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAtracGetStreamDataInfo: write=0x%08X, writableBytes=%d, readOffset=%d, %s", mem.read32(writeAddr), mem.read32(writableBytesAddr), mem.read32(readOffsetAddr), id.toString()));
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=2108887633, version=150, checkInsideInterrupt=true)
    public void sceAtracAddStreamData(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        int bytesToAdd = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracAddStreamData: atracID=%d, bytesToAdd=0x%x", atID, bytesToAdd));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracAddStreamData: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            this.atracIDs.get(atID).addStreamData(bytesToAdd);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAtracAddStreamData: %s", this.atracIDs.get(atID).toString()));
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-2081923424, version=150, checkInsideInterrupt=true)
    public void sceAtracGetSecondBufferInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int atID = cpu.gpr[4] & 0xFF;
        int outPosition = cpu.gpr[5];
        int outBytes = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceAtracGetSecondBufferInfo: atracID = " + atID + ", outPos=0x" + Integer.toHexString(outPosition) + ", outBytes=0x" + Integer.toHexString(outBytes)));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetSecondBufferInfo: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else if (this.atracIDs.get(atID).isSecondBufferNeeded()) {
            if (Memory.isAddressGood(outPosition) && Memory.isAddressGood(outBytes)) {
                mem.write32(outPosition, this.atracIDs.get(atID).getSecondInputFileOffset());
                mem.write32(outBytes, this.atracIDs.get(atID).getSecondInputFileSize());
            }
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2140995550;
        }
    }

    @HLEFunction(nid=-2084603139, version=150, checkInsideInterrupt=true)
    public void sceAtracSetSecondBuffer(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        int secondBuffer = cpu.gpr[5];
        int secondBufferSize = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetSecondBuffer: atID = %d, buffer = 0x%08X, bufferSize = 0x%08X", atID, secondBuffer, secondBufferSize));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracSetSecondBuffer: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            this.atracIDs.get(atID).setData(secondBuffer, secondBufferSize, secondBufferSize, true);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-499238347, version=150, checkInsideInterrupt=true)
    public void sceAtracGetNextDecodePosition(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int atID = cpu.gpr[4] & 0xFF;
        int posAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetNextDecodePosition atracID = %d, posAddr = 0x%08X", atID, posAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetNextDecodePosition: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            AtracID id = this.atracIDs.get(atID);
            if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
                cpu.gpr[2] = -2140995548;
            } else {
                mem.write32(posAddr, id.getAtracCurrentSample());
                cpu.gpr[2] = 0;
            }
        }
    }

    @HLEFunction(nid=-1564759874, version=150, checkInsideInterrupt=true)
    public void sceAtracGetSoundSample(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int atID = cpu.gpr[4] & 0xFF;
        int endSampleAddr = cpu.gpr[5];
        int loopStartSampleAddr = cpu.gpr[6];
        int loopEndSampleAddr = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetSoundSample atracID = %d, endSampleAddr = 0x%08X, loopStartSampleAddr = 0x%08X, loopEndSampleAddr = 0x%08X", atID, endSampleAddr, loopStartSampleAddr, loopEndSampleAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetSoundSample: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            AtracID id = this.atracIDs.get(atID);
            int endSample = id.getAtracEndSample();
            int loopStartSample = id.getLoopStartSample();
            int loopEndSample = id.getLoopEndSample();
            if (endSample < 0) {
                endSample = id.getAtracCodec().getAtracEndSample();
            }
            if (endSample < 0) {
                endSample = id.getInputFileSize();
            }
            mem.write32(endSampleAddr, endSample);
            mem.write32(loopStartSampleAddr, loopStartSample);
            mem.write32(loopEndSampleAddr, loopEndSample);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=828804010, version=150, checkInsideInterrupt=true)
    public void sceAtracGetChannel(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int atID = cpu.gpr[4] & 0xFF;
        int channelAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceAtracGetChannel: atracID = " + atID + ", channelAddr =0x" + Integer.toHexString(channelAddr)));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetChannel: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            mem.write32(channelAddr, this.atracIDs.get(atID).getAtracChannels());
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-693767433, version=150, checkInsideInterrupt=true)
    public void sceAtracGetMaxSample(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int atID = cpu.gpr[4] & 0xFF;
        int maxSamplesAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetMaxSample: atracID = %d, maxSamplesAddr = 0x%08X", atID, maxSamplesAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetMaxSample: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            if (Memory.isAddressGood(maxSamplesAddr)) {
                mem.write32(maxSamplesAddr, this.atracIDs.get(atID).getMaxSamples());
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=922397691, version=150, checkInsideInterrupt=true)
    public void sceAtracGetNextSample(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int atID = cpu.gpr[4] & 0xFF;
        int nbrSamplesAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetNextSample: atracID=%d, nbrSamplesAddr=0x%08x", atID, nbrSamplesAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetNextSample: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            AtracID id = this.atracIDs.get(atID);
            int samples = id.getMaxSamples();
            if (id.getInputBufferOffset() >= id.getInputBufferSize()) {
                samples = 0;
            }
            if (Memory.isAddressGood(nbrSamplesAddr)) {
                mem.write32(nbrSamplesAddr, samples);
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-1521180328, version=150, checkInsideInterrupt=true)
    public void sceAtracGetBitrate(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int atID = cpu.gpr[4] & 0xFF;
        int bitrateAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceAtracGetBitrate: atracID = " + atID + ", bitrateAddr =0x" + Integer.toHexString(bitrateAddr)));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetBitrate: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            mem.write32(bitrateAddr, this.atracIDs.get(atID).getAtracBitrate());
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-89851749, version=150, checkInsideInterrupt=true)
    public void sceAtracGetLoopStatus(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int atID = cpu.gpr[4] & 0xFF;
        int loopNbr = cpu.gpr[5];
        int statusAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetLoopStatus atracID=%d, loopNbr=0x%08x, statusAddr=0x%08X", atID, loopNbr, statusAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetLoopStatus: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            if (Memory.isAddressGood(loopNbr)) {
                mem.write32(loopNbr, this.atracIDs.get(atID).getLoopNum());
            }
            if (Memory.isAddressGood(statusAddr)) {
                mem.write32(statusAddr, this.atracIDs.get(atID).getLoopStatus());
            }
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-2038357835, version=150, checkInsideInterrupt=true)
    public void sceAtracSetLoopNum(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        int loopNbr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceAtracSetLoopNum: atracID = " + atID + ", loopNbr = " + loopNbr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracSetLoopNum: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            this.atracIDs.get(atID).setLoopNum(loopNbr);
            this.atracIDs.get(atID).getAtracCodec().setAtracLoopCount(loopNbr);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-901995566, version=150, checkInsideInterrupt=true)
    public void sceAtracGetBufferInfoForReseting(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        int sample = cpu.gpr[5];
        int bufferInfoAddr = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetBufferInfoForReseting atracID=%d, sample=%d, bufferInfoAddr=0x%08x", atID, sample, bufferInfoAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetBufferInfoForReseting: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            this.atracIDs.get(atID).getBufferInfoForReseting(sample, bufferInfoAddr);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=1682855431, version=150, checkInsideInterrupt=true)
    public void sceAtracResetPlayPosition(Processor processor) {
        CpuState cpu = processor.cpu;
        int atID = cpu.gpr[4] & 0xFF;
        int sample = cpu.gpr[5];
        int bytesWrittenFirstBuf = cpu.gpr[6];
        int bytesWrittenSecondBuf = cpu.gpr[7];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracResetPlayPosition atracId=%d, sample=%d, bytesWrittenFirstBuf=%d, bytesWrittenSecondBuf=%d", atID, sample, bytesWrittenFirstBuf, bytesWrittenSecondBuf));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracResetPlayPosition: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            AtracID id = this.atracIDs.get(atID);
            id.setPlayPosition(sample, bytesWrittenFirstBuf, bytesWrittenSecondBuf);
            cpu.gpr[2] = 0;
        }
    }

    @HLEFunction(nid=-393251429, version=150, checkInsideInterrupt=true)
    public void sceAtracGetInternalErrorInfo(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Memory.getInstance();
        int atID = cpu.gpr[4] & 0xFF;
        int errorAddr = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetInternalErrorInfo atracId=%d, errorAddr=0x%08X", atID, errorAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetInternalErrorInfo: bad atracID= " + atID));
            cpu.gpr[2] = -2140995579;
        } else {
            mem.write32(errorAddr, this.atracIDs.get(atID).getInternalErrorInfo());
            cpu.gpr[2] = 0;
        }
    }

    private static class EnableConnectorSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableConnectorSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAtrac3plus.setEnableConnector(value);
        }
    }

    protected class AtracID {
        protected int id;
        protected int codecType;
        protected AtracCodec atracCodec;
        protected int atracBitrate = 64;
        protected int atracChannels = 2;
        protected int atracSampleRate = 44100;
        protected int atracBytesPerFrame = 560;
        protected int atracEndSample;
        protected int atracCurrentSample;
        protected int maxSamples;
        protected int atracSampleOffset;
        protected int inputBufferAddr;
        protected int inputBufferSize;
        protected int inputBufferOffset;
        protected int inputBufferWritableBytes;
        protected int inputBufferNeededBytes;
        protected int secondInputBufferAddr;
        protected int secondInputBufferSize;
        protected int secondInputBufferOffset;
        protected int secondInputBufferWritableBytes;
        protected int secondInputBufferNeededBytes;
        protected int inputFileSize;
        protected int inputFileOffset;
        protected int secondInputFileSize;
        protected int secondInputFileOffset;
        protected boolean isSecondBufferNeeded;
        protected boolean isSecondBufferSet;
        protected int internalErrorInfo;
        protected int loopNum;
        protected int numLoops;
        protected LoopInfo[] loops;
        protected int loopStartBytesWrittenFirstBuf;
        protected int loopStartBytesWrittenSecondBuf;
        protected int currentLoopNum = -1;
        protected boolean forceReloadOfData;
        protected boolean forceAllDataIsOnMemory;

        public AtracID(int id, int codecType, AtracCodec atracCodec) {
            this.codecType = codecType;
            this.id = id;
            this.atracCodec = atracCodec;
            if (codecType == 4097 && sceAtrac3plus.this.atrac3Num < sceAtrac3plus.this.atrac3MaxIDsCount) {
                ++sceAtrac3plus.this.atrac3Num;
                this.maxSamples = 1024;
                atracCodec.setAtracMaxSamples(this.maxSamples);
            } else if (codecType == 4096 && sceAtrac3plus.this.atrac3plusNum < sceAtrac3plus.this.atrac3plusMaxIDsCount) {
                ++sceAtrac3plus.this.atrac3plusNum;
                this.maxSamples = 2048;
                atracCodec.setAtracMaxSamples(this.maxSamples);
            } else {
                this.id = -1;
                this.atracCodec = null;
                this.maxSamples = 0;
            }
        }

        public void release() {
            if (this.id >= 0) {
                if (this.codecType == 4097) {
                    --sceAtrac3plus.this.atrac3Num;
                } else if (this.codecType == 4096) {
                    --sceAtrac3plus.this.atrac3plusNum;
                }
            }
        }

        private void analyzeAtracHeader() {
            Memory mem = Memory.getInstance();
            int currentAddr = this.inputBufferAddr;
            int bufferSize = this.inputBufferSize;
            this.atracEndSample = -1;
            this.atracCurrentSample = 0;
            this.isSecondBufferNeeded = false;
            this.numLoops = 0;
            if (bufferSize < 12) {
                log.error((Object)String.format("Atrac buffer too small %d", bufferSize));
                return;
            }
            int RIFFMagic = mem.read32(currentAddr);
            int WAVEMagic = mem.read32(currentAddr + 8);
            if (RIFFMagic != 1179011410 || WAVEMagic != 1163280727) {
                log.error((Object)String.format("Not a RIFF/WAVE format! %08X %08X", RIFFMagic, WAVEMagic));
                return;
            }
            this.inputFileSize = mem.read32(currentAddr + 4) + 8;
            currentAddr += 12;
            bufferSize -= 12;
            boolean foundData = false;
            while (bufferSize >= 8 && !foundData) {
                int chunkMagic = mem.read32(currentAddr);
                int chunkSize = mem.read32(currentAddr + 4);
                currentAddr += 8;
                if (chunkSize > (bufferSize -= 8)) break;
                switch (chunkMagic) {
                    case 544501094: {
                        if (chunkSize < 16) break;
                        int compressionCode = mem.read16(currentAddr);
                        this.atracChannels = mem.read16(currentAddr + 2);
                        this.atracSampleRate = mem.read32(currentAddr + 4);
                        this.atracBitrate = mem.read32(currentAddr + 8);
                        this.atracBytesPerFrame = mem.read16(currentAddr + 12);
                        int hiBytesPerSample = mem.read16(currentAddr + 14);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("WAVE format: magic=0x%08X('%s'), chunkSize=%d, compressionCode=0x%04X, channels=%d, sampleRate=%d, bitrate=%d, chunkAlign=%d, hiBytesPerSample=%d", chunkMagic, sceAtrac3plus.this.getStringFromInt32(chunkMagic), chunkSize, compressionCode, this.atracChannels, this.atracSampleRate, this.atracBitrate, this.atracBytesPerFrame, hiBytesPerSample));
                        StringBuilder restChunk = new StringBuilder();
                        for (int i = 16; i < chunkSize; ++i) {
                            int b = mem.read8(currentAddr + i);
                            restChunk.append(String.format(" %02X", b));
                        }
                        if (restChunk.length() <= 0) break;
                        log.debug((Object)String.format("Additional chunk data:%s", restChunk));
                        break;
                    }
                    case 1952670054: {
                        if (chunkSize < 8) break;
                        this.atracEndSample = mem.read32(currentAddr);
                        this.atracSampleOffset = mem.read32(currentAddr + 4);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("FACT Chunk: endSample=%d, sampleOffset=%d", this.atracEndSample, this.atracSampleOffset));
                        break;
                    }
                    case 1819307379: {
                        int checkNumLoops;
                        if (chunkSize < 36 || chunkSize < 36 + (checkNumLoops = mem.read32(currentAddr + 28)) * 24) break;
                        this.numLoops = checkNumLoops;
                        this.loops = new LoopInfo[this.numLoops];
                        int loopInfoAddr = currentAddr + 36;
                        for (int i = 0; i < this.numLoops; ++i) {
                            LoopInfo loop;
                            this.loops[i] = loop = new LoopInfo();
                            loop.cuePointID = mem.read32(loopInfoAddr);
                            loop.type = mem.read32(loopInfoAddr + 4);
                            loop.startSample = mem.read32(loopInfoAddr + 8) - this.atracSampleOffset;
                            loop.endSample = mem.read32(loopInfoAddr + 12) - this.atracSampleOffset;
                            loop.fraction = mem.read32(loopInfoAddr + 16);
                            loop.playCount = mem.read32(loopInfoAddr + 20);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Loop #%d: %s", i, loop.toString()));
                            }
                            loopInfoAddr += 24;
                        }
                        break;
                    }
                    case 1635017060: {
                        foundData = true;
                    }
                }
                currentAddr += chunkSize;
                bufferSize -= chunkSize;
            }
        }

        public int getAtracId() {
            return this.id;
        }

        public int getAtracCodecType() {
            return this.codecType;
        }

        public AtracCodec getAtracCodec() {
            return this.atracCodec;
        }

        public int getAtracBitrate() {
            return this.atracBitrate;
        }

        public int getAtracChannels() {
            return this.atracChannels;
        }

        public int getAtracSampleRate() {
            return this.atracSampleRate;
        }

        public int getAtracEndSample() {
            return this.atracEndSample;
        }

        public int getAtracCurrentSample() {
            return this.atracCurrentSample;
        }

        public int getAtracBytesPerFrame() {
            return this.atracBytesPerFrame;
        }

        public void setAtracCurrentSample(int sample) {
            this.atracCurrentSample = sample;
        }

        public int getLoopNum() {
            if (!this.hasLoop()) {
                return 0;
            }
            return this.loopNum;
        }

        public void setLoopNum(int num) {
            this.loopNum = num;
        }

        public int getMaxSamples() {
            return this.maxSamples;
        }

        public int getInputBufferAddr() {
            return this.inputBufferAddr;
        }

        public int getInputBufferSize() {
            return this.inputBufferSize;
        }

        public int getInputBufferOffset() {
            return this.inputBufferOffset;
        }

        public void setInputBufferOffset(int offset) {
            this.inputBufferOffset = offset;
        }

        public int getInputBufferWritableBytes() {
            return this.inputBufferWritableBytes;
        }

        public void setInputBufferWritableBytes(int bytes) {
            this.inputBufferWritableBytes = bytes;
        }

        public int getInputBufferNeededBytes() {
            return this.inputBufferNeededBytes;
        }

        public int getSecondInputBufferAddr() {
            return this.secondInputBufferAddr;
        }

        public int getSecondInputBufferSize() {
            return this.secondInputBufferSize;
        }

        public int getSecondInputBufferOffset() {
            return this.secondInputBufferOffset;
        }

        public int getSecondInputBufferWritableBytes() {
            return this.secondInputBufferWritableBytes;
        }

        public int getSecondInputBufferNeededBytes() {
            return this.secondInputBufferNeededBytes;
        }

        public int getInputFileSize() {
            return this.inputFileSize;
        }

        public void setInputFileSize(int bytes) {
            this.inputFileSize = bytes;
        }

        public int getInputFileOffset() {
            return this.inputFileOffset;
        }

        public void setInputFileOffset(int offset) {
            this.inputFileOffset = offset;
        }

        public int getSecondInputFileSize() {
            return this.secondInputFileSize;
        }

        public int getSecondInputFileOffset() {
            return this.secondInputFileOffset;
        }

        public boolean isSecondBufferNeeded() {
            return this.isSecondBufferNeeded;
        }

        public boolean isSecondBufferSet() {
            return this.isSecondBufferSet;
        }

        public int getInternalErrorInfo() {
            return this.internalErrorInfo;
        }

        public void setData(int buffer, int readSize, int bufferSize, boolean isSecondBuf) {
            Emulator.getClock().pause();
            if (isSecondBuf) {
                this.secondInputBufferAddr = buffer;
                this.secondInputBufferSize = bufferSize;
                this.secondInputBufferOffset = bufferSize - readSize;
                this.secondInputBufferWritableBytes = bufferSize - readSize;
                this.isSecondBufferSet = true;
            } else {
                this.inputBufferAddr = buffer;
                this.inputBufferSize = bufferSize;
                this.inputBufferOffset = bufferSize - readSize;
                this.inputBufferWritableBytes = bufferSize - readSize;
                this.inputFileSize = readSize;
                this.inputFileOffset = readSize;
                this.secondInputFileSize = 256;
                this.secondInputFileOffset = this.inputFileSize - 256;
                this.forceAllDataIsOnMemory = false;
                this.forceReloadOfData = false;
                this.analyzeAtracHeader();
                log.info((Object)String.format("hleAtracSetData atracID=%d, buffer=0x%08X, readSize=0x%X, bufferSize=0x%X, fileSize=0x%X", this.getAtracId(), buffer, readSize, this.inputBufferSize, this.inputFileSize));
                if (this.getAtracCodec() == null) {
                    log.warn((Object)String.format("hleAtracSetData atracID=%d is invalid", this.getAtracId()));
                    return;
                }
                this.getAtracCodec().atracSetData(this.getAtracId(), this.getAtracCodecType(), buffer, readSize, this.inputFileSize);
            }
            Emulator.getClock().resume();
        }

        protected void addStreamData(int length) {
            if (length > 0) {
                this.inputFileOffset += length;
                this.inputBufferOffset -= length;
                this.forceReloadOfData = false;
                this.getAtracCodec().atracAddStreamData(this.inputBufferAddr, length);
            }
        }

        public int getRemainFrames() {
            if (this.inputFileOffset >= this.inputFileSize || this.atracCurrentSample >= this.atracEndSample) {
                return -1;
            }
            if (this.forceReloadOfData) {
                return 0;
            }
            if (this.forceAllDataIsOnMemory) {
                return -1;
            }
            if (this.getInputBufferWritableBytes() <= 0) {
                return this.inputBufferSize / this.atracBytesPerFrame;
            }
            int remainFrames = (this.inputBufferSize - this.inputBufferOffset) / this.atracBytesPerFrame;
            return remainFrames;
        }

        public void getBufferInfoForReseting(int sample, int bufferInfoAddr) {
            Memory mem = Memory.getInstance();
            if (Memory.isAddressGood(bufferInfoAddr)) {
                mem.write32(bufferInfoAddr, this.inputBufferAddr);
                mem.write32(bufferInfoAddr + 4, this.inputBufferWritableBytes);
                mem.write32(bufferInfoAddr + 8, this.inputBufferNeededBytes);
                mem.write32(bufferInfoAddr + 12, this.inputFileOffset);
                mem.write32(bufferInfoAddr + 16, this.secondInputBufferAddr);
                mem.write32(bufferInfoAddr + 20, this.secondInputBufferWritableBytes);
                mem.write32(bufferInfoAddr + 24, this.secondInputBufferNeededBytes);
                mem.write32(bufferInfoAddr + 28, this.secondInputFileOffset);
            }
        }

        public void setDecodedSamples(int samples) {
            int currentSample = this.getAtracCurrentSample();
            int nextCurrentSample = currentSample + samples;
            for (int i = 0; i < this.numLoops; ++i) {
                LoopInfo loop = this.loops[i];
                if (currentSample <= loop.startSample && loop.startSample < nextCurrentSample) {
                    this.loopStartBytesWrittenFirstBuf = this.inputFileOffset;
                    this.loopStartBytesWrittenSecondBuf = this.secondInputFileOffset;
                    this.currentLoopNum = i;
                    break;
                }
                if (currentSample > loop.endSample || loop.endSample > nextCurrentSample || this.currentLoopNum != i) continue;
                if (this.loopNum == 0) {
                    this.currentLoopNum = -1;
                    continue;
                }
                log.info((Object)String.format("Replaying atrac loop atracID=%d, loopStart=%d, loopEnd=%d", this.id, loop.startSample, loop.endSample));
                this.setPlayPosition(loop.startSample, this.loopStartBytesWrittenFirstBuf, this.loopStartBytesWrittenSecondBuf);
                nextCurrentSample = loop.startSample;
                if (this.loopNum <= 0) break;
                --this.loopNum;
                break;
            }
            this.setAtracCurrentSample(nextCurrentSample);
        }

        public void setPlayPosition(int sample, int bytesWrittenFirstBuf, int bytesWrittenSecondBuf) {
            if (sample != this.getAtracCurrentSample()) {
                this.setInputBufferOffset(this.getInputBufferSize() - bytesWrittenFirstBuf);
                this.setAtracCurrentSample(sample);
                this.getAtracCodec().atracResetPlayPosition(sample);
                int position = this.getAtracCodec().getChannelPosition();
                if (position >= 0) {
                    this.setInputFileOffset(position);
                } else {
                    this.setInputFileOffset(0);
                }
                if (this.getInputBufferSize() < this.getInputFileSize() && !this.getAtracCodec().isExternalAudio()) {
                    this.getAtracCodec().resetChannel();
                    this.forceReloadOfData = true;
                } else {
                    this.forceAllDataIsOnMemory = true;
                }
            }
        }

        private boolean hasLoop() {
            return this.numLoops > 0;
        }

        public int getLoopStatus() {
            if (!this.hasLoop()) {
                return 0;
            }
            return 1;
        }

        public int getLoopStartSample() {
            if (!this.hasLoop()) {
                return -1;
            }
            return this.loops[0].startSample;
        }

        public int getLoopEndSample() {
            if (!this.hasLoop()) {
                return -1;
            }
            return this.loops[0].endSample;
        }

        public void update() {
            this.setInputBufferWritableBytes(this.getInputBufferOffset());
            if (this.getInputFileOffset() >= this.getInputFileSize()) {
                this.setInputBufferWritableBytes(0);
            } else if (this.getInputBufferWritableBytes() > this.getInputFileSize() - this.getInputFileOffset()) {
                this.setInputBufferWritableBytes(this.getInputFileSize() - this.getInputFileOffset());
            }
        }

        public boolean isForceReloadOfData() {
            return this.forceReloadOfData;
        }

        public String toString() {
            return String.format("AtracID[id=%d, inputBufferAddr=0x%08X, inputBufferSize=%d, inputBufferOffset=%d, inputBufferWritableBytes=%d, inputBufferNeededBytes=%d]", this.id, this.inputBufferAddr, this.inputBufferSize, this.inputBufferOffset, this.inputBufferWritableBytes, this.inputBufferNeededBytes);
        }
    }

    protected static class LoopInfo {
        protected int cuePointID;
        protected int type;
        protected int startSample;
        protected int endSample;
        protected int fraction;
        protected int playCount;

        protected LoopInfo() {
        }

        public String toString() {
            return String.format("LoopInfo[cuePointID %d, type %d, startSample %d, endSample %d, fraction %d, playCount %d]", this.cuePointID, this.type, this.startSample, this.endSample, this.fraction, this.playCount);
        }
    }
}

