/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Audio;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.sound.AudioBlockingOutputAction;
import jpcsp.sound.SoundChannel;
import org.apache.log4j.Logger;

public class sceAudio
extends HLEModule {
    public static Logger log = Modules.getLogger("sceAudio");
    protected static final int PSP_AUDIO_VOLUME_MAX = 32768;
    protected static final int PSP_AUDIO_CHANNEL_MAX = 8;
    protected static final int PSP_AUDIO_SAMPLE_MIN = 64;
    protected static final int PSP_AUDIO_SAMPLE_MAX = 65472;
    protected static final int PSP_AUDIO_FORMAT_STEREO = 0;
    protected static final int PSP_AUDIO_FORMAT_MONO = 16;
    protected SoundChannel[] pspPCMChannels;
    protected SoundChannel pspSRCChannel;
    protected boolean disableChReserve;
    protected boolean disableBlockingAudio;

    @Override
    public String getName() {
        return "sceAudio";
    }

    @Override
    public void start() {
        SoundChannel.init();
        this.pspPCMChannels = new SoundChannel[8];
        for (int channel = 0; channel < this.pspPCMChannels.length; ++channel) {
            this.pspPCMChannels[channel] = new SoundChannel(channel);
        }
        this.pspSRCChannel = new SoundChannel(8);
        this.setSettingsListener("emu.disablesceAudio", new DisableAudioSettingsListerner());
        this.setSettingsListener("emu.disableblockingaudio", new DisableBlockingAudioSettingsListerner());
        super.start();
    }

    private void setChReserveEnabled(boolean enabled) {
        this.disableChReserve = !enabled;
        log.info((Object)("Audio ChReserve disabled: " + this.disableChReserve));
    }

    private void setBlockingEnabled(boolean enabled) {
        this.disableBlockingAudio = !enabled;
        log.info((Object)("Audio Blocking disabled: " + this.disableBlockingAudio));
    }

    protected int doAudioOutput(SoundChannel channel, int pvoid_buf) {
        int ret = -1;
        if (channel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("doAudioOutput(%s, 0x%08X)", channel.toString(), pvoid_buf));
            }
            int bytesPerSample = channel.isFormatStereo() ? 4 : 2;
            int nbytes = bytesPerSample * channel.getSampleLength();
            byte[] data = new byte[nbytes];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(pvoid_buf, nbytes, 2);
            if (channel.isFormatMono()) {
                int volume = Audio.getVolume(channel.getLeftVolume());
                for (int i = 0; i < nbytes; i += 2) {
                    short sample = (short)memoryReader.readNext();
                    sample = SoundChannel.adjustSample(sample, volume);
                    SoundChannel.storeSample(sample, data, i);
                }
            } else {
                int leftVolume = Audio.getVolume(channel.getLeftVolume());
                int rightVolume = Audio.getVolume(channel.getRightVolume());
                for (int i = 0; i < nbytes; i += 4) {
                    short lsample = (short)memoryReader.readNext();
                    short rsample = (short)memoryReader.readNext();
                    lsample = SoundChannel.adjustSample(lsample, leftVolume);
                    rsample = SoundChannel.adjustSample(rsample, rightVolume);
                    SoundChannel.storeSample(lsample, data, i);
                    SoundChannel.storeSample(rsample, data, i + 2);
                }
            }
            channel.play(data);
            ret = channel.getSampleLength();
        } else {
            log.warn((Object)("doAudioOutput: channel " + channel.getIndex() + " not reserved"));
        }
        return ret;
    }

    protected void blockThreadOutput(SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        this.blockThreadOutput(threadMan.getCurrentThreadID(), channel, addr, leftVolume, rightVolume);
        threadMan.hleBlockCurrentThread();
    }

    protected void blockThreadOutput(int threadId, SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        AudioBlockingOutputAction action = new AudioBlockingOutputAction(threadId, channel, addr, leftVolume, rightVolume);
        int delayMicros = channel.getUnblockOutputDelayMicros(addr == 0);
        long schedule = Emulator.getClock().microTime() + (long)delayMicros;
        Emulator.getScheduler().addAction(schedule, action);
    }

    public void hleAudioBlockingOutput(int threadId, SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleAudioBlockingOutput %s", channel.toString()));
        }
        if (addr == 0) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo thread = threadMan.getThreadById(threadId);
            if (thread != null) {
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleUnblockThread(threadId);
            }
        } else if (!channel.isOutputBlocking()) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo thread = threadMan.getThreadById(threadId);
            if (thread != null) {
                int ret;
                this.changeChannelVolume(channel, leftVolume, rightVolume);
                thread.cpuContext.gpr[2] = ret = this.doAudioOutput(channel, addr);
                threadMan.hleUnblockThread(threadId);
            }
        } else {
            this.blockThreadOutput(threadId, channel, addr, leftVolume, rightVolume);
        }
    }

    protected int changeChannelVolume(SoundChannel channel, int leftvol, int rightvol) {
        int ret = -1;
        if (channel.isReserved()) {
            channel.setLeftVolume(leftvol);
            channel.setRightVolume(rightvol);
            ret = 0;
        }
        return ret;
    }

    protected int hleAudioGetChannelRestLen(SoundChannel channel) {
        int len = channel.getRestLength();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleAudioGetChannelRestLen(%d) = %d", channel.getIndex(), len));
        }
        return len;
    }

    protected void hleAudioSRCChReserve(Processor processor, int samplecount, int freq, int format) {
        CpuState cpu = processor.cpu;
        if (IntrManager.getInstance().isInsideInterrupt()) {
            cpu.gpr[2] = -2147352476;
            return;
        }
        if (this.disableChReserve) {
            log.warn((Object)("IGNORED hleAudioSRCChReserve samplecount= " + samplecount + " freq= " + freq + " format=" + format));
            cpu.gpr[2] = -1;
        } else if (!this.pspSRCChannel.isReserved()) {
            this.pspSRCChannel.setSampleRate(freq);
            this.pspSRCChannel.setReserved(true);
            this.pspSRCChannel.setSampleLength(samplecount);
            this.pspSRCChannel.setFormat(format);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-2131626016, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public void sceAudioInit(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioInit [0x80F1F7E0]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=554002423, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public void sceAudioEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioEnd [0x210567F7]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1564562836, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public void sceAudioSetFrequency(Processor processor) {
        CpuState cpu = processor.cpu;
        int frequency = cpu.gpr[4];
        if (frequency == 44100 || frequency == 48000) {
            for (int i = 0; i < this.pspPCMChannels.length; ++i) {
                this.pspPCMChannels[i].setSampleRate(frequency);
            }
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-1240099392, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public void sceAudioLoopbackTest(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioLoopbackTest [0xB61595C0]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1837448405, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public void sceAudioSetVolumeOffset(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioSetVolumeOffset [0x927AC32B]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1945105998, version=150, checkInsideInterrupt=true)
    public void sceAudioOutput(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        int vol = cpu.gpr[5];
        int pvoid_buf = cpu.gpr[6];
        if (!Memory.isAddressGood(pvoid_buf)) {
            log.warn((Object)("sceAudioOutput bad pointer " + String.format("0x%08X", pvoid_buf)));
            cpu.gpr[2] = -2144993276;
        } else if (!this.pspPCMChannels[channel].isOutputBlocking()) {
            this.changeChannelVolume(this.pspPCMChannels[channel], vol, vol);
            cpu.gpr[2] = this.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf);
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            cpu.gpr[2] = -2144993278;
        }
    }

    @HLEFunction(nid=325889873, version=150, checkInsideInterrupt=true)
    public void sceAudioOutputBlocking(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        int vol = cpu.gpr[5];
        int pvoid_buf = cpu.gpr[6];
        if (pvoid_buf == 0) {
            if (!this.pspPCMChannels[channel].isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioOutputBlocking[pvoid_buf==0] blocking " + this.pspPCMChannels[channel].toString()));
                }
                this.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf, vol, vol);
            } else {
                cpu.gpr[2] = 0;
            }
        } else if (!Memory.isAddressGood(pvoid_buf)) {
            log.warn((Object)("sceAudioOutputBlocking bad pointer " + String.format("0x%08X", pvoid_buf)));
            cpu.gpr[2] = -2144993276;
        } else if (!this.pspPCMChannels[channel].isOutputBlocking() || this.disableBlockingAudio) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceAudioOutputBlocking[not blocking] " + this.pspPCMChannels[channel].toString()));
            }
            this.changeChannelVolume(this.pspPCMChannels[channel], vol, vol);
            cpu.gpr[2] = this.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf);
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceAudioOutputBlocking[not blocking] returning " + cpu.gpr[2] + " (" + this.pspPCMChannels[channel].toString() + ")"));
            }
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceAudioOutputBlocking[blocking] " + this.pspPCMChannels[channel].toString()));
            }
            this.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf, vol, vol);
        }
    }

    @HLEFunction(nid=-489329875, version=150, checkInsideInterrupt=true)
    public void sceAudioOutputPanned(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        int leftvol = cpu.gpr[5];
        int rightvol = cpu.gpr[6];
        int pvoid_buf = cpu.gpr[7];
        if (!Memory.isAddressGood(pvoid_buf)) {
            log.warn((Object)("sceAudioOutputPanned bad pointer " + String.format("0x%08X", pvoid_buf)));
            cpu.gpr[2] = -2144993276;
        } else if (!this.pspPCMChannels[channel].isOutputBlocking()) {
            this.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
            cpu.gpr[2] = this.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf);
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            cpu.gpr[2] = -2144993278;
        }
    }

    @HLEFunction(nid=334860988, version=150, checkInsideInterrupt=true)
    public void sceAudioOutputPannedBlocking(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        int leftvol = cpu.gpr[5];
        int rightvol = cpu.gpr[6];
        int pvoid_buf = cpu.gpr[7];
        if (pvoid_buf == 0) {
            if (!this.pspPCMChannels[channel].isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioOutputPannedBlocking[pvoid_buf==0] blocking " + this.pspPCMChannels[channel].toString()));
                }
                this.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf, leftvol, rightvol);
            } else {
                cpu.gpr[2] = 0;
            }
        } else if (!Memory.isAddressGood(pvoid_buf)) {
            log.warn((Object)("sceAudioOutputPannedBlocking bad pointer " + String.format("0x%08X", pvoid_buf)));
            cpu.gpr[2] = -2144993276;
        } else if (!this.pspPCMChannels[channel].isOutputBlocking() || this.disableBlockingAudio) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutputPannedBlocking[not blocking] leftVol=%d, rightVol=%d, channel=%s", leftvol, rightvol, this.pspPCMChannels[channel].toString()));
            }
            this.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
            cpu.gpr[2] = this.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf);
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutputPannedBlocking[blocking] leftVol=%d, rightVol=%d, channel=%s", leftvol, rightvol, this.pspPCMChannels[channel].toString()));
            }
            this.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf, leftvol, rightvol);
        }
    }

    @HLEFunction(nid=1590172757, version=150, checkInsideInterrupt=true)
    public void sceAudioChReserve(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        int samplecount = cpu.gpr[5];
        int format = cpu.gpr[6];
        if (this.disableChReserve) {
            log.warn((Object)("IGNORED sceAudioChReserve channel= " + channel + " samplecount = " + samplecount + " format = " + format));
            cpu.gpr[2] = -1;
        } else {
            log.debug((Object)("sceAudioChReserve channel= " + channel + " samplecount = " + samplecount + " format = " + format));
            if (channel != -1) {
                if (this.pspPCMChannels[channel].isReserved()) {
                    log.warn((Object)("sceAudioChReserve failed - channel " + channel + " already in use"));
                    channel = -1;
                }
            } else {
                for (int i = 0; i < this.pspPCMChannels.length; ++i) {
                    if (this.pspPCMChannels[i].isReserved()) continue;
                    channel = i;
                    break;
                }
                if (channel == -1) {
                    log.warn((Object)"sceAudioChReserve failed - no free channels available");
                }
            }
            if (channel != -1) {
                this.pspPCMChannels[channel].setReserved(true);
                this.pspPCMChannels[channel].setSampleLength(samplecount);
                this.pspPCMChannels[channel].setFormat(format);
            }
            cpu.gpr[2] = channel;
        }
    }

    @HLEFunction(nid=1106226663, version=150, checkInsideInterrupt=true)
    public void sceAudioOneshotOutput(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioOneshotOutput [0x41EFADE7]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1875142739, version=150, checkInsideInterrupt=true)
    public void sceAudioChRelease(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        if (this.pspPCMChannels[channel].isReserved()) {
            this.pspPCMChannels[channel].release();
            this.pspPCMChannels[channel].setReserved(false);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-1341025745, version=150, checkInsideInterrupt=true)
    public void sceAudioGetChannelRestLength(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        cpu.gpr[2] = this.hleAudioGetChannelRestLen(this.pspPCMChannels[channel]);
    }

    @HLEFunction(nid=-886160482, version=150, checkInsideInterrupt=true)
    public void sceAudioSetChannelDataLen(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        int samplecount = cpu.gpr[5];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioSetChannelDataLen channel=%d, sampleCount=%d", channel, samplecount));
        }
        this.pspPCMChannels[channel].setSampleLength(samplecount);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1778578387, version=150, checkInsideInterrupt=true)
    public void sceAudioChangeChannelConfig(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        int format = cpu.gpr[5];
        this.pspPCMChannels[channel].setFormat(format);
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1209935641, version=150, checkInsideInterrupt=true)
    public void sceAudioChangeChannelVolume(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        int leftvol = cpu.gpr[5];
        int rightvol = cpu.gpr[6];
        cpu.gpr[2] = this.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
    }

    @HLEFunction(nid=22424483, version=150, checkInsideInterrupt=true)
    public void sceAudioOutput2Reserve(Processor processor) {
        CpuState cpu = processor.cpu;
        int samplecount = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioOutput2Reserve sampleCount=%d", samplecount));
        }
        this.hleAudioSRCChReserve(processor, samplecount, 44100, 0);
    }

    @HLEFunction(nid=1125738565, version=150, checkInsideInterrupt=true)
    public void sceAudioOutput2Release(Processor processor) {
        this.sceAudioSRCChRelease(processor);
    }

    @HLEFunction(nid=760476526, version=150, checkInsideInterrupt=true)
    public void sceAudioOutput2OutputBlocking(Processor processor) {
        this.sceAudioSRCOutputBlocking(processor);
    }

    @HLEFunction(nid=1685909299, version=150, checkInsideInterrupt=true)
    public void sceAudioOutput2GetRestSample(Processor processor) {
        CpuState cpu = processor.cpu;
        cpu.gpr[2] = this.hleAudioGetChannelRestLen(this.pspSRCChannel);
    }

    @HLEFunction(nid=1676839068, version=150, checkInsideInterrupt=true)
    public void sceAudioOutput2ChangeLength(Processor processor) {
        CpuState cpu = processor.cpu;
        int samplecount = cpu.gpr[4];
        if (this.pspSRCChannel.isReserved()) {
            this.pspSRCChannel.setSampleLength(samplecount);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=945107217, version=150, checkInsideInterrupt=true)
    public void sceAudioSRCChReserve(Processor processor) {
        CpuState cpu = processor.cpu;
        int samplecount = cpu.gpr[4];
        int freq = cpu.gpr[5];
        int format = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioSRCChReserve sampleCount=%d, freq=%d, format=%d", samplecount, freq, format));
        }
        this.hleAudioSRCChReserve(processor, samplecount, freq, format);
    }

    @HLEFunction(nid=1547157678, version=150, checkInsideInterrupt=true)
    public void sceAudioSRCChRelease(Processor processor) {
        CpuState cpu = processor.cpu;
        if (this.pspSRCChannel.isReserved()) {
            this.pspSRCChannel.release();
            this.pspSRCChannel.setReserved(false);
        }
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-529371050, version=150, checkInsideInterrupt=true)
    public void sceAudioSRCOutputBlocking(Processor processor) {
        CpuState cpu = processor.cpu;
        int vol = cpu.gpr[4];
        int buf = cpu.gpr[5];
        if (buf == 0) {
            if (!this.pspSRCChannel.isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioSRCOutputBlocking[pvoid_buf==0] blocking " + this.pspSRCChannel));
                }
                this.blockThreadOutput(this.pspSRCChannel, buf, vol, vol);
            } else {
                cpu.gpr[2] = 0;
            }
        } else if (!Memory.isAddressGood(buf)) {
            log.warn((Object)("sceAudioSRCOutputBlocking bad pointer " + String.format("0x%08X", buf)));
            cpu.gpr[2] = -2144993276;
        } else if (!this.pspSRCChannel.isOutputBlocking() || this.disableBlockingAudio) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioSRCOutputBlocking[not blocking] 0x%08X to %s", buf, this.pspSRCChannel.toString()));
            }
            this.changeChannelVolume(this.pspSRCChannel, vol, vol);
            cpu.gpr[2] = this.doAudioOutput(this.pspSRCChannel, buf);
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioSRCOutputBlocking[blocking] 0x%08X to %s", buf, this.pspSRCChannel.toString()));
            }
            this.blockThreadOutput(this.pspSRCChannel, buf, vol, vol);
        }
    }

    @HLEFunction(nid=141449365, version=150, checkInsideInterrupt=true)
    public void sceAudioInputBlocking(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioInputBlocking [0x086E5895]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1833692264, version=150, checkInsideInterrupt=true)
    public void sceAudioInput(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioInput [0x6D4BEC68]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1492597082, version=150, checkInsideInterrupt=true)
    public void sceAudioGetInputLength(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioGetInputLength [0xA708C6A6]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-2018318767, version=150, checkInsideInterrupt=true)
    public void sceAudioWaitInputEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioWaitInputEnd [0x87B2E651]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=2112231048, version=150, checkInsideInterrupt=true)
    public void sceAudioInputInit(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioInputInit [0x7DE61688]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-383331333, version=150, checkInsideInterrupt=true)
    public void sceAudioInputInitEx(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioInputInitEx [0xE926D3FB]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1506605938, version=150, checkInsideInterrupt=true)
    public void sceAudioPollInputEnd(Processor processor) {
        CpuState cpu = processor.cpu;
        System.out.println("Unimplemented NID function sceAudioPollInputEnd [0xA633048E]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-371623679, version=150, checkInsideInterrupt=true)
    public void sceAudioGetChannelRestLen(Processor processor) {
        CpuState cpu = processor.cpu;
        int channel = cpu.gpr[4];
        cpu.gpr[2] = this.hleAudioGetChannelRestLen(this.pspPCMChannels[channel]);
    }

    private class DisableBlockingAudioSettingsListerner
    extends AbstractBoolSettingsListener {
        private DisableBlockingAudioSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAudio.this.setBlockingEnabled(!value);
        }
    }

    private class DisableAudioSettingsListerner
    extends AbstractBoolSettingsListener {
        private DisableAudioSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAudio.this.setChReserveEnabled(!value);
        }
    }
}

