/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.MainGUI;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.Resource;
import jpcsp.State;
import jpcsp.graphics.GEProfiler;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.RenderingEngineFactory;
import jpcsp.graphics.RE.RenderingEngineLwjgl;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureManager;
import jpcsp.graphics.textures.GETexture;
import jpcsp.graphics.textures.GETextureManager;
import jpcsp.graphics.textures.TextureCache;
import jpcsp.scheduler.UnblockThreadAction;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.AbstractStringSettingsListener;
import jpcsp.settings.ISettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;

public class sceDisplay
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceDisplay");
    protected AWTGLCanvas_sceDisplay canvas;
    private boolean onlyGEGraphics = false;
    private boolean saveGEToTexture = false;
    private boolean useSoftwareRenderer = false;
    private static final boolean useDebugGL = false;
    private static final int internalTextureFormat = 3;
    public static final int PSP_DISPLAY_MODE_LCD = 0;
    public static final int PSP_DISPLAY_MODE_VESA1A = 26;
    public static final int PSP_DISPLAY_MODE_PSEUDO_VGA = 96;
    public static final int PSP_DISPLAY_SETBUF_IMMEDIATE = 0;
    public static final int PSP_DISPLAY_SETBUF_NEXTFRAME = 1;
    private static final float hCountPerVblank = 285.72f;
    private static final float FRAME_PER_SEC = 59.94006f;
    private IRenderingEngine re;
    private IRenderingEngine reDisplay;
    private boolean startModules;
    private boolean isStarted;
    private int drawBuffer;
    private boolean resetDisplaySettings;
    private int mode;
    private int width;
    private int height;
    private int widthGe;
    private int heightGe;
    private static float viewportResizeFilterScaleFactor = 1.0f;
    private static int viewportResizeFilterScaleFactorInt = 1;
    private boolean resizePending;
    private int topaddrFb;
    private int bufferwidthFb;
    private int pixelformatFb;
    private int sync;
    private boolean setGeBufCalledAtLeastOnce;
    public boolean gotBadGeBufParams;
    public boolean gotBadFbBufParams;
    protected boolean isFbShowing;
    private int bottomaddrFb;
    private int topaddrGe;
    private int bottomaddrGe;
    private int bufferwidthGe;
    private int pixelformatGe;
    private boolean detailsDirty;
    private boolean displayDirty;
    private boolean geDirty;
    private long lastUpdate;
    private boolean initGLcalled;
    private String openGLversion;
    private boolean calledFromCommandLine;
    private Buffer pixelsFb;
    private Buffer pixelsGe;
    private Buffer temp;
    private int tempSize;
    private int canvasWidth;
    private int canvasHeight;
    private boolean createTex;
    private int texFb;
    private int resizedTexFb;
    private float texS;
    private float texT;
    private int captureX;
    private int captureY;
    private int captureWidth;
    private int captureHeight;
    private Robot captureRobot;
    public boolean getscreen = false;
    private float texS1;
    private float texS2;
    private float texS3;
    private float texS4;
    private float texT1;
    private float texT2;
    private float texT3;
    private float texT4;
    private int ang = 4;
    public boolean isrotating = false;
    private long prevStatsTime;
    private long frameCount;
    private long prevFrameCount;
    private long reportCount;
    private double averageFPS = 0.0;
    private int vcount;
    private long lastVblankMicroTime;
    private DisplayVblankAction displayVblankAction;
    public DurationStatistics statistics;
    public DurationStatistics statisticsCopyGeToMemory;
    public DurationStatistics statisticsCopyMemoryToGe;
    private AsyncDisplayThread asyncDisplayThread;
    private SoftwareRenderingDisplayThread softwareRenderingDisplayThread;
    private List<WaitVblankInfo> waitingOnVblank;
    private int antiAliasSamplesNum;
    private int desiredFps = 0;
    private int maxFramesSkippedInSequence = 3;
    private int framesSkippedInSequence;
    private LinkedList<Long> frameTimestamps = new LinkedList();
    private boolean skipNextFrameBufferSwitch;
    public static boolean ignoreLWJGLError = false;

    public AWTGLCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public String getName() {
        return "sceDisplay";
    }

    public sceDisplay() throws LWJGLException {
        this.setSettingsListener("emu.graphics.antialias", new AntiAliasSettingsListerner());
        DisplaySettingsListener displaySettingsListener = new DisplaySettingsListener();
        this.setSettingsListener("emu.useVertexCache", displaySettingsListener);
        this.setSettingsListener("emu.useshaders", displaySettingsListener);
        this.setSettingsListener("emu.useGeometryShader", displaySettingsListener);
        this.setSettingsListener("emu.disableubo", displaySettingsListener);
        this.setSettingsListener("emu.enablevao", displaySettingsListener);
        this.setSettingsListener("emu.enablegetexture", displaySettingsListener);
        this.setSettingsListener("emu.enablenativeclut", displaySettingsListener);
        this.setSettingsListener("emu.enabledynamicshaders", displaySettingsListener);
        this.setSettingsListener("emu.enableshaderstenciltest", displaySettingsListener);
        this.setSettingsListener("emu.enableshadercolormask", displaySettingsListener);
        this.canvas = new AWTGLCanvas_sceDisplay();
        this.setScreenResolution(480, 272);
        this.texFb = -1;
        this.resizedTexFb = -1;
        this.startModules = false;
        this.isStarted = false;
        this.resizePending = false;
        this.tempSize = 0;
    }

    public void setDesiredFPS(int desiredFPS) {
        this.desiredFps = desiredFPS;
    }

    public int getDesiredFPS() {
        return this.desiredFps;
    }

    public void setScreenResolution(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.canvas.setSize(width, height);
    }

    public float getViewportResizeScaleFactor() {
        return viewportResizeFilterScaleFactor;
    }

    public void setViewportResizeScaleFactor(int width, int height) {
        float scaleAspectRatio;
        float scaleWidth = (float)width / 480.0f;
        float scaleHeight = (float)height / 272.0f;
        if (Emulator.getMainGUI().isFullScreen()) {
            Dimension fullScreenDimension = MainGUI.getFullScreenDimension();
            scaleAspectRatio = fullScreenDimension.width == width && fullScreenDimension.height > height ? scaleWidth : (fullScreenDimension.height == height && fullScreenDimension.width > width ? scaleHeight : Math.min(scaleWidth, scaleHeight));
        } else {
            scaleAspectRatio = (scaleWidth + scaleHeight) / 2.0f;
        }
        this.setViewportResizeScaleFactor(scaleAspectRatio);
        this.resizePending = true;
    }

    public void setViewportResizeScaleFactor(float viewportResizeFilterScaleFactor) {
        if (viewportResizeFilterScaleFactor < 1.0f) {
            return;
        }
        if (viewportResizeFilterScaleFactor != sceDisplay.viewportResizeFilterScaleFactor) {
            sceDisplay.viewportResizeFilterScaleFactor = viewportResizeFilterScaleFactor;
            viewportResizeFilterScaleFactorInt = Math.round((float)Math.ceil(viewportResizeFilterScaleFactor));
            Dimension size = new Dimension(sceDisplay.getResizedWidth(480), sceDisplay.getResizedHeight(272));
            this.canvas.setSize(size);
            this.canvas.setPreferredSize(size);
            if (Emulator.getMainGUI().isFullScreen()) {
                Emulator.getMainGUI().setFullScreenDisplaySize();
            }
            this.createTex = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("setViewportResizeScaleFactor resize=%f, size(%dx%d), canvas(%dx%d), location(%d,%d)", Float.valueOf(viewportResizeFilterScaleFactor), size.width, size.height, this.canvasWidth, this.canvasHeight, this.canvas.getLocation().x, this.canvas.getLocation().y));
            }
        }
    }

    public static final int getResizedWidth(int width) {
        return Math.round((float)width * viewportResizeFilterScaleFactor);
    }

    public static final int getResizedWidthPow2(int widthPow2) {
        return widthPow2 * viewportResizeFilterScaleFactorInt;
    }

    public static final int getResizedHeight(int height) {
        return Math.round((float)height * viewportResizeFilterScaleFactor);
    }

    public static final int getResizedHeightPow2(int heightPow2) {
        return heightPow2 * viewportResizeFilterScaleFactorInt;
    }

    private void setAntiAliasSamplesNum(int samples) {
        this.antiAliasSamplesNum = samples;
    }

    @Override
    public void start() {
        this.statistics = new DurationStatistics("sceDisplay Statistics");
        this.statisticsCopyGeToMemory = new DurationStatistics("Copy GE to Memory");
        this.statisticsCopyMemoryToGe = new DurationStatistics("Copy Memory to GE");
        if (log.isDebugEnabled()) {
            try {
                DisplayMode[] availableDisplayModes = Display.getAvailableDisplayModes();
                for (int i = 0; availableDisplayModes != null && i < availableDisplayModes.length; ++i) {
                    log.debug((Object)String.format("Available Display Mode #%d = %s", i, availableDisplayModes[i]));
                }
                log.debug((Object)String.format("Desktop Display Mode = %s", Display.getDesktopDisplayMode()));
                log.debug((Object)String.format("Current Display Mode = %s", Display.getDisplayMode()));
                log.debug((Object)String.format("initGL called = %b, OpenGL Version = %s", this.initGLcalled, this.openGLversion));
            }
            catch (LWJGLException e) {
                log.error((Object)e);
            }
        }
        if (!(this.initGLcalled || this.calledFromCommandLine || ignoreLWJGLError)) {
            throw new RuntimeException(Resource.get("JpcspCannotDisplay"));
        }
        this.mode = 0;
        this.width = 480;
        this.height = 272;
        this.topaddrFb = 0x4000000;
        this.bufferwidthFb = 512;
        this.pixelformatFb = 3;
        this.sync = 0;
        this.bottomaddrFb = this.topaddrFb + this.bufferwidthFb * this.height * sceDisplay.getPixelFormatBytes(this.pixelformatFb);
        this.detailsDirty = true;
        this.displayDirty = true;
        this.geDirty = false;
        this.createTex = true;
        this.pixelsFb = this.getPixels(this.topaddrFb, this.bottomaddrFb);
        this.widthGe = 480;
        this.heightGe = 272;
        this.topaddrGe = this.topaddrFb;
        this.bufferwidthGe = this.bufferwidthFb;
        this.pixelformatGe = this.pixelformatFb;
        this.bottomaddrGe = this.bottomaddrFb;
        this.pixelsGe = this.getPixels(this.topaddrGe, this.bottomaddrGe);
        this.isFbShowing = false;
        this.setGeBufCalledAtLeastOnce = false;
        this.gotBadGeBufParams = false;
        this.gotBadFbBufParams = false;
        this.prevStatsTime = 0L;
        this.frameCount = 0L;
        this.prevFrameCount = 0L;
        this.reportCount = 0L;
        this.averageFPS = 0.0;
        this.vcount = 0;
        if (this.asyncDisplayThread == null) {
            this.asyncDisplayThread = new AsyncDisplayThread();
            this.asyncDisplayThread.setDaemon(true);
            this.asyncDisplayThread.setName("Async Display Thread");
            this.asyncDisplayThread.start();
        }
        if (this.displayVblankAction == null) {
            this.displayVblankAction = new DisplayVblankAction();
            IntrManager.getInstance().addVBlankAction(this.displayVblankAction);
        }
        this.waitingOnVblank = new LinkedList<WaitVblankInfo>();
        this.startModules = true;
        this.re = null;
        this.reDisplay = null;
        this.resetDisplaySettings = false;
        this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
        if (this.saveGEToTexture) {
            log.info((Object)"Saving GE to Textures");
        }
        this.captureX = Settings.getInstance().readInt("gui.windows.mainwindow.x") + 4;
        this.captureY = Settings.getInstance().readInt("gui.windows.mainwindow.y") + 76;
        this.captureWidth = this.getCanvasWidth();
        this.captureHeight = this.getCanvasHeight();
        try {
            this.captureRobot = new Robot();
            this.captureRobot.setAutoDelay(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSettingsListener("emu.onlyGEGraphics", new OnlyGeSettingsListener());
        this.setSettingsListener("emu.useSoftwareRenderer", new SoftwareRendererSettingsListener());
        super.start();
    }

    @Override
    public void stop() {
        VideoEngine.getInstance().stop();
        if (this.asyncDisplayThread != null) {
            this.asyncDisplayThread.exit();
            this.asyncDisplayThread = null;
        }
        this.re = null;
        this.reDisplay = null;
        this.startModules = false;
        this.isStarted = false;
        super.stop();
    }

    public void exit() {
        if (this.statistics != null) {
            // empty if block
        }
    }

    public void step(boolean immediately) {
        long now = System.currentTimeMillis();
        if (immediately || now - this.lastUpdate > 16L || this.geDirty) {
            if ((!this.onlyGEGraphics || VideoEngine.getInstance().hasDrawLists()) && (this.geDirty || this.detailsDirty || this.displayDirty)) {
                this.detailsDirty = false;
                this.displayDirty = false;
                this.geDirty = false;
                this.asyncDisplayThread.display();
            }
            this.lastUpdate = now;
        }
    }

    public void step() {
        this.step(false);
    }

    public final void write8(int rawAddress) {
        if (rawAddress < this.bottomaddrFb && rawAddress >= this.topaddrFb) {
            this.displayDirty = true;
        }
    }

    public final void write16(int rawAddress) {
        if (rawAddress < this.bottomaddrFb && rawAddress >= this.topaddrFb) {
            this.displayDirty = true;
        }
    }

    public final void write32(int rawAddress) {
        if (rawAddress < this.bottomaddrFb && rawAddress >= this.topaddrFb) {
            this.displayDirty = true;
        }
    }

    public IRenderingEngine getRenderingEngine() {
        return this.re;
    }

    public void setGeDirty(boolean dirty) {
        this.geDirty = dirty;
        if (dirty && this.softwareRenderingDisplayThread != null) {
            this.softwareRenderingDisplayThread.display();
        }
    }

    public void hleDisplaySetGeMode(int width, int height) {
        if (width <= 0 || height <= 0) {
            log.warn((Object)("hleDisplaySetGeMode(" + width + "," + height + ") bad params"));
        } else {
            log.debug((Object)("hleDisplaySetGeMode(width=" + width + ",height=" + height + ")"));
            this.widthGe = width;
            this.heightGe = height;
            this.bottomaddrGe = this.topaddrGe + this.bufferwidthGe * this.heightGe * sceDisplay.getPixelFormatBytes(this.pixelformatGe);
            this.pixelsGe = this.getPixels(this.topaddrGe, this.bottomaddrGe);
        }
    }

    public void hleDisplaySetGeBuf(int topaddr, int bufferwidth, int pixelformat, boolean copyGEToMemory, boolean forceLoadGEToScreen) {
        this.hleDisplaySetGeBuf(topaddr, bufferwidth, pixelformat, copyGEToMemory, forceLoadGEToScreen, this.widthGe, this.heightGe);
    }

    public void hleDisplaySetGeBuf(int topaddr, int bufferwidth, int pixelformat, boolean copyGEToMemory, boolean forceLoadGEToScreen, int width, int height) {
        boolean loadGEToScreen;
        if ((topaddr &= 0x3FFFFFFF) < 0x4000000) {
            topaddr += 0x4000000;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, copyGE=%b, with=%d, height=%d", topaddr, bufferwidth, pixelformat, copyGEToMemory, width, height));
        }
        if (this.isUsingSoftwareRenderer() || VideoEngine.getInstance().isSkipThisFrame()) {
            copyGEToMemory = false;
            forceLoadGEToScreen = false;
        }
        if (topaddr == this.topaddrGe && bufferwidth == this.bufferwidthGe && pixelformat == this.pixelformatGe && width == this.widthGe && height == this.heightGe) {
            if (forceLoadGEToScreen) {
                this.loadGEToScreen();
            }
            return;
        }
        if (topaddr < 0x4000000 || topaddr >= 0x41FFFFF || (bufferwidth &= 0xFFFFFFFC) <= 0 || pixelformat < 0 || pixelformat > 3 || this.sync != 0 && this.sync != 1) {
            String msg = "hleDisplaySetGeBuf bad params (" + Integer.toHexString(topaddr) + "," + bufferwidth + "," + pixelformat + ")";
            if (this.setGeBufCalledAtLeastOnce) {
                log.warn((Object)msg);
                this.gotBadGeBufParams = true;
            } else {
                log.debug((Object)msg);
                this.setGeBufCalledAtLeastOnce = true;
            }
            return;
        }
        if (this.gotBadGeBufParams) {
            this.gotBadGeBufParams = false;
            log.info((Object)("hleDisplaySetGeBuf ok (" + Integer.toHexString(topaddr) + "," + bufferwidth + "," + pixelformat + ")"));
        }
        if (this.re.isVertexArrayAvailable()) {
            this.re.bindVertexArray(0);
        }
        boolean bl = loadGEToScreen = !this.isUsingSoftwareRenderer() && !VideoEngine.getInstance().isSkipThisFrame();
        if (copyGEToMemory && (this.topaddrGe != topaddr || this.pixelformatGe != pixelformat)) {
            this.copyGeToMemory(false);
            loadGEToScreen = true;
        }
        this.topaddrGe = topaddr;
        this.bufferwidthGe = bufferwidth;
        this.pixelformatGe = pixelformat;
        this.widthGe = width;
        this.heightGe = height;
        this.bottomaddrGe = this.topaddrGe + this.bufferwidthGe * this.heightGe * sceDisplay.getPixelFormatBytes(this.pixelformatGe);
        this.pixelsGe = this.getPixels(this.topaddrGe, this.bottomaddrGe);
        this.checkTemp();
        if (loadGEToScreen) {
            this.loadGEToScreen();
            if (State.captureGeNextFrame) {
                this.captureGeImage();
            }
        }
        this.setGeBufCalledAtLeastOnce = true;
    }

    public static int getPixelFormatBytes(int pixelformat) {
        return IRenderingEngine.sizeOfTextureType[pixelformat];
    }

    private Buffer getPixels(int topaddr, int bottomaddr) {
        Buffer pixels = Memory.getInstance().getBuffer(topaddr, bottomaddr - topaddr);
        return pixels;
    }

    public boolean isGeAddress(int address) {
        return (address &= 0x3FFFFFFF) >= this.topaddrGe && address < this.bottomaddrGe;
    }

    public boolean isFbAddress(int address) {
        return (address &= 0x3FFFFFFF) >= this.topaddrFb && address < this.bottomaddrFb;
    }

    public boolean isOnlyGEGraphics() {
        return this.onlyGEGraphics;
    }

    private void setOnlyGEGraphics(boolean onlyGEGraphics) {
        this.onlyGEGraphics = onlyGEGraphics;
        VideoEngine.log.info((Object)("Only GE Graphics: " + onlyGEGraphics));
    }

    private void setUseSoftwareRenderer(boolean useSoftwareRenderer) {
        this.useSoftwareRenderer = useSoftwareRenderer;
        if (useSoftwareRenderer) {
            if (this.softwareRenderingDisplayThread == null) {
                // empty if block
            }
        } else if (this.softwareRenderingDisplayThread != null) {
            log.debug((Object)"Stopping Software Rendering Display Thread");
            this.softwareRenderingDisplayThread.exit();
            this.softwareRenderingDisplayThread = null;
        }
    }

    public boolean isUsingSoftwareRenderer() {
        return this.useSoftwareRenderer;
    }

    public void rotate(int angleId) {
        this.ang = angleId;
        switch (angleId) {
            case 0: {
                this.texS1 = this.texS2 = this.texS;
                this.texT2 = this.texT3 = this.texT;
                this.texT4 = 0.0f;
                this.texT1 = 0.0f;
                this.texS4 = 0.0f;
                this.texS3 = 0.0f;
                this.isrotating = true;
                break;
            }
            case 1: {
                this.texS3 = this.texS4 = this.texS;
                this.texT1 = this.texT4 = this.texT;
                this.texT3 = 0.0f;
                this.texT2 = 0.0f;
                this.texS2 = 0.0f;
                this.texS1 = 0.0f;
                this.isrotating = true;
                break;
            }
            case 2: {
                this.texS1 = this.texS4 = this.texS;
                this.texT3 = this.texT4 = this.texT;
                this.texT2 = 0.0f;
                this.texT1 = 0.0f;
                this.texS3 = 0.0f;
                this.texS2 = 0.0f;
                this.isrotating = true;
                break;
            }
            case 3: {
                this.texS2 = this.texS3 = this.texS;
                this.texT1 = this.texT2 = this.texT;
                this.texT4 = 0.0f;
                this.texT3 = 0.0f;
                this.texS4 = 0.0f;
                this.texS1 = 0.0f;
                this.isrotating = true;
                break;
            }
            default: {
                this.isrotating = false;
            }
        }
    }

    public void saveScreen() {
        int tag = 0;
        String fileName = State.discId + "-" + "Shot" + "-" + tag + ".png";
        File screenshot = new File(fileName);
        File directory = new File(System.getProperty("user.dir"));
        for (File file : directory.listFiles()) {
            if (!file.getName().contains(State.discId + "-" + "Shot")) continue;
            fileName = State.discId + "-" + "Shot" + "-" + ++tag + ".png";
            screenshot = new File(fileName);
        }
        Rectangle rect = new Rectangle(this.captureX, this.captureY, this.captureWidth, this.captureHeight);
        try {
            BufferedImage img = this.captureRobot.createScreenCapture(rect);
            ImageIO.write((RenderedImage)img, "png", screenshot);
            img.flush();
        }
        catch (Exception e) {
            return;
        }
        this.getscreen = false;
    }

    public int getTopAddrFb() {
        return this.topaddrFb;
    }

    public int getBufferWidthFb() {
        return this.bufferwidthFb;
    }

    public int getPixelFormatFb() {
        return this.pixelformatFb;
    }

    public int getSync() {
        return this.sync;
    }

    public int getWidthFb() {
        return this.width;
    }

    public int getHeightFb() {
        return this.height;
    }

    public int getTopAddrGe() {
        return this.topaddrGe;
    }

    public int getBufferWidthGe() {
        return this.bufferwidthGe;
    }

    public int getWidthGe() {
        return this.widthGe;
    }

    public int getHeightGe() {
        return this.heightGe;
    }

    public BufferInfo getBufferInfoGe() {
        return new BufferInfo(this.topaddrGe, this.bottomaddrGe, this.widthGe, this.heightGe, this.bufferwidthGe, this.pixelformatGe);
    }

    public BufferInfo getBufferInfoFb() {
        return new BufferInfo(this.topaddrFb, this.bottomaddrFb, this.width, this.height, this.bufferwidthFb, this.pixelformatFb);
    }

    public boolean getSaveGEToTexture() {
        return this.saveGEToTexture;
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public void captureGeImage() {
        if (this.isUsingSoftwareRenderer()) {
            Buffer buffer = Memory.getInstance().getBuffer(this.topaddrGe, this.bufferwidthGe * this.heightGe * sceDisplay.getPixelFormatBytes(this.pixelformatGe));
            CaptureManager.captureImage(this.topaddrGe, 0, buffer, this.widthGe, this.heightGe, this.bufferwidthGe, this.pixelformatGe, false, 0, false, false);
            return;
        }
        int texGe = this.re.genTexture();
        this.re.bindTexture(texGe);
        this.re.setTextureFormat(this.pixelformatGe, false);
        this.re.setTexImage(0, 3, sceDisplay.getResizedWidthPow2(this.bufferwidthGe), sceDisplay.getResizedHeightPow2(Utilities.makePow2(this.heightGe)), this.pixelformatGe, this.pixelformatGe, 0, null);
        this.re.setTextureMipmapMinFilter(0);
        this.re.setTextureMipmapMagFilter(0);
        this.re.setTextureMipmapMinLevel(0);
        this.re.setTextureMipmapMaxLevel(0);
        this.re.setTextureWrapMode(1, 1);
        this.re.setPixelStore(sceDisplay.getResizedWidthPow2(this.bufferwidthGe), sceDisplay.getPixelFormatBytes(this.pixelformatGe));
        this.re.copyTexSubImage(0, 0, 0, 0, 0, sceDisplay.getResizedWidth(Math.min(this.widthGe, this.bufferwidthGe)), sceDisplay.getResizedHeight(this.heightGe));
        this.temp.clear();
        this.re.getTexImage(0, this.pixelformatGe, this.pixelformatGe, this.temp);
        CaptureManager.captureImage(this.topaddrGe, 0, this.temp, sceDisplay.getResizedWidth(this.widthGe), sceDisplay.getResizedHeight(this.heightGe), sceDisplay.getResizedWidthPow2(this.bufferwidthGe), this.pixelformatGe, false, 0, true, false);
        this.re.deleteTexture(texGe);
    }

    public void captureCurrentTexture(int address, int width, int height, int bufferWidth, int pixelFormat) {
        this.re.setPixelStore(bufferWidth, sceDisplay.getPixelFormatBytes(pixelFormat));
        this.temp.clear();
        this.re.getTexImage(0, pixelFormat, pixelFormat, this.temp);
        CaptureManager.captureImage(address, 0, this.temp, width, height, bufferWidth, pixelFormat, false, 0, true, false);
    }

    private void reportFPSStats() {
        long timeNow = System.currentTimeMillis();
        long realElapsedTime = timeNow - this.prevStatsTime;
        if (realElapsedTime > 1000L) {
            ++this.reportCount;
            int lastFPS = (int)(this.frameCount - this.prevFrameCount);
            this.averageFPS = (double)this.frameCount / (double)this.reportCount;
            this.prevFrameCount = this.frameCount;
            this.prevStatsTime = timeNow;
            Emulator.setFpsTitle(String.format("FPS: %d, averageFPS: %.1f", lastFPS, this.averageFPS));
        }
    }

    private void loadGEToScreen() {
        if (VideoEngine.log.isDebugEnabled()) {
            VideoEngine.log.debug((Object)String.format("Reloading GE Memory (0x%08X-0x%08X) to screen (%dx%d)", this.topaddrGe, this.bottomaddrGe, this.widthGe, this.heightGe));
        }
        if (this.statisticsCopyMemoryToGe != null) {
            this.statisticsCopyMemoryToGe.start();
        }
        if (this.saveGEToTexture && !VideoEngine.getInstance().isVideoTexture(this.topaddrGe)) {
            GETexture geTexture = GETextureManager.getInstance().getGETexture(this.re, this.topaddrGe, this.bufferwidthGe, this.widthGe, this.heightGe, this.pixelformatGe, true);
            geTexture.copyTextureToScreen(this.re);
        } else {
            if (this.re.isVertexArrayAvailable()) {
                this.re.bindVertexArray(0);
            }
            this.re.bindTexture(this.texFb);
            this.re.setPixelStore(this.bufferwidthGe, sceDisplay.getPixelFormatBytes(this.pixelformatGe));
            int textureSize = this.bufferwidthGe * this.heightGe * sceDisplay.getPixelFormatBytes(this.pixelformatGe);
            this.pixelsGe.clear();
            this.re.setTexSubImage(0, 0, 0, this.bufferwidthGe, this.heightGe, this.pixelformatGe, this.pixelformatGe, textureSize, this.pixelsGe);
            this.drawFrameBuffer(false, true, this.bufferwidthGe, this.pixelformatGe, this.widthGe, this.heightGe);
        }
        if (this.statisticsCopyMemoryToGe != null) {
            this.statisticsCopyMemoryToGe.end();
        }
    }

    public void copyGeToMemory(boolean preserveScreen) {
        if (this.isUsingSoftwareRenderer()) {
            return;
        }
        if (VideoEngine.log.isDebugEnabled()) {
            VideoEngine.log.debug((Object)String.format("Copy GE Screen to Memory 0x%08X-0x%08X", this.topaddrGe, this.bottomaddrGe));
        }
        if (this.statisticsCopyGeToMemory != null) {
            this.statisticsCopyGeToMemory.start();
        }
        if (this.saveGEToTexture && !VideoEngine.getInstance().isVideoTexture(this.topaddrGe)) {
            GETexture geTexture = GETextureManager.getInstance().getGETexture(this.re, this.topaddrGe, this.bufferwidthGe, this.widthGe, this.heightGe, this.pixelformatGe, true);
            geTexture.copyScreenToTexture(this.re);
        } else {
            this.re.bindTexture(this.resizedTexFb);
            this.re.setTextureFormat(this.pixelformatGe, false);
            this.re.copyTexSubImage(0, 0, 0, 0, 0, sceDisplay.getResizedWidth(Math.min(this.bufferwidthGe, this.widthGe)), sceDisplay.getResizedHeight(this.heightGe));
            this.drawFrameBuffer(true, true, this.bufferwidthGe, this.pixelformatGe, this.widthGe, this.heightGe);
            this.copyScreenToPixels(this.pixelsGe, this.bufferwidthGe, this.pixelformatGe, this.widthGe, this.heightGe);
            if (preserveScreen) {
                this.drawFrameBuffer(true, false, this.bufferwidthGe, this.pixelformatGe, this.widthGe, this.heightGe);
            }
        }
        if (this.statisticsCopyGeToMemory != null) {
            this.statisticsCopyGeToMemory.end();
        }
        if (GEProfiler.isProfilerEnabled()) {
            GEProfiler.copyGeToMemory();
        }
    }

    private void drawFrameBuffer(boolean keepOriginalSize, boolean invert, int bufferwidth, int pixelformat, int width, int height) {
        if (!this.isrotating) {
            this.texS1 = this.texS4 = this.texS;
            this.texT1 = this.texT2 = this.texT;
            this.texT4 = 0.0f;
            this.texT3 = 0.0f;
            this.texS3 = 0.0f;
            this.texS2 = 0.0f;
        }
        this.reDisplay.startDirectRendering(true, false, true, true, !invert, width, height);
        if (keepOriginalSize) {
            this.reDisplay.setViewport(0, 0, width, height);
        } else {
            this.reDisplay.setViewport(0, 0, sceDisplay.getResizedWidth(width), sceDisplay.getResizedHeight(height));
        }
        this.reDisplay.setTextureFormat(pixelformat, false);
        IREBufferManager bufferManager = this.reDisplay.getBufferManager();
        ByteBuffer drawByteBuffer = bufferManager.getBuffer(this.drawBuffer);
        drawByteBuffer.clear();
        FloatBuffer drawFloatBuffer = drawByteBuffer.asFloatBuffer();
        drawFloatBuffer.clear();
        drawFloatBuffer.put(this.texS1);
        drawFloatBuffer.put(this.texT1);
        drawFloatBuffer.put(width);
        drawFloatBuffer.put(height);
        drawFloatBuffer.put(this.texS2);
        drawFloatBuffer.put(this.texT2);
        drawFloatBuffer.put(0.0f);
        drawFloatBuffer.put(height);
        drawFloatBuffer.put(this.texS3);
        drawFloatBuffer.put(this.texT3);
        drawFloatBuffer.put(0.0f);
        drawFloatBuffer.put(0.0f);
        drawFloatBuffer.put(this.texS4);
        drawFloatBuffer.put(this.texT4);
        drawFloatBuffer.put(width);
        drawFloatBuffer.put(0.0f);
        if (this.reDisplay.isVertexArrayAvailable()) {
            this.reDisplay.bindVertexArray(0);
        }
        this.reDisplay.setVertexInfo(null, false, false, true, 7);
        this.reDisplay.enableClientState(0);
        this.reDisplay.disableClientState(1);
        this.reDisplay.disableClientState(2);
        this.reDisplay.enableClientState(3);
        bufferManager.setTexCoordPointer(this.drawBuffer, 2, 6, 4 * VideoEngine.SIZEOF_FLOAT, 0);
        bufferManager.setVertexPointer(this.drawBuffer, 2, 6, 4 * VideoEngine.SIZEOF_FLOAT, 2 * VideoEngine.SIZEOF_FLOAT);
        bufferManager.setBufferData(this.drawBuffer, drawFloatBuffer.position() * VideoEngine.SIZEOF_FLOAT, drawByteBuffer.rewind(), 6);
        this.reDisplay.drawArrays(7, 0, 4);
        this.reDisplay.endDirectRendering();
        this.isrotating = false;
    }

    private void drawFrameBufferFromMemory() {
        this.pixelsFb.clear();
        this.reDisplay.bindTexture(this.texFb);
        this.reDisplay.setTextureFormat(this.pixelformatFb, false);
        this.reDisplay.setPixelStore(this.bufferwidthFb, this.pixelformatFb);
        int textureSize = this.bufferwidthFb * this.height * sceDisplay.getPixelFormatBytes(this.pixelformatFb);
        this.reDisplay.setTexSubImage(0, 0, 0, this.bufferwidthFb, this.height, this.pixelformatFb, this.pixelformatFb, textureSize, this.pixelsFb);
        if (this.ang != 4) {
            this.rotate(this.ang);
        }
        this.drawFrameBuffer(false, true, this.bufferwidthFb, this.pixelformatFb, this.width, this.height);
    }

    private void copyBufferByLines(IntBuffer dstBuffer, IntBuffer srcBuffer, int dstBufferWidth, int srcBufferWidth, int pixelFormat, int width, int height) {
        int pixelsPerElement = 4 / sceDisplay.getPixelFormatBytes(pixelFormat);
        for (int y = 0; y < height; ++y) {
            int srcStartOffset = y * srcBufferWidth / pixelsPerElement;
            int dstStartOffset = y * dstBufferWidth / pixelsPerElement;
            srcBuffer.limit(srcStartOffset + (width + 1) / pixelsPerElement);
            srcBuffer.position(srcStartOffset);
            dstBuffer.position(dstStartOffset);
            if (srcBuffer.remaining() >= dstBuffer.remaining()) continue;
            dstBuffer.put(srcBuffer);
        }
    }

    private void copyScreenToPixels(Buffer pixels, int bufferWidth, int pixelFormat, int width, int height) {
        this.reDisplay.bindTexture(this.texFb);
        this.reDisplay.setTextureFormat(this.pixelformatFb, false);
        this.reDisplay.setPixelStore(bufferWidth, sceDisplay.getPixelFormatBytes(pixelFormat));
        this.reDisplay.copyTexSubImage(0, 0, 0, 0, 0, Math.min(bufferWidth, width), height);
        Buffer buffer = pixels.capacity() >= this.temp.capacity() ? pixels : this.temp;
        buffer.clear();
        this.reDisplay.getTexImage(0, pixelFormat, pixelFormat, buffer);
        if (buffer == this.temp) {
            this.temp.clear();
            pixels.clear();
            this.temp.limit(pixels.limit());
            if (this.temp instanceof ByteBuffer) {
                ByteBuffer srcBuffer = (ByteBuffer)this.temp;
                ByteBuffer dstBuffer = (ByteBuffer)pixels;
                dstBuffer.put(srcBuffer);
            } else if (this.temp instanceof IntBuffer) {
                IntBuffer srcBuffer = (IntBuffer)this.temp;
                IntBuffer dstBuffer = (IntBuffer)pixels;
                VideoEngine videoEngine = VideoEngine.getInstance();
                if (videoEngine.isUsingTRXKICK() && videoEngine.getMaxSpriteHeight() < Integer.MAX_VALUE) {
                    int srcBufferWidth = bufferWidth;
                    int dstBufferWidth = bufferWidth;
                    int pixelsPerElement = 4 / sceDisplay.getPixelFormatBytes(pixelFormat);
                    int maxHeight = videoEngine.getMaxSpriteHeight();
                    int maxWidth = videoEngine.getMaxSpriteWidth();
                    int textureAlignment = pixelsPerElement == 1 ? 3 : 7;
                    maxHeight = maxHeight + textureAlignment & ~textureAlignment;
                    maxWidth = maxWidth + textureAlignment & ~textureAlignment;
                    if (VideoEngine.log.isDebugEnabled()) {
                        VideoEngine.log.debug((Object)("maxSpriteHeight=" + maxHeight + ", maxSpriteWidth=" + maxWidth));
                    }
                    if (maxHeight > height) {
                        maxHeight = height;
                    }
                    if (maxWidth > width) {
                        maxWidth = width;
                    }
                    this.copyBufferByLines(dstBuffer, srcBuffer, dstBufferWidth, srcBufferWidth, pixelFormat, maxWidth, maxHeight);
                } else {
                    dstBuffer.put(srcBuffer);
                }
            } else {
                throw new RuntimeException("unhandled buffer type");
            }
        }
    }

    protected void blockCurrentThreadOnVblank(int cycles, boolean doCallbacks) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = threadMan.getCurrentThread();
        int threadId = threadMan.getCurrentThreadID();
        int lastWaitVblank = thread.displayLastWaitVcount;
        int unblockVcount = lastWaitVblank + cycles;
        if (unblockVcount <= this.vcount) {
            UnblockThreadAction vblankAction = new UnblockThreadAction(threadId);
            IntrManager.getInstance().addVBlankActionOnce(vblankAction);
            thread.displayLastWaitVcount = this.vcount + 1;
        } else {
            WaitVblankInfo waitVblankInfo = new WaitVblankInfo(threadId, unblockVcount);
            this.waitingOnVblank.add(waitVblankInfo);
        }
        if (doCallbacks) {
            threadMan.hleBlockCurrentThreadCB(null, new VblankWaitStateChecker(this.vcount + cycles));
        } else {
            threadMan.hleBlockCurrentThread();
        }
    }

    private void hleVblankStart() {
        this.lastVblankMicroTime = Emulator.getClock().microTime();
        ++this.vcount;
        if (!this.waitingOnVblank.isEmpty()) {
            ListIterator<WaitVblankInfo> lit = this.waitingOnVblank.listIterator();
            while (lit.hasNext()) {
                WaitVblankInfo waitVblankInfo = lit.next();
                if (waitVblankInfo.unblockVcount > this.vcount) continue;
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                SceKernelThreadInfo thread = threadMan.getThreadById(waitVblankInfo.threadId);
                if (thread != null) {
                    thread.displayLastWaitVcount = this.vcount;
                    threadMan.hleUnblockThread(waitVblankInfo.threadId);
                }
                lit.remove();
            }
        }
    }

    private boolean isVblank() {
        long nowMicroTime = Emulator.getClock().microTime();
        long microTimeSinceLastVblank = nowMicroTime - this.lastVblankMicroTime;
        return microTimeSinceLastVblank <= 731L;
    }

    private int getCurrentHcount() {
        long nowMicroTime = Emulator.getClock().microTime();
        long microTimeSinceLastVblank = nowMicroTime - this.lastVblankMicroTime;
        float vblankStep = (float)microTimeSinceLastVblank / 16666.666f;
        if (vblankStep > 1.0f) {
            vblankStep = 1.0f;
        }
        return (int)(vblankStep * 285.72f);
    }

    public int getVcount() {
        return this.vcount;
    }

    private int createTexture(int textureId, boolean isResized) {
        if (textureId != -1) {
            this.reDisplay.deleteTexture(textureId);
        }
        textureId = this.reDisplay.genTexture();
        this.reDisplay.bindTexture(textureId);
        this.reDisplay.setTextureFormat(this.pixelformatFb, false);
        this.reDisplay.setTexImage(0, 3, isResized ? sceDisplay.getResizedWidthPow2(this.bufferwidthFb) : this.bufferwidthFb, isResized ? sceDisplay.getResizedHeightPow2(Utilities.makePow2(this.height)) : Utilities.makePow2(this.height), this.pixelformatFb, this.pixelformatFb, 0, null);
        this.reDisplay.setTextureMipmapMinFilter(0);
        this.reDisplay.setTextureMipmapMagFilter(0);
        this.reDisplay.setTextureMipmapMinLevel(0);
        this.reDisplay.setTextureMipmapMaxLevel(0);
        this.reDisplay.setTextureWrapMode(1, 1);
        return textureId;
    }

    private void checkTemp() {
        int sizeInBytes = sceDisplay.getResizedWidthPow2(Math.max(this.bufferwidthFb, this.bufferwidthGe)) * sceDisplay.getResizedHeightPow2(Utilities.makePow2(Math.max(this.height, this.heightGe))) * sceDisplay.getPixelFormatBytes(Math.max(this.pixelformatFb, this.pixelformatGe));
        if (sizeInBytes > this.tempSize) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(sizeInBytes).order(ByteOrder.LITTLE_ENDIAN);
            this.temp = Memory.getInstance().getMainMemoryByteBuffer() instanceof IntBuffer ? byteBuffer.asIntBuffer() : byteBuffer;
            this.tempSize = sizeInBytes;
        }
    }

    public void setCalledFromCommandLine() {
        this.calledFromCommandLine = true;
    }

    @HLEFunction(nid=237039991, version=150, checkInsideInterrupt=true)
    public int sceDisplaySetMode(int displayMode, int displayWidth, int displayHeight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceDisplaySetMode(mode=" + displayMode + ",width=" + displayWidth + ",height=" + displayHeight + ")"));
        }
        if (displayWidth <= 0 || displayHeight <= 0) {
            return -2147483388;
        }
        if (displayMode != 0) {
            return -2147483385;
        }
        this.mode = displayMode;
        this.width = displayWidth;
        this.height = displayHeight;
        this.bottomaddrFb = this.topaddrFb + this.bufferwidthFb * displayHeight * sceDisplay.getPixelFormatBytes(this.pixelformatFb);
        this.pixelsFb = this.getPixels(this.topaddrFb, this.bottomaddrFb);
        this.detailsDirty = true;
        return 0;
    }

    @HLEFunction(nid=-559835180, version=150)
    public int sceDisplayGetMode(TPointer32 modeAddr, TPointer32 widthAddr, TPointer32 heightAddr) {
        modeAddr.setValue(this.mode);
        widthAddr.setValue(this.width);
        heightAddr.setValue(this.height);
        return 0;
    }

    @HLEFunction(nid=-609827644, version=150)
    public float sceDisplayGetFramePerSec() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceDisplayGetFramePerSec ret: 59.94006");
        }
        return 59.94006f;
    }

    @HLEFunction(nid=2127928260, version=150, checkInsideInterrupt=true)
    @HLEUnimplemented
    public int sceDisplaySetHoldMode(int holdMode) {
        log.warn((Object)("IGNORING: sceDisplaySetHoldMode holdMode=" + holdMode));
        return 0;
    }

    @HLEFunction(nid=-1522219898, version=150, checkInsideInterrupt=true)
    @HLEUnimplemented
    public int sceDisplaySetResumeMode(int resumeMode) {
        log.warn((Object)("IGNORING: sceDisplaySetResumeMode resumeMode=" + resumeMode));
        return 0;
    }

    @HLEFunction(nid=681411326, version=150)
    public int sceDisplaySetFrameBuf(int topaddr, int bufferwidth, int pixelformat, int syncType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplaySetFrameBuf(topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, syncType=%d)", topaddr, bufferwidth, pixelformat, syncType));
        }
        return this.hleDisplaySetFrameBuf(topaddr, bufferwidth, pixelformat, syncType);
    }

    public int hleDisplaySetFrameBuf(int topaddr, int bufferwidth, int pixelformat, int syncType) {
        if (bufferwidth < 0 || (bufferwidth & bufferwidth - 1) != 0 || bufferwidth == 0 && (topaddr &= 0x3FFFFFFF) != 0) {
            log.warn((Object)("sceDisplaySetFrameBuf(topaddr=0x" + Integer.toHexString(topaddr) + ", bufferwidth=" + bufferwidth + ", pixelformat=" + pixelformat + ", syncType=" + syncType + ") bad bufferwidth"));
            this.isFbShowing = false;
            this.gotBadFbBufParams = true;
            return -2147483388;
        }
        if (pixelformat < 0 || pixelformat > 3) {
            log.warn((Object)("sceDisplaySetFrameBuf(topaddr=0x" + Integer.toHexString(topaddr) + ", bufferwidth=" + bufferwidth + ", pixelformat=" + pixelformat + ", syncType=" + syncType + ") bad pixelformat"));
            this.isFbShowing = false;
            this.gotBadFbBufParams = true;
            return -1;
        }
        if (syncType != 0 && syncType != 1) {
            log.warn((Object)("sceDisplaySetFrameBuf(topaddr=0x" + Integer.toHexString(topaddr) + ", bufferwidth=" + bufferwidth + ", pixelformat=" + pixelformat + ", syncType=" + syncType + ") bad syncType"));
            this.isFbShowing = false;
            this.gotBadFbBufParams = true;
            return -2147483385;
        }
        if (topaddr == 0) {
            log.warn((Object)("sceDisplaySetFrameBuf(topaddr=0x" + Integer.toHexString(topaddr) + ", bufferwidth=" + bufferwidth + ", pixelformat=" + pixelformat + ", syncType=" + syncType + ") (blocking display output)"));
            this.isFbShowing = false;
            this.gotBadFbBufParams = true;
            return 0;
        }
        if (!Memory.isAddressGood(topaddr)) {
            return -2147483389;
        }
        if (topaddr != this.topaddrFb) {
            ++this.frameCount;
        }
        this.framesSkippedInSequence = this.skipNextFrameBufferSwitch ? ++this.framesSkippedInSequence : 0;
        boolean skipThisFrame = false;
        if (this.desiredFps > 0) {
            long currentFrameTimestamp = Emulator.getClock().currentTimeMillis();
            this.frameTimestamps.addLast(currentFrameTimestamp);
            while (currentFrameTimestamp - this.frameTimestamps.getFirst() > 1000L) {
                this.frameTimestamps.removeFirst();
            }
            int currentFps = this.frameTimestamps.size();
            if (currentFps < this.desiredFps && this.framesSkippedInSequence < this.maxFramesSkippedInSequence) {
                skipThisFrame = true;
            }
        }
        VideoEngine.getInstance().setSkipThisFrame(skipThisFrame);
        if (this.skipNextFrameBufferSwitch) {
            if (topaddr != this.topaddrFb) {
                Memory.getInstance().memcpy(topaddr, this.topaddrFb, this.bottomaddrFb - this.topaddrFb);
            }
            this.skipNextFrameBufferSwitch = false;
        }
        if (this.gotBadFbBufParams) {
            this.gotBadFbBufParams = false;
            log.info((Object)String.format("sceDisplaySetFrameBuf(topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, syncType=%d ok", topaddr, bufferwidth, pixelformat, syncType));
        }
        if (pixelformat != this.pixelformatFb || bufferwidth != this.bufferwidthFb || Utilities.makePow2(this.height) != Utilities.makePow2(this.height)) {
            this.createTex = true;
        }
        this.topaddrFb = topaddr;
        this.bufferwidthFb = bufferwidth;
        this.pixelformatFb = pixelformat;
        this.sync = syncType;
        this.bottomaddrFb = topaddr + this.bufferwidthFb * this.height * sceDisplay.getPixelFormatBytes(this.pixelformatFb);
        this.pixelsFb = this.getPixels(this.topaddrFb, this.bottomaddrFb);
        this.texS = (float)this.width / (float)bufferwidth;
        this.texT = (float)this.height / (float)Utilities.makePow2(this.height);
        this.detailsDirty = true;
        if (State.captureGeNextFrame && CaptureManager.hasListExecuted()) {
            CaptureManager.captureFrameBufDetails();
            CaptureManager.endCapture();
            State.captureGeNextFrame = false;
        }
        this.isFbShowing = true;
        VideoEngine.getInstance().hleSetFrameBuf(this.topaddrFb, this.bufferwidthFb, this.pixelformatFb);
        return 0;
    }

    @HLEFunction(nid=-287691180, version=150)
    public int sceDisplayGetFrameBuf(TPointer32 topaddrAddr, TPointer32 bufferwidthAddr, TPointer32 pixelformatAddr, int syncType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetFrameBuf topaddrAddr=0x%08X, bufferwidthAddr=0x%08X, pixelformatAddr=0x%08X, sync=%d", topaddrAddr.getAddress(), bufferwidthAddr.getAddress(), pixelformatAddr.getAddress(), syncType));
        }
        topaddrAddr.setValue(this.topaddrFb);
        bufferwidthAddr.setValue(this.bufferwidthFb);
        pixelformatAddr.setValue(this.pixelformatFb);
        return 0;
    }

    @HLEFunction(nid=-1259112198, version=150)
    public boolean sceDisplayIsForeground() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceDisplayIsForeground ret: " + this.isFbShowing));
        }
        return this.isFbShowing;
    }

    @HLEFunction(nid=834976424, version=150)
    @HLEUnimplemented
    public int sceDisplayGetBrightness(int leveladdr, int unkaddr) {
        log.warn((Object)("IGNORING: sceDisplayGetBrightness leveladdr=0x" + Integer.toHexString(leveladdr) + ", unkaddr=0x" + Integer.toHexString(unkaddr)));
        return 0;
    }

    @HLEFunction(nid=-1670468905, version=150)
    public int sceDisplayGetVcount() {
        return this.vcount;
    }

    @HLEFunction(nid=1296961772, version=150)
    public void sceDisplayIsVblank(Processor processor) {
        CpuState cpu = processor.cpu;
        int n = cpu.gpr[2] = this.isVblank() ? 1 : 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceDisplayIsVblank returns " + cpu.gpr[2]));
        }
    }

    @HLEFunction(nid=919468766, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblank() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceDisplayWaitVblank");
        }
        if (!this.isVblank()) {
            this.sceDisplayWaitVblankStart();
        }
        return 0;
    }

    @HLEFunction(nid=-1900417975, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankCB() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceDisplayWaitVblankCB");
        }
        if (!this.isVblank()) {
            this.sceDisplayWaitVblankStartCB();
        }
        return 0;
    }

    @HLEFunction(nid=-1739839513, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankStart() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceDisplayWaitVblankStart");
        }
        this.blockCurrentThreadOnVblank(1, false);
        return 0;
    }

    @HLEFunction(nid=1190233795, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankStartCB() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceDisplayWaitVblankStartCB");
        }
        this.blockCurrentThreadOnVblank(1, true);
        return 0;
    }

    @HLEFunction(nid=2000540579, version=150)
    public int sceDisplayGetCurrentHcount() {
        int currentHcount = this.getCurrentHcount();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetCurrentHcount returning %d", currentHcount));
        }
        return currentHcount;
    }

    @HLEFunction(nid=554609466, version=150)
    public int sceDisplayGetAccumulatedHcount() {
        int currentHcount = this.getCurrentHcount();
        int accumulatedHcount = currentHcount + (int)((float)this.vcount * 285.72f);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetAccumulatedHcount returning %d (currentHcount=%d)", accumulatedHcount, currentHcount));
        }
        return accumulatedHcount;
    }

    @HLEFunction(nid=-1472270023, version=150)
    @HLEUnimplemented
    public int sceDisplayAdjustAccumulatedHcount() {
        return 0;
    }

    public static class BufferInfo {
        public int topAddr;
        public int bottomAddr;
        public int width;
        public int height;
        public int bufferWidth;
        public int pixelFormat;

        public BufferInfo(int topAddr, int bottomAddr, int width, int height, int bufferWidth, int pixelFormat) {
            this.topAddr = topAddr;
            this.bottomAddr = bottomAddr;
            this.width = width;
            this.height = height;
            this.bufferWidth = bufferWidth;
            this.pixelFormat = pixelFormat;
        }
    }

    private class DisplaySettingsListener
    implements ISettingsListener {
        private DisplaySettingsListener() {
        }

        @Override
        public void settingsValueChanged(String option, String value) {
            if (sceDisplay.this.isStarted) {
                sceDisplay.this.resetDisplaySettings = true;
            }
        }
    }

    private class AntiAliasSettingsListerner
    extends AbstractStringSettingsListener {
        private Pattern pattern = Pattern.compile("x(\\d+)", 2);

        private AntiAliasSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(String value) {
            Matcher matcher;
            int samples = 0;
            if (value != null && (matcher = this.pattern.matcher(value)).matches()) {
                samples = Integer.parseInt(matcher.group(1));
            }
            sceDisplay.this.setAntiAliasSamplesNum(samples);
        }
    }

    private class VblankWaitStateChecker
    implements IWaitStateChecker {
        private int vcount;

        public VblankWaitStateChecker(int vcount) {
            this.vcount = vcount;
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            return sceDisplay.this.vcount < this.vcount;
        }
    }

    private class DisplayVblankAction
    implements IAction {
        private DisplayVblankAction() {
        }

        @Override
        public void execute() {
            sceDisplay.this.hleVblankStart();
        }
    }

    private static class SoftwareRenderingDisplayThread
    extends AbstractDisplayThread {
        private SoftwareRenderingDisplayThread() {
        }

        @Override
        protected void doDisplay() {
            IRenderingEngine re = Modules.sceDisplayModule.getRenderingEngine();
            if (re != null && VideoEngine.getInstance().hasDrawLists()) {
                re.startDisplay();
                VideoEngine.getInstance().update();
                re.endDisplay();
            }
        }
    }

    private static class AsyncDisplayThread
    extends AbstractDisplayThread {
        private AsyncDisplayThread() {
        }

        @Override
        protected void doDisplay() {
            if (!Modules.sceDisplayModule.isOnlyGEGraphics() || VideoEngine.getInstance().hasDrawLists()) {
                Modules.sceDisplayModule.canvas.repaint();
            }
        }
    }

    private static abstract class AbstractDisplayThread
    extends Thread {
        private Semaphore displaySemaphore = new Semaphore(1);
        protected boolean run = true;

        public AbstractDisplayThread() {
            VideoEngine.getInstance();
        }

        @Override
        public void run() {
            while (this.run) {
                this.waitForDisplay();
                if (!this.run) continue;
                this.doDisplay();
            }
        }

        protected abstract void doDisplay();

        public void display() {
            this.displaySemaphore.release();
        }

        private void waitForDisplay() {
            while (true) {
                try {
                    int availablePermits;
                    while ((availablePermits = this.displaySemaphore.drainPermits()) <= 0 && !this.displaySemaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void exit() {
            this.run = false;
            this.display();
        }
    }

    private static class WaitVblankInfo {
        public int threadId;
        public int unblockVcount;

        public WaitVblankInfo(int threadId, int unblockVcount) {
            this.threadId = threadId;
            this.unblockVcount = unblockVcount;
        }
    }

    private class SoftwareRendererSettingsListener
    extends AbstractBoolSettingsListener {
        private SoftwareRendererSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceDisplay.this.setUseSoftwareRenderer(value);
            if (sceDisplay.this.isStarted) {
                sceDisplay.this.resetDisplaySettings = true;
            }
        }
    }

    private class OnlyGeSettingsListener
    extends AbstractBoolSettingsListener {
        private OnlyGeSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceDisplay.this.setOnlyGEGraphics(value);
        }
    }

    class AWTGLCanvas_sceDisplay
    extends AWTGLCanvas {
        public AWTGLCanvas_sceDisplay() throws LWJGLException {
            super(null, new PixelFormat().withBitsPerPixel(8).withAlphaBits(8).withStencilBits(8).withSamples(sceDisplay.this.antiAliasSamplesNum), null, new ContextAttribs().withDebug(false));
        }

        @Override
        protected void paintGL() {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("paintGL resize=%f, size(%dx%d), canvas(%dx%d), location(%d,%d)", Float.valueOf(viewportResizeFilterScaleFactor), sceDisplay.this.canvas.getSize().width, sceDisplay.this.canvas.getSize().height, sceDisplay.this.canvasWidth, sceDisplay.this.canvasHeight, sceDisplay.this.canvas.getLocation().x, sceDisplay.this.canvas.getLocation().y));
            }
            if (sceDisplay.this.resizePending && Emulator.getMainGUI().isVisible()) {
                Emulator.getMainGUI().pack();
                sceDisplay.this.resizePending = false;
            }
            if (sceDisplay.this.statistics != null) {
                sceDisplay.this.statistics.start();
            }
            if (sceDisplay.this.resetDisplaySettings) {
                TextureCache.getInstance().reset(sceDisplay.this.re);
                sceDisplay.this.startModules = true;
                sceDisplay.this.re = null;
                sceDisplay.this.reDisplay = null;
                sceDisplay.this.resetDisplaySettings = false;
                sceDisplay.this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
                if (sceDisplay.this.saveGEToTexture) {
                    log.info((Object)"Saving GE to Textures");
                }
            }
            if (sceDisplay.this.re == null) {
                if (sceDisplay.this.startModules) {
                    sceDisplay.this.re = RenderingEngineFactory.createRenderingEngine();
                    if (sceDisplay.this.isUsingSoftwareRenderer()) {
                        sceDisplay.this.reDisplay = RenderingEngineFactory.createRenderingEngineForDisplay();
                        sceDisplay.this.reDisplay.setGeContext(VideoEngine.getInstance().getContext());
                    } else {
                        sceDisplay.this.reDisplay = sceDisplay.this.re;
                    }
                } else {
                    sceDisplay.this.re = RenderingEngineFactory.createInitialRenderingEngine();
                    sceDisplay.this.reDisplay = sceDisplay.this.re;
                }
            }
            if (sceDisplay.this.startModules) {
                sceDisplay.this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
                if (sceDisplay.this.saveGEToTexture) {
                    GETextureManager.getInstance().reset(sceDisplay.this.reDisplay);
                }
                VideoEngine.getInstance().start();
                sceDisplay.this.drawBuffer = sceDisplay.this.reDisplay.getBufferManager().genBuffer(6, 16, 6);
                sceDisplay.this.startModules = false;
                if (sceDisplay.this.saveGEToTexture && !sceDisplay.this.re.isFramebufferObjectAvailable()) {
                    sceDisplay.this.saveGEToTexture = false;
                    log.warn((Object)"Saving GE to Textures has been automatically disabled: FBO is not supported by this OpenGL version");
                }
                sceDisplay.this.isStarted = true;
            }
            if (!sceDisplay.this.isStarted) {
                sceDisplay.this.reDisplay.clear(0.0f, 0.0f, 0.0f, 0.0f);
                return;
            }
            if (sceDisplay.this.createTex) {
                sceDisplay.this.texFb = sceDisplay.this.createTexture(sceDisplay.this.texFb, false);
                sceDisplay.this.resizedTexFb = sceDisplay.this.createTexture(sceDisplay.this.resizedTexFb, true);
                sceDisplay.this.checkTemp();
                sceDisplay.this.createTex = false;
            }
            sceDisplay.this.skipNextFrameBufferSwitch = VideoEngine.getInstance().isSkipThisFrame();
            if (sceDisplay.this.isUsingSoftwareRenderer()) {
                if (sceDisplay.this.softwareRenderingDisplayThread == null) {
                    sceDisplay.this.re.startDisplay();
                    VideoEngine.getInstance().update();
                    sceDisplay.this.re.endDisplay();
                }
                sceDisplay.this.reDisplay.startDisplay();
                sceDisplay.this.drawFrameBufferFromMemory();
                sceDisplay.this.reDisplay.endDisplay();
            } else if (sceDisplay.this.onlyGEGraphics) {
                sceDisplay.this.re.startDisplay();
                VideoEngine.getInstance().update();
                sceDisplay.this.re.endDisplay();
            } else {
                GETexture geTexture;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - start display");
                }
                sceDisplay.this.re.startDisplay();
                if (VideoEngine.getInstance().update()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sceDisplay.paintGL - saving the GE to memory 0x%08X", sceDisplay.this.topaddrGe));
                    }
                    if (sceDisplay.this.saveGEToTexture && !VideoEngine.getInstance().isVideoTexture(sceDisplay.this.topaddrGe)) {
                        geTexture = GETextureManager.getInstance().getGETexture(sceDisplay.this.reDisplay, sceDisplay.this.topaddrGe, sceDisplay.this.bufferwidthGe, sceDisplay.this.widthGe, sceDisplay.this.heightGe, sceDisplay.this.pixelformatGe, true);
                        geTexture.copyScreenToTexture(sceDisplay.this.re);
                    } else {
                        sceDisplay.this.reDisplay.bindTexture(sceDisplay.this.resizedTexFb);
                        sceDisplay.this.reDisplay.setTextureFormat(sceDisplay.this.pixelformatGe, false);
                        sceDisplay.this.reDisplay.copyTexSubImage(0, 0, 0, 0, 0, sceDisplay.getResizedWidth(sceDisplay.this.widthGe), sceDisplay.getResizedHeight(sceDisplay.this.heightGe));
                        sceDisplay.this.drawFrameBuffer(true, true, sceDisplay.this.bufferwidthFb, sceDisplay.this.pixelformatFb, sceDisplay.this.width, sceDisplay.this.height);
                        sceDisplay.this.copyScreenToPixels(sceDisplay.this.pixelsGe, sceDisplay.this.bufferwidthGe, sceDisplay.this.pixelformatGe, sceDisplay.this.widthGe, sceDisplay.this.heightGe);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceDisplay.paintGL - rendering the FB 0x%08X", sceDisplay.this.topaddrFb));
                }
                if (sceDisplay.this.saveGEToTexture && !VideoEngine.getInstance().isVideoTexture(sceDisplay.this.topaddrFb)) {
                    geTexture = GETextureManager.getInstance().getGETexture(sceDisplay.this.reDisplay, sceDisplay.this.topaddrFb, sceDisplay.this.bufferwidthFb, sceDisplay.this.width, sceDisplay.this.height, sceDisplay.this.pixelformatFb, true);
                    geTexture.copyTextureToScreen(sceDisplay.this.reDisplay);
                } else {
                    sceDisplay.this.drawFrameBufferFromMemory();
                }
                sceDisplay.this.re.endDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - end display");
                }
            }
            try {
                sceDisplay.this.canvas.swapBuffers();
            }
            catch (LWJGLException lWJGLException) {
                // empty catch block
            }
            sceDisplay.this.reportFPSStats();
            if (sceDisplay.this.statistics != null) {
                sceDisplay.this.statistics.end();
            }
            if (sceDisplay.this.getscreen) {
                sceDisplay.this.saveScreen();
            }
        }

        @Override
        protected void initGL() {
            this.setSwapInterval(1);
            super.initGL();
            sceDisplay.this.initGLcalled = true;
            sceDisplay.this.openGLversion = RenderingEngineLwjgl.getVersion();
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("setBounds width=%d, height=%d", width, height));
            }
            sceDisplay.this.canvasWidth = width;
            sceDisplay.this.canvasHeight = height;
            super.setBounds(x, y, width, height);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            sceDisplay.this.captureX = this.getX();
            sceDisplay.this.captureY = this.getY();
            sceDisplay.this.captureWidth = this.getWidth();
            sceDisplay.this.captureHeight = this.getHeight();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            sceDisplay.this.captureX = this.getX();
            sceDisplay.this.captureY = this.getY();
            sceDisplay.this.captureWidth = this.getWidth();
            sceDisplay.this.captureHeight = this.getHeight();
            sceDisplay.this.setViewportResizeScaleFactor(this.getWidth(), this.getHeight());
        }
    }
}

