/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules303;

import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.Processor;

public class sceUtility
extends jpcsp.HLE.modules271.sceUtility {
    protected HashMap<Integer, SceModule> loadedModules = new HashMap();
    protected HashMap<Integer, String> waitingModules = new HashMap();

    protected String getModuleName(int module) {
        for (UtilityModule m : UtilityModule.values()) {
            if (m.getID() != module) continue;
            return m.toString();
        }
        return "PSP_MODULE_UNKNOWN_" + Integer.toHexString(module);
    }

    protected int hleUtilityLoadModule(int module, String moduleName) {
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (this.loadedModules.containsKey(module) || this.waitingModules.containsKey(module)) {
            return -2146365182;
        }
        if (!moduleManager.hasFlash0Module(moduleName)) {
            this.waitingModules.put(module, moduleName);
            return -2146365183;
        }
        int sceModuleId = moduleManager.LoadFlash0Module(moduleName);
        SceModule sceModule = Managers.modules.getModuleByUID(sceModuleId);
        this.loadedModules.put(module, sceModule);
        return 0;
    }

    protected int hleUtilityUnloadModule(int module) {
        if (this.loadedModules.containsKey(module)) {
            HLEModuleManager moduleManager = HLEModuleManager.getInstance();
            SceModule sceModule = this.loadedModules.remove(module);
            moduleManager.UnloadFlash0Module(sceModule);
            return 0;
        }
        if (this.waitingModules.containsKey(module)) {
            this.waitingModules.remove(module);
            return 0;
        }
        return -2146365181;
    }

    @HLEFunction(nid=707476960, version=303, checkInsideInterrupt=true)
    public void sceUtilityLoadModule(Processor processor) {
        CpuState cpu = processor.cpu;
        int module = cpu.gpr[4];
        String moduleName = this.getModuleName(module);
        int result = this.hleUtilityLoadModule(module, moduleName);
        if (result == -2146365183) {
            log.info((Object)String.format("IGNORING: sceUtilityLoadModule(module=0x%04X) %s", module, moduleName));
            result = 0;
        } else {
            log.info((Object)String.format("sceUtilityLoadModule(module=0x%04X) %s loaded", module, moduleName));
        }
        cpu.gpr[2] = result;
    }

    @HLEFunction(nid=-459538798, version=303, checkInsideInterrupt=true)
    public void sceUtilityUnloadModule(Processor processor) {
        CpuState cpu = processor.cpu;
        int module = cpu.gpr[4];
        String moduleName = this.getModuleName(module);
        log.info((Object)String.format("sceUtilityUnloadModule(module=0x%04X) %s unloaded", module, moduleName));
        cpu.gpr[2] = this.hleUtilityUnloadModule(module);
    }

    public static enum UtilityModule {
        PSP_MODULE_NET_COMMON(256),
        PSP_MODULE_NET_ADHOC(257),
        PSP_MODULE_NET_INET(258),
        PSP_MODULE_NET_PARSEURI(259),
        PSP_MODULE_NET_PARSEHTTP(260),
        PSP_MODULE_NET_HTTP(261),
        PSP_MODULE_NET_SSL(262),
        PSP_MODULE_NET_HTTPSTORAGE(264),
        PSP_MODULE_USB_PSPCM(512),
        PSP_MODULE_USB_MIC(513),
        PSP_MODULE_USB_CAM(514),
        PSP_MODULE_USB_GPS(515),
        PSP_MODULE_AV_AVCODEC(768),
        PSP_MODULE_AV_SASCORE(769),
        PSP_MODULE_AV_ATRAC3PLUS(770),
        PSP_MODULE_AV_MPEGBASE(771),
        PSP_MODULE_AV_MP3(772),
        PSP_MODULE_AV_VAUDIO(773),
        PSP_MODULE_AV_AAC(774),
        PSP_MODULE_AV_G729(775),
        PSP_MODULE_AV_MP4(776),
        PSP_MODULE_NP_COMMON(1024),
        PSP_MODULE_NP_SERVICE(1025),
        PSP_MODULE_NP_MATCHING2(1026),
        PSP_MODULE_NP_DRM(1280),
        PSP_MODULE_IRDA(1536);

        private int id;

        private UtilityModule(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }
    }
}

