/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.autotests;

import java.awt.DisplayMode;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeoutException;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.GUI.IMainGUI;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.autotests.AutoTestsOutput;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;

public class AutoTestsRunner {
    Emulator emulator = new Emulator(new DummyGUI());

    public AutoTestsRunner() {
        this.emulator.setFirmwareVersion(630);
    }

    public void run() {
        Logger.getRootLogger().addAppender((Appender)new WriterAppender((Layout)new SimpleLayout(), (OutputStream)System.out));
        Logger.getRootLogger().setLevel(Level.ERROR);
        try {
            this.runImpl();
        }
        catch (Throwable o) {
            o.printStackTrace();
        }
        System.exit(0);
    }

    protected void runImpl() throws Throwable {
        this.runTestFolder("pspautotests/tests");
    }

    protected void runTestFolder(String folderPath) throws Throwable {
        for (File file : new File(folderPath).listFiles()) {
            String name;
            if (file.getName().charAt(0) == '.') continue;
            if (file.isDirectory()) {
                this.runTestFolder(file.getAbsolutePath());
                continue;
            }
            if (!file.isFile() || !(name = file.getAbsolutePath()).substring(name.length() - 9).equals(".expected")) continue;
            this.runTest(name.substring(0, name.length() - 9));
        }
    }

    protected boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    protected void buildFile(String fileName) throws IOException, InterruptedException {
        String command = this.isWindows() ? "pspautotests/tests/build.bat" : "pspautotests/tests/build.sh";
        Runtime.getRuntime().exec(new String[]{command, fileName}).waitFor();
    }

    protected void runTest(String baseFileName) throws Throwable {
        try {
            this.buildFile(baseFileName + ".elf");
            this.runFile(baseFileName + ".elf");
            this.checkOutput(baseFileName + ".expected");
        }
        catch (TimeoutException toe) {
            System.out.println("FAIL:TIMEOUT");
        }
    }

    protected void checkOutput(String fileName) throws IOException {
        String expectedOutput;
        String actualOutput = AutoTestsOutput.getOutput().trim();
        if (actualOutput.equals(expectedOutput = AutoTestsRunner.readFileAsString(fileName).trim())) {
            System.out.println("OK");
        } else {
            System.out.println("FAIL");
            AutoTestsRunner.diff(expectedOutput, actualOutput);
        }
    }

    public static void diff(String x, String y) {
        AutoTestsRunner.diff(x.split("\\n"), y.split("\\n"));
    }

    public static void diff(String[] x, String[] y) {
        int j;
        int i;
        int M = x.length;
        int N = y.length;
        int[][] opt = new int[M + 1][N + 1];
        for (i = M - 1; i >= 0; --i) {
            for (j = N - 1; j >= 0; --j) {
                opt[i][j] = x[i].equals(y[j]) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < M && j < N) {
            if (x[i].equals(y[j])) {
                System.out.println("  " + x[i]);
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                System.out.println("- " + x[i++]);
                continue;
            }
            System.out.println("+ " + y[j++]);
        }
        while (i < M || j < N) {
            if (i == M) {
                System.out.println("- " + y[j++]);
                continue;
            }
            if (j != N) continue;
            System.out.println("+ " + x[i++]);
        }
    }

    protected void reset() {
        AutoTestsOutput.clearOutput();
        Emulator.PauseEmuWithStatus(64);
        RuntimeContext.reset();
        HLEModuleManager.getInstance().stopModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runFile(String fileName) throws Throwable {
        File file = new File(fileName);
        this.reset();
        sceDisplay.ignoreLWJGLError = true;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            try {
                FileChannel roChannel = raf.getChannel();
                try {
                    MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                    this.emulator.load(file.getPath(), readbuffer);
                }
                finally {
                    roChannel.close();
                }
            }
            finally {
                raf.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        RuntimeContext.setIsHomebrew(true);
        UmdIsoReader umdIsoReader = new UmdIsoReader("pspautotests/input/cube.cso");
        Modules.IoFileMgrForUserModule.setIsoReader(umdIsoReader);
        Modules.sceUmdUserModule.setIsoReader(umdIsoReader);
        Modules.IoFileMgrForUserModule.setfilepath(file.getPath());
        System.out.print(String.format("Running: %s...", fileName));
        RuntimeContext.setIsHomebrew(false);
        HLEModuleManager.getInstance().startModules();
        this.emulator.RunEmu();
        long startTime = System.currentTimeMillis();
        while (!Emulator.pause) {
            if (System.currentTimeMillis() - startTime > 5000L) {
                throw new TimeoutException();
            }
            Thread.sleep(1L);
        }
        HLEModuleManager.getInstance().stopModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f = null;
        try {
            f = new BufferedInputStream(new FileInputStream(filePath));
            f.read(buffer);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }

    class DummyGUI
    implements IMainGUI {
        DummyGUI() {
        }

        @Override
        public void setMainTitle(String title) {
        }

        @Override
        public void RefreshButtons() {
        }

        @Override
        public void setLocation() {
        }

        @Override
        public DisplayMode getDisplayMode() {
            return new DisplayMode(480, 272, 32, 60);
        }

        @Override
        public void endWindowDialog() {
        }

        @Override
        public boolean isFullScreen() {
            return false;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void pack() {
        }

        @Override
        public void setFullScreenDisplaySize() {
        }

        @Override
        public void startWindowDialog(Window window) {
        }

        @Override
        public void startBackgroundWindowDialog(Window window) {
        }
    }
}

