/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class PSPModuleInfo {
    private int m_attr;
    private int m_version;
    private byte[] m_name = new byte[28];
    private long m_gp;
    private long m_exports;
    private long m_exp_end;
    private long m_imports;
    private long m_imp_end;
    private String m_namez = "";

    public void read(ByteBuffer f) throws IOException {
        int len;
        this.m_attr = Utilities.readUHalf(f);
        this.m_version = Utilities.readUHalf(f);
        f.get(this.m_name);
        this.m_gp = Utilities.readUWord(f);
        this.m_exports = Utilities.readUWord(f);
        this.m_exp_end = Utilities.readUWord(f);
        this.m_imports = Utilities.readUWord(f);
        this.m_imp_end = Utilities.readUWord(f);
        for (len = 0; len < 28 && this.m_name[len] != 0; ++len) {
        }
        this.m_namez = new String(this.m_name, 0, len);
    }

    public void read(Memory mem, int address) {
        this.m_attr = mem.read16(address);
        this.m_version = mem.read16(address + 2);
        int len = 0;
        for (int i = 0; i < 28; ++i) {
            this.m_name[i] = (byte)mem.read8(address + 4 + i);
            if (this.m_name[i] != 0 || len != 0) continue;
            len = i;
        }
        this.m_namez = new String(this.m_name, 0, len);
        this.m_gp = mem.read32(address + 32);
        this.m_exports = mem.read32(address + 36);
        this.m_exp_end = mem.read32(address + 40);
        this.m_imports = mem.read32(address + 44);
        this.m_imp_end = mem.read32(address + 48);
    }

    public int getM_attr() {
        return this.m_attr;
    }

    public int getM_version() {
        return this.m_version;
    }

    public byte[] getM_name() {
        return this.m_name;
    }

    public long getM_gp() {
        return this.m_gp;
    }

    public long getM_exports() {
        return this.m_exports;
    }

    public long getM_exp_end() {
        return this.m_exp_end;
    }

    public long getM_imports() {
        return this.m_imports;
    }

    public long getM_imp_end() {
        return this.m_imp_end;
    }

    public String getM_namez() {
        return this.m_namez;
    }
}

