/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.HashMap;
import jpcsp.graphics.GeCommands;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class GEProfiler {
    public static Logger log = Logger.getLogger((String)"profiler");
    private static boolean profilerEnabled = true;
    private static ProfilerEnabledSettingsListerner profilerEnabledSettingsListerner;
    private static final Long zero;
    private static HashMap<Integer, Long> cmdCounts;
    private static long geListCount;
    private static long textureLoadCount;
    private static long copyGeToMemoryCount;

    public static void initialise() {
        if (profilerEnabledSettingsListerner == null) {
            profilerEnabledSettingsListerner = new ProfilerEnabledSettingsListerner();
            Settings.getInstance().registerSettingsListener("Profiler", "emu.profiler", profilerEnabledSettingsListerner);
        }
        GEProfiler.reset();
    }

    private static void setProfilerEnabled(boolean enabled) {
        profilerEnabled = enabled;
    }

    public static boolean isProfilerEnabled() {
        return profilerEnabled;
    }

    public static void reset() {
        if (!profilerEnabled) {
            return;
        }
        cmdCounts.clear();
        geListCount = 0L;
        textureLoadCount = 0L;
        copyGeToMemoryCount = 0L;
    }

    public static void exit() {
        if (!profilerEnabled) {
            return;
        }
        log.info((Object)"------------------ GEProfiler ----------------------");
        log.info((Object)String.format("GE list count: %d", geListCount));
        log.info((Object)String.format("Texture load count: %d, average %.1f per GE list", textureLoadCount, (double)textureLoadCount / (double)geListCount));
        log.info((Object)String.format("Copy GE to memory: %d, average %.1f per GE list", copyGeToMemoryCount, (double)copyGeToMemoryCount / (double)geListCount));
        GeCommands geCommands = GeCommands.getInstance();
        for (Integer cmd : cmdCounts.keySet()) {
            Long cmdCount = cmdCounts.get(cmd);
            log.info((Object)String.format("%s: called %d times, average %.1f per GE list", geCommands.getCommandString(cmd), (long)cmdCount, (double)cmdCount.longValue() / (double)geListCount));
        }
    }

    public static void startGeList() {
        ++geListCount;
    }

    public static void startGeCmd(int cmd) {
        Long cmdCount = cmdCounts.get(cmd);
        if (cmdCount == null) {
            cmdCount = zero;
        }
        cmdCounts.put(cmd, cmdCount + 1L);
    }

    public static void loadTexture() {
        ++textureLoadCount;
    }

    public static void copyGeToMemory() {
        ++copyGeToMemoryCount;
    }

    static {
        zero = new Long(0L);
        cmdCounts = new HashMap();
    }

    private static class ProfilerEnabledSettingsListerner
    extends AbstractBoolSettingsListener {
        private ProfilerEnabledSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            GEProfiler.setProfilerEnabled(value);
        }
    }
}

