/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.graphics.RE.software.PixelState;

public class PrimitiveState {
    public float p1x;
    public float p1y;
    public float p1z;
    public float p1w;
    public float p1wInverted;
    public float p2x;
    public float p2y;
    public float p2z;
    public float p2w;
    public float p2wInverted;
    public float p3x;
    public float p3y;
    public float p3z;
    public float p3w;
    public float p3wInverted;
    public int pxMin;
    public int pxMax;
    public int pyMin;
    public int pyMax;
    public int pzMin;
    public int pzMax;
    public float t1u;
    public float t1v;
    public float t2u;
    public float t2v;
    public float t3u;
    public float t3v;
    public int tuMin;
    public int tuMax;
    public int tvMin;
    public int tvMax;
    public float uStart;
    public float uStep;
    public float vStart;
    public float vStep;
    public int destinationWidth;
    public int destinationHeight;
    public boolean needResample;
    public float resampleFactorWidth;
    public float resampleFactorHeight;
    public float diff13x;
    public float diff13y;
    public float diff32x;
    public float diff23y;
    public float denomInverted;

    protected void copy(PrimitiveState from) {
        this.p1x = from.p1x;
        this.p1y = from.p1y;
        this.p1z = from.p1z;
        this.p1w = from.p1w;
        this.p1wInverted = from.p1wInverted;
        this.p2x = from.p2x;
        this.p2y = from.p2y;
        this.p2z = from.p2z;
        this.p2w = from.p2w;
        this.p2wInverted = from.p2wInverted;
        this.p3x = from.p3x;
        this.p3y = from.p3y;
        this.p3z = from.p3z;
        this.p3w = from.p3w;
        this.p3wInverted = from.p3wInverted;
        this.pxMin = from.pxMin;
        this.pxMax = from.pxMax;
        this.pyMin = from.pyMin;
        this.pyMax = from.pyMax;
        this.pzMin = from.pzMin;
        this.pzMax = from.pzMax;
        this.t1u = from.t1u;
        this.t1v = from.t1v;
        this.t2u = from.t2u;
        this.t2v = from.t2v;
        this.t3u = from.t3u;
        this.t3v = from.t3v;
        this.tuMin = from.tuMin;
        this.tuMax = from.tuMax;
        this.tvMin = from.tvMin;
        this.tvMax = from.tvMax;
        this.uStart = from.uStart;
        this.uStep = from.uStep;
        this.vStart = from.vStart;
        this.vStep = from.vStep;
        this.destinationWidth = from.destinationWidth;
        this.destinationHeight = from.destinationHeight;
        this.diff13x = from.diff13x;
        this.diff13y = from.diff13y;
        this.diff32x = from.diff32x;
        this.diff23y = from.diff23y;
        this.denomInverted = from.denomInverted;
    }

    public void preComputeTriangleWeights() {
        this.diff13x = this.p1x - this.p3x;
        this.diff13y = this.p1y - this.p3y;
        this.diff32x = this.p3x - this.p2x;
        this.diff23y = this.p2y - this.p3y;
        float denom = this.diff23y * this.diff13x + this.diff32x * this.diff13y;
        this.denomInverted = 1.0f / denom;
    }

    public void computeTriangleWeights(PixelState pixel, int x, int y) {
        float diff03x = (float)x - this.p3x + 0.01f;
        float diff03y = (float)y - this.p3y;
        pixel.triangleWeight1 = (this.diff23y * diff03x + this.diff32x * diff03y) * this.denomInverted;
        pixel.triangleWeight2 = (this.diff13x * diff03y - this.diff13y * diff03x) * this.denomInverted;
        pixel.triangleWeight3 = 1.0f - (pixel.triangleWeight1 + pixel.triangleWeight2);
    }

    public void deltaXTriangleWeigths(PixelState pixel) {
        pixel.triangleWeight1 += this.diff23y * this.denomInverted;
        pixel.triangleWeight2 -= this.diff13y * this.denomInverted;
        pixel.triangleWeight3 = 1.0f - (pixel.triangleWeight1 + pixel.triangleWeight2);
    }

    public boolean isClockwise() {
        float crossProduct = (this.p2x - this.p1x) * (this.p3y - this.p1y) - (this.p2y - this.p1y) * (this.p3x - this.p1x);
        return crossProduct >= 0.0f;
    }

    public String toString() {
        return String.format("Prim[pos (%d-%d),(%d,%d), tex (%d-%d),(%d-%d)]", this.pxMin, this.pxMax, this.pyMin, this.pyMax, this.tuMin, this.tuMax, this.tvMin, this.tvMax);
    }
}

