/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceUtility;
import jpcsp.hardware.Wlan;
import jpcsp.network.upnp.UPnP;
import org.apache.log4j.Logger;

public class ProOnline {
    public static Logger log = Logger.getLogger((String)"ProOnline");
    private static ProOnline instance;
    private static boolean enabled;
    private UPnP upnp;
    private Socket metaSocket;
    protected static final int OPCODE_PING = 0;
    protected static final int OPCODE_LOGIN = 1;
    protected static final int OPCODE_CONNECT = 2;
    protected static final int OPCODE_DISCONNECT = 3;
    protected static final int OPCODE_SCAN = 4;
    protected static final int OPCODE_SCAN_COMPLETE = 5;
    protected static final int OPCODE_CONNECT_BSSID = 6;
    protected static final int OPCODE_CHAT = 7;
    private static final int metaPort = 27312;
    private static String metaServer;
    private static final int pingTimeoutMillis = 2000;
    private volatile boolean exit;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        ProOnline.enabled = enabled;
        if (enabled) {
            log.info((Object)"Enabling ProLine network");
        }
    }

    public static ProOnline getInstance() {
        if (instance == null && ProOnline.isEnabled()) {
            instance = new ProOnline();
        }
        return instance;
    }

    private ProOnline() {
    }

    public void init() {
        log.info((Object)"ProOnline init");
        this.upnp = new UPnP();
        this.upnp.discover();
    }

    protected void sendToMetaServer(SceNetAdhocctlPacketBase packet) throws IOException {
        this.metaSocket.getOutputStream().write(packet.getBytes());
        this.metaSocket.getOutputStream().flush();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Sent packet to meta server: %s", packet));
        }
    }

    protected void safeSendToMetaServer(SceNetAdhocctlPacketBase packet) {
        try {
            this.sendToMetaServer(packet);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void proNetAdhocctlInit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proNetAdhocctlInit");
        }
        try {
            this.metaSocket = new Socket(metaServer, 27312);
            this.metaSocket.setReuseAddress(true);
            this.metaSocket.setSoTimeout(500);
            SceNetAdhocctlLoginPacketC2S loginPacket = new SceNetAdhocctlLoginPacketC2S();
            this.sendToMetaServer(loginPacket);
            FriendFinder friendFinderThread = new FriendFinder();
            friendFinderThread.setName("ProLine Friend Finder");
            friendFinderThread.setDaemon(true);
            friendFinderThread.start();
        }
        catch (UnknownHostException e) {
            log.error((Object)"proNetAdhocctlInit", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"proNetAdhocctlInit", (Throwable)e);
        }
    }

    public void proNetAdhocctlConnect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proNetAdhocctlConnect");
        }
        this.proNetAdhocctlCreate();
    }

    public void proNetAdhocctlCreate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proNetAdhocctlCreate");
        }
        try {
            this.sendToMetaServer(new SceNetAdhocctlConnectPacketC2S());
        }
        catch (IOException e) {
            log.error((Object)"proNetAdhocctlCreate", (Throwable)e);
        }
    }

    public void proNetAdhocctlDisconnect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proNetAdhocctlDisconnect");
        }
        try {
            this.sendToMetaServer(new SceNetAdhocctlDisconnectPacketC2S());
        }
        catch (IOException e) {
            log.error((Object)"proNetAdhocctlDisconnect", (Throwable)e);
        }
    }

    public void proNetAdhocctlTerm() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proNetAdhocctlTerm");
        }
        this.exit = true;
    }

    public void proNetAdhocctlScan() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proNetAdhocctlScan");
        }
        try {
            this.sendToMetaServer(new SceNetAdhocctlScanPacketC2S());
        }
        catch (IOException e) {
            log.error((Object)"proNetAdhocctlScan", (Throwable)e);
        }
    }

    protected void friendFinder() {
        long lastPing = Emulator.getClock().currentTimeMillis();
        byte[] buffer = new byte[1024];
        int offset = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting friendFinder");
        }
        while (!this.exit) {
            long now = Emulator.getClock().currentTimeMillis();
            if (now - lastPing >= 2000L) {
                lastPing = now;
                this.safeSendToMetaServer(new SceNetAdhocctlPingPacketC2S());
            }
            try {
                int length = this.metaSocket.getInputStream().read(buffer, offset, buffer.length - offset);
                if (length > 0) {
                    offset += length;
                }
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                log.error((Object)"friendFinder", (Throwable)e);
            }
            if (offset <= 0) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Received from meta server: OPCODE %d", buffer[0]));
            }
            int consumed = 0;
            switch (buffer[0]) {
                case 6: {
                    SceNetAdhocctlPacketBase packet = new SceNetAdhocctlConnectBSSIDPacketS2C(buffer, offset);
                    if (offset < ((SceNetAdhocctlConnectBSSIDPacketS2C)packet).getLength()) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Incoming OPCODE_CONNECT_BSSID %s", packet));
                    }
                    log.info((Object)String.format("Received MAC address %s", ((SceNetAdhocctlConnectBSSIDPacketS2C)packet).mac));
                    consumed = ((SceNetAdhocctlConnectBSSIDPacketS2C)packet).getLength();
                    break;
                }
                case 2: {
                    SceNetAdhocctlPacketBase packet = new SceNetAdhocctlConnectPacketS2C(buffer, offset);
                    if (offset >= ((SceNetAdhocctlConnectPacketS2C)packet).getLength()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Incoming OPCODE_CONNECT %s", packet));
                        }
                        this.addFriend(((SceNetAdhocctlConnectPacketS2C)packet).nickName, ((SceNetAdhocctlConnectPacketS2C)packet).mac, ((SceNetAdhocctlConnectPacketS2C)packet).ip);
                        consumed = ((SceNetAdhocctlConnectPacketS2C)packet).getLength();
                    }
                }
                case 4: {
                    SceNetAdhocctlPacketBase packet = new SceNetAdhocctlScanPacketS2C(buffer, offset);
                    if (offset < ((SceNetAdhocctlScanPacketS2C)packet).getLength()) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Incoming OPCODE_SCAN %s", packet));
                    }
                    Modules.sceNetAdhocctlModule.hleNetAdhocctlAddNetwork(((SceNetAdhocctlScanPacketS2C)packet).group, ((SceNetAdhocctlScanPacketS2C)packet).mac, 0);
                    consumed = ((SceNetAdhocctlScanPacketS2C)packet).getLength();
                    break;
                }
                case 5: {
                    SceNetAdhocctlPacketBase packet = new SceNetAdhocctlScanCompletePacketS2C(buffer, offset);
                    if (offset < packet.getLength()) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Incoming OPCODE_SCAN_COMPLETE %s", packet));
                    }
                    Modules.sceNetAdhocctlModule.hleNetAdhocctlScanComplete();
                    consumed = packet.getLength();
                    break;
                }
                default: {
                    log.error((Object)String.format("Received unknown opcode %d", buffer[0]));
                    consumed = 1;
                }
            }
            if (consumed <= 0) continue;
            System.arraycopy(buffer, consumed, buffer, 0, offset - consumed);
            offset -= consumed;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exiting friendFinder");
        }
        try {
            this.metaSocket.close();
        }
        catch (IOException e) {
            log.error((Object)"friendFinder", (Throwable)e);
        }
        this.metaSocket = null;
    }

    public static String convertIpToString(int ip) {
        return String.format("%d.%d.%d.%d", ip & 0xFF, ip >> 8 & 0xFF, (ip >> 16) % 255, ip >> 24 & 0xFF);
    }

    protected void addFriend(String nickName, pspNetMacAddress mac, int ip) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Adding friend nickName='%s', mac=%s, ip=%s", nickName, mac, ProOnline.convertIpToString(ip)));
        }
    }

    static {
        enabled = false;
        metaServer = "coldbird.uk.to";
    }

    protected class FriendFinder
    extends Thread {
        protected FriendFinder() {
        }

        @Override
        public void run() {
            ProOnline.this.friendFinder();
        }
    }

    private static class SceNetAdhocctlScanCompletePacketS2C
    extends SceNetAdhocctlPacketBase {
        public SceNetAdhocctlScanCompletePacketS2C(byte[] bytes, int length) {
            this.init(bytes, length);
        }

        public String toString() {
            return String.format("ScanCompletePacketS2C", new Object[0]);
        }
    }

    private static class SceNetAdhocctlScanPacketS2C
    extends SceNetAdhocctlPacketBase {
        String group;
        pspNetMacAddress mac;

        public SceNetAdhocctlScanPacketS2C(byte[] bytes, int length) {
            this.init(bytes, length);
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.group = this.copyStringFromBytes(bytes, 8);
                this.mac = this.copyMacFromBytes(bytes);
            }
        }

        @Override
        public int getLength() {
            return super.getLength() + 8 + 6;
        }

        public String toString() {
            return String.format("ScanPacketS2C[group='%s', mac=%s]", this.group, this.mac);
        }
    }

    private static class SceNetAdhocctlConnectBSSIDPacketS2C
    extends SceNetAdhocctlPacketBase {
        pspNetMacAddress mac;

        public SceNetAdhocctlConnectBSSIDPacketS2C(byte[] bytes, int length) {
            this.init(bytes, length);
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.mac = this.copyMacFromBytes(bytes);
            }
        }

        @Override
        public int getLength() {
            return super.getLength() + 6;
        }

        public String toString() {
            return String.format("ConnectBSSIDPacketS2C[mac=%s]", this.mac);
        }
    }

    private static class SceNetAdhocctlConnectPacketS2C
    extends SceNetAdhocctlPacketBase {
        String nickName;
        pspNetMacAddress mac;
        int ip;

        public SceNetAdhocctlConnectPacketS2C(byte[] bytes, int length) {
            this.init(bytes, length);
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.nickName = this.copyStringFromBytes(bytes, 128);
                this.mac = this.copyMacFromBytes(bytes);
                this.ip = this.copyInt32FromBytes(bytes);
            }
        }

        @Override
        public int getLength() {
            return super.getLength() + 128 + 6 + 4;
        }

        public String toString() {
            return String.format("ConnectPacketS2C[nickName='%s', mac=%s, ip=%s]", this.nickName, this.mac, ProOnline.convertIpToString(this.ip));
        }
    }

    private static class SceNetAdhocctlConnectPacketC2S
    extends SceNetAdhocctlPacketBase {
        String group;

        public SceNetAdhocctlConnectPacketC2S() {
            this.opcode = 2;
            this.group = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetGroupName();
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.group, 8);
        }

        @Override
        public int getLength() {
            return super.getLength() + 8;
        }
    }

    private static class SceNetAdhocctlLoginPacketC2S
    extends SceNetAdhocctlPacketBase {
        pspNetMacAddress mac = new pspNetMacAddress();
        String nickName;
        String game;

        public SceNetAdhocctlLoginPacketC2S() {
            this.opcode = 1;
            this.mac.setMacAddress(Wlan.getMacAddress());
            this.nickName = sceUtility.getSystemParamNickname();
            this.game = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetAdhocID();
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.mac);
            this.copyToBytes(bytes, this.nickName, 128);
            this.copyToBytes(bytes, this.game, 9);
        }

        @Override
        public int getLength() {
            return super.getLength() + 6 + 128 + 9;
        }
    }

    private static class SceNetAdhocctlScanPacketC2S
    extends SceNetAdhocctlPacketBase {
        public SceNetAdhocctlScanPacketC2S() {
            this.opcode = 4;
        }
    }

    private static class SceNetAdhocctlDisconnectPacketC2S
    extends SceNetAdhocctlPacketBase {
        public SceNetAdhocctlDisconnectPacketC2S() {
            this.opcode = 3;
        }
    }

    private static class SceNetAdhocctlPingPacketC2S
    extends SceNetAdhocctlPacketBase {
        public SceNetAdhocctlPingPacketC2S() {
            this.opcode = 0;
        }
    }

    private static class SceNetAdhocctlPacketBase {
        protected int opcode;
        protected int offset;

        private SceNetAdhocctlPacketBase() {
        }

        public byte[] getBytes() {
            byte[] bytes = new byte[this.getLength()];
            this.getBytes(bytes);
            return bytes;
        }

        protected void getBytes(byte[] bytes) {
            this.offset = 0;
            bytes[this.offset] = (byte)this.opcode;
            ++this.offset;
        }

        protected void copyToBytes(byte[] bytes, String s, int length) {
            int i = 0;
            while (i < length) {
                bytes[this.offset] = (byte)(i < s.length() ? s.charAt(i) : (char)'\u0000');
                ++i;
                ++this.offset;
            }
        }

        protected String copyStringFromBytes(byte[] bytes, int length) {
            int stringLength = length;
            for (int i = 0; i < length; ++i) {
                if (bytes[this.offset + i] != 0) continue;
                stringLength = i;
                break;
            }
            String s = new String(bytes, this.offset, stringLength);
            this.offset += length;
            return s;
        }

        protected int copyInt8FromBytes(byte[] bytes) {
            return bytes[this.offset++] & 0xFF;
        }

        protected int copyInt32FromBytes(byte[] bytes) {
            return this.copyInt8FromBytes(bytes) | this.copyInt8FromBytes(bytes) << 8 | this.copyInt8FromBytes(bytes) << 16 | this.copyInt8FromBytes(bytes) << 24;
        }

        protected pspNetMacAddress copyMacFromBytes(byte[] bytes) {
            pspNetMacAddress mac = new pspNetMacAddress();
            mac.setMacAddress(bytes, this.offset);
            this.offset += 6;
            return mac;
        }

        protected void copyToBytes(byte[] bytes, pspNetMacAddress mac) {
            System.arraycopy(mac.macAddress, 0, bytes, this.offset, 6);
            this.offset += 6;
        }

        protected void init(byte[] bytes, int length) {
            this.offset = 0;
            if (length >= this.getLength()) {
                this.opcode = bytes[this.offset];
                ++this.offset;
            }
        }

        public int getLength() {
            return 1;
        }
    }
}

