/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.HLE.modules.sceSasCore;
import jpcsp.sound.ISampleSource;
import jpcsp.sound.SoundVoice;

public class SampleSourceWithADSR
implements ISampleSource {
    private ISampleSource sampleSource;
    private SoundVoice voice;
    private EnvelopeState envelopeState;
    private final boolean tracing;

    public SampleSourceWithADSR(ISampleSource sampleSource, SoundVoice voice, SoundVoice.VoiceADSREnvelope envelope) {
        this.sampleSource = sampleSource;
        this.voice = voice;
        this.envelopeState = new EnvelopeState(envelope);
        this.tracing = sceSasCore.log.isTraceEnabled();
    }

    @Override
    public short getNextSample() {
        if (!this.voice.isOn()) {
            this.envelopeState.setKeyOff();
        }
        if (this.envelopeState.isEnded()) {
            this.voice.setPlaying(false);
            return 0;
        }
        int envelopeValue = this.envelopeState.getNextEnvelopeValue();
        short sample = this.sampleSource.getNextSample();
        int envelopeValue16 = (envelopeValue >> 14) + 1 >> 1;
        short modulatedSample = (short)(sample * envelopeValue16 + 16384 >> 15);
        if (this.tracing) {
            sceSasCore.log.trace((Object)String.format("getNextSample voice=%d, sample=0x%04X, envelopeValue=0x%08X, modulatedSample=0x%04X", this.voice.getIndex(), sample, envelopeValue, modulatedSample));
        }
        this.voice.getEnvelope().height = envelopeValue;
        return modulatedSample;
    }

    @Override
    public int getNumberSamples() {
        return this.sampleSource.getNumberSamples();
    }

    @Override
    public int getSampleIndex() {
        return this.sampleSource.getSampleIndex();
    }

    @Override
    public void setSampleIndex(int index) {
        this.sampleSource.setSampleIndex(index);
    }

    private static class EnvelopeState {
        private SoundVoice.VoiceADSREnvelope envelope;
        private long nextEnvelopeValue;
        private final CurveState[] curveStates = new CurveState[4];
        private int curve;
        private final boolean tracing;
        private static final int ATTACK_CURVE_STATE = 0;
        private static final int DECAY_CURVE_STATE = 1;
        private static final int SUSTAIN_CURVE_STATE = 2;
        private static final int RELEASE_CURVE_STATE = 3;

        public EnvelopeState(SoundVoice.VoiceADSREnvelope envelope) {
            this.envelope = envelope;
            this.tracing = sceSasCore.log.isTraceEnabled();
            this.curveStates[0] = this.createCurveState(envelope.AttackRate, envelope.AttackCurveType);
            this.curveStates[1] = this.createCurveState(envelope.DecayRate, envelope.DecayCurveType);
            this.curveStates[2] = this.createCurveState(envelope.SustainRate, envelope.SustainCurveType);
            this.curveStates[3] = this.createCurveState(envelope.ReleaseRate, envelope.ReleaseCurveType);
        }

        private CurveState createCurveState(int rate, int curveType) {
            if (rate < 0) {
                rate = Integer.MAX_VALUE;
            }
            switch (curveType) {
                case 0: {
                    return new LinearIncrease(rate);
                }
                case 1: {
                    return new LinearDecrease(rate);
                }
                case 2: {
                    return new LinearBent(rate);
                }
                case 3: {
                    return new ExponentDecrease(rate);
                }
                case 4: {
                    return new ExponentIncrease(rate);
                }
                case 5: {
                    return new Direct(rate);
                }
            }
            sceSasCore.log.warn((Object)String.format("Unimplemented curve type %d", curveType));
            return new CurveState(rate);
        }

        private boolean switchToNextCurve() {
            if (this.curve >= 2) {
                return false;
            }
            if (this.nextEnvelopeValue > 0x40000000L) {
                this.nextEnvelopeValue = 0x40000000L;
                return true;
            }
            if (this.nextEnvelopeValue < 0L) {
                this.nextEnvelopeValue = 0L;
                return true;
            }
            return this.curve == 1 && this.nextEnvelopeValue < (long)this.envelope.SustainLevel;
        }

        private int getIntEnvelopeValue(long envelopeValue) {
            if (envelopeValue <= 0L) {
                return 0;
            }
            if (envelopeValue >= 0x40000000L) {
                return 0x40000000;
            }
            return (int)envelopeValue;
        }

        public int getNextEnvelopeValue() {
            if (this.switchToNextCurve()) {
                ++this.curve;
            }
            long currentEnvelopeValue = this.nextEnvelopeValue;
            this.nextEnvelopeValue = this.curveStates[this.curve].getNextCurveValue(currentEnvelopeValue);
            if (this.tracing) {
                sceSasCore.log.trace((Object)String.format("getNextEnvelopeValue curve=%d, current=0x%08X, next=0x%08X", this.curve, currentEnvelopeValue, this.nextEnvelopeValue));
            }
            return this.getIntEnvelopeValue(currentEnvelopeValue);
        }

        public void setKeyOff() {
            this.curve = 3;
        }

        public boolean isEnded() {
            return this.curve >= 2 && this.nextEnvelopeValue <= 0L;
        }
    }

    private static class Direct
    extends CurveState {
        public Direct(int rate) {
            super(rate);
        }

        @Override
        public long getNextCurveValue(long currentCurveValue) {
            return this.rate;
        }
    }

    private static class ExponentDecrease
    extends ExponentIncrease {
        public ExponentDecrease(int rate) {
            super(rate);
        }

        @Override
        public long getNextCurveValue(long currentCurveValue) {
            return 0x40000000L - super.getNextCurveValue(currentCurveValue);
        }
    }

    private static class ExponentIncrease
    extends CurveState {
        private int duration = this.getDuration();
        private int index;
        private static final short[] expCurve = new short[]{0, 896, 1764, 2605, 3419, 4210, 4975, 5715, 6433, 7129, 7803, 8454, 9087, 9700, 10293, 10867, 11424, 11963, 12486, 12992, 13483, 13958, 14418, 14864, 15296, 15715, 16119, 16513, 16892, 17262, 17619, 17963, 18299, 18623, 18938, 19243, 19537, 19824, 20100, 20368, 20629, 20881, 21124, 21360, 21589, 21812, 22025, 22233, 22435, 22631, 22820, 23003, 23180, 23353, 23520, 23681, 23836, 23989, 24136, 24277, 24416, 24549, 24678, 24802, 24925, 25042, 25156, 25266, 25373, 25476, 25576, 25674, 25768, 25859, 25947, 26033, 26117, 26195, 26274, 26349, 26423, 26493, 26561, 26628, 26692, 26754, 26815, 26873, 26930, 26985, 27037, 27090, 27139, 27188, 27235, 27279, 27324, 27366, 27406, 27447, 27485, 27524, 27559, 27595, 27629, 27662, 27693, 27725, 27755, 27784, 27812, 27839, 27865, 27891, 27916, 27940, 27963, 27986, 28008, 28029, 28049, 28070, 28089, 28106, 28126, 28143, 28159, 28176, 28192, 28208, 28222, 28236, 28250, 28264, 28278, 28290, 28302, 28315, 28325, 28337, 28348, 28358, 28369, 28379, 28388, 28397, 28406, 28414, 28423, 28432, 28439, 28448, 28455, 28462, 28469, 28476, 28483, 28488, 28495, 28500, 28507, 28512, 28518, 28523, 28528, 28532, 28537, 28542, 28546, 28551, 28554, 28560, 28563, 28567, 28570, 28574, 28577, 28581, 28584, 28588, 28589, 28593, 28596, 28598, 28602, 28603, 28607, 28609, 28612, 28614, 28616, 28617, 28621, 28623, 28624, 28626, 28628, 28630, 28631, 28633, 28635, 28637, 28638, 28638, 28640, 28642, 28644, 28645, 28645, 28647, 28649, 28649, 28651, 28652, 28652, 28654, 28654, 28656, 28656, 28658, 28658, 28659, 28659, 28661, 28661, 28663, 28663, 28663, 28665, 28665, 28665, 28666, 28666, 28666, 28668, 28668, 28668, 28670, 28670, 28670, 28672};
        private static final short expCurveReference = 28672;

        public ExponentIncrease(int rate) {
            super(rate);
        }

        private int getDuration() {
            int duration = this.rate == 0 ? Integer.MAX_VALUE : Integer.MAX_VALUE / this.rate * 16;
            return duration;
        }

        private short extrapolateSample(short[] curve, int index, int duration) {
            float curveIndex = (float)(index * curve.length) / (float)duration;
            int curveIndex1 = (int)curveIndex;
            int curveIndex2 = curveIndex1 + 1;
            float curveIndexFraction = curveIndex - (float)curveIndex1;
            if (curveIndex1 < 0) {
                return curve[0];
            }
            if (curveIndex2 >= curve.length || curveIndex2 < 0) {
                return curve[curve.length - 1];
            }
            float sample = (float)curve[curveIndex1] * (1.0f - curveIndexFraction) + (float)curve[curveIndex2] * curveIndexFraction;
            return (short)Math.round(sample);
        }

        @Override
        public long getNextCurveValue(long currentCurveValue) {
            short expFactor = this.extrapolateSample(expCurve, this.index, this.duration);
            ++this.index;
            return (long)expFactor * 0x40000000L / 28672L;
        }
    }

    private static class LinearBent
    extends LinearIncrease {
        public LinearBent(int rate) {
            super(rate);
        }

        @Override
        public long getNextCurveValue(long currentCurveValue) {
            this.step = currentCurveValue <= 0x30000000L ? this.rate : this.rate >> 2;
            return super.getNextCurveValue(currentCurveValue);
        }
    }

    private static class LinearDecrease
    extends LinearIncrease {
        public LinearDecrease(int rate) {
            super(rate);
            this.step = -this.step;
        }
    }

    private static class LinearIncrease
    extends CurveState {
        protected int step;

        public LinearIncrease(int rate) {
            super(rate);
            this.step = rate;
        }

        @Override
        public long getNextCurveValue(long currentCurveValue) {
            return currentCurveValue + (long)this.step;
        }
    }

    private static class CurveState {
        protected int rate;

        public CurveState(int rate) {
            this.rate = rate;
        }

        public long getNextCurveValue(long currentCurveValue) {
            return currentCurveValue;
        }
    }
}

