/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.spinner;

import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Action;
import javax.swing.JSpinner;

public class SpinnerWheelSupport {
    public static final String CLIENT_PROPERTY_MOUSE_WHEEL_LISTENER = "mouseWheelListener";
    protected static final String ACTION_NAME_INCREMENT = "increment";
    protected static final String ACTION_NAME_DECREMENT = "decrement";

    public static void installMouseWheelSupport(final JSpinner jSpinner) {
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                Action action;
                int n = mouseWheelEvent.getWheelRotation();
                if (n < 0) {
                    Action action2 = jSpinner.getActionMap().get(SpinnerWheelSupport.ACTION_NAME_INCREMENT);
                    if (action2 != null) {
                        action2.actionPerformed(new ActionEvent(mouseWheelEvent.getSource(), 0, SpinnerWheelSupport.ACTION_NAME_INCREMENT));
                    }
                } else if (n > 0 && (action = jSpinner.getActionMap().get(SpinnerWheelSupport.ACTION_NAME_DECREMENT)) != null) {
                    action.actionPerformed(new ActionEvent(mouseWheelEvent.getSource(), 0, SpinnerWheelSupport.ACTION_NAME_DECREMENT));
                }
            }
        };
        jSpinner.addMouseWheelListener(mouseWheelListener);
        jSpinner.putClientProperty(CLIENT_PROPERTY_MOUSE_WHEEL_LISTENER, mouseWheelListener);
    }

    public static void uninstallMouseWheelSupport(JSpinner jSpinner) {
        MouseWheelListener mouseWheelListener = (MouseWheelListener)jSpinner.getClientProperty(CLIENT_PROPERTY_MOUSE_WHEEL_LISTENER);
        if (mouseWheelListener != null) {
            jSpinner.removeMouseWheelListener(mouseWheelListener);
        }
    }
}

