/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.JNILibraryLoader;
import com.xuggle.ferry.JNIReference;
import com.xuggle.test_utils.NameAwareTestClassRunner;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=NameAwareTestClassRunner.class)
public class JNILibraryLoaderTest {
    private static final Logger log = LoggerFactory.getLogger(JNILibraryLoaderTest.class);
    private String mTestName = null;

    @Before
    public void setUp() {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
        log.debug("-----START----- {}", (Object)this.mTestName);
        JNILibraryLoader loader = JNILibraryLoader.getInstance();
        loader.setOS(null);
    }

    @After
    public void tearDown() {
        System.gc();
        log.debug("----- END ----- {}", (Object)this.mTestName);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException {
        System.gc();
        Thread.sleep(1000L);
        JNIReference.getMgr().gc();
    }

    @Test
    public void testCreation() {
        JNILibraryLoader loader = JNILibraryLoader.getInstance();
        Assert.assertNotNull((Object)loader);
    }

    @Test
    public void testGetOS() {
        JNILibraryLoader loader = JNILibraryLoader.getInstance();
        JNILibraryLoader.OSName os = loader.getOS();
        switch (os) {
            case Linux: {
                Assert.assertTrue((boolean)System.getProperty("os.name", "").startsWith("Linux"));
                break;
            }
            case MacOSX: {
                Assert.assertTrue((boolean)System.getProperty("os.name", "").startsWith("Mac"));
                break;
            }
            case Windows: {
                Assert.assertTrue((boolean)System.getProperty("os.name", "").startsWith("Windows"));
                break;
            }
            case Unknown: {
                Assert.fail((String)"should default to linux");
            }
        }
    }

    @Test
    public void testGetSystemRuntimeLibraryPathVar() {
        JNILibraryLoader.OSName[] osTypes = new JNILibraryLoader.OSName[]{JNILibraryLoader.OSName.Linux, JNILibraryLoader.OSName.Windows, JNILibraryLoader.OSName.MacOSX};
        String[] varNames = new String[]{"LD_LIBRARY_PATH", "PATH", "DYLD_LIBRARY_PATH"};
        for (int i = 0; i < varNames.length; ++i) {
            String expected = varNames[i];
            JNILibraryLoader.OSName os = osTypes[i];
            JNILibraryLoader loader = JNILibraryLoader.getInstance();
            loader.setOS(os);
            String actual = loader.getSystemRuntimeLibraryPathVar();
            log.trace("Comparing System Runtime Library Path: {} vs {}", (Object)expected, (Object)actual);
            Assert.assertEquals((String)"unexpected variable name", (Object)expected, (Object)actual);
        }
    }

    @Test
    public void testGenerateFilenamesLinux() {
        JNILibraryLoader loader = JNILibraryLoader.getInstance();
        List files = loader.getLibraryCandidates("foo", new Long("1"));
        for (String file : files) {
            log.debug("candidate: {}", (Object)file);
        }
    }
}

