/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainerFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;

public class ContainerFormatTest
extends TestCase {
    private final String sampleFile = "fixtures/testfile.flv";

    @Test
    public void testSetOutputFmt() {
        IContainerFormat fmt = IContainerFormat.make();
        fmt.setOutputFormat("flv", null, null);
        fmt.setOutputFormat("flv", "fixtures/testfile.flv", null);
        fmt.setOutputFormat("flv", "file:fixtures/testfile.flv", null);
        fmt.setOutputFormat("NotAShortName", null, null);
        fmt.setOutputFormat("NotAShortName", "NotAURL", null);
        fmt.setOutputFormat("NotAShortName", "file:NotAURL", null);
        fmt.setOutputFormat("NotAShortName", "NotAProtocol:NotAURL", null);
        ContainerFormatTest.assertTrue((String)"got to end of test without coredump.  woo hoo", (boolean)true);
    }

    @Test
    public void testSetInputFmt() {
        IContainerFormat fmt = IContainerFormat.make();
        fmt.setInputFormat("flv");
        fmt.setInputFormat("mov");
        fmt.setInputFormat("NotAShortName");
        ContainerFormatTest.assertTrue((String)"got to end of test without coredump.  woo hoo", (boolean)true);
    }

    @Test
    public void testGetInputFlag() {
        IContainerFormat fmt = IContainerFormat.make();
        int retval = -1;
        int flags = fmt.getInputFlags();
        ContainerFormatTest.assertEquals((String)"should be not set", (int)flags, (int)0);
        retval = fmt.setInputFormat("s16be");
        ContainerFormatTest.assertTrue((String)"should succeed", (retval >= 0 ? 1 : 0) != 0);
        boolean hasGenericIndex = fmt.getInputFlag(IContainerFormat.Flags.FLAG_GENERIC_INDEX);
        ContainerFormatTest.assertTrue((String)"should have global header", (boolean)hasGenericIndex);
    }

    @Test
    public void testGetOutputFlag() {
        IContainerFormat fmt = IContainerFormat.make();
        int retval = -1;
        int flags = fmt.getOutputFlags();
        ContainerFormatTest.assertEquals((String)"should be not set", (int)flags, (int)0);
        retval = fmt.setOutputFormat("mov", null, null);
        ContainerFormatTest.assertTrue((String)"should succeed", (retval >= 0 ? 1 : 0) != 0);
        boolean hasGlobalHeader = fmt.getOutputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER);
        ContainerFormatTest.assertTrue((String)"should have global header", (boolean)hasGlobalHeader);
    }

    @Test
    public void testSetInputFlag() {
        IContainerFormat fmt = IContainerFormat.make();
        int retval = -1;
        int flags = fmt.getInputFlags();
        ContainerFormatTest.assertEquals((String)"should be not set", (int)flags, (int)0);
        retval = fmt.setInputFormat("s16be");
        ContainerFormatTest.assertTrue((String)"should succeed", (retval >= 0 ? 1 : 0) != 0);
        boolean hasGlobalHeader = fmt.getInputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER);
        ContainerFormatTest.assertTrue((String)"should not have global header", (!hasGlobalHeader ? 1 : 0) != 0);
        fmt.setInputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER, true);
        hasGlobalHeader = fmt.getInputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER);
        ContainerFormatTest.assertTrue((String)"should have global header", (boolean)hasGlobalHeader);
        fmt.setInputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER, false);
        hasGlobalHeader = fmt.getInputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER);
        ContainerFormatTest.assertTrue((String)"should not have global header", (!hasGlobalHeader ? 1 : 0) != 0);
    }

    @Test
    public void testSetOutputFlag() {
        IContainerFormat fmt = IContainerFormat.make();
        int retval = -1;
        int flags = fmt.getOutputFlags();
        ContainerFormatTest.assertEquals((String)"should be not set", (int)flags, (int)0);
        retval = fmt.setOutputFormat("mov", null, null);
        ContainerFormatTest.assertTrue((String)"should succeed", (retval >= 0 ? 1 : 0) != 0);
        boolean hasGlobalHeader = fmt.getOutputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER);
        ContainerFormatTest.assertTrue((String)"should have global header", (boolean)hasGlobalHeader);
        fmt.setOutputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER, false);
        hasGlobalHeader = fmt.getOutputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER);
        ContainerFormatTest.assertTrue((String)"should not have global header", (!hasGlobalHeader ? 1 : 0) != 0);
        fmt.setOutputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER, true);
        hasGlobalHeader = fmt.getOutputFlag(IContainerFormat.Flags.FLAG_GLOBALHEADER);
        ContainerFormatTest.assertTrue((String)"should have global header", (boolean)hasGlobalHeader);
    }

    @Test
    public void testGetOutputCodecsSupported() {
        IContainerFormat fmt = IContainerFormat.make();
        int retval = -1;
        int flags = fmt.getOutputFlags();
        ContainerFormatTest.assertEquals((String)"should be not set", (int)flags, (int)0);
        retval = fmt.setOutputFormat("mov", null, null);
        ContainerFormatTest.assertTrue((String)"should succeed", (retval >= 0 ? 1 : 0) != 0);
        List codecs = fmt.getOutputCodecsSupported();
        ContainerFormatTest.assertNotNull((Object)codecs);
        ContainerFormatTest.assertTrue((String)"should get at least one codec", (codecs.size() > 1 ? 1 : 0) != 0);
        ContainerFormatTest.assertTrue((String)"should have MP3", (boolean)codecs.contains(ICodec.ID.CODEC_ID_MP3));
        ContainerFormatTest.assertTrue((String)"Should contain H263", (boolean)codecs.contains(ICodec.ID.CODEC_ID_H263));
    }

    @Test
    public void testGetInputFormats() {
        Collection installed = IContainerFormat.getInstalledInputFormats();
        ContainerFormatTest.assertTrue((installed.size() > 0 ? 1 : 0) != 0);
        for (IContainerFormat fmt : installed) {
            ContainerFormatTest.assertNotNull((Object)fmt);
            ContainerFormatTest.assertTrue((boolean)fmt.isInput());
            ContainerFormatTest.assertTrue((fmt.getInputFormatShortName().length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetOutputFormats() {
        Collection installed = IContainerFormat.getInstalledOutputFormats();
        ContainerFormatTest.assertTrue((installed.size() > 0 ? 1 : 0) != 0);
        for (IContainerFormat fmt : installed) {
            ContainerFormatTest.assertNotNull((Object)fmt);
            ContainerFormatTest.assertTrue((boolean)fmt.isOutput());
            ContainerFormatTest.assertTrue((fmt.getOutputFormatShortName().length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEstablishOutputCodecId() {
        JNIMemoryManager.getMgr().flush();
        IContainerFormat fmt = IContainerFormat.make();
        fmt.setOutputFormat("flv", null, null);
        ContainerFormatTest.assertEquals((Object)ICodec.ID.CODEC_ID_FLV1, (Object)fmt.establishOutputCodecId(ICodec.Type.CODEC_TYPE_VIDEO));
        ContainerFormatTest.assertEquals((Object)ICodec.ID.CODEC_ID_MP3, (Object)fmt.establishOutputCodecId(ICodec.Type.CODEC_TYPE_AUDIO));
        fmt.setOutputFormat("mp4", null, null);
        ContainerFormatTest.assertEquals((Object)ICodec.ID.CODEC_ID_MPEG4, (Object)fmt.establishOutputCodecId(ICodec.Type.CODEC_TYPE_VIDEO));
        ContainerFormatTest.assertEquals((Object)ICodec.ID.CODEC_ID_AAC, (Object)fmt.establishOutputCodecId(ICodec.Type.CODEC_TYPE_AUDIO));
        fmt.setOutputFormat("3gp", null, null);
        ContainerFormatTest.assertEquals((Object)ICodec.ID.CODEC_ID_H263, (Object)fmt.establishOutputCodecId(ICodec.Type.CODEC_TYPE_VIDEO));
        ContainerFormatTest.assertEquals((Object)ICodec.ID.CODEC_ID_AMR_NB, (Object)fmt.establishOutputCodecId(ICodec.Type.CODEC_TYPE_AUDIO));
        fmt.delete();
        ContainerFormatTest.assertEquals((long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testEstablishOutputCodecIdFailOnMismatchedArgs() {
        JNIMemoryManager.getMgr().flush();
        IContainerFormat fmt = IContainerFormat.make();
        fmt.setOutputFormat("flv", null, null);
        try {
            fmt.establishOutputCodecId(ICodec.Type.CODEC_TYPE_VIDEO, ICodec.ID.CODEC_ID_MP3);
            ContainerFormatTest.fail((String)"should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        fmt.delete();
        ContainerFormatTest.assertEquals((long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testEstablishOutputCodecIdFailOnInputFormat() {
        JNIMemoryManager.getMgr().flush();
        IContainerFormat fmt = IContainerFormat.make();
        fmt.setInputFormat("flv");
        try {
            fmt.establishOutputCodecId(ICodec.Type.CODEC_TYPE_VIDEO);
            ContainerFormatTest.fail((String)"should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        fmt.delete();
        ContainerFormatTest.assertEquals((long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testIssue200() {
        IContainerFormat format = IContainerFormat.make();
        format.setOutputFormat("flv", null, null);
        List codecs = format.getOutputCodecsSupported();
        HashSet<ICodec.ID> uniqueCodecs = new HashSet<ICodec.ID>();
        for (ICodec.ID id : codecs) {
            ContainerFormatTest.assertFalse((String)("id not unique: " + id), (boolean)uniqueCodecs.contains(id));
            uniqueCodecs.add(id);
        }
    }

    @Test
    public void testIssue201() {
        IContainerFormat format = IContainerFormat.make();
        format.setOutputFormat("flv", null, null);
        List codecs = format.getOutputCodecsSupported();
        for (ICodec.ID id : codecs) {
            ICodec codec = ICodec.findEncodingCodec((ICodec.ID)id);
            ContainerFormatTest.assertNotNull((Object)codec);
            if (codec.getType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            ContainerFormatTest.assertEquals((Object)ICodec.ID.CODEC_ID_FLV1, (Object)id);
            break;
        }
    }
}

