/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IMediaDataWrapper;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MediaDataWrapperTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGet() {
        IAudioSamples samples = IAudioSamples.make((long)1024L, (long)2L);
        IMediaDataWrapper wrapper = IMediaDataWrapper.make((IMediaData)samples);
        Assert.assertTrue((boolean)(wrapper.get() instanceof IAudioSamples));
        Assert.assertEquals((Object)samples, (Object)wrapper.get());
        IPacket media = IPacket.make();
        wrapper.wrap((IMediaData)media);
        Assert.assertTrue((boolean)(wrapper.get() instanceof IPacket));
        media = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)10, (int)10);
        wrapper.wrap((IMediaData)media);
        Assert.assertTrue((boolean)(wrapper.get() instanceof IVideoPicture));
        media = IMediaDataWrapper.make(null);
        wrapper.wrap((IMediaData)media);
        Assert.assertTrue((boolean)(wrapper.get() instanceof IMediaDataWrapper));
    }

    @Test
    public void testUnwrap() {
        IAudioSamples samples = IAudioSamples.make((long)1024L, (long)2L);
        IMediaDataWrapper wrapper = IMediaDataWrapper.make((IMediaData)samples);
        IMediaDataWrapper wrapper2 = IMediaDataWrapper.make((IMediaData)wrapper);
        Assert.assertEquals((Object)wrapper, (Object)wrapper2.get());
        Assert.assertEquals((Object)samples, (Object)wrapper2.unwrap());
    }

    @Test
    public void testWrap() {
        IAudioSamples samples = IAudioSamples.make((long)1024L, (long)2L);
        IMediaDataWrapper wrapper = IMediaDataWrapper.make(null);
        Assert.assertNull((Object)wrapper.get());
        wrapper.wrap((IMediaData)samples);
        Assert.assertTrue((boolean)(wrapper.get() instanceof IAudioSamples));
        Assert.assertEquals((Object)samples, (Object)wrapper.get());
    }
}

