/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.FfmpegIO;
import com.xuggle.xuggler.io.FfmpegIOHandle;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.IURLProtocolHandlerFactory;
import com.xuggle.xuggler.io.URLProtocolManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class URLProtocolHandlerTest {
    private static final URLProtocolManager mMgr = URLProtocolManager.getManager();
    private static final IURLProtocolHandler mHandler = new IURLProtocolHandler(){

        public int close() {
            throw new IllegalStateException("fails on purpose");
        }

        public boolean isStreamed(String aUrl, int aFlags) {
            return true;
        }

        public int open(String aUrl, int aFlags) {
            if (aUrl.equals("test:succeed")) {
                return 0;
            }
            throw new IllegalStateException("fails on purpose");
        }

        public int read(byte[] aBuf, int aSize) {
            throw new IllegalStateException("fails on purpose");
        }

        public long seek(long aOffset, int aWhence) {
            throw new IllegalStateException("fails on purpose");
        }

        public int write(byte[] aBuf, int aSize) {
            throw new IllegalStateException("fails on purpose");
        }
    };
    private static final IURLProtocolHandlerFactory mFactory = new IURLProtocolHandlerFactory(){

        public IURLProtocolHandler getHandler(String aProtocol, String aUrl, int aFlags) {
            return mHandler;
        }
    };
    private final byte[] mBuffer = new byte[10];
    private FfmpegIOHandle mHandle;

    @BeforeClass
    public static void beforeClass() {
        mMgr.registerFactory("test", mFactory);
    }

    @Before
    public void setUp() {
        this.mHandle = new FfmpegIOHandle();
    }

    @Test
    public void testOpenException() {
        Assert.assertEquals((String)"should fail", (long)-1L, (long)FfmpegIO.url_open((FfmpegIOHandle)this.mHandle, (String)"test:fail", (int)2));
    }

    @Test
    public void testReadException() {
        int retval = -1;
        retval = FfmpegIO.url_open((FfmpegIOHandle)this.mHandle, (String)"test:succeed", (int)2);
        Assert.assertEquals((String)"should succeed", (long)0L, (long)retval);
        retval = FfmpegIO.url_read((FfmpegIOHandle)this.mHandle, (byte[])this.mBuffer, (int)this.mBuffer.length);
        Assert.assertEquals((String)"should fail", (long)-1L, (long)retval);
    }

    @Test
    public void testWriteException() {
        int retval = -1;
        retval = FfmpegIO.url_open((FfmpegIOHandle)this.mHandle, (String)"test:succeed", (int)2);
        Assert.assertEquals((String)"should succeed", (long)0L, (long)retval);
        retval = FfmpegIO.url_write((FfmpegIOHandle)this.mHandle, (byte[])this.mBuffer, (int)this.mBuffer.length);
        Assert.assertEquals((String)"should fail", (long)-1L, (long)retval);
    }

    @Test
    public void testSeekException() {
        int retval = -1;
        retval = FfmpegIO.url_open((FfmpegIOHandle)this.mHandle, (String)"test:succeed", (int)2);
        Assert.assertEquals((String)"should succeed", (long)0L, (long)retval);
        retval = (int)FfmpegIO.url_seek((FfmpegIOHandle)this.mHandle, (long)0L, (int)2);
        Assert.assertEquals((String)"should fail", (long)-1L, (long)retval);
    }

    @Test
    public void testCloseException() {
        int retval = -1;
        retval = FfmpegIO.url_open((FfmpegIOHandle)this.mHandle, (String)"test:succeed", (int)2);
        Assert.assertEquals((String)"should succeed", (long)0L, (long)retval);
        retval = FfmpegIO.url_close((FfmpegIOHandle)this.mHandle);
        Assert.assertEquals((String)"should fail", (long)-1L, (long)retval);
    }

    @Test
    public void testURLProtocolManagerGetResource() {
        String url = "http://www.xuggle.com/xuggler";
        String resource = URLProtocolManager.getResourceFromURL((String)url);
        String protocol = URLProtocolManager.getProtocolFromURL((String)url);
        Assert.assertEquals((Object)"http", (Object)protocol);
        Assert.assertEquals((Object)"www.xuggle.com/xuggler", (Object)resource);
        url = "file:/foo/bar";
        resource = URLProtocolManager.getResourceFromURL((String)url);
        protocol = URLProtocolManager.getProtocolFromURL((String)url);
        Assert.assertEquals((Object)"file", (Object)protocol);
        Assert.assertEquals((Object)"/foo/bar", (Object)resource);
    }
}

