/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.FerryJNI;
import com.xuggle.ferry.JNINativeFinalizer;

public class Logger {
    private volatile long swigCPtr;
    protected boolean swigCMemOwn;
    private JNINativeFinalizer mUnusedVariableToAllowImports;

    protected Logger(long cPtr, boolean cMemoryOwn) {
        this.swigCPtr = cPtr;
        this.swigCMemOwn = cMemoryOwn;
    }

    public static long getCPtr(Logger obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Logger) {
            equal = ((Logger)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            FerryJNI.delete_Logger(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public static Logger getLogger(String aLoggerName) {
        long cPtr = FerryJNI.Logger_getLogger(aLoggerName);
        return cPtr == 0L ? null : new Logger(cPtr, false);
    }

    public static Logger getStaticLogger(String aLoggerName) {
        long cPtr = FerryJNI.Logger_getStaticLogger(aLoggerName);
        return cPtr == 0L ? null : new Logger(cPtr, false);
    }

    public boolean log(String filename, int lineNo, Level level, String format) {
        return FerryJNI.Logger_log(this.swigCPtr, this, filename, lineNo, level.swigValue(), format);
    }

    public boolean error(String filename, int lineNo, String format) {
        return FerryJNI.Logger_error(this.swigCPtr, this, filename, lineNo, format);
    }

    public boolean warn(String filename, int lineNo, String format) {
        return FerryJNI.Logger_warn(this.swigCPtr, this, filename, lineNo, format);
    }

    public boolean info(String filename, int lineNo, String format) {
        return FerryJNI.Logger_info(this.swigCPtr, this, filename, lineNo, format);
    }

    public boolean debug(String filename, int lineNo, String format) {
        return FerryJNI.Logger_debug(this.swigCPtr, this, filename, lineNo, format);
    }

    public boolean trace(String filename, int lineNo, String format) {
        return FerryJNI.Logger_trace(this.swigCPtr, this, filename, lineNo, format);
    }

    public boolean isLogging(Level level) {
        return FerryJNI.Logger_isLogging(this.swigCPtr, this, level.swigValue());
    }

    public void setIsLogging(Level level, boolean value) {
        FerryJNI.Logger_setIsLogging(this.swigCPtr, this, level.swigValue(), value);
    }

    public static boolean isGlobalLogging(Level level) {
        return FerryJNI.Logger_isGlobalLogging(level.swigValue());
    }

    public static void setGlobalIsLogging(Level level, boolean value) {
        FerryJNI.Logger_setGlobalIsLogging(level.swigValue(), value);
    }

    public String getName() {
        return FerryJNI.Logger_getName(this.swigCPtr, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        LEVEL_ERROR(FerryJNI.Logger_LEVEL_ERROR_get()),
        LEVEL_WARN(FerryJNI.Logger_LEVEL_WARN_get()),
        LEVEL_INFO(FerryJNI.Logger_LEVEL_INFO_get()),
        LEVEL_DEBUG(FerryJNI.Logger_LEVEL_DEBUG_get()),
        LEVEL_TRACE(FerryJNI.Logger_LEVEL_TRACE_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Level swigToEnum(int swigValue) {
            Level[] swigValues = (Level[])Level.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Level swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Level.class + " with value " + swigValue);
        }

        private Level() {
            this.swigValue = SwigNext.next++;
        }

        private Level(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Level(Level swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

