/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.demos;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IContainerParameters;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.demos.VideoImage;
import java.awt.image.BufferedImage;

public class DisplayWebcamVideo {
    private static VideoImage mScreen = null;

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("must pass in driver and device name");
        }
        String driverName = args[0];
        String deviceName = args[1];
        if (!IVideoResampler.isSupported(IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new RuntimeException("you must install the GPL version of Xuggler (with IVideoResampler support) for this demo to work");
        }
        IContainer container = IContainer.make();
        IContainerParameters params = IContainerParameters.make();
        params.setTimeBase(IRational.make(30, 1));
        params.setVideoWidth(320);
        params.setVideoHeight(240);
        container.setParameters(params);
        IContainerFormat format = IContainerFormat.make();
        if (format.setInputFormat(driverName) < 0) {
            throw new IllegalArgumentException("couldn't open webcam device: " + driverName);
        }
        int retval = container.open(deviceName, IContainer.Type.READ, format);
        if (retval < 0) {
            IError error = IError.make(retval);
            throw new IllegalArgumentException("could not open file: " + deviceName + "; Error: " + error.getDescription());
        }
        int numStreams = container.getNumStreams();
        int videoStreamId = -1;
        IStreamCoder videoCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoStreamId = i;
            videoCoder = coder;
            break;
        }
        if (videoStreamId == -1) {
            throw new RuntimeException("could not find video stream in container: " + deviceName);
        }
        if (videoCoder.open() < 0) {
            throw new RuntimeException("could not open video decoder for container: " + deviceName);
        }
        IVideoResampler resampler = null;
        if (videoCoder.getPixelType() != IPixelFormat.Type.BGR24 && (resampler = IVideoResampler.make(videoCoder.getWidth(), videoCoder.getHeight(), IPixelFormat.Type.BGR24, videoCoder.getWidth(), videoCoder.getHeight(), videoCoder.getPixelType())) == null) {
            throw new RuntimeException("could not create color space resampler for: " + deviceName);
        }
        DisplayWebcamVideo.openJavaWindow();
        IPacket packet = IPacket.make();
        while (container.readNextPacket(packet) >= 0) {
            int bytesDecoded;
            if (packet.getStreamIndex() != videoStreamId) continue;
            IVideoPicture picture = IVideoPicture.make(videoCoder.getPixelType(), videoCoder.getWidth(), videoCoder.getHeight());
            for (int offset = 0; offset < packet.getSize(); offset += bytesDecoded) {
                bytesDecoded = videoCoder.decodeVideo(picture, packet, offset);
                if (bytesDecoded >= 0) continue;
                throw new RuntimeException("got error decoding video in: " + deviceName);
            }
        }
        if (videoCoder != null) {
            videoCoder.close();
            videoCoder = null;
        }
        if (container != null) {
            container.close();
            container = null;
        }
        DisplayWebcamVideo.closeJavaWindow();
    }

    private static void updateJavaWindow(BufferedImage javaImage) {
        mScreen.setImage(javaImage);
    }

    private static void openJavaWindow() {
        mScreen = new VideoImage();
    }

    private static void closeJavaWindow() {
        System.exit(0);
    }
}

