/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import java.math.BigInteger;
import java.util.Arrays;
import jpcsp.Allegrex.FpuState;
import jpcsp.Emulator;
import jpcsp.Memory;

public class VfpuState
extends FpuState {
    public final VfpuValue[] vpr = new VfpuValue[128];
    public static final float[] floatConstants = new float[]{0.0f, Float.MAX_VALUE, (float)Math.sqrt(2.0), (float)Math.sqrt(0.5), 2.0f / (float)Math.sqrt(Math.PI), 0.63661975f, 0.31830987f, 0.7853982f, 1.5707964f, (float)Math.PI, (float)Math.E, (float)(Math.log(Math.E) / Math.log(2.0)), (float)Math.log10(Math.E), (float)Math.log(2.0), (float)Math.log(10.0), (float)Math.PI * 2, 0.5235988f, (float)Math.log10(2.0), (float)(Math.log(10.0) / Math.log(2.0)), (float)Math.sqrt(3.0) / 2.0f};
    private static Random rnd;
    public Vcr vcr;
    private static float[] v1;
    private static float[] v2;
    private static float[] v3;
    private static int[] v1i;
    private static int[] v2i;
    private static int[] v3i;

    private void resetFpr() {
        for (int i = 0; i < this.vpr.length; ++i) {
            this.vpr[i].reset();
        }
    }

    @Override
    public void reset() {
        this.resetFpr();
        this.vcr.reset();
    }

    @Override
    public void resetAll() {
        super.resetAll();
        this.resetFpr();
        this.vcr.reset();
    }

    public VfpuState() {
        this.vcr = new Vcr();
        rnd = new Random();
        for (int i = 0; i < this.vpr.length; ++i) {
            this.vpr[i] = new VfpuValue();
        }
    }

    public void copy(VfpuState that) {
        super.copy(that);
        for (int i = 0; i < this.vpr.length; ++i) {
            this.vpr[i].copy(that.vpr[i]);
        }
        this.vcr.copy(that.vcr);
    }

    public VfpuState(VfpuState that) {
        super(that);
        for (int i = 0; i < this.vpr.length; ++i) {
            this.vpr[i] = new VfpuValue(that.vpr[i]);
        }
        this.vcr = new Vcr(that.vcr);
    }

    public static int getVprIndex(int m, int c, int r) {
        return (m << 4) + (c << 2) + r;
    }

    public float getVprFloat(int m, int c, int r) {
        return this.vpr[VfpuState.getVprIndex(m, c, r)].getFloat();
    }

    public int getVprInt(int m, int c, int r) {
        return this.vpr[VfpuState.getVprIndex(m, c, r)].getInt();
    }

    public void setVprFloat(int m, int c, int r, float value) {
        this.vpr[VfpuState.getVprIndex(m, c, r)].setFloat(value);
    }

    public void setVprInt(int m, int c, int r, int value) {
        this.vpr[VfpuState.getVprIndex(m, c, r)].setInt(value);
    }

    private float transformVr(int swz, boolean abs, boolean cst, boolean neg, float[] x) {
        float value = 0.0f;
        if (cst) {
            switch (swz) {
                case 0: {
                    value = abs ? 3.0f : 0.0f;
                    break;
                }
                case 1: {
                    value = abs ? 0.33333334f : 1.0f;
                    break;
                }
                case 2: {
                    value = abs ? 0.25f : 2.0f;
                    break;
                }
                case 3: {
                    value = abs ? 0.16666667f : 0.5f;
                }
            }
        } else {
            value = x[swz];
        }
        if (abs) {
            value = Math.abs(value);
        }
        return neg ? 0.0f - value : value;
    }

    private int transformVrInt(int swz, boolean abs, boolean cst, boolean neg, int[] x) {
        if (!(cst || abs || neg)) {
            return x[swz];
        }
        float value = 0.0f;
        if (cst) {
            switch (swz) {
                case 0: {
                    value = abs ? 3.0f : 0.0f;
                    break;
                }
                case 1: {
                    value = abs ? 0.33333334f : 1.0f;
                    break;
                }
                case 2: {
                    value = abs ? 0.25f : 2.0f;
                    break;
                }
                case 3: {
                    value = abs ? 0.16666667f : 0.5f;
                }
            }
        } else {
            value = Float.intBitsToFloat(x[swz]);
        }
        if (abs) {
            value = Math.abs(value);
        }
        if (neg) {
            value = 0.0f - value;
        }
        return Float.floatToRawIntBits(value);
    }

    private float applyPrefixVs(int i, float[] x) {
        return this.transformVr(this.vcr.pfxs.swz[i], this.vcr.pfxs.abs[i], this.vcr.pfxs.cst[i], this.vcr.pfxs.neg[i], x);
    }

    private int applyPrefixVsInt(int i, int[] x) {
        return this.transformVrInt(this.vcr.pfxs.swz[i], this.vcr.pfxs.abs[i], this.vcr.pfxs.cst[i], this.vcr.pfxs.neg[i], x);
    }

    private float applyPrefixVt(int i, float[] x) {
        return this.transformVr(this.vcr.pfxt.swz[i], this.vcr.pfxt.abs[i], this.vcr.pfxt.cst[i], this.vcr.pfxt.neg[i], x);
    }

    private int applyPrefixVtInt(int i, int[] x) {
        return this.transformVrInt(this.vcr.pfxt.swz[i], this.vcr.pfxt.abs[i], this.vcr.pfxt.cst[i], this.vcr.pfxt.neg[i], x);
    }

    private float applyPrefixVd(int i, float value) {
        switch (this.vcr.pfxd.sat[i]) {
            case 1: {
                return Math.max(0.0f, Math.min(1.0f, value));
            }
            case 3: {
                return Math.max(-1.0f, Math.min(1.0f, value));
            }
        }
        return value;
    }

    private int applyPrefixVdInt(int i, int value) {
        switch (this.vcr.pfxd.sat[i]) {
            case 1: {
                return Float.floatToRawIntBits(Math.max(0.0f, Math.min(1.0f, Float.intBitsToFloat(value))));
            }
            case 3: {
                return Float.floatToRawIntBits(Math.max(-1.0f, Math.min(1.0f, Float.intBitsToFloat(value))));
            }
        }
        return value;
    }

    public void loadVs(int vsize, int vs) {
        int m = vs >> 2 & 7;
        int i = vs >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = vs >> 5 & 3;
                VfpuState.v1[0] = this.getVprFloat(m, i, s);
                if (!this.vcr.pfxs.enabled) break;
                VfpuState.v1[0] = this.applyPrefixVs(0, v1);
                this.vcr.pfxs.enabled = false;
                break;
            }
            case 2: {
                int s = (vs & 0x40) >> 5;
                if ((vs & 0x20) != 0) {
                    VfpuState.v1[0] = this.getVprFloat(m, s + 0, i);
                    VfpuState.v1[1] = this.getVprFloat(m, s + 1, i);
                } else {
                    VfpuState.v1[0] = this.getVprFloat(m, i, s + 0);
                    VfpuState.v1[1] = this.getVprFloat(m, i, s + 1);
                }
                if (!this.vcr.pfxs.enabled) break;
                VfpuState.v3[0] = this.applyPrefixVs(0, v1);
                VfpuState.v3[1] = this.applyPrefixVs(1, v1);
                VfpuState.v1[0] = v3[0];
                VfpuState.v1[1] = v3[1];
                this.vcr.pfxs.enabled = false;
                break;
            }
            case 3: {
                int s = (vs & 0x40) >> 6;
                if ((vs & 0x20) != 0) {
                    VfpuState.v1[0] = this.getVprFloat(m, s + 0, i);
                    VfpuState.v1[1] = this.getVprFloat(m, s + 1, i);
                    VfpuState.v1[2] = this.getVprFloat(m, s + 2, i);
                } else {
                    VfpuState.v1[0] = this.getVprFloat(m, i, s + 0);
                    VfpuState.v1[1] = this.getVprFloat(m, i, s + 1);
                    VfpuState.v1[2] = this.getVprFloat(m, i, s + 2);
                }
                if (!this.vcr.pfxs.enabled) break;
                VfpuState.v3[0] = this.applyPrefixVs(0, v1);
                VfpuState.v3[1] = this.applyPrefixVs(1, v1);
                VfpuState.v3[2] = this.applyPrefixVs(2, v1);
                VfpuState.v1[0] = v3[0];
                VfpuState.v1[1] = v3[1];
                VfpuState.v1[2] = v3[2];
                this.vcr.pfxs.enabled = false;
                break;
            }
            case 4: {
                if ((vs & 0x40) != 0) {
                    Emulator.log.error((Object)String.format("Unsupported vs=%d", vs));
                }
                if ((vs & 0x20) != 0) {
                    VfpuState.v1[0] = this.getVprFloat(m, 0, i);
                    VfpuState.v1[1] = this.getVprFloat(m, 1, i);
                    VfpuState.v1[2] = this.getVprFloat(m, 2, i);
                    VfpuState.v1[3] = this.getVprFloat(m, 3, i);
                } else {
                    VfpuState.v1[0] = this.getVprFloat(m, i, 0);
                    VfpuState.v1[1] = this.getVprFloat(m, i, 1);
                    VfpuState.v1[2] = this.getVprFloat(m, i, 2);
                    VfpuState.v1[3] = this.getVprFloat(m, i, 3);
                }
                if (!this.vcr.pfxs.enabled) break;
                VfpuState.v3[0] = this.applyPrefixVs(0, v1);
                VfpuState.v3[1] = this.applyPrefixVs(1, v1);
                VfpuState.v3[2] = this.applyPrefixVs(2, v1);
                VfpuState.v3[3] = this.applyPrefixVs(3, v1);
                VfpuState.v1[0] = v3[0];
                VfpuState.v1[1] = v3[1];
                VfpuState.v1[2] = v3[2];
                VfpuState.v1[3] = v3[3];
                this.vcr.pfxs.enabled = false;
                break;
            }
        }
    }

    public void loadVsInt(int vsize, int vs) {
        int m = vs >> 2 & 7;
        int i = vs >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = vs >> 5 & 3;
                VfpuState.v1i[0] = this.getVprInt(m, i, s);
                if (!this.vcr.pfxs.enabled) break;
                VfpuState.v1i[0] = this.applyPrefixVsInt(0, v1i);
                this.vcr.pfxs.enabled = false;
                break;
            }
            case 2: {
                int s = (vs & 0x40) >> 5;
                if ((vs & 0x20) != 0) {
                    VfpuState.v1i[0] = this.getVprInt(m, s + 0, i);
                    VfpuState.v1i[1] = this.getVprInt(m, s + 1, i);
                } else {
                    VfpuState.v1i[0] = this.getVprInt(m, i, s + 0);
                    VfpuState.v1i[1] = this.getVprInt(m, i, s + 1);
                }
                if (!this.vcr.pfxs.enabled) break;
                VfpuState.v3i[0] = this.applyPrefixVsInt(0, v1i);
                VfpuState.v3i[1] = this.applyPrefixVsInt(1, v1i);
                VfpuState.v1i[0] = v3i[0];
                VfpuState.v1i[1] = v3i[1];
                this.vcr.pfxs.enabled = false;
                break;
            }
            case 3: {
                int s = (vs & 0x40) >> 6;
                if ((vs & 0x20) != 0) {
                    VfpuState.v1i[0] = this.getVprInt(m, s + 0, i);
                    VfpuState.v1i[1] = this.getVprInt(m, s + 1, i);
                    VfpuState.v1i[2] = this.getVprInt(m, s + 2, i);
                } else {
                    VfpuState.v1i[0] = this.getVprInt(m, i, s + 0);
                    VfpuState.v1i[1] = this.getVprInt(m, i, s + 1);
                    VfpuState.v1i[2] = this.getVprInt(m, i, s + 2);
                }
                if (!this.vcr.pfxs.enabled) break;
                VfpuState.v3i[0] = this.applyPrefixVsInt(0, v1i);
                VfpuState.v3i[1] = this.applyPrefixVsInt(1, v1i);
                VfpuState.v3i[2] = this.applyPrefixVsInt(2, v1i);
                VfpuState.v1i[0] = v3i[0];
                VfpuState.v1i[1] = v3i[1];
                VfpuState.v1i[2] = v3i[2];
                this.vcr.pfxs.enabled = false;
                break;
            }
            case 4: {
                if ((vs & 0x40) != 0) {
                    Emulator.log.error((Object)String.format("Unsupported vs=%d", vs));
                }
                if ((vs & 0x20) != 0) {
                    VfpuState.v1i[0] = this.getVprInt(m, 0, i);
                    VfpuState.v1i[1] = this.getVprInt(m, 1, i);
                    VfpuState.v1i[2] = this.getVprInt(m, 2, i);
                    VfpuState.v1i[3] = this.getVprInt(m, 3, i);
                } else {
                    VfpuState.v1i[0] = this.getVprInt(m, i, 0);
                    VfpuState.v1i[1] = this.getVprInt(m, i, 1);
                    VfpuState.v1i[2] = this.getVprInt(m, i, 2);
                    VfpuState.v1i[3] = this.getVprInt(m, i, 3);
                }
                if (!this.vcr.pfxs.enabled) break;
                VfpuState.v3i[0] = this.applyPrefixVsInt(0, v1i);
                VfpuState.v3i[1] = this.applyPrefixVsInt(1, v1i);
                VfpuState.v3i[2] = this.applyPrefixVsInt(2, v1i);
                VfpuState.v3i[3] = this.applyPrefixVsInt(3, v1i);
                VfpuState.v1i[0] = v3i[0];
                VfpuState.v1i[1] = v3i[1];
                VfpuState.v1i[2] = v3i[2];
                VfpuState.v1i[3] = v3i[3];
                this.vcr.pfxs.enabled = false;
                break;
            }
        }
    }

    public void loadVt(int vsize, int vt) {
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = vt >> 5 & 3;
                VfpuState.v2[0] = this.getVprFloat(m, i, s);
                if (!this.vcr.pfxt.enabled) break;
                VfpuState.v2[0] = this.applyPrefixVt(0, v2);
                this.vcr.pfxt.enabled = false;
                break;
            }
            case 2: {
                int s = (vt & 0x40) >> 5;
                if ((vt & 0x20) != 0) {
                    VfpuState.v2[0] = this.getVprFloat(m, s + 0, i);
                    VfpuState.v2[1] = this.getVprFloat(m, s + 1, i);
                } else {
                    VfpuState.v2[0] = this.getVprFloat(m, i, s + 0);
                    VfpuState.v2[1] = this.getVprFloat(m, i, s + 1);
                }
                if (!this.vcr.pfxt.enabled) break;
                VfpuState.v3[0] = this.applyPrefixVt(0, v2);
                VfpuState.v3[1] = this.applyPrefixVt(1, v2);
                VfpuState.v2[0] = v3[0];
                VfpuState.v2[1] = v3[1];
                this.vcr.pfxt.enabled = false;
                break;
            }
            case 3: {
                int s = (vt & 0x40) >> 6;
                if ((vt & 0x20) != 0) {
                    VfpuState.v2[0] = this.getVprFloat(m, s + 0, i);
                    VfpuState.v2[1] = this.getVprFloat(m, s + 1, i);
                    VfpuState.v2[2] = this.getVprFloat(m, s + 2, i);
                } else {
                    VfpuState.v2[0] = this.getVprFloat(m, i, s + 0);
                    VfpuState.v2[1] = this.getVprFloat(m, i, s + 1);
                    VfpuState.v2[2] = this.getVprFloat(m, i, s + 2);
                }
                if (!this.vcr.pfxt.enabled) break;
                VfpuState.v3[0] = this.applyPrefixVt(0, v2);
                VfpuState.v3[1] = this.applyPrefixVt(1, v2);
                VfpuState.v3[2] = this.applyPrefixVt(2, v2);
                VfpuState.v2[0] = v3[0];
                VfpuState.v2[1] = v3[1];
                VfpuState.v2[2] = v3[2];
                this.vcr.pfxt.enabled = false;
                break;
            }
            case 4: {
                if ((vt & 0x40) != 0) {
                    Emulator.log.error((Object)String.format("Unsupported vt=%d", vt));
                }
                if ((vt & 0x20) != 0) {
                    VfpuState.v2[0] = this.getVprFloat(m, 0, i);
                    VfpuState.v2[1] = this.getVprFloat(m, 1, i);
                    VfpuState.v2[2] = this.getVprFloat(m, 2, i);
                    VfpuState.v2[3] = this.getVprFloat(m, 3, i);
                } else {
                    VfpuState.v2[0] = this.getVprFloat(m, i, 0);
                    VfpuState.v2[1] = this.getVprFloat(m, i, 1);
                    VfpuState.v2[2] = this.getVprFloat(m, i, 2);
                    VfpuState.v2[3] = this.getVprFloat(m, i, 3);
                }
                if (!this.vcr.pfxt.enabled) break;
                VfpuState.v3[0] = this.applyPrefixVt(0, v2);
                VfpuState.v3[1] = this.applyPrefixVt(1, v2);
                VfpuState.v3[2] = this.applyPrefixVt(2, v2);
                VfpuState.v3[3] = this.applyPrefixVt(3, v2);
                VfpuState.v2[0] = v3[0];
                VfpuState.v2[1] = v3[1];
                VfpuState.v2[2] = v3[2];
                VfpuState.v2[3] = v3[3];
                this.vcr.pfxt.enabled = false;
                break;
            }
        }
    }

    public void loadVtInt(int vsize, int vt) {
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = vt >> 5 & 3;
                VfpuState.v2i[0] = this.getVprInt(m, i, s);
                if (!this.vcr.pfxt.enabled) break;
                VfpuState.v2i[0] = this.applyPrefixVtInt(0, v2i);
                this.vcr.pfxt.enabled = false;
                break;
            }
            case 2: {
                int s = (vt & 0x40) >> 5;
                if ((vt & 0x20) != 0) {
                    VfpuState.v2i[0] = this.getVprInt(m, s + 0, i);
                    VfpuState.v2i[1] = this.getVprInt(m, s + 1, i);
                } else {
                    VfpuState.v2i[0] = this.getVprInt(m, i, s + 0);
                    VfpuState.v2i[1] = this.getVprInt(m, i, s + 1);
                }
                if (!this.vcr.pfxt.enabled) break;
                VfpuState.v3i[0] = this.applyPrefixVtInt(0, v2i);
                VfpuState.v3i[1] = this.applyPrefixVtInt(1, v2i);
                VfpuState.v2i[0] = v3i[0];
                VfpuState.v2i[1] = v3i[1];
                this.vcr.pfxt.enabled = false;
                break;
            }
            case 3: {
                int s = (vt & 0x40) >> 6;
                if ((vt & 0x20) != 0) {
                    VfpuState.v2i[0] = this.getVprInt(m, s + 0, i);
                    VfpuState.v2i[1] = this.getVprInt(m, s + 1, i);
                    VfpuState.v2i[2] = this.getVprInt(m, s + 2, i);
                } else {
                    VfpuState.v2i[0] = this.getVprInt(m, i, s + 0);
                    VfpuState.v2i[1] = this.getVprInt(m, i, s + 1);
                    VfpuState.v2i[2] = this.getVprInt(m, i, s + 2);
                }
                if (!this.vcr.pfxt.enabled) break;
                VfpuState.v3i[0] = this.applyPrefixVtInt(0, v2i);
                VfpuState.v3i[1] = this.applyPrefixVtInt(1, v2i);
                VfpuState.v3i[2] = this.applyPrefixVtInt(2, v2i);
                VfpuState.v2i[0] = v3i[0];
                VfpuState.v2i[1] = v3i[1];
                VfpuState.v2i[2] = v3i[2];
                this.vcr.pfxt.enabled = false;
                break;
            }
            case 4: {
                if ((vt & 0x40) != 0) {
                    Emulator.log.error((Object)String.format("Unsupported vt=%d", vt));
                }
                if ((vt & 0x20) != 0) {
                    VfpuState.v2i[0] = this.getVprInt(m, 0, i);
                    VfpuState.v2i[1] = this.getVprInt(m, 1, i);
                    VfpuState.v2i[2] = this.getVprInt(m, 2, i);
                    VfpuState.v2i[3] = this.getVprInt(m, 3, i);
                } else {
                    VfpuState.v2i[0] = this.getVprInt(m, i, 0);
                    VfpuState.v2i[1] = this.getVprInt(m, i, 1);
                    VfpuState.v2i[2] = this.getVprInt(m, i, 2);
                    VfpuState.v2i[3] = this.getVprInt(m, i, 3);
                }
                if (!this.vcr.pfxt.enabled) break;
                VfpuState.v3i[0] = this.applyPrefixVtInt(0, v2i);
                VfpuState.v3i[1] = this.applyPrefixVtInt(1, v2i);
                VfpuState.v3i[2] = this.applyPrefixVtInt(2, v2i);
                VfpuState.v3i[3] = this.applyPrefixVtInt(3, v2i);
                VfpuState.v2i[0] = v3i[0];
                VfpuState.v2i[1] = v3i[1];
                VfpuState.v2i[2] = v3i[2];
                VfpuState.v2i[3] = v3i[3];
                this.vcr.pfxt.enabled = false;
                break;
            }
        }
    }

    public void loadVd(int vsize, int vd) {
        int m = vd >> 2 & 7;
        int i = vd >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = vd >> 5 & 3;
                VfpuState.v3[0] = this.getVprFloat(m, i, s);
                break;
            }
            case 2: {
                int s = (vd & 0x40) >> 5;
                if ((vd & 0x20) != 0) {
                    VfpuState.v3[0] = this.getVprFloat(m, s + 0, i);
                    VfpuState.v3[1] = this.getVprFloat(m, s + 1, i);
                    break;
                }
                VfpuState.v3[0] = this.getVprFloat(m, i, s + 0);
                VfpuState.v3[1] = this.getVprFloat(m, i, s + 1);
                break;
            }
            case 3: {
                int s = (vd & 0x40) >> 6;
                if ((vd & 0x20) != 0) {
                    VfpuState.v3[0] = this.getVprFloat(m, s + 0, i);
                    VfpuState.v3[1] = this.getVprFloat(m, s + 1, i);
                    VfpuState.v3[2] = this.getVprFloat(m, s + 2, i);
                    break;
                }
                VfpuState.v3[0] = this.getVprFloat(m, i, s + 0);
                VfpuState.v3[1] = this.getVprFloat(m, i, s + 1);
                VfpuState.v3[2] = this.getVprFloat(m, i, s + 2);
                break;
            }
            case 4: {
                if ((vd & 0x40) != 0) {
                    Emulator.log.error((Object)String.format("Unsupported vd=%d", vd));
                }
                if ((vd & 0x20) != 0) {
                    VfpuState.v3[0] = this.getVprFloat(m, 0, i);
                    VfpuState.v3[1] = this.getVprFloat(m, 1, i);
                    VfpuState.v3[2] = this.getVprFloat(m, 2, i);
                    VfpuState.v3[3] = this.getVprFloat(m, 3, i);
                    break;
                }
                VfpuState.v3[0] = this.getVprFloat(m, i, 0);
                VfpuState.v3[1] = this.getVprFloat(m, i, 1);
                VfpuState.v3[2] = this.getVprFloat(m, i, 2);
                VfpuState.v3[3] = this.getVprFloat(m, i, 3);
                break;
            }
        }
    }

    public void loadVdInt(int vsize, int vd) {
        int m = vd >> 2 & 7;
        int i = vd >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = vd >> 5 & 3;
                VfpuState.v3i[0] = this.getVprInt(m, i, s);
                break;
            }
            case 2: {
                int s = (vd & 0x40) >> 5;
                if ((vd & 0x20) != 0) {
                    VfpuState.v3i[0] = this.getVprInt(m, s + 0, i);
                    VfpuState.v3i[1] = this.getVprInt(m, s + 1, i);
                    break;
                }
                VfpuState.v3i[0] = this.getVprInt(m, i, s + 0);
                VfpuState.v3i[1] = this.getVprInt(m, i, s + 1);
                break;
            }
            case 3: {
                int s = (vd & 0x40) >> 6;
                if ((vd & 0x20) != 0) {
                    VfpuState.v3i[0] = this.getVprInt(m, s + 0, i);
                    VfpuState.v3i[1] = this.getVprInt(m, s + 1, i);
                    VfpuState.v3i[2] = this.getVprInt(m, s + 2, i);
                    break;
                }
                VfpuState.v3i[0] = this.getVprInt(m, i, s + 0);
                VfpuState.v3i[1] = this.getVprInt(m, i, s + 1);
                VfpuState.v3i[2] = this.getVprInt(m, i, s + 2);
                break;
            }
            case 4: {
                if ((vd & 0x40) != 0) {
                    Emulator.log.error((Object)String.format("Unsupported vd=%d", vd));
                }
                if ((vd & 0x20) != 0) {
                    VfpuState.v3i[0] = this.getVprInt(m, 0, i);
                    VfpuState.v3i[1] = this.getVprInt(m, 1, i);
                    VfpuState.v3i[2] = this.getVprInt(m, 2, i);
                    VfpuState.v3i[3] = this.getVprInt(m, 3, i);
                    break;
                }
                VfpuState.v3i[0] = this.getVprInt(m, i, 0);
                VfpuState.v3i[1] = this.getVprInt(m, i, 1);
                VfpuState.v3i[2] = this.getVprInt(m, i, 2);
                VfpuState.v3i[3] = this.getVprInt(m, i, 3);
                break;
            }
        }
    }

    public void saveVd(int vsize, int vd, float[] vr) {
        int m = vd >> 2 & 7;
        int i = vd >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = vd >> 5 & 3;
                if (this.vcr.pfxd.enabled) {
                    if (!this.vcr.pfxd.msk[0]) {
                        this.setVprFloat(m, i, s, this.applyPrefixVd(0, vr[0]));
                    }
                    this.vcr.pfxd.enabled = false;
                    break;
                }
                this.setVprFloat(m, i, s, vr[0]);
                break;
            }
            case 2: {
                int s = (vd & 0x40) >> 5;
                if (this.vcr.pfxd.enabled) {
                    if ((vd & 0x20) != 0) {
                        for (int j = 0; j < 2; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprFloat(m, s + j, i, this.applyPrefixVd(j, vr[j]));
                        }
                    } else {
                        for (int j = 0; j < 2; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprFloat(m, i, s + j, this.applyPrefixVd(j, vr[j]));
                        }
                    }
                    this.vcr.pfxd.enabled = false;
                    break;
                }
                if ((vd & 0x20) != 0) {
                    for (int j = 0; j < 2; ++j) {
                        this.setVprFloat(m, s + j, i, vr[j]);
                    }
                } else {
                    for (int j = 0; j < 2; ++j) {
                        this.setVprFloat(m, i, s + j, vr[j]);
                    }
                }
                break;
            }
            case 3: {
                int s = (vd & 0x40) >> 6;
                if (this.vcr.pfxd.enabled) {
                    if ((vd & 0x20) != 0) {
                        for (int j = 0; j < 3; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprFloat(m, s + j, i, this.applyPrefixVd(j, vr[j]));
                        }
                    } else {
                        for (int j = 0; j < 3; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprFloat(m, i, s + j, this.applyPrefixVd(j, vr[j]));
                        }
                    }
                    this.vcr.pfxd.enabled = false;
                    break;
                }
                if ((vd & 0x20) != 0) {
                    for (int j = 0; j < 3; ++j) {
                        this.setVprFloat(m, s + j, i, vr[j]);
                    }
                } else {
                    for (int j = 0; j < 3; ++j) {
                        this.setVprFloat(m, i, s + j, vr[j]);
                    }
                }
                break;
            }
            case 4: {
                if ((vd & 0x40) != 0) {
                    Emulator.log.error((Object)String.format("Unsupported vd=%d", vd));
                }
                if (this.vcr.pfxd.enabled) {
                    if ((vd & 0x20) != 0) {
                        for (int j = 0; j < 4; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprFloat(m, j, i, this.applyPrefixVd(j, vr[j]));
                        }
                    } else {
                        for (int j = 0; j < 4; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprFloat(m, i, j, this.applyPrefixVd(j, vr[j]));
                        }
                    }
                    this.vcr.pfxd.enabled = false;
                    break;
                }
                if ((vd & 0x20) != 0) {
                    for (int j = 0; j < 4; ++j) {
                        this.setVprFloat(m, j, i, vr[j]);
                    }
                } else {
                    for (int j = 0; j < 4; ++j) {
                        this.setVprFloat(m, i, j, vr[j]);
                    }
                }
                break;
            }
        }
    }

    public void saveVdInt(int vsize, int vd, int[] vr) {
        int m = vd >> 2 & 7;
        int i = vd >> 0 & 3;
        switch (vsize) {
            case 1: {
                int s = vd >> 5 & 3;
                if (this.vcr.pfxd.enabled) {
                    if (!this.vcr.pfxd.msk[0]) {
                        this.setVprInt(m, i, s, this.applyPrefixVdInt(0, vr[0]));
                    }
                    this.vcr.pfxd.enabled = false;
                    break;
                }
                this.setVprInt(m, i, s, vr[0]);
                break;
            }
            case 2: {
                int s = (vd & 0x40) >> 5;
                if (this.vcr.pfxd.enabled) {
                    if ((vd & 0x20) != 0) {
                        for (int j = 0; j < 2; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprInt(m, s + j, i, this.applyPrefixVdInt(j, vr[j]));
                        }
                    } else {
                        for (int j = 0; j < 2; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprInt(m, i, s + j, this.applyPrefixVdInt(j, vr[j]));
                        }
                    }
                    this.vcr.pfxd.enabled = false;
                    break;
                }
                if ((vd & 0x20) != 0) {
                    for (int j = 0; j < 2; ++j) {
                        this.setVprInt(m, s + j, i, vr[j]);
                    }
                } else {
                    for (int j = 0; j < 2; ++j) {
                        this.setVprInt(m, i, s + j, vr[j]);
                    }
                }
                break;
            }
            case 3: {
                int s = (vd & 0x40) >> 6;
                if (this.vcr.pfxd.enabled) {
                    if ((vd & 0x20) != 0) {
                        for (int j = 0; j < 3; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprInt(m, s + j, i, this.applyPrefixVdInt(j, vr[j]));
                        }
                    } else {
                        for (int j = 0; j < 3; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprInt(m, i, s + j, this.applyPrefixVdInt(j, vr[j]));
                        }
                    }
                    this.vcr.pfxd.enabled = false;
                    break;
                }
                if ((vd & 0x20) != 0) {
                    for (int j = 0; j < 3; ++j) {
                        this.setVprInt(m, s + j, i, vr[j]);
                    }
                } else {
                    for (int j = 0; j < 3; ++j) {
                        this.setVprInt(m, i, s + j, vr[j]);
                    }
                }
                break;
            }
            case 4: {
                if ((vd & 0x40) != 0) {
                    Emulator.log.error((Object)String.format("Unsupported vd=%d", vd));
                }
                if (this.vcr.pfxd.enabled) {
                    if ((vd & 0x20) != 0) {
                        for (int j = 0; j < 4; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprInt(m, j, i, this.applyPrefixVdInt(j, vr[j]));
                        }
                    } else {
                        for (int j = 0; j < 4; ++j) {
                            if (this.vcr.pfxd.msk[j]) continue;
                            this.setVprInt(m, i, j, this.applyPrefixVdInt(j, vr[j]));
                        }
                    }
                    this.vcr.pfxd.enabled = false;
                    break;
                }
                if ((vd & 0x20) != 0) {
                    for (int j = 0; j < 4; ++j) {
                        this.setVprInt(m, j, i, vr[j]);
                    }
                } else {
                    for (int j = 0; j < 4; ++j) {
                        this.setVprInt(m, i, j, vr[j]);
                    }
                }
                break;
            }
        }
    }

    public static float halffloatToFloat(int imm16) {
        int s = imm16 >> 15 & 1;
        int e = imm16 >> 10 & 0x1F;
        int f = imm16 >> 0 & 0x3FF;
        if (e == 0) {
            if (f == 0) {
                return Float.intBitsToFloat(s << 31);
            }
            while ((f & 0x400) == 0) {
                f <<= 1;
                --e;
            }
            ++e;
            f &= 0xFFFFFBFF;
        } else if (e == 31) {
            if (f == 0) {
                return Float.intBitsToFloat(s << 31 | 0x7F800000);
            }
            return Float.intBitsToFloat(s << 31 | 0x7F800000 | f << 13);
        }
        return Float.intBitsToFloat(s << 31 | (e += 112) << 23 | (f <<= 13));
    }

    int floatToHalffloat(float v) {
        int i = Float.floatToRawIntBits(v);
        int s = i >> 16 & 0x8000;
        int e = (i >> 23 & 0xFF) - 112;
        int f = i >> 0 & 0x7FFFFF;
        if (e <= 0) {
            if (e < -10) {
                if (s != 0) {
                    return 32768;
                }
                return 0;
            }
            f = (f | 0x800000) >> 1 - e;
            return s | f >> 13;
        }
        if (e == 143) {
            if (f == 0) {
                return s | 0x7C00;
            }
            return s | 0x7C00 | f | ((f >>= 13) == 0 ? 1 : 0);
        }
        if (e > 30) {
            return s | 0x7C00;
        }
        return s | e << 10 | f >> 13;
    }

    public void doVADD(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            int n = i;
            v1[n] = v1[n] + v2[i];
        }
        this.saveVd(vsize, vd, v1);
    }

    public void doVSUB(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            int n = i;
            v1[n] = v1[n] - v2[i];
        }
        this.saveVd(vsize, vd, v1);
    }

    public void doVSBN(int vsize, int vd, int vs, int vt) {
        if (vsize != 1) {
            this.doUNK("Only supported VSBN.S");
        }
        this.loadVs(1, vs);
        this.loadVtInt(1, vt);
        VfpuState.v1[0] = Math.scalb(v1[0], v2i[0]);
        this.saveVd(1, vd, v1);
    }

    public void doVDIV(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            int n = i;
            v1[n] = v1[n] / v2[i];
        }
        this.saveVd(vsize, vd, v1);
    }

    public void doVMUL(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            int n = i;
            v1[n] = v1[n] * v2[i];
        }
        this.saveVd(vsize, vd, v1);
    }

    public void doVDOT(int vsize, int vd, int vs, int vt) {
        if (vsize == 1) {
            this.doUNK("Unsupported VDOT.S");
        }
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        float dot = v1[0] * v2[0];
        for (int i = 1; i < vsize; ++i) {
            dot += v1[i] * v2[i];
        }
        VfpuState.v3[0] = dot;
        this.saveVd(1, vd, v3);
    }

    public void doVSCL(int vsize, int vd, int vs, int vt) {
        if (vsize == 1) {
            this.doUNK("Unsupported VSCL.S");
        }
        this.loadVs(vsize, vs);
        this.loadVt(1, vt);
        float scale = v2[0];
        int i = 0;
        while (i < vsize) {
            int n = i++;
            v1[n] = v1[n] * scale;
        }
        this.saveVd(vsize, vd, v1);
    }

    public void doVHDP(int vsize, int vd, int vs, int vt) {
        int i;
        if (vsize == 1) {
            this.doUNK("Unsupported VHDP.S");
        }
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        float hdp = v1[0] * v2[0];
        for (i = 1; i < vsize - 1; ++i) {
            hdp += v1[i] * v2[i];
        }
        VfpuState.v2[0] = hdp + v2[i];
        this.saveVd(1, vd, v2);
    }

    public void doVCRS(int vsize, int vd, int vs, int vt) {
        if (vsize != 3) {
            this.doUNK("Only supported VCRS.T");
        }
        this.loadVs(3, vs);
        this.loadVt(3, vt);
        VfpuState.v3[0] = v1[1] * v2[2];
        VfpuState.v3[1] = v1[2] * v2[0];
        VfpuState.v3[2] = v1[0] * v2[1];
        this.saveVd(3, vd, v3);
    }

    public void doVDET(int vsize, int vd, int vs, int vt) {
        if (vsize != 2) {
            this.doUNK("Only supported VDET.P");
            return;
        }
        this.loadVs(2, vs);
        this.loadVt(2, vt);
        VfpuState.v1[0] = v1[0] * v2[1] - v1[1] * v2[0];
        this.saveVd(1, vd, v1);
    }

    public void doMFV(int rt, int imm7) {
        int r = imm7 >> 5 & 3;
        int m = imm7 >> 2 & 7;
        int c = imm7 >> 0 & 3;
        this.gpr[rt] = this.getVprInt(m, c, r);
    }

    public void doMFVC(int rt, int imm7) {
        if (rt != 0) {
            int value = 0;
            switch (imm7) {
                case 0: {
                    value |= this.vcr.pfxs.swz[0] << 0;
                    value |= this.vcr.pfxs.swz[1] << 2;
                    value |= this.vcr.pfxs.swz[2] << 4;
                    value |= this.vcr.pfxs.swz[3] << 6;
                    if (this.vcr.pfxs.abs[0]) {
                        value |= 0x100;
                    }
                    if (this.vcr.pfxs.abs[1]) {
                        value |= 0x200;
                    }
                    if (this.vcr.pfxs.abs[2]) {
                        value |= 0x400;
                    }
                    if (this.vcr.pfxs.abs[3]) {
                        value |= 0x800;
                    }
                    if (this.vcr.pfxs.cst[0]) {
                        value |= 0x1000;
                    }
                    if (this.vcr.pfxs.cst[1]) {
                        value |= 0x2000;
                    }
                    if (this.vcr.pfxs.cst[2]) {
                        value |= 0x4000;
                    }
                    if (this.vcr.pfxs.cst[3]) {
                        value |= 0x8000;
                    }
                    if (this.vcr.pfxs.neg[0]) {
                        value |= 0x10000;
                    }
                    if (this.vcr.pfxs.neg[1]) {
                        value |= 0x20000;
                    }
                    if (this.vcr.pfxs.neg[2]) {
                        value |= 0x40000;
                    }
                    if (this.vcr.pfxs.neg[3]) {
                        value |= 0x80000;
                    }
                    this.gpr[rt] = value;
                    break;
                }
                case 1: {
                    value |= this.vcr.pfxt.swz[0] << 0;
                    value |= this.vcr.pfxt.swz[1] << 2;
                    value |= this.vcr.pfxt.swz[2] << 4;
                    value |= this.vcr.pfxt.swz[3] << 6;
                    if (this.vcr.pfxt.abs[0]) {
                        value |= 0x100;
                    }
                    if (this.vcr.pfxt.abs[1]) {
                        value |= 0x200;
                    }
                    if (this.vcr.pfxt.abs[2]) {
                        value |= 0x400;
                    }
                    if (this.vcr.pfxt.abs[3]) {
                        value |= 0x800;
                    }
                    if (this.vcr.pfxt.cst[0]) {
                        value |= 0x1000;
                    }
                    if (this.vcr.pfxt.cst[1]) {
                        value |= 0x2000;
                    }
                    if (this.vcr.pfxt.cst[2]) {
                        value |= 0x4000;
                    }
                    if (this.vcr.pfxt.cst[3]) {
                        value |= 0x8000;
                    }
                    if (this.vcr.pfxt.neg[0]) {
                        value |= 0x10000;
                    }
                    if (this.vcr.pfxt.neg[1]) {
                        value |= 0x20000;
                    }
                    if (this.vcr.pfxt.neg[2]) {
                        value |= 0x40000;
                    }
                    if (this.vcr.pfxt.neg[3]) {
                        value |= 0x80000;
                    }
                    this.gpr[rt] = value;
                    break;
                }
                case 2: {
                    value |= this.vcr.pfxd.sat[0] << 0;
                    value |= this.vcr.pfxd.sat[1] << 2;
                    value |= this.vcr.pfxd.sat[2] << 4;
                    value |= this.vcr.pfxd.sat[3] << 6;
                    if (this.vcr.pfxd.msk[0]) {
                        value |= 0x100;
                    }
                    if (this.vcr.pfxd.msk[1]) {
                        value |= 0x200;
                    }
                    if (this.vcr.pfxd.msk[2]) {
                        value |= 0x400;
                    }
                    if (this.vcr.pfxd.msk[3]) {
                        value |= 0x800;
                    }
                    this.gpr[rt] = value;
                    break;
                }
                case 3: {
                    for (int i = this.vcr.cc.length - 1; i >= 0; --i) {
                        value <<= 1;
                        if (!this.vcr.cc[i]) continue;
                        value |= 1;
                    }
                    this.gpr[rt] = value;
                    break;
                }
                case 8: {
                    this.gpr[rt] = rnd.getSeed();
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.gpr[rt] = 1065353216;
                    break;
                }
                default: {
                    this.doUNK("Unimplemented MFVC (rt=" + rt + ", imm7=" + imm7 + ")");
                }
            }
        }
    }

    public void doMTV(int rt, int imm7) {
        int r = imm7 >> 5 & 3;
        int m = imm7 >> 2 & 7;
        int c = imm7 >> 0 & 3;
        this.setVprInt(m, c, r, this.gpr[rt]);
    }

    public void doMTVC(int rt, int imm7) {
        int value = this.gpr[rt];
        switch (imm7) {
            case 0: {
                this.vcr.pfxs.swz[0] = value >> 0 & 3;
                this.vcr.pfxs.swz[1] = value >> 2 & 3;
                this.vcr.pfxs.swz[2] = value >> 4 & 3;
                this.vcr.pfxs.swz[3] = value >> 6 & 3;
                this.vcr.pfxs.abs[0] = (value >> 8 & 1) == 1;
                this.vcr.pfxs.abs[1] = (value >> 9 & 1) == 1;
                this.vcr.pfxs.abs[2] = (value >> 10 & 1) == 1;
                this.vcr.pfxs.abs[3] = (value >> 11 & 1) == 1;
                this.vcr.pfxs.cst[0] = (value >> 12 & 1) == 1;
                this.vcr.pfxs.cst[1] = (value >> 13 & 1) == 1;
                this.vcr.pfxs.cst[2] = (value >> 14 & 1) == 1;
                this.vcr.pfxs.cst[3] = (value >> 15 & 1) == 1;
                this.vcr.pfxs.neg[0] = (value >> 16 & 1) == 1;
                this.vcr.pfxs.neg[1] = (value >> 17 & 1) == 1;
                this.vcr.pfxs.neg[2] = (value >> 18 & 1) == 1;
                this.vcr.pfxs.neg[3] = (value >> 19 & 1) == 1;
                this.vcr.pfxs.enabled = true;
                break;
            }
            case 1: {
                this.vcr.pfxt.swz[0] = value >> 0 & 3;
                this.vcr.pfxt.swz[1] = value >> 2 & 3;
                this.vcr.pfxt.swz[2] = value >> 4 & 3;
                this.vcr.pfxt.swz[3] = value >> 6 & 3;
                this.vcr.pfxt.abs[0] = (value >> 8 & 1) == 1;
                this.vcr.pfxt.abs[1] = (value >> 9 & 1) == 1;
                this.vcr.pfxt.abs[2] = (value >> 10 & 1) == 1;
                this.vcr.pfxt.abs[3] = (value >> 11 & 1) == 1;
                this.vcr.pfxt.cst[0] = (value >> 12 & 1) == 1;
                this.vcr.pfxt.cst[1] = (value >> 13 & 1) == 1;
                this.vcr.pfxt.cst[2] = (value >> 14 & 1) == 1;
                this.vcr.pfxt.cst[3] = (value >> 15 & 1) == 1;
                this.vcr.pfxt.neg[0] = (value >> 16 & 1) == 1;
                this.vcr.pfxt.neg[1] = (value >> 17 & 1) == 1;
                this.vcr.pfxt.neg[2] = (value >> 18 & 1) == 1;
                this.vcr.pfxt.neg[3] = (value >> 19 & 1) == 1;
                this.vcr.pfxt.enabled = true;
                break;
            }
            case 2: {
                this.vcr.pfxd.sat[0] = value >> 0 & 3;
                this.vcr.pfxd.sat[1] = value >> 2 & 3;
                this.vcr.pfxd.sat[2] = value >> 4 & 3;
                this.vcr.pfxd.sat[3] = value >> 6 & 3;
                this.vcr.pfxd.msk[0] = (value >> 8 & 1) == 1;
                this.vcr.pfxd.msk[1] = (value >> 9 & 1) == 1;
                this.vcr.pfxd.msk[2] = (value >> 10 & 1) == 1;
                this.vcr.pfxd.msk[3] = (value >> 11 & 1) == 1;
                this.vcr.pfxd.enabled = true;
                break;
            }
            case 3: {
                for (int i = 0; i < this.vcr.cc.length; ++i) {
                    this.vcr.cc[i] = (value & 1) != 0;
                    value >>>= 1;
                }
                break;
            }
            case 8: {
                rnd.setSeed(value);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                this.doUNK("Unimplemented MTVC (rt=" + rt + ", imm7=" + imm7 + ", value=0x" + Integer.toHexString(value) + ")");
            }
        }
    }

    public boolean doBVF(int imm3, int simm16) {
        this.npc = !this.vcr.cc[imm3] ? VfpuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBVT(int imm3, int simm16) {
        this.npc = this.vcr.cc[imm3] ? VfpuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBVFL(int imm3, int simm16) {
        if (!this.vcr.cc[imm3]) {
            this.npc = VfpuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public boolean doBVTL(int imm3, int simm16) {
        if (this.vcr.cc[imm3]) {
            this.npc = VfpuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public void doVCMP(int vsize, int vs, int vt, int cond) {
        boolean cc_or = false;
        boolean cc_and = true;
        if ((cond & 8) == 0) {
            boolean not = (cond & 4) == 4;
            boolean cc = false;
            this.loadVs(vsize, vs);
            this.loadVt(vsize, vt);
            for (int i = 0; i < vsize; ++i) {
                switch (cond & 3) {
                    case 0: {
                        cc = not;
                        break;
                    }
                    case 1: {
                        cc = not ? v1[i] != v2[i] : v1[i] == v2[i];
                        break;
                    }
                    case 2: {
                        cc = not ? v1[i] >= v2[i] : v1[i] < v2[i];
                        break;
                    }
                    case 3: {
                        cc = not ? v1[i] > v2[i] : v1[i] <= v2[i];
                    }
                }
                this.vcr.cc[i] = cc;
                cc_or = cc_or || cc;
                cc_and = cc_and && cc;
            }
        } else {
            this.loadVs(vsize, vs);
            for (int i = 0; i < vsize; ++i) {
                boolean cc;
                if ((cond & 3) == 0) {
                    cc = (cond & 4) == 0 ? v1[i] == 0.0f : v1[i] != 0.0f;
                } else {
                    boolean bl = cc = (cond & 1) == 1 && Float.isNaN(v1[i]) || (cond & 2) == 2 && Float.isInfinite(v1[i]);
                    if ((cond & 4) == 4) {
                        cc = !cc;
                    }
                }
                this.vcr.cc[i] = cc;
                cc_or = cc_or || cc;
                cc_and = cc_and && cc;
            }
        }
        this.vcr.cc[4] = cc_or;
        this.vcr.cc[5] = cc_and;
    }

    public void doVMIN(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = Math.min(v1[i], v2[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVMAX(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = Math.max(v1[i], v2[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVSCMP(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = Math.signum(v1[i] - v2[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVSGE(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = v1[i] >= v2[i] ? 1.0f : 0.0f;
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVSLT(int vsize, int vd, int vs, int vt) {
        this.loadVs(vsize, vs);
        this.loadVt(vsize, vt);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = v1[i] < v2[i] ? 1.0f : 0.0f;
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVMOV(int vsize, int vd, int vs) {
        this.loadVsInt(vsize, vs);
        this.saveVdInt(vsize, vd, v1i);
    }

    public void doVABS(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = Math.abs(v1[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVNEG(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = 0.0f - v1[i];
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVIDT(int vsize, int vd) {
        int id = vd & 3;
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = id == i ? 1.0f : 0.0f;
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVSAT0(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = Math.min(Math.max(0.0f, v1[i]), 1.0f);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVSAT1(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = Math.min(Math.max(-1.0f, v1[i]), 1.0f);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVZERO(int vsize, int vd) {
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = 0.0f;
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVONE(int vsize, int vd) {
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = 1.0f;
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVRCP(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = 1.0f / v1[i];
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVRSQ(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (float)(1.0 / Math.sqrt(v1[i]));
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVSIN(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (float)Math.sin(1.5707963267948966 * (double)v1[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVCOS(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (float)Math.cos(1.5707963267948966 * (double)v1[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVEXP2(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (float)Math.pow(2.0, v1[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVLOG2(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (float)(Math.log(v1[i]) / Math.log(2.0));
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVSQRT(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (float)Math.sqrt(v1[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVASIN(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (float)(Math.asin(v1[i]) * 2.0 / Math.PI);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVNRCP(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = 0.0f - 1.0f / v1[i];
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVNSIN(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = 0.0f - (float)Math.sin(1.5707963267948966 * (double)v1[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVREXP2(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (float)(1.0 / Math.pow(2.0, v1[i]));
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVRNDS(int vsize, int vs) {
        if (vsize != 1) {
            this.doUNK("Only supported VRNDS.S");
            return;
        }
        this.loadVsInt(1, vs);
        rnd.setSeed(v1i[0]);
    }

    public void doVRNDI(int vsize, int vd) {
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3i[i] = rnd.nextInt();
        }
        this.saveVdInt(vsize, vd, v3i);
    }

    public void doVRNDF1(int vsize, int vd) {
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = 1.0f + rnd.nextFloat();
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVRNDF2(int vsize, int vd) {
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = (1.0f + rnd.nextFloat()) * 2.0f;
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVF2H(int vsize, int vd, int vs) {
        if ((vsize & 1) == 1) {
            this.doUNK("Only supported VF2H.P or VF2H.Q");
            return;
        }
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize / 2; ++i) {
            VfpuState.v3[i] = this.floatToHalffloat(v1[1 + i * 2]) << 16 | this.floatToHalffloat(v1[0 + i * 2]) << 0;
        }
        this.saveVd(vsize / 2, vd, v3);
    }

    public void doVH2F(int vsize, int vd, int vs) {
        if (vsize > 2) {
            this.doUNK("Only supported VH2F.S or VH2F.P");
            return;
        }
        this.loadVsInt(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            int imm32 = v1i[i];
            VfpuState.v3[0 + 2 * i] = VfpuState.halffloatToFloat(imm32 & 0xFFFF);
            VfpuState.v3[1 + 2 * i] = VfpuState.halffloatToFloat(imm32 >>> 16);
        }
        this.saveVd(vsize * 2, vd, v3);
    }

    public void doVSBZ(int vsize, int vd, int vs) {
        this.doUNK("Unimplemented VSBZ");
    }

    public void doVLGB(int vsize, int vd, int vs) {
        this.doUNK("Unimplemented VLGB");
    }

    public void doVUC2I(int vsize, int vd, int vs) {
        if (vsize != 1) {
            this.doUNK("Only supported VUC2I.S");
            return;
        }
        this.loadVsInt(1, vs);
        int n = v1i[0];
        VfpuState.v3i[0] = (n & 0xFF) * 0x1010101 >>> 1;
        VfpuState.v3i[1] = (n >> 8 & 0xFF) * 0x1010101 >>> 1;
        VfpuState.v3i[2] = (n >> 16 & 0xFF) * 0x1010101 >>> 1;
        VfpuState.v3i[3] = (n >> 24 & 0xFF) * 0x1010101 >>> 1;
        this.saveVdInt(4, vd, v3i);
    }

    public void doVC2I(int vsize, int vd, int vs) {
        if (vsize != 1) {
            this.doUNK("Only supported VC2I.S");
            return;
        }
        this.loadVsInt(1, vs);
        int n = v1i[0];
        VfpuState.v3i[0] = (n & 0xFF) << 24;
        VfpuState.v3i[1] = (n >> 8 & 0xFF) << 24;
        VfpuState.v3i[2] = (n >> 16 & 0xFF) << 24;
        VfpuState.v3i[3] = (n >> 24 & 0xFF) << 24;
        this.saveVdInt(4, vd, v3i);
    }

    public void doVUS2I(int vsize, int vd, int vs) {
        if (vsize > 2) {
            this.doUNK("Only supported VUS2I.S or VUS2I.P");
            return;
        }
        this.loadVsInt(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            int imm32 = v1i[i];
            VfpuState.v3i[0 + 2 * i] = (imm32 & 0xFFFF) << 15;
            VfpuState.v3i[1 + 2 * i] = (imm32 >>> 16 & 0xFFFF) << 15;
        }
        this.saveVdInt(vsize * 2, vd, v3i);
    }

    public void doVS2I(int vsize, int vd, int vs) {
        if (vsize > 2) {
            this.doUNK("Only supported VS2I.S or VS2I.P");
            return;
        }
        this.loadVsInt(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            int imm32 = v1i[i];
            VfpuState.v3i[0 + 2 * i] = (imm32 & 0xFFFF) << 16;
            VfpuState.v3i[1 + 2 * i] = (imm32 >>> 16 & 0xFFFF) << 16;
        }
        this.saveVdInt(vsize * 2, vd, v3i);
    }

    public void doVI2UC(int vsize, int vd, int vs) {
        if (vsize != 4) {
            this.doUNK("Only supported VI2UC.Q");
            return;
        }
        this.loadVsInt(4, vs);
        int x = v1i[0];
        int y = v1i[1];
        int z = v1i[2];
        int w = v1i[3];
        VfpuState.v3i[0] = (x < 0 ? 0 : x >> 23 << 0) | (y < 0 ? 0 : y >> 23 << 8) | (z < 0 ? 0 : z >> 23 << 16) | (w < 0 ? 0 : w >> 23 << 24);
        this.saveVdInt(1, vd, v3i);
    }

    public void doVI2C(int vsize, int vd, int vs) {
        if (vsize != 4) {
            this.doUNK("Only supported VI2C.Q");
            return;
        }
        this.loadVsInt(4, vs);
        int x = v1i[0];
        int y = v1i[1];
        int z = v1i[2];
        int w = v1i[3];
        VfpuState.v3i[0] = x >>> 24 << 0 | y >>> 24 << 8 | z >>> 24 << 16 | w >>> 24 << 24;
        this.saveVdInt(1, vd, v3i);
    }

    public void doVI2US(int vsize, int vd, int vs) {
        if ((vsize & 1) != 0) {
            this.doUNK("Only supported VI2US.P and VI2US.Q");
            return;
        }
        this.loadVsInt(vsize, vs);
        int x = v1i[0];
        int y = v1i[1];
        VfpuState.v3i[0] = (x < 0 ? 0 : x >> 15 << 0) | (y < 0 ? 0 : y >> 15 << 16);
        if (vsize == 4) {
            int z = v1i[2];
            int w = v1i[3];
            VfpuState.v3i[1] = (z < 0 ? 0 : z >> 15 << 0) | (w < 0 ? 0 : w >> 15 << 16);
            this.saveVdInt(2, vd, v3i);
        } else {
            this.saveVdInt(1, vd, v3i);
        }
    }

    public void doVI2S(int vsize, int vd, int vs) {
        if ((vsize & 1) != 0) {
            this.doUNK("Only supported VI2S.P and VI2S.Q");
            return;
        }
        this.loadVsInt(vsize, vs);
        int x = v1i[0];
        int y = v1i[1];
        VfpuState.v3i[0] = x >>> 16 << 0 | y >>> 16 << 16;
        if (vsize == 4) {
            int z = v1i[2];
            int w = v1i[3];
            VfpuState.v3i[1] = z >>> 16 << 0 | w >>> 16 << 16;
            this.saveVdInt(2, vd, v3i);
        } else {
            this.saveVdInt(1, vd, v3i);
        }
    }

    public void doVSRT1(int vsize, int vd, int vs) {
        if (vsize != 4) {
            this.doUNK("Only supported VSRT1.Q");
            return;
        }
        this.loadVs(4, vs);
        float x = v1[0];
        float y = v1[1];
        float z = v1[2];
        float w = v1[3];
        VfpuState.v3[0] = Math.min(x, y);
        VfpuState.v3[1] = Math.max(x, y);
        VfpuState.v3[2] = Math.min(z, w);
        VfpuState.v3[3] = Math.max(z, w);
        this.saveVd(4, vd, v3);
    }

    public void doVSRT2(int vsize, int vd, int vs) {
        if (vsize != 4) {
            this.doUNK("Only supported VSRT2.Q");
            return;
        }
        this.loadVs(4, vs);
        float x = v1[0];
        float y = v1[1];
        float z = v1[2];
        float w = v1[3];
        VfpuState.v3[0] = Math.min(x, w);
        VfpuState.v3[1] = Math.min(y, z);
        VfpuState.v3[2] = Math.max(y, z);
        VfpuState.v3[3] = Math.max(x, w);
        this.saveVd(4, vd, v3);
    }

    public void doVBFY1(int vsize, int vd, int vs) {
        if ((vsize & 1) == 1) {
            this.doUNK("Only supported VBFY1.P or VBFY1.Q");
            return;
        }
        this.loadVs(vsize, vs);
        float x = v1[0];
        float y = v1[1];
        VfpuState.v3[0] = x + y;
        VfpuState.v3[1] = x - y;
        if (vsize > 2) {
            float z = v1[2];
            float w = v1[3];
            VfpuState.v3[2] = z + w;
            VfpuState.v3[3] = z - w;
            this.saveVd(4, vd, v3);
        } else {
            this.saveVd(2, vd, v3);
        }
    }

    public void doVBFY2(int vsize, int vd, int vs) {
        if (vsize != 4) {
            this.doUNK("Only supported VBFY2.Q");
            return;
        }
        this.loadVs(vsize, vs);
        float x = v1[0];
        float y = v1[1];
        float z = v1[2];
        float w = v1[3];
        VfpuState.v3[0] = x + z;
        VfpuState.v3[1] = y + w;
        VfpuState.v3[2] = x - z;
        VfpuState.v3[3] = y - w;
        this.saveVd(4, vd, v3);
    }

    public void doVOCP(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v1[i] = 1.0f - v1[i];
        }
        this.saveVd(vsize, vd, v1);
    }

    public void doVSOCP(int vsize, int vd, int vs) {
        if (vsize > 2) {
            this.doUNK("Only supported VSOCP.S or VSOCP.P");
            return;
        }
        this.loadVs(vsize, vs);
        float x = v1[0];
        VfpuState.v3[0] = Math.min(Math.max(0.0f, 1.0f - x), 1.0f);
        VfpuState.v3[1] = Math.min(Math.max(0.0f, 1.0f + x), 1.0f);
        if (vsize > 1) {
            float y = v1[1];
            VfpuState.v3[2] = Math.min(Math.max(0.0f, 1.0f - y), 1.0f);
            VfpuState.v3[3] = Math.min(Math.max(0.0f, 1.0f + y), 1.0f);
            this.saveVd(4, vd, v3);
        } else {
            this.saveVd(2, vd, v3);
        }
    }

    public void doVFAD(int vsize, int vd, int vs) {
        if (vsize == 1) {
            this.doUNK("Unsupported VFAD.S");
            return;
        }
        this.loadVs(vsize, vs);
        for (int i = 1; i < vsize; ++i) {
            v1[0] = v1[0] + v1[i];
        }
        this.saveVd(1, vd, v1);
    }

    public void doVAVG(int vsize, int vd, int vs) {
        if (vsize == 1) {
            this.doUNK("Unsupported VAVG.S");
            return;
        }
        this.loadVs(vsize, vs);
        for (int i = 1; i < vsize; ++i) {
            v1[0] = v1[0] + v1[i];
        }
        v1[0] = v1[0] / (float)vsize;
        this.saveVd(1, vd, v1);
    }

    public void doVSRT3(int vsize, int vd, int vs) {
        if (vsize != 4) {
            this.doUNK("Only supported VSRT3.Q (vsize=" + vsize + ")");
            return;
        }
        this.loadVs(4, vs);
        float x = v1[0];
        float y = v1[1];
        float z = v1[2];
        float w = v1[3];
        VfpuState.v3[0] = Math.max(x, y);
        VfpuState.v3[1] = Math.min(x, y);
        VfpuState.v3[2] = Math.max(z, w);
        VfpuState.v3[3] = Math.min(z, w);
        this.saveVd(4, vd, v3);
    }

    public void doVSGN(int vsize, int vd, int vs) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = Math.signum(v1[i]);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVSRT4(int vsize, int vd, int vs) {
        if (vsize != 4) {
            this.doUNK("Only supported VSRT4.Q");
            return;
        }
        this.loadVs(4, vs);
        float x = v1[0];
        float y = v1[1];
        float z = v1[2];
        float w = v1[3];
        VfpuState.v3[0] = Math.max(x, w);
        VfpuState.v3[1] = Math.max(y, z);
        VfpuState.v3[2] = Math.min(y, z);
        VfpuState.v3[3] = Math.min(x, w);
        this.saveVd(4, vd, v3);
    }

    public void doVMFVC(int vd, int imm7) {
        int value = 0;
        switch (imm7) {
            case 0: {
                value |= this.vcr.pfxs.swz[0] << 0;
                value |= this.vcr.pfxs.swz[1] << 2;
                value |= this.vcr.pfxs.swz[2] << 4;
                value |= this.vcr.pfxs.swz[3] << 6;
                if (this.vcr.pfxs.abs[0]) {
                    value |= 0x100;
                }
                if (this.vcr.pfxs.abs[1]) {
                    value |= 0x200;
                }
                if (this.vcr.pfxs.abs[2]) {
                    value |= 0x400;
                }
                if (this.vcr.pfxs.abs[3]) {
                    value |= 0x800;
                }
                if (this.vcr.pfxs.cst[0]) {
                    value |= 0x1000;
                }
                if (this.vcr.pfxs.cst[1]) {
                    value |= 0x2000;
                }
                if (this.vcr.pfxs.cst[2]) {
                    value |= 0x4000;
                }
                if (this.vcr.pfxs.cst[3]) {
                    value |= 0x8000;
                }
                if (this.vcr.pfxs.neg[0]) {
                    value |= 0x10000;
                }
                if (this.vcr.pfxs.neg[1]) {
                    value |= 0x20000;
                }
                if (this.vcr.pfxs.neg[2]) {
                    value |= 0x40000;
                }
                if (this.vcr.pfxs.neg[3]) {
                    value |= 0x80000;
                }
                VfpuState.v3i[0] = value;
                this.saveVdInt(1, vd, v3i);
                break;
            }
            case 1: {
                value |= this.vcr.pfxt.swz[0] << 0;
                value |= this.vcr.pfxt.swz[1] << 2;
                value |= this.vcr.pfxt.swz[2] << 4;
                value |= this.vcr.pfxt.swz[3] << 6;
                if (this.vcr.pfxt.abs[0]) {
                    value |= 0x100;
                }
                if (this.vcr.pfxt.abs[1]) {
                    value |= 0x200;
                }
                if (this.vcr.pfxt.abs[2]) {
                    value |= 0x400;
                }
                if (this.vcr.pfxt.abs[3]) {
                    value |= 0x800;
                }
                if (this.vcr.pfxt.cst[0]) {
                    value |= 0x1000;
                }
                if (this.vcr.pfxt.cst[1]) {
                    value |= 0x2000;
                }
                if (this.vcr.pfxt.cst[2]) {
                    value |= 0x4000;
                }
                if (this.vcr.pfxt.cst[3]) {
                    value |= 0x8000;
                }
                if (this.vcr.pfxt.neg[0]) {
                    value |= 0x10000;
                }
                if (this.vcr.pfxt.neg[1]) {
                    value |= 0x20000;
                }
                if (this.vcr.pfxt.neg[2]) {
                    value |= 0x40000;
                }
                if (this.vcr.pfxt.neg[3]) {
                    value |= 0x80000;
                }
                VfpuState.v3i[0] = value;
                this.saveVdInt(1, vd, v3i);
                break;
            }
            case 2: {
                value |= this.vcr.pfxd.sat[0] << 0;
                value |= this.vcr.pfxd.sat[1] << 2;
                value |= this.vcr.pfxd.sat[2] << 4;
                value |= this.vcr.pfxd.sat[3] << 6;
                if (this.vcr.pfxd.msk[0]) {
                    value |= 0x100;
                }
                if (this.vcr.pfxd.msk[1]) {
                    value |= 0x200;
                }
                if (this.vcr.pfxd.msk[2]) {
                    value |= 0x400;
                }
                if (this.vcr.pfxd.msk[3]) {
                    value |= 0x800;
                }
                VfpuState.v3i[0] = value;
                this.saveVdInt(1, vd, v3i);
                break;
            }
            case 3: {
                for (int i = this.vcr.cc.length - 1; i >= 0; --i) {
                    value <<= 1;
                    if (!this.vcr.cc[i]) continue;
                    value |= 1;
                }
                VfpuState.v3i[0] = value;
                this.saveVdInt(1, vd, v3i);
                break;
            }
            case 8: {
                VfpuState.v3i[0] = rnd.getSeed();
                this.saveVdInt(1, vd, v3i);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                VfpuState.v3i[0] = 1065353216;
                this.saveVdInt(1, vd, v3i);
                break;
            }
            default: {
                this.doUNK("Unimplemented VMFVC (vd=" + vd + ", imm7=" + imm7 + ")");
            }
        }
    }

    public void doVMTVC(int vd, int imm7) {
        this.loadVdInt(1, vd);
        int value = v1i[0];
        switch (imm7) {
            case 0: {
                this.vcr.pfxs.swz[0] = value >> 0 & 3;
                this.vcr.pfxs.swz[1] = value >> 2 & 3;
                this.vcr.pfxs.swz[2] = value >> 4 & 3;
                this.vcr.pfxs.swz[3] = value >> 6 & 3;
                this.vcr.pfxs.abs[0] = (value >> 8 & 1) == 1;
                this.vcr.pfxs.abs[1] = (value >> 9 & 1) == 1;
                this.vcr.pfxs.abs[2] = (value >> 10 & 1) == 1;
                this.vcr.pfxs.abs[3] = (value >> 11 & 1) == 1;
                this.vcr.pfxs.cst[0] = (value >> 12 & 1) == 1;
                this.vcr.pfxs.cst[1] = (value >> 13 & 1) == 1;
                this.vcr.pfxs.cst[2] = (value >> 14 & 1) == 1;
                this.vcr.pfxs.cst[3] = (value >> 15 & 1) == 1;
                this.vcr.pfxs.neg[0] = (value >> 16 & 1) == 1;
                this.vcr.pfxs.neg[1] = (value >> 17 & 1) == 1;
                this.vcr.pfxs.neg[2] = (value >> 18 & 1) == 1;
                this.vcr.pfxs.neg[3] = (value >> 19 & 1) == 1;
                this.vcr.pfxs.enabled = true;
                break;
            }
            case 1: {
                this.vcr.pfxt.swz[0] = value >> 0 & 3;
                this.vcr.pfxt.swz[1] = value >> 2 & 3;
                this.vcr.pfxt.swz[2] = value >> 4 & 3;
                this.vcr.pfxt.swz[3] = value >> 6 & 3;
                this.vcr.pfxt.abs[0] = (value >> 8 & 1) == 1;
                this.vcr.pfxt.abs[1] = (value >> 9 & 1) == 1;
                this.vcr.pfxt.abs[2] = (value >> 10 & 1) == 1;
                this.vcr.pfxt.abs[3] = (value >> 11 & 1) == 1;
                this.vcr.pfxt.cst[0] = (value >> 12 & 1) == 1;
                this.vcr.pfxt.cst[1] = (value >> 13 & 1) == 1;
                this.vcr.pfxt.cst[2] = (value >> 14 & 1) == 1;
                this.vcr.pfxt.cst[3] = (value >> 15 & 1) == 1;
                this.vcr.pfxt.neg[0] = (value >> 16 & 1) == 1;
                this.vcr.pfxt.neg[1] = (value >> 17 & 1) == 1;
                this.vcr.pfxt.neg[2] = (value >> 18 & 1) == 1;
                this.vcr.pfxt.neg[3] = (value >> 19 & 1) == 1;
                this.vcr.pfxt.enabled = true;
                break;
            }
            case 2: {
                this.vcr.pfxd.sat[0] = value >> 0 & 3;
                this.vcr.pfxd.sat[1] = value >> 2 & 3;
                this.vcr.pfxd.sat[2] = value >> 4 & 3;
                this.vcr.pfxd.sat[3] = value >> 6 & 3;
                this.vcr.pfxd.msk[0] = (value >> 8 & 1) == 1;
                this.vcr.pfxd.msk[1] = (value >> 9 & 1) == 1;
                this.vcr.pfxd.msk[2] = (value >> 10 & 1) == 1;
                this.vcr.pfxd.msk[3] = (value >> 11 & 1) == 1;
                this.vcr.pfxd.enabled = true;
                break;
            }
            case 3: {
                for (int i = 0; i < this.vcr.cc.length; ++i) {
                    this.vcr.cc[i] = (value & 1) != 0;
                    value >>>= 1;
                }
                break;
            }
            case 8: {
                rnd.setSeed(value);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                this.doUNK("Unimplemented VMTVC (vd=" + vd + ", imm7=" + imm7 + ", value=0x" + Integer.toHexString(value) + ")");
            }
        }
    }

    public void doVT4444(int vsize, int vd, int vs) {
        this.loadVsInt(4, vs);
        int i0 = v1i[0];
        int i1 = v1i[1];
        int i2 = v1i[2];
        int i3 = v1i[3];
        int o0 = 0;
        int o1 = 0;
        o0 |= (i0 >> 4 & 0xF) << 0;
        o0 |= (i0 >> 12 & 0xF) << 4;
        o0 |= (i0 >> 20 & 0xF) << 8;
        o0 |= (i0 >> 28 & 0xF) << 12;
        o0 |= (i1 >> 4 & 0xF) << 16;
        o0 |= (i1 >> 12 & 0xF) << 20;
        o0 |= (i1 >> 20 & 0xF) << 24;
        o0 |= (i1 >> 28 & 0xF) << 28;
        o1 |= (i2 >> 4 & 0xF) << 0;
        o1 |= (i2 >> 12 & 0xF) << 4;
        o1 |= (i2 >> 20 & 0xF) << 8;
        o1 |= (i2 >> 28 & 0xF) << 12;
        o1 |= (i3 >> 4 & 0xF) << 16;
        o1 |= (i3 >> 12 & 0xF) << 20;
        o1 |= (i3 >> 20 & 0xF) << 24;
        VfpuState.v3i[0] = o0;
        VfpuState.v3i[1] = o1 |= (i3 >> 28 & 0xF) << 28;
        this.saveVdInt(2, vd, v3i);
    }

    public void doVT5551(int vsize, int vd, int vs) {
        this.loadVsInt(4, vs);
        int i0 = v1i[0];
        int i1 = v1i[1];
        int i2 = v1i[2];
        int i3 = v1i[3];
        int o0 = 0;
        int o1 = 0;
        o0 |= (i0 >> 3 & 0x1F) << 0;
        o0 |= (i0 >> 11 & 0x1F) << 5;
        o0 |= (i0 >> 19 & 0x1F) << 10;
        o0 |= (i0 >> 31 & 1) << 15;
        o0 |= (i1 >> 3 & 0x1F) << 16;
        o0 |= (i1 >> 11 & 0x1F) << 21;
        o0 |= (i1 >> 19 & 0x1F) << 26;
        o0 |= (i1 >> 31 & 1) << 31;
        o1 |= (i2 >> 3 & 0x1F) << 0;
        o1 |= (i2 >> 11 & 0x1F) << 5;
        o1 |= (i2 >> 19 & 0x1F) << 10;
        o1 |= (i2 >> 31 & 1) << 15;
        o1 |= (i3 >> 3 & 0x1F) << 16;
        o1 |= (i3 >> 11 & 0x1F) << 21;
        o1 |= (i3 >> 19 & 0x1F) << 26;
        VfpuState.v3i[0] = o0;
        VfpuState.v3i[1] = o1 |= (i3 >> 31 & 1) << 31;
        this.saveVdInt(2, vd, v3i);
    }

    public void doVT5650(int vsize, int vd, int vs) {
        this.loadVsInt(4, vs);
        int i0 = v1i[0];
        int i1 = v1i[1];
        int i2 = v1i[2];
        int i3 = v1i[3];
        int o0 = 0;
        int o1 = 0;
        o0 |= (i0 >> 3 & 0x1F) << 0;
        o0 |= (i0 >> 10 & 0x3F) << 5;
        o0 |= (i0 >> 19 & 0x1F) << 11;
        o0 |= (i1 >> 3 & 0x1F) << 16;
        o0 |= (i1 >> 10 & 0x3F) << 21;
        o0 |= (i1 >> 19 & 0x1F) << 27;
        o1 |= (i2 >> 3 & 0x1F) << 0;
        o1 |= (i2 >> 10 & 0x3F) << 5;
        o1 |= (i2 >> 19 & 0x1F) << 11;
        o1 |= (i3 >> 3 & 0x1F) << 16;
        o1 |= (i3 >> 10 & 0x3F) << 21;
        VfpuState.v3i[0] = o0;
        VfpuState.v3i[1] = o1 |= (i3 >> 19 & 0x1F) << 27;
        this.saveVdInt(2, vd, v3i);
    }

    public void doVCST(int vsize, int vd, int imm5) {
        float constant = 0.0f;
        if (imm5 >= 0 && imm5 < floatConstants.length) {
            constant = floatConstants[imm5];
        }
        for (int i = 0; i < vsize; ++i) {
            VfpuState.v3[i] = constant;
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVF2IN(int vsize, int vd, int vs, int imm5) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            float value = Math.scalb(v1[i], imm5);
            VfpuState.v3i[i] = Math.round(value);
        }
        this.saveVdInt(vsize, vd, v3i);
    }

    public void doVF2IZ(int vsize, int vd, int vs, int imm5) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            float value = Math.scalb(v1[i], imm5);
            VfpuState.v3i[i] = v1[i] >= 0.0f ? (int)Math.floor(value) : (int)Math.ceil(value);
        }
        this.saveVdInt(vsize, vd, v3i);
    }

    public void doVF2IU(int vsize, int vd, int vs, int imm5) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            float value = Math.scalb(v1[i], imm5);
            VfpuState.v3i[i] = (int)Math.ceil(value);
        }
        this.saveVdInt(vsize, vd, v3i);
    }

    public void doVF2ID(int vsize, int vd, int vs, int imm5) {
        this.loadVs(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            float value = Math.scalb(v1[i], imm5);
            VfpuState.v3i[i] = (int)Math.floor(value);
        }
        this.saveVdInt(vsize, vd, v3i);
    }

    public void doVI2F(int vsize, int vd, int vs, int imm5) {
        this.loadVsInt(vsize, vs);
        for (int i = 0; i < vsize; ++i) {
            float value = v1i[i];
            VfpuState.v3[i] = Math.scalb(value, -imm5);
        }
        this.saveVd(vsize, vd, v3);
    }

    public void doVCMOVT(int vsize, int imm3, int vd, int vs) {
        if (imm3 < 6) {
            if (this.vcr.cc[imm3]) {
                this.loadVs(vsize, vs);
                this.saveVd(vsize, vd, v1);
            } else {
                this.vcr.pfxs.enabled = false;
                if (this.vcr.pfxd.enabled) {
                    this.loadVd(vsize, vd);
                    this.saveVd(vsize, vd, v3);
                }
            }
        } else if (imm3 == 6) {
            this.loadVs(vsize, vs);
            this.loadVt(vsize, vd);
            for (int i = 0; i < vsize; ++i) {
                if (!this.vcr.cc[i]) continue;
                VfpuState.v2[i] = v1[i];
            }
            this.saveVd(vsize, vd, v2);
        }
    }

    public void doVCMOVF(int vsize, int imm3, int vd, int vs) {
        if (imm3 < 6) {
            if (!this.vcr.cc[imm3]) {
                this.loadVs(vsize, vs);
                this.saveVd(vsize, vd, v1);
            } else {
                this.vcr.pfxs.enabled = false;
                if (this.vcr.pfxd.enabled) {
                    this.loadVd(vsize, vd);
                    this.saveVd(vsize, vd, v3);
                }
            }
        } else if (imm3 == 6) {
            this.loadVs(vsize, vs);
            this.loadVt(vsize, vd);
            for (int i = 0; i < vsize; ++i) {
                if (this.vcr.cc[i]) continue;
                VfpuState.v2[i] = v1[i];
            }
            this.saveVd(vsize, vd, v2);
        } else {
            this.loadVs(vsize, vs);
            this.saveVd(vsize, vd, v1);
        }
    }

    public void doVWBN(int vsize, int vd, int vs, int imm8) {
        if (vsize != 1) {
            this.doUNK("Only supported VWBN.S");
            return;
        }
        this.loadVs(vsize, vs);
        BigInteger exp = BigInteger.valueOf((int)Math.pow(2.0, 127 - imm8));
        BigInteger bn = BigInteger.valueOf((int)v1[0]);
        if (bn.intValue() > 0) {
            bn = bn.modPow(exp, bn);
        }
        VfpuState.v1[0] = bn.floatValue() + (float)(v1[0] < 0.0f ? exp.negate().intValue() : exp.intValue());
        this.saveVd(vsize, vd, v1);
    }

    public void doVPFXS(int negw, int negz, int negy, int negx, int cstw, int cstz, int csty, int cstx, int absw, int absz, int absy, int absx, int swzw, int swzz, int swzy, int swzx) {
        this.vcr.pfxs.swz[0] = swzx;
        this.vcr.pfxs.swz[1] = swzy;
        this.vcr.pfxs.swz[2] = swzz;
        this.vcr.pfxs.swz[3] = swzw;
        this.vcr.pfxs.abs[0] = absx != 0;
        this.vcr.pfxs.abs[1] = absy != 0;
        this.vcr.pfxs.abs[2] = absz != 0;
        this.vcr.pfxs.abs[3] = absw != 0;
        this.vcr.pfxs.cst[0] = cstx != 0;
        this.vcr.pfxs.cst[1] = csty != 0;
        this.vcr.pfxs.cst[2] = cstz != 0;
        this.vcr.pfxs.cst[3] = cstw != 0;
        this.vcr.pfxs.neg[0] = negx != 0;
        this.vcr.pfxs.neg[1] = negy != 0;
        this.vcr.pfxs.neg[2] = negz != 0;
        this.vcr.pfxs.neg[3] = negw != 0;
        this.vcr.pfxs.enabled = true;
    }

    public void doVPFXT(int negw, int negz, int negy, int negx, int cstw, int cstz, int csty, int cstx, int absw, int absz, int absy, int absx, int swzw, int swzz, int swzy, int swzx) {
        this.vcr.pfxt.swz[0] = swzx;
        this.vcr.pfxt.swz[1] = swzy;
        this.vcr.pfxt.swz[2] = swzz;
        this.vcr.pfxt.swz[3] = swzw;
        this.vcr.pfxt.abs[0] = absx != 0;
        this.vcr.pfxt.abs[1] = absy != 0;
        this.vcr.pfxt.abs[2] = absz != 0;
        this.vcr.pfxt.abs[3] = absw != 0;
        this.vcr.pfxt.cst[0] = cstx != 0;
        this.vcr.pfxt.cst[1] = csty != 0;
        this.vcr.pfxt.cst[2] = cstz != 0;
        this.vcr.pfxt.cst[3] = cstw != 0;
        this.vcr.pfxt.neg[0] = negx != 0;
        this.vcr.pfxt.neg[1] = negy != 0;
        this.vcr.pfxt.neg[2] = negz != 0;
        this.vcr.pfxt.neg[3] = negw != 0;
        this.vcr.pfxt.enabled = true;
    }

    public void doVPFXD(int mskw, int mskz, int msky, int mskx, int satw, int satz, int saty, int satx) {
        this.vcr.pfxd.sat[0] = satx;
        this.vcr.pfxd.sat[1] = saty;
        this.vcr.pfxd.sat[2] = satz;
        this.vcr.pfxd.sat[3] = satw;
        this.vcr.pfxd.msk[0] = mskx != 0;
        this.vcr.pfxd.msk[1] = msky != 0;
        this.vcr.pfxd.msk[2] = mskz != 0;
        this.vcr.pfxd.msk[3] = mskw != 0;
        this.vcr.pfxd.enabled = true;
    }

    public void doVIIM(int vd, int imm16) {
        VfpuState.v3[0] = imm16;
        this.saveVd(1, vd, v3);
    }

    public void doVFIM(int vd, int imm16) {
        VfpuState.v3[0] = VfpuState.halffloatToFloat(imm16);
        this.saveVd(1, vd, v3);
    }

    public void doVMMUL(int vsize, int vd, int vs, int vt) {
        if (vsize == 1) {
            this.doUNK("Not supported VMMUL.S");
            return;
        }
        for (int i = 0; i < vsize; ++i) {
            this.loadVt(vsize, vt + i);
            for (int j = 0; j < vsize; ++j) {
                this.loadVs(vsize, vs + j);
                float dot = v1[0] * v2[0];
                for (int k = 1; k < vsize; ++k) {
                    dot += v1[k] * v2[k];
                }
                VfpuState.v3[j] = dot;
            }
            this.saveVd(vsize, vd + i, v3);
        }
    }

    public void doVHTFM2(int vd, int vs, int vt) {
        this.loadVt(1, vt);
        this.loadVs(2, vs + 0);
        VfpuState.v3[0] = v1[0] * v2[0] + v1[1];
        this.loadVs(2, vs + 1);
        VfpuState.v3[1] = v1[0] * v2[0] + v1[1];
        this.saveVd(2, vd, v3);
    }

    public void doVTFM2(int vd, int vs, int vt) {
        this.loadVt(2, vt);
        this.loadVs(2, vs + 0);
        VfpuState.v3[0] = v1[0] * v2[0] + v1[1] * v2[1];
        this.loadVs(2, vs + 1);
        VfpuState.v3[1] = v1[0] * v2[0] + v1[1] * v2[1];
        this.saveVd(2, vd, v3);
    }

    public void doVHTFM3(int vd, int vs, int vt) {
        this.loadVt(2, vt);
        this.loadVs(3, vs + 0);
        VfpuState.v3[0] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2];
        this.loadVs(3, vs + 1);
        VfpuState.v3[1] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2];
        this.loadVs(3, vs + 2);
        VfpuState.v3[2] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2];
        this.saveVd(3, vd, v3);
    }

    public void doVTFM3(int vd, int vs, int vt) {
        this.loadVt(3, vt);
        this.loadVs(3, vs + 0);
        VfpuState.v3[0] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        this.loadVs(3, vs + 1);
        VfpuState.v3[1] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        this.loadVs(3, vs + 2);
        VfpuState.v3[2] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        this.saveVd(3, vd, v3);
    }

    public void doVHTFM4(int vd, int vs, int vt) {
        this.loadVt(3, vt);
        this.loadVs(4, vs + 0);
        VfpuState.v3[0] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3];
        this.loadVs(4, vs + 1);
        VfpuState.v3[1] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3];
        this.loadVs(4, vs + 2);
        VfpuState.v3[2] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3];
        this.loadVs(4, vs + 3);
        VfpuState.v3[3] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3];
        this.saveVd(4, vd, v3);
    }

    public void doVTFM4(int vd, int vs, int vt) {
        this.loadVt(4, vt);
        this.loadVs(4, vs + 0);
        VfpuState.v3[0] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3] * v2[3];
        this.loadVs(4, vs + 1);
        VfpuState.v3[1] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3] * v2[3];
        this.loadVs(4, vs + 2);
        VfpuState.v3[2] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3] * v2[3];
        this.loadVs(4, vs + 3);
        VfpuState.v3[3] = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3] * v2[3];
        this.saveVd(4, vd, v3);
    }

    public void doVMSCL(int vsize, int vd, int vs, int vt) {
        for (int i = 0; i < vsize; ++i) {
            this.doVSCL(vsize, vd + i, vs + i, vt);
        }
    }

    public void doVCRSP(int vd, int vs, int vt) {
        this.loadVs(3, vs);
        this.loadVt(3, vt);
        VfpuState.v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
        VfpuState.v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
        VfpuState.v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
        this.saveVd(3, vd, v3);
    }

    public void doVQMUL(int vd, int vs, int vt) {
        this.loadVs(4, vs);
        this.loadVt(4, vt);
        VfpuState.v3[0] = v1[0] * v2[3] + v1[1] * v2[2] - v1[2] * v2[1] + v1[3] * v2[0];
        VfpuState.v3[1] = -v1[0] * v2[2] + v1[1] * v2[3] + v1[2] * v2[0] + v1[3] * v2[1];
        VfpuState.v3[2] = v1[0] * v2[1] - v1[1] * v2[0] + v1[2] * v2[3] + v1[3] * v2[2];
        VfpuState.v3[3] = -v1[0] * v2[0] - v1[1] * v2[1] - v1[2] * v2[2] + v1[3] * v2[3];
        this.saveVd(4, vd, v3);
    }

    public void doVMMOV(int vsize, int vd, int vs) {
        for (int i = 0; i < vsize; ++i) {
            this.doVMOV(vsize, vd + i, vs + i);
        }
    }

    public void doVMIDT(int vsize, int vd) {
        for (int i = 0; i < vsize; ++i) {
            this.doVIDT(vsize, vd + i);
        }
    }

    public void doVMZERO(int vsize, int vd) {
        for (int i = 0; i < vsize; ++i) {
            this.doVZERO(vsize, vd + i);
        }
    }

    public void doVMONE(int vsize, int vd) {
        for (int i = 0; i < vsize; ++i) {
            this.doVONE(vsize, vd + i);
        }
    }

    public void doVROT(int vsize, int vd, int vs, int imm5) {
        this.loadVs(1, vs);
        double a = 1.5707963267948966 * (double)v1[0];
        double ca = Math.cos(a);
        double sa = Math.sin(a);
        int si = imm5 >>> 2 & 3;
        int ci = imm5 >>> 0 & 3;
        if ((imm5 & 0x10) != 0) {
            sa = 0.0 - sa;
        }
        if (si == ci) {
            for (int i = 0; i < vsize; ++i) {
                VfpuState.v3[i] = (float)sa;
            }
        } else {
            for (int i = 0; i < vsize; ++i) {
                VfpuState.v3[i] = 0.0f;
            }
            VfpuState.v3[si] = (float)sa;
        }
        VfpuState.v3[ci] = (float)ca;
        this.saveVd(vsize, vd, v3);
    }

    public void doLVS(int vt, int rs, int simm14_a16) {
        int s = vt >> 5 & 3;
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        this.setVprInt(m, i, s, memory.read32(this.gpr[rs] + simm14_a16));
    }

    public void doSVS(int vt, int rs, int simm14_a16) {
        int s = vt >> 5 & 3;
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        int address = this.gpr[rs] + simm14_a16;
        if ((address & 3) != 0) {
            Memory.log.error((Object)String.format("SV.S unaligned addr:0x%08x pc:0x%08x", address, this.pc));
        }
        memory.write32(this.gpr[rs] + simm14_a16, this.getVprInt(m, i, s));
    }

    public void doLVQ(int vt, int rs, int simm14_a16) {
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        int address = this.gpr[rs] + simm14_a16;
        if ((address & 0xF) != 0) {
            Memory.log.error((Object)String.format("LV.Q unaligned addr:0x%08x pc:0x%08x", address, this.pc));
        }
        if ((vt & 0x20) != 0) {
            for (int j = 0; j < 4; ++j) {
                this.setVprInt(m, j, i, memory.read32(address + j * 4));
            }
        } else {
            for (int j = 0; j < 4; ++j) {
                this.setVprInt(m, i, j, memory.read32(address + j * 4));
            }
        }
    }

    public void doLVLQ(int vt, int rs, int simm14_a16) {
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        int address = this.gpr[rs] + simm14_a16;
        if ((address & 3) != 0) {
            Memory.log.error((Object)String.format("LVL.Q unaligned addr:0x%08x pc:0x%08x", address, this.pc));
        }
        int k = 3 - (address >> 2 & 3);
        address &= 0xFFFFFFF0;
        if ((vt & 0x20) != 0) {
            for (int j = k; j < 4; ++j) {
                this.setVprInt(m, j, i, memory.read32(address));
                address += 4;
            }
        } else {
            for (int j = k; j < 4; ++j) {
                this.setVprInt(m, i, j, memory.read32(address));
                address += 4;
            }
        }
    }

    public void doLVRQ(int vt, int rs, int simm14_a16) {
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        int address = this.gpr[rs] + simm14_a16;
        if ((address & 3) != 0) {
            Memory.log.error((Object)String.format("LVR.Q unaligned addr:0x%08x pc:0x%08x", address, this.pc));
        }
        int k = 4 - (address >> 2 & 3);
        if ((vt & 0x20) != 0) {
            for (int j = 0; j < k; ++j) {
                this.setVprInt(m, j, i, memory.read32(address));
                address += 4;
            }
        } else {
            for (int j = 0; j < k; ++j) {
                this.setVprInt(m, i, j, memory.read32(address));
                address += 4;
            }
        }
    }

    public void doSVQ(int vt, int rs, int simm14_a16) {
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        int address = this.gpr[rs] + simm14_a16;
        if ((address & 0xF) != 0) {
            Memory.log.error((Object)String.format("SV.Q unaligned addr:0x%08x pc:0x%08x", address, this.pc));
        }
        if ((vt & 0x20) != 0) {
            for (int j = 0; j < 4; ++j) {
                memory.write32(address + j * 4, this.getVprInt(m, j, i));
            }
        } else {
            for (int j = 0; j < 4; ++j) {
                memory.write32(address + j * 4, this.getVprInt(m, i, j));
            }
        }
    }

    public void doSVLQ(int vt, int rs, int simm14_a16) {
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        int address = this.gpr[rs] + simm14_a16;
        if ((address & 3) != 0) {
            Memory.log.error((Object)String.format("SVL.Q unaligned addr:0x%08x pc:0x%08x", address, this.pc));
        }
        int k = 3 - (address >> 2 & 3);
        address &= 0xFFFFFFF0;
        if ((vt & 0x20) != 0) {
            for (int j = k; j < 4; ++j) {
                memory.write32(address, this.getVprInt(m, j, i));
                address += 4;
            }
        } else {
            for (int j = k; j < 4; ++j) {
                memory.write32(address, this.getVprInt(m, i, j));
                address += 4;
            }
        }
    }

    public void doSVRQ(int vt, int rs, int simm14_a16) {
        int m = vt >> 2 & 7;
        int i = vt >> 0 & 3;
        int address = this.gpr[rs] + simm14_a16;
        if ((address & 3) != 0) {
            Memory.log.error((Object)String.format("SVR.Q unaligned addr:0x%08x pc:0x%08x", address, this.pc));
        }
        int k = 4 - (address >> 2 & 3);
        if ((vt & 0x20) != 0) {
            for (int j = 0; j < k; ++j) {
                memory.write32(address, this.getVprInt(m, j, i));
                address += 4;
            }
        } else {
            for (int j = 0; j < k; ++j) {
                memory.write32(address, this.getVprInt(m, i, j));
                address += 4;
            }
        }
    }

    static {
        v1 = new float[4];
        v2 = new float[4];
        v3 = new float[4];
        v1i = new int[4];
        v2i = new int[4];
        v3i = new int[4];
    }

    public static class Vcr {
        public PfxSrc pfxs;
        public PfxSrc pfxt;
        public PfxDst pfxd;
        public boolean[] cc;

        public void reset() {
            this.pfxs.reset();
            this.pfxt.reset();
            this.pfxd.reset();
            Arrays.fill(this.cc, false);
        }

        public Vcr() {
            this.pfxs = new PfxSrc();
            this.pfxt = new PfxSrc();
            this.pfxd = new PfxDst();
            this.cc = new boolean[6];
        }

        public void copy(Vcr that) {
            this.pfxs.copy(that.pfxs);
            this.pfxt.copy(that.pfxt);
            this.pfxd.copy(that.pfxd);
            this.cc = (boolean[])that.cc.clone();
        }

        public Vcr(Vcr that) {
            this.pfxs = new PfxSrc(that.pfxs);
            this.pfxt = new PfxSrc(that.pfxt);
            this.pfxd = new PfxDst(that.pfxd);
            this.cc = (boolean[])that.cc.clone();
        }

        public static class PfxDst {
            public int[] sat;
            public boolean[] msk;
            public boolean enabled;

            public void reset() {
                Arrays.fill(this.sat, 0);
                Arrays.fill(this.msk, false);
                this.enabled = false;
            }

            public PfxDst() {
                this.sat = new int[4];
                this.msk = new boolean[4];
                this.enabled = false;
            }

            public void copy(PfxDst that) {
                System.arraycopy(that.sat, 0, this.sat, 0, this.sat.length);
                System.arraycopy(that.msk, 0, this.msk, 0, this.msk.length);
                this.enabled = that.enabled;
            }

            public PfxDst(PfxDst that) {
                this.copy(that);
            }
        }

        public static class PfxSrc {
            public int[] swz;
            public boolean[] abs;
            public boolean[] cst;
            public boolean[] neg;
            public boolean enabled;

            public void reset() {
                Arrays.fill(this.swz, 0);
                Arrays.fill(this.abs, false);
                Arrays.fill(this.cst, false);
                Arrays.fill(this.neg, false);
                this.enabled = false;
            }

            public PfxSrc() {
                this.swz = new int[4];
                this.abs = new boolean[4];
                this.cst = new boolean[4];
                this.neg = new boolean[4];
                this.enabled = false;
            }

            public void copy(PfxSrc that) {
                System.arraycopy(that.swz, 0, this.swz, 0, this.swz.length);
                System.arraycopy(that.abs, 0, this.abs, 0, this.abs.length);
                System.arraycopy(that.cst, 0, this.cst, 0, this.cst.length);
                System.arraycopy(that.neg, 0, this.neg, 0, this.neg.length);
                this.enabled = that.enabled;
            }

            public PfxSrc(PfxSrc that) {
                this.copy(that);
            }
        }
    }

    private static class Random {
        private long seed;
        private static final long multiplier = 25214903917L;
        private static final long addend = 11L;
        private static final long mask = 0xFFFFFFFFL;

        public Random() {
            this(1065353217);
        }

        public Random(int seed) {
            this.setSeed(seed);
        }

        public void setSeed(int seed) {
            this.seed = (long)seed & 0xFFFFFFFFL;
        }

        public int getSeed() {
            return (int)this.seed;
        }

        protected int next(int bits) {
            this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFL;
            return (int)(this.seed >>> 32 - bits);
        }

        public int nextInt() {
            return this.next(32);
        }

        public int nextInt(int n) {
            int val;
            int bits;
            if (n <= 0) {
                throw new IllegalArgumentException("n must be positive");
            }
            if ((n & -n) == n) {
                return (int)((long)n * (long)this.next(31) >> 31);
            }
            while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
            }
            return val;
        }

        public float nextFloat() {
            return (float)this.next(24) / 1.6777216E7f;
        }
    }

    public static final class VfpuValue {
        private int intValue;
        private float floatValue;

        public VfpuValue() {
        }

        public VfpuValue(VfpuValue that) {
            this.floatValue = that.floatValue;
            this.intValue = that.intValue;
        }

        public int getInt() {
            return this.intValue;
        }

        public float getFloat() {
            return this.floatValue;
        }

        public void setInt(int value) {
            this.intValue = value;
            this.floatValue = Float.intBitsToFloat(value);
        }

        public void setFloat(float value) {
            this.floatValue = value;
            this.intValue = Float.floatToRawIntBits(value);
        }

        public void reset() {
            this.floatValue = 0.0f;
            this.intValue = 0;
        }

        public void copy(VfpuValue that) {
            this.floatValue = that.floatValue;
            this.intValue = that.intValue;
        }
    }
}

