/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.CompilerContext;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class CodeInstruction {
    protected int address;
    private int opcode;
    private Common.Instruction insn;
    private boolean isBranchTarget;
    private int branchingTo;
    private boolean isBranching;
    private Label label;

    protected CodeInstruction() {
    }

    public CodeInstruction(int address, int opcode, Common.Instruction insn, boolean isBranchTarget, boolean isBranching, int branchingTo) {
        this.address = address;
        this.opcode = opcode;
        this.insn = insn;
        this.isBranchTarget = isBranchTarget;
        this.isBranching = isBranching;
        this.branchingTo = branchingTo;
    }

    public CodeInstruction(CodeInstruction codeInstruction) {
        this.address = codeInstruction.address;
        this.opcode = codeInstruction.opcode;
        this.insn = codeInstruction.insn;
        this.isBranchTarget = codeInstruction.isBranchTarget;
        this.branchingTo = codeInstruction.branchingTo;
        this.isBranching = codeInstruction.isBranching;
        this.label = codeInstruction.label;
    }

    public int getAddress() {
        return this.address;
    }

    public int getEndAddress() {
        return this.address;
    }

    public int getLength() {
        return 1;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public Common.Instruction getInsn() {
        return this.insn;
    }

    public void setInsn(Common.Instruction insn) {
        this.insn = insn;
    }

    public boolean isBranchTarget() {
        return this.isBranchTarget;
    }

    public void setBranchTarget(boolean isBranchTarget) {
        this.isBranchTarget = isBranchTarget;
    }

    public boolean isBranching() {
        return this.isBranching;
    }

    public void setBranching(boolean isBranching) {
        this.isBranching = isBranching;
    }

    public int getBranchingTo() {
        return this.branchingTo;
    }

    public void setBranchingTo(int branchingTo) {
        this.branchingTo = branchingTo;
    }

    public Label getLabel(boolean isBranchTarget) {
        if (this.label == null) {
            this.label = new Label();
            if (isBranchTarget) {
                this.setBranchTarget(true);
            }
        }
        return this.label;
    }

    public Label getLabel() {
        return this.getLabel(true);
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public void forceNewLabel() {
        this.label = new Label();
    }

    private void setLabel(Label label) {
        this.label = label;
    }

    protected void startCompile(CompilerContext context, MethodVisitor mv) {
        if (Compiler.log.isDebugEnabled()) {
            Compiler.log.debug((Object)("CodeInstruction.compile " + this.toString()));
        }
        context.setCodeInstruction(this);
        context.beforeInstruction(this);
        if (this.hasLabel()) {
            mv.visitLabel(this.getLabel());
        }
        context.startInstruction(this);
    }

    public void compile(CompilerContext context, MethodVisitor mv) {
        this.startCompile(context, mv);
        if (this.isBranching()) {
            this.compileBranch(context, mv);
        } else if (this.insn == Instructions.JR) {
            this.compileJr(context, mv);
        } else if (this.insn == Instructions.JALR) {
            this.compileJalr(context, mv);
        } else {
            this.insn.compile(context, this.getOpcode());
        }
        context.endInstruction();
    }

    private void compileJr(CompilerContext context, MethodVisitor mv) {
        context.loadRs();
        this.compileDelaySlot(context, mv);
        context.visitJump();
    }

    private void compileJalr(CompilerContext context, MethodVisitor mv) {
        context.loadRs();
        this.compileDelaySlot(context, mv);
        context.visitCall(this.getAddress() + 8, context.getRdRegisterIndex());
    }

    private void compileBranch(CompilerContext context, MethodVisitor mv) {
        int branchingOpcode = this.getBranchingOpcode(context, mv);
        if (branchingOpcode != 0) {
            CodeInstruction branchingToCodeInstruction = context.getCodeBlock().getCodeInstruction(this.getBranchingTo());
            if (branchingToCodeInstruction != null) {
                context.visitJump(branchingOpcode, branchingToCodeInstruction);
            } else {
                context.visitJump(branchingOpcode, this.getBranchingTo());
            }
        }
    }

    private CodeInstruction getAfterDelaySlotCodeInstruction(CompilerContext context) {
        return context.getCodeBlock().getCodeInstruction(this.getAddress() + 8);
    }

    private CodeInstruction getDelaySlotCodeInstruction(CompilerContext context) {
        return context.getCodeBlock().getCodeInstruction(this.getAddress() + 4);
    }

    private void compileDelaySlot(CompilerContext context, MethodVisitor mv) {
        CodeInstruction delaySlotCodeInstruction = this.getDelaySlotCodeInstruction(context);
        if (delaySlotCodeInstruction == null) {
            Compiler.log.error((Object)("Cannot find delay slot instruction at 0x" + Integer.toHexString(this.getAddress() + 4)));
            return;
        }
        Label delaySlotLabel = null;
        if (delaySlotCodeInstruction.hasLabel()) {
            delaySlotLabel = delaySlotCodeInstruction.getLabel();
            delaySlotCodeInstruction.forceNewLabel();
        }
        delaySlotCodeInstruction.compile(context, mv);
        if (delaySlotLabel != null) {
            delaySlotCodeInstruction.setLabel(delaySlotLabel);
        } else if (delaySlotCodeInstruction.hasLabel()) {
            delaySlotCodeInstruction.forceNewLabel();
        }
        context.setCodeInstruction(this);
        context.skipInstructions(1, false);
    }

    private int getBranchingOpcodeBranch0(CompilerContext context, MethodVisitor mv) {
        this.compileDelaySlot(context, mv);
        if (this.getBranchingTo() == this.getAddress()) {
            context.visitLogInfo(mv, String.format("Pausing emulator - jump to self (death loop) at 0x%08X", this.getAddress()));
            context.visitPauseEmuWithStatus(mv, 128);
        }
        return 167;
    }

    private boolean isDelaySlotWritingRegister(CompilerContext context, int registerIndex) {
        CodeInstruction delaySlotCodeInstruction = this.getDelaySlotCodeInstruction(context);
        if (delaySlotCodeInstruction == null) {
            return false;
        }
        return delaySlotCodeInstruction.isWritingRegister(registerIndex);
    }

    private int getBranchingOpcodeCall0(CompilerContext context, MethodVisitor mv) {
        context.prepareCall(this.getBranchingTo(), this.getAddress() + 8, 31, false);
        this.compileDelaySlot(context, mv);
        context.visitCall(this.getBranchingTo(), this.getAddress() + 8, 31, false, this.isDelaySlotWritingRegister(context, 31));
        return 0;
    }

    private int getBranchingOpcodeBranch1(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        context.loadRs();
        this.compileDelaySlot(context, mv);
        return branchingOpcode;
    }

    private int getBranchingOpcodeBranch1L(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        context.loadRs();
        CodeInstruction afterDelaySlotCodeInstruction = this.getAfterDelaySlotCodeInstruction(context);
        context.visitJump(notBranchingOpcode, afterDelaySlotCodeInstruction);
        this.compileDelaySlot(context, mv);
        return 167;
    }

    private int getBranchingOpcodeCall1(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        context.prepareCall(this.getBranchingTo(), this.getAddress() + 8, 31, true);
        context.loadRs();
        this.compileDelaySlot(context, mv);
        CodeInstruction afterDelaySlotCodeInstruction = this.getAfterDelaySlotCodeInstruction(context);
        context.visitJump(notBranchingOpcode, afterDelaySlotCodeInstruction);
        context.visitCall(this.getBranchingTo(), this.getAddress() + 8, 31, true, this.isDelaySlotWritingRegister(context, 31));
        return 0;
    }

    private int getBranchingOpcodeCall1L(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        context.prepareCall(this.getBranchingTo(), this.getAddress() + 8, 31, true);
        context.loadRs();
        CodeInstruction afterDelaySlotCodeInstruction = this.getAfterDelaySlotCodeInstruction(context);
        context.visitJump(notBranchingOpcode, afterDelaySlotCodeInstruction);
        this.compileDelaySlot(context, mv);
        context.visitCall(this.getBranchingTo(), this.getAddress() + 8, 31, true, this.isDelaySlotWritingRegister(context, 31));
        return 0;
    }

    private int loadRegistersForBranchingOpcodeBranch2(CompilerContext context, MethodVisitor mv, int branchingOpcode) {
        boolean loadRs = true;
        boolean loadRt = true;
        if (context.getRsRegisterIndex() == context.getRtRegisterIndex()) {
            if (branchingOpcode == 159) {
                loadRs = false;
                loadRt = false;
                branchingOpcode = 167;
                context.loadImm(0);
                context.getMethodVisitor().visitInsn(87);
            } else if (branchingOpcode == 160) {
                loadRs = false;
                loadRt = false;
                branchingOpcode = 0;
            }
        } else if (context.isRsRegister0()) {
            if (branchingOpcode == 159) {
                loadRs = false;
                branchingOpcode = 153;
            } else if (branchingOpcode == 160) {
                loadRs = false;
                branchingOpcode = 154;
            }
        } else if (context.isRtRegister0()) {
            if (branchingOpcode == 159) {
                loadRt = false;
                branchingOpcode = 153;
            } else if (branchingOpcode == 160) {
                loadRt = false;
                branchingOpcode = 154;
            }
        }
        if (loadRs) {
            context.loadRs();
        }
        if (loadRt) {
            context.loadRt();
        }
        return branchingOpcode;
    }

    private int getBranchingOpcodeBranch2(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        branchingOpcode = this.loadRegistersForBranchingOpcodeBranch2(context, mv, branchingOpcode);
        this.compileDelaySlot(context, mv);
        if (branchingOpcode == 167 && this.getBranchingTo() == this.getAddress()) {
            context.visitLogInfo(mv, String.format("Pausing emulator - branch to self (death loop) at 0x%08X", this.getAddress()));
            context.visitPauseEmuWithStatus(mv, 128);
        }
        return branchingOpcode;
    }

    private int getBranchingOpcodeBranch2L(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        if ((notBranchingOpcode = this.loadRegistersForBranchingOpcodeBranch2(context, mv, notBranchingOpcode)) != 0) {
            CodeInstruction afterDelaySlotCodeInstruction = this.getAfterDelaySlotCodeInstruction(context);
            context.visitJump(notBranchingOpcode, afterDelaySlotCodeInstruction);
        }
        this.compileDelaySlot(context, mv);
        return 167;
    }

    private int getBranchingOpcodeBC1(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        context.loadFcr31c();
        this.compileDelaySlot(context, mv);
        return branchingOpcode;
    }

    private int getBranchingOpcodeBC1L(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        context.loadFcr31c();
        CodeInstruction afterDelaySlotCodeInstruction = this.getAfterDelaySlotCodeInstruction(context);
        context.visitJump(notBranchingOpcode, afterDelaySlotCodeInstruction);
        this.compileDelaySlot(context, mv);
        return 167;
    }

    private int getBranchingOpcodeBV(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        context.loadVcrCc();
        CodeInstruction delaySlotCodeInstruction = this.getDelaySlotCodeInstruction(context);
        if (delaySlotCodeInstruction == null || delaySlotCodeInstruction.insn != this.insn) {
            this.compileDelaySlot(context, mv);
        }
        return branchingOpcode;
    }

    private int getBranchingOpcodeBVL(CompilerContext context, MethodVisitor mv, int branchingOpcode, int notBranchingOpcode) {
        context.loadVcrCc();
        CodeInstruction afterDelaySlotCodeInstruction = this.getAfterDelaySlotCodeInstruction(context);
        context.visitJump(notBranchingOpcode, afterDelaySlotCodeInstruction);
        this.compileDelaySlot(context, mv);
        return 167;
    }

    private int getBranchingOpcode(CompilerContext context, MethodVisitor mv) {
        int branchingOpcode = 0;
        if (this.insn == Instructions.BEQ) {
            branchingOpcode = this.getBranchingOpcodeBranch2(context, mv, 159, 160);
        } else if (this.insn == Instructions.BEQL) {
            branchingOpcode = this.getBranchingOpcodeBranch2L(context, mv, 159, 160);
        } else if (this.insn == Instructions.BNE) {
            branchingOpcode = this.getBranchingOpcodeBranch2(context, mv, 160, 159);
        } else if (this.insn == Instructions.BNEL) {
            branchingOpcode = this.getBranchingOpcodeBranch2L(context, mv, 160, 159);
        } else if (this.insn == Instructions.BGEZ) {
            branchingOpcode = this.getBranchingOpcodeBranch1(context, mv, 156, 155);
        } else if (this.insn == Instructions.BGEZL) {
            branchingOpcode = this.getBranchingOpcodeBranch1L(context, mv, 156, 155);
        } else if (this.insn == Instructions.BGTZ) {
            branchingOpcode = this.getBranchingOpcodeBranch1(context, mv, 157, 158);
        } else if (this.insn == Instructions.BGTZL) {
            branchingOpcode = this.getBranchingOpcodeBranch1L(context, mv, 157, 158);
        } else if (this.insn == Instructions.BLEZ) {
            branchingOpcode = this.getBranchingOpcodeBranch1(context, mv, 158, 157);
        } else if (this.insn == Instructions.BLEZL) {
            branchingOpcode = this.getBranchingOpcodeBranch1L(context, mv, 158, 157);
        } else if (this.insn == Instructions.BLTZ) {
            branchingOpcode = this.getBranchingOpcodeBranch1(context, mv, 155, 156);
        } else if (this.insn == Instructions.BLTZL) {
            branchingOpcode = this.getBranchingOpcodeBranch1L(context, mv, 155, 156);
        } else if (this.insn == Instructions.J) {
            branchingOpcode = this.getBranchingOpcodeBranch0(context, mv);
        } else if (this.insn == Instructions.JAL) {
            branchingOpcode = this.getBranchingOpcodeCall0(context, mv);
        } else if (this.insn == Instructions.BLTZAL) {
            branchingOpcode = this.getBranchingOpcodeCall1(context, mv, 155, 156);
        } else if (this.insn == Instructions.BLTZALL) {
            branchingOpcode = this.getBranchingOpcodeCall1L(context, mv, 155, 156);
        } else if (this.insn == Instructions.BGEZAL) {
            branchingOpcode = this.getBranchingOpcodeCall1(context, mv, 156, 155);
        } else if (this.insn == Instructions.BGEZALL) {
            branchingOpcode = this.getBranchingOpcodeCall1L(context, mv, 156, 155);
        } else if (this.insn == Instructions.BC1F) {
            branchingOpcode = this.getBranchingOpcodeBC1(context, mv, 153, 154);
        } else if (this.insn == Instructions.BC1FL) {
            branchingOpcode = this.getBranchingOpcodeBC1L(context, mv, 153, 154);
        } else if (this.insn == Instructions.BC1T) {
            branchingOpcode = this.getBranchingOpcodeBC1(context, mv, 154, 153);
        } else if (this.insn == Instructions.BC1TL) {
            branchingOpcode = this.getBranchingOpcodeBC1L(context, mv, 154, 153);
        } else if (this.insn == Instructions.BVF) {
            branchingOpcode = this.getBranchingOpcodeBV(context, mv, 153, 154);
        } else if (this.insn == Instructions.BVT) {
            branchingOpcode = this.getBranchingOpcodeBV(context, mv, 154, 153);
        } else if (this.insn == Instructions.BVFL) {
            branchingOpcode = this.getBranchingOpcodeBVL(context, mv, 153, 154);
        } else if (this.insn == Instructions.BVTL) {
            branchingOpcode = this.getBranchingOpcodeBVL(context, mv, 154, 153);
        } else {
            Compiler.log.error((Object)("CodeInstruction.getBranchingOpcode: unknown instruction " + this.insn.disasm(this.getAddress(), this.getOpcode())));
        }
        return branchingOpcode;
    }

    public boolean hasFlags(int flags) {
        return this.getInsn().hasFlags(flags);
    }

    public int getSaValue() {
        return this.opcode >> 6 & 0x1F;
    }

    public int getRsRegisterIndex() {
        return this.opcode >> 21 & 0x1F;
    }

    public int getRtRegisterIndex() {
        return this.opcode >> 16 & 0x1F;
    }

    public int getRdRegisterIndex() {
        return this.opcode >> 11 & 0x1F;
    }

    public int getFdRegisterIndex() {
        return this.opcode >> 6 & 0x1F;
    }

    public int getFsRegisterIndex() {
        return this.opcode >> 11 & 0x1F;
    }

    public int getFtRegisterIndex() {
        return this.opcode >> 16 & 0x1F;
    }

    public int getCrValue() {
        return this.opcode >> 11 & 0x1F;
    }

    public int getVdRegisterIndex() {
        return this.opcode >> 0 & 0x7F;
    }

    public int getVsRegisterIndex() {
        return this.opcode >> 8 & 0x7F;
    }

    public int getVtRegisterIndex() {
        return this.opcode >> 16 & 0x7F;
    }

    public int getVsize() {
        int one = this.opcode >> 7 & 1;
        int two = this.opcode >> 15 & 1;
        return 1 + one + (two << 1);
    }

    public int getImm14(boolean signedImm) {
        int imm14 = this.opcode & 0xFFFC;
        if (signedImm) {
            imm14 = (short)imm14;
        }
        return imm14;
    }

    public int getImm16(boolean signedImm) {
        int imm16 = this.opcode & 0xFFFF;
        if (signedImm) {
            imm16 = (short)imm16;
        }
        return imm16;
    }

    public int getImm7() {
        return this.opcode & 0x7F;
    }

    public int getImm5() {
        return this.opcode >> 16 & 0x1F;
    }

    public int getImm4() {
        return this.opcode & 0xF;
    }

    public int getImm3() {
        return this.opcode >> 16 & 7;
    }

    public boolean isWritingRegister(int registerIndex) {
        if (registerIndex == 0) {
            return false;
        }
        if (this.hasFlags(4096) && this.getRtRegisterIndex() == registerIndex) {
            return true;
        }
        return this.hasFlags(8192) && this.getRdRegisterIndex() == registerIndex;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.isBranching() ? "<" : " ");
        result.append(this.isBranchTarget() ? ">" : " ");
        result.append(" 0x");
        result.append(Integer.toHexString(this.getAddress()).toUpperCase());
        result.append(" - ");
        result.append(this.getInsn().disasm(this.getAddress(), this.getOpcode()));
        return result.toString();
    }
}

