/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SyscallIgnore;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModuleFunction;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.format.DeferredStub;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;

public class SyscallHandler {
    public static boolean ignoreUnmappedImports = false;
    public static final int syscallUnmappedImport = 1048575;
    private static IgnoreUnmappedImportsSettingsListerner ignoreUnmappedImportsSettingsListerner;

    private static boolean isEnableIgnoreUnmappedImports() {
        return ignoreUnmappedImports;
    }

    private static void setEnableIgnoreUnmappedImports(boolean enable) {
        ignoreUnmappedImports = enable;
        if (enable) {
            Modules.log.info((Object)"Ignore Unmapped Imports enabled");
        }
    }

    private static void unsupportedSyscall(int code) {
        if (ignoreUnmappedImportsSettingsListerner == null) {
            ignoreUnmappedImportsSettingsListerner = new IgnoreUnmappedImportsSettingsListerner();
            Settings.getInstance().registerSettingsListener("SyscallHandler", "emu.ignoreUnmappedImports", ignoreUnmappedImportsSettingsListerner);
        }
        if (code == 1048575) {
            CpuState cpu = Emulator.getProcessor().cpu;
            String description = String.format("0x%08X", cpu.pc);
            block0: for (SceModule module : Managers.modules.values()) {
                for (DeferredStub deferredStub : module.unresolvedImports) {
                    if (deferredStub.getImportAddress() != cpu.pc && deferredStub.getImportAddress() != cpu.pc - 4) continue;
                    description = deferredStub.toString();
                    continue block0;
                }
            }
            if (SyscallHandler.isEnableIgnoreUnmappedImports()) {
                Modules.log.warn((Object)String.format("IGNORING: Unmapped import at %s - %08x %08x %08x", description, cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]));
            } else {
                Modules.log.error((Object)String.format("Unmapped import at %s - %08x %08x %08x", description, cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]));
                Emulator.PauseEmu();
            }
            cpu.gpr[2] = 0;
        } else {
            HLEModuleFunction hleModuleFunction = HLEModuleManager.getInstance().getSyscallFunction(code);
            if (hleModuleFunction != null) {
                Modules.log.error((Object)String.format("HLE Function %s(%s) not activated by default for Firmware Version %d", hleModuleFunction.getFunctionName(), hleModuleFunction.getModuleName(), Emulator.getInstance().getFirmwareVersion()));
            } else {
                CpuState cpu = Emulator.getProcessor().cpu;
                String name = "";
                for (SyscallIgnore c : SyscallIgnore.values()) {
                    if (c.getSyscall() != code) continue;
                    name = c.toString();
                    break;
                }
                Modules.log.warn((Object)String.format("Unsupported syscall %X %s %08X %08X %08X", code, name, cpu.gpr[4], cpu.gpr[5], cpu.gpr[6]));
            }
        }
    }

    public static void syscall(int code) {
        SyscallHandler.unsupportedSyscall(code);
    }

    private static class IgnoreUnmappedImportsSettingsListerner
    extends AbstractBoolSettingsListener {
        private IgnoreUnmappedImportsSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            SyscallHandler.setEnableIgnoreUnmappedImports(value);
        }
    }
}

