/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jpcsp.HLE.ITPointerBase;
import jpcsp.HLE.SerializeMemory;
import jpcsp.Memory;

public final class TPointer
implements ITPointerBase {
    private Memory memory;
    private int address;

    public TPointer(Memory memory, int address) {
        this.memory = memory;
        this.address = address & 0x3FFFFFFF;
    }

    @Override
    public boolean isAddressGood() {
        return Memory.isAddressGood(this.address);
    }

    @Override
    public boolean isAlignedTo(int offset) {
        return this.address % offset == 0;
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    public Memory getMemory() {
        return this.memory;
    }

    @Override
    public boolean isNull() {
        return this.address == 0;
    }

    public byte getValue8() {
        return this.getValue8(0);
    }

    public short getValue16() {
        return this.getValue16(0);
    }

    public int getValue32() {
        return this.getValue32(0);
    }

    public long getValue64() {
        return this.getValue64(0);
    }

    public void setValue8(byte value) {
        this.setValue8(0, value);
    }

    public void setValue16(short value) {
        this.setValue16(0, value);
    }

    public void setValue32(int value) {
        this.setValue32(0, value);
    }

    public void setValue64(long value) {
        this.setValue64(0, value);
    }

    public byte getValue8(int offset) {
        return (byte)this.memory.read8(this.address + offset);
    }

    public short getValue16(int offset) {
        return (short)this.memory.read16(this.address + offset);
    }

    public int getValue32(int offset) {
        return this.memory.read32(this.address + offset);
    }

    public long getValue64(int offset) {
        return this.memory.read64(this.address + offset);
    }

    public void setValue8(int offset, byte value) {
        if (this.isAddressGood()) {
            this.memory.write8(this.address + offset, value);
        }
    }

    public void setValue16(int offset, short value) {
        if (this.isAddressGood()) {
            this.memory.write16(this.address + offset, value);
        }
    }

    public void setValue32(int offset, int value) {
        if (this.isAddressGood()) {
            this.memory.write32(this.address + offset, value);
        }
    }

    public void setValue64(int offset, long value) {
        if (this.isAddressGood()) {
            this.memory.write64(this.address + offset, value);
        }
    }

    public void setObject(int offset, Object object) {
        SerializeMemory.serialize(object, new TPointerOutputStream(offset));
    }

    public <T> T getObject(Class<T> objectClass, int offset) {
        return SerializeMemory.unserialize(objectClass, new TPointerInputStream(offset));
    }

    public String toString() {
        return String.format("0x%08X", this.getAddress());
    }

    private class TPointerInputStream
    extends InputStream {
        private int offset = 0;

        public TPointerInputStream(int offset) {
            this.offset = offset;
        }

        @Override
        public int read() throws IOException {
            return TPointer.this.getValue8(this.offset++);
        }
    }

    private class TPointerOutputStream
    extends OutputStream {
        private int offset = 0;

        public TPointerOutputStream(int offset) {
            this.offset = offset;
        }

        @Override
        public void write(int b) throws IOException {
            TPointer.this.setValue8(this.offset++, (byte)b);
        }
    }
}

