/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.emulator;

import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.FileArg;
import jpcsp.HLE.VFS.VirtualFileSystem;
import jpcsp.Memory;
import jpcsp.autotests.AutoTestsOutput;

public class EmulatorVirtualFileSystem
extends VirtualFileSystem {
    @Override
    public int ioDevctl(FileArg fileArg, String deviceName, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        if (!deviceName.equals("emulator:") && !deviceName.equals("kemulator:")) {
            throw new SceKernelErrorException(-2147418093);
        }
        switch (command) {
            case 1: {
                if (!outputPointer.isAddressGood() && outputLength < 4) {
                    return -1;
                }
                outputPointer.setValue32(1);
                return 0;
            }
            case 2: {
                AutoTestsOutput.appendString(new String(Memory.getInstance().readChunk(inputPointer.getAddress(), inputLength).array()));
                return 0;
            }
            case 3: {
                return 0;
            }
        }
        throw new RuntimeException(String.format("Unknown emulator: cmd 0x%08X", command));
    }
}

