/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceKernelVplInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class VplManager {
    public static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelVplInfo> vplMap;
    private VplWaitStateChecker vplWaitStateChecker;
    protected static final int PSP_VPL_ATTR_FIFO = 0;
    protected static final int PSP_VPL_ATTR_PRIORITY = 256;
    protected static final int PSP_VPL_ATTR_PASS = 512;
    public static final int PSP_VPL_ATTR_ADDR_HIGH = 16384;
    public static final int PSP_VPL_ATTR_EXT = 32768;
    public static final int PSP_VPL_ATTR_MASK = 50175;
    public static final VplManager singleton = new VplManager();

    public void reset() {
        this.vplMap = new HashMap();
        this.vplWaitStateChecker = new VplWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelVplInfo fpl = this.vplMap.get(thread.wait.Vpl_id);
        if (fpl != null) {
            --fpl.numWaitThreads;
            if (fpl.numWaitThreads < 0) {
                log.warn((Object)("removing waiting thread " + Integer.toHexString(thread.uid) + ", vpl " + Integer.toHexString(fpl.uid) + " numWaitThreads underflowed"));
                fpl.numWaitThreads = 0;
            }
            return true;
        }
        return false;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352152;
        } else {
            log.warn((Object)"VPL deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(6)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onVplDeletedCancelled(int vid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(6) || thread.wait.Vpl_id != vid) continue;
            thread.cpuContext.gpr[2] = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onVplDeleted(int vid) {
        this.onVplDeletedCancelled(vid, -2147352139);
    }

    private void onVplCancelled(int vid) {
        this.onVplDeletedCancelled(vid, -2147352151);
    }

    private void onVplFree(SceKernelVplInfo info) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        if ((info.attr & 0x100) == 0) {
            Iterator<SceKernelThreadInfo> it = threadMan.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(6) || thread.wait.Vpl_id != info.uid) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onVplFree waking thread %s", thread.toString()));
                }
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        } else if ((info.attr & 0x100) == 256) {
            Iterator<SceKernelThreadInfo> it = threadMan.iteratorByPriority();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(6) || thread.wait.Vpl_id != info.uid) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onVplFree waking thread %s", thread.toString()));
                }
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private int tryAllocateVpl(SceKernelVplInfo info, int size) {
        return info.alloc(size);
    }

    public void sceKernelCreateVpl(int name_addr, int partitionid, int attr, int size, int opt_addr) {
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Processor.memory;
        String name = Utilities.readStringZ(name_addr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCreateVpl(name=%s, partition=%d, attr=0x%X, size=0x%X, opt=0x%08X)", name, partitionid, attr, size, opt_addr));
        }
        if (Memory.isAddressGood(opt_addr)) {
            int optsize = mem.read32(opt_addr);
            log.warn((Object)("sceKernelCreateVpl option at 0x" + Integer.toHexString(opt_addr) + " (size=" + optsize + ")"));
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        if ((attr & 0xFFFF3C00) != 0) {
            log.warn((Object)("sceKernelCreateVpl bad attr value 0x" + Integer.toHexString(attr)));
            cpu.gpr[2] = -2147352175;
        } else if (size <= 0) {
            cpu.gpr[2] = -2147352137;
        } else {
            SceKernelVplInfo info = SceKernelVplInfo.tryCreateVpl(name, partitionid, attr, size, memType);
            if (info != null) {
                log.debug((Object)("sceKernelCreateVpl '" + name + "' assigned uid " + Integer.toHexString(info.uid)));
                this.vplMap.put(info.uid, info);
                cpu.gpr[2] = info.uid;
            } else {
                cpu.gpr[2] = -2147352176;
            }
        }
    }

    public void sceKernelDeleteVpl(int uid) {
        SceKernelVplInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelDeleteVpl(uid=0x" + Integer.toHexString(uid) + ")"));
        }
        if ((info = this.vplMap.remove(uid)) == null) {
            log.warn((Object)("sceKernelDeleteVpl unknown uid=0x" + Integer.toHexString(uid)));
            cpu.gpr[2] = -2147352164;
        } else {
            if (info.freeSize < info.poolSize) {
                log.warn((Object)("sceKernelDeleteVpl approx " + (info.poolSize - info.freeSize) + " unfreed bytes allocated"));
            }
            info.delete();
            cpu.gpr[2] = 0;
            this.onVplDeleted(uid);
        }
    }

    private void hleKernelAllocateVpl(int uid, int size, int data_addr, int timeout_addr, boolean wait, boolean doCallbacks) {
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleKernelAllocateVpl uid=0x" + Integer.toHexString(uid) + " size=0x" + Integer.toHexString(size) + " data_addr=0x" + Integer.toHexString(data_addr) + " timeout_addr=0x" + Integer.toHexString(timeout_addr) + " callbacks=" + doCallbacks));
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-Vpl", true);
        SceKernelVplInfo vpl = this.vplMap.get(uid);
        if (vpl == null) {
            log.warn((Object)("hleKernelAllocateVpl unknown uid=0x" + Integer.toHexString(uid)));
            Emulator.getProcessor().cpu.gpr[2] = -2147352164;
        } else if (size <= 0 || size > vpl.poolSize) {
            cpu.gpr[2] = -2147352137;
        } else {
            int addr = this.tryAllocateVpl(vpl, size);
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            if (addr == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("hleKernelAllocateVpl - '" + vpl.name + "' fast check failed"));
                }
                if (wait) {
                    ++vpl.numWaitThreads;
                    SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
                    currentThread.wait.Vpl_id = uid;
                    currentThread.wait.Vpl_size = size;
                    currentThread.wait.Vpl_dataAddr = data_addr;
                    threadMan.hleKernelThreadEnterWaitState(6, uid, this.vplWaitStateChecker, timeout_addr, doCallbacks);
                } else {
                    cpu.gpr[2] = -2147352153;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleKernelAllocateVpl - '%s' fast check succeeded, allocated addr=0x%08X", vpl.name, addr));
                }
                mem.write32(data_addr, addr);
                cpu.gpr[2] = 0;
            }
        }
    }

    public void sceKernelAllocateVpl(int uid, int size, int data_addr, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelAllocateVpl redirecting to hleKernelAllocateVpl(callbacks=false)");
        }
        this.hleKernelAllocateVpl(uid, size, data_addr, timeout_addr, true, false);
    }

    public void sceKernelAllocateVplCB(int uid, int size, int data_addr, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelAllocateVplCB redirecting to hleKernelAllocateVpl(callbacks=true)");
        }
        this.hleKernelAllocateVpl(uid, size, data_addr, timeout_addr, true, true);
    }

    public void sceKernelTryAllocateVpl(int uid, int size, int data_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelTryAllocateVpl redirecting to hleKernelAllocateVpl");
        }
        this.hleKernelAllocateVpl(uid, size, data_addr, 0, false, false);
    }

    public void sceKernelFreeVpl(int uid, int data_addr) {
        SceKernelVplInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelFreeVpl(uid=0x%x, data=0x%08X)", uid, data_addr));
        }
        if ((info = this.vplMap.get(uid)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelFreeVpl unknown uid=0x%x", uid));
            }
            cpu.gpr[2] = -2147352164;
        } else if (info.free(data_addr)) {
            cpu.gpr[2] = 0;
            this.onVplFree(info);
        } else {
            cpu.gpr[2] = -2147352138;
        }
    }

    public void sceKernelCancelVpl(int uid, int numWaitThreadAddr) {
        SceKernelVplInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCancelVpl(uid=0x" + Integer.toHexString(uid) + ",numWaitThreadAddr=0x" + Integer.toHexString(numWaitThreadAddr) + ")"));
        }
        if ((info = this.vplMap.get(uid)) == null) {
            log.warn((Object)("sceKernelCancelVpl unknown uid=0x" + Integer.toHexString(uid)));
            cpu.gpr[2] = -2147352164;
        } else {
            Memory mem = Memory.getInstance();
            if (Memory.isAddressGood(numWaitThreadAddr)) {
                mem.write32(numWaitThreadAddr, info.numWaitThreads);
            }
            cpu.gpr[2] = 0;
            this.onVplCancelled(uid);
        }
    }

    public void sceKernelReferVplStatus(int uid, int info_addr) {
        SceKernelVplInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Processor.memory;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReferVplStatus(uid=0x" + Integer.toHexString(uid) + ",info=0x" + Integer.toHexString(info_addr) + ")"));
        }
        if ((info = this.vplMap.get(uid)) == null) {
            log.warn((Object)("sceKernelReferVplStatus unknown uid=0x" + Integer.toHexString(uid)));
            cpu.gpr[2] = -2147352164;
        } else {
            info.write(mem, info_addr);
            cpu.gpr[2] = 0;
        }
    }

    private VplManager() {
    }

    private class VplWaitStateChecker
    implements IWaitStateChecker {
        private VplWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelVplInfo vpl = (SceKernelVplInfo)VplManager.this.vplMap.get(wait.Vpl_id);
            if (vpl == null) {
                thread.cpuContext.gpr[2] = -2147352164;
                return false;
            }
            if (VplManager.this.tryAllocateVpl(vpl, wait.Vpl_size) != 0) {
                --vpl.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                return false;
            }
            return true;
        }
    }
}

