/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jpcsp.Memory;

public class ScePspDateTime {
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public int microsecond;

    public ScePspDateTime() {
        Calendar cal = Calendar.getInstance();
        this.year = cal.get(1);
        this.month = 1 + cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.microsecond = cal.get(14) * 1000;
    }

    public ScePspDateTime(int timezone) {
        int minutes;
        Calendar cal = Calendar.getInstance();
        int hours = 0;
        for (minutes = timezone; minutes > 59; minutes -= 60) {
            ++hours;
        }
        String timeString = String.format("UTC+%02d%02d", hours, minutes);
        TimeZone tz = TimeZone.getTimeZone(timeString);
        cal.setTimeZone(tz);
        this.year = cal.get(1);
        this.month = 1 + cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.microsecond = cal.get(14) * 1000;
    }

    public ScePspDateTime(int year, int month, int day, int hour, int minute, int second, int microsecond) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microsecond = microsecond;
    }

    public static ScePspDateTime fromMSDOSTime(long time) {
        long milliseconds = time / 10000L;
        long days = milliseconds / 86400000L;
        long hours = (milliseconds -= days * 86400000L) / 3600000L;
        long minutes = (milliseconds -= hours * 3600000L) / 60000L;
        long seconds = (milliseconds -= minutes * 60000L) / 1000L;
        milliseconds -= seconds * 1000L;
        Calendar cal = Calendar.getInstance();
        cal.set(1980, 0, 1, 0, 0, 0);
        cal.add(5, (int)days);
        cal.add(11, (int)hours);
        cal.add(12, (int)minutes);
        cal.add(13, (int)seconds);
        cal.add(14, (int)milliseconds);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = cal.get(14) * 1000;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public static ScePspDateTime fromFILETIMETime(long time) {
        long milliseconds = time / 10000L;
        long days = milliseconds / 86400000L;
        long hours = (milliseconds -= days * 86400000L) / 3600000L;
        long minutes = (milliseconds -= hours * 3600000L) / 60000L;
        long seconds = (milliseconds -= minutes * 60000L) / 1000L;
        milliseconds -= seconds * 1000L;
        Calendar cal = Calendar.getInstance();
        cal.set(1601, 0, 1, 0, 0, 0);
        cal.add(5, (int)days);
        cal.add(11, (int)hours);
        cal.add(12, (int)minutes);
        cal.add(13, (int)seconds);
        cal.add(14, (int)milliseconds);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = cal.get(14) * 1000;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public static ScePspDateTime fromUnixTime(long time) {
        Calendar cal = Calendar.getInstance();
        Date date = new Date(time);
        cal.setTime(date);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = cal.get(14) * 1000;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public static ScePspDateTime fromMicros(long micros) {
        Calendar cal = Calendar.getInstance();
        Date date = new Date(micros / 1000L);
        cal.setTime(date);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = (int)(micros % 1000000L);
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public void read(Memory mem, int address) {
        this.year = mem.read16(address);
        this.month = mem.read16(address + 2);
        this.day = mem.read16(address + 4);
        this.hour = mem.read16(address + 6);
        this.minute = mem.read16(address + 8);
        this.second = mem.read16(address + 10);
        this.microsecond = mem.read32(address + 12);
    }

    public void write(Memory mem, int address) {
        mem.write16(address, (short)(this.year & 0xFFFF));
        mem.write16(address + 2, (short)(this.month & 0xFFFF));
        mem.write16(address + 4, (short)(this.day & 0xFFFF));
        mem.write16(address + 6, (short)(this.hour & 0xFFFF));
        mem.write16(address + 8, (short)(this.minute & 0xFFFF));
        mem.write16(address + 10, (short)(this.second & 0xFFFF));
        mem.write32(address + 12, this.microsecond);
    }

    public static int sizeof() {
        return 16;
    }

    public String toString() {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d", this.year, this.month, this.day, this.hour, this.minute, this.second);
    }
}

