/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;

public class pspFontStyle
extends pspAbstractMemoryMappedStructure {
    public static final int FONT_FAMILY_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_STYLE_REGULAR = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD = 5;
    public static final int FONT_STYLE_BOLD_ITALIC = 6;
    public static final int FONT_STYLE_DB = 103;
    public static final int FONT_LANGUAGE_JAPANESE = 1;
    public static final int FONT_LANGUAGE_LATIN = 2;
    public static final int FONT_LANGUAGE_KOREAN = 3;
    public float fontH;
    public float fontV;
    public float fontHRes;
    public float fontVRes;
    public float fontWeight;
    public short fontFamily;
    public short fontStyle;
    public short fontStyleSub;
    public short fontLanguage;
    public short fontRegion;
    public short fontCountry;
    public String fontName;
    public String fontFileName;
    public int fontAttributes;
    public int fontExpire;

    @Override
    protected void read() {
        this.fontH = this.readFloat();
        this.fontV = this.readFloat();
        this.fontHRes = this.readFloat();
        this.fontVRes = this.readFloat();
        this.fontWeight = this.readFloat();
        this.fontFamily = (short)this.read16();
        this.fontStyle = (short)this.read16();
        this.fontStyleSub = (short)this.read16();
        this.fontLanguage = (short)this.read16();
        this.fontRegion = (short)this.read16();
        this.fontCountry = (short)this.read16();
        this.fontName = this.readStringNZ(64);
        this.fontFileName = this.readStringNZ(64);
        this.fontAttributes = this.read32();
        this.fontExpire = this.read32();
    }

    @Override
    protected void write() {
        this.writeFloat(this.fontH);
        this.writeFloat(this.fontV);
        this.writeFloat(this.fontHRes);
        this.writeFloat(this.fontVRes);
        this.writeFloat(this.fontWeight);
        this.write16(this.fontFamily);
        this.write16(this.fontStyle);
        this.write16(this.fontStyleSub);
        this.write16(this.fontLanguage);
        this.write16(this.fontRegion);
        this.write16(this.fontCountry);
        this.writeStringNZ(64, this.fontName);
        this.writeStringNZ(64, this.fontFileName);
        this.write32(this.fontAttributes);
        this.write32(this.fontExpire);
    }

    @Override
    public int sizeof() {
        return 168;
    }

    public boolean isMatching(pspFontStyle fontStyle) {
        if (fontStyle.fontH != 0.0f && Math.round(fontStyle.fontH) != Math.round(this.fontH)) {
            return false;
        }
        if (fontStyle.fontV != 0.0f && Math.round(fontStyle.fontV) != Math.round(this.fontV)) {
            return false;
        }
        if (fontStyle.fontHRes != 0.0f && Math.round(fontStyle.fontHRes) != Math.round(this.fontHRes)) {
            return false;
        }
        if (fontStyle.fontVRes != 0.0f && Math.round(fontStyle.fontVRes) != Math.round(this.fontVRes)) {
            return false;
        }
        if (fontStyle.fontWeight != this.fontWeight) {
            return false;
        }
        if (fontStyle.fontFamily != 0 && fontStyle.fontFamily != this.fontFamily) {
            return false;
        }
        if (fontStyle.fontStyle != 0 && fontStyle.fontStyle != this.fontStyle) {
            return false;
        }
        if (fontStyle.fontStyleSub != 0 && fontStyle.fontStyleSub != this.fontStyleSub) {
            return false;
        }
        if (fontStyle.fontLanguage != 0 && fontStyle.fontLanguage != this.fontLanguage) {
            return false;
        }
        if (fontStyle.fontRegion != 0 && fontStyle.fontRegion != this.fontRegion) {
            return false;
        }
        if (fontStyle.fontCountry != 0 && fontStyle.fontCountry != this.fontCountry) {
            return false;
        }
        if (fontStyle.fontName.length() > 0 && !fontStyle.fontName.equals(this.fontName)) {
            return false;
        }
        if (fontStyle.fontFileName.length() > 0 && !fontStyle.fontFileName.equals(this.fontFileName)) {
            return false;
        }
        return fontStyle.fontAttributes == 0 || fontStyle.fontAttributes == this.fontAttributes;
    }

    public String toString() {
        return String.format("fontH %f, fontV %f, fontHRes %f, fontVRes %f, fontWeight %f, fontFamily %d, fontStyle %d, fontStyleSub %d, fontLanguage %d, fontRegion %d, fontCountry %d, fontName '%s', fontFileName '%s', fontAttributes %d, fontExpire %d", Float.valueOf(this.fontH), Float.valueOf(this.fontV), Float.valueOf(this.fontHRes), Float.valueOf(this.fontVRes), Float.valueOf(this.fontWeight), this.fontFamily, this.fontStyle, this.fontStyleSub, this.fontLanguage, this.fontRegion, this.fontCountry, this.fontName, this.fontFileName, this.fontAttributes, this.fontExpire);
    }
}

