/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.hardware.Screen;
import org.apache.log4j.Logger;

public class sceSuspendForUser
extends HLEModule {
    private static Logger log = Modules.getLogger("sceSuspendForUser");
    public static final int KERNEL_POWER_TICK_SUSPEND_AND_DISPLAY = 0;
    public static final int KERNEL_POWER_TICK_SUSPEND = 1;
    public static final int KERNEL_POWER_TICK_DISPLAY = 6;
    private boolean volatileMemLocked;

    @Override
    public String getName() {
        return "sceSuspendForUser";
    }

    @Override
    public void start() {
        this.volatileMemLocked = false;
        super.start();
    }

    @HLEFunction(nid=-354739241, version=150, checkInsideInterrupt=true)
    public int sceKernelPowerLock(int type) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("IGNORING:sceKernelPowerLock type=%d", type));
        }
        return 0;
    }

    @HLEFunction(nid=988705377, version=150, checkInsideInterrupt=true)
    public int sceKernelPowerUnlock(int type) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("IGNORING:sceKernelPowerUnlock type=%d", type));
        }
        return 0;
    }

    @HLEFunction(nid=151833407, version=150, checkInsideInterrupt=true)
    public int sceKernelPowerTick(int flag) {
        if ((flag & 1) == 1 && log.isTraceEnabled()) {
            log.trace((Object)"IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_SUSPEND)");
        }
        if ((flag & 6) == 6) {
            Screen.hleKernelPowerTick();
            if (log.isTraceEnabled()) {
                log.trace((Object)"IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_DISPLAY)");
            }
        }
        if (flag == 0) {
            Screen.hleKernelPowerTick();
            if (log.isTraceEnabled()) {
                log.trace((Object)"IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_SUSPEND_AND_DISPLAY)");
            }
        }
        return 0;
    }

    protected int hleKernelVolatileMemLock(int type, TPointer32 paddr, TPointer32 psize, boolean trylock) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelVolatileMemLock type=%d, paddr=%s, psize=%s, trylock=%b", type, paddr, psize, trylock));
        }
        if (type != 0) {
            log.warn((Object)"hleKernelVolatileMemLock bad param: type != 0");
            return -2147483137;
        }
        if (this.volatileMemLocked) {
            log.warn((Object)"hleKernelVolatileMemLock already locked");
            return trylock ? -2144665088 : -1;
        }
        this.volatileMemLocked = true;
        if (!paddr.isNull()) {
            paddr.setValue(0x8400000);
        }
        if (!psize.isNull()) {
            psize.setValue(0x400000);
        }
        return 0;
    }

    @HLEFunction(nid=1040347603, version=150, checkInsideInterrupt=true)
    public int sceKernelVolatileMemLock(int type, @CanBeNull TPointer32 paddr, @CanBeNull TPointer32 psize) {
        return this.hleKernelVolatileMemLock(type, paddr, psize, false);
    }

    @HLEFunction(nid=-1588641614, version=150)
    public int sceKernelVolatileMemTryLock(int type, @CanBeNull TPointer32 paddr, @CanBeNull TPointer32 psize) {
        return this.hleKernelVolatileMemLock(type, paddr, psize, true);
    }

    @HLEFunction(nid=-1519786971, version=150)
    public int sceKernelVolatileMemUnlock(int type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelVolatileMemUnlock type=%d", type));
        }
        if (type != 0) {
            log.warn((Object)"sceKernelVolatileMemUnlock bad param: type != 0");
            return -2147483137;
        }
        if (!this.volatileMemLocked) {
            log.warn((Object)"sceKernelVolatileMemUnlock - Volatile Memory was not locked!");
            return -1;
        }
        this.volatileMemLocked = false;
        return 0;
    }
}

