/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import jpcsp.Allegrex.CpuState;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.kernel.types.SceUtilityGameSharingParams;
import jpcsp.HLE.kernel.types.SceUtilityGamedataInstallParams;
import jpcsp.HLE.kernel.types.SceUtilityHtmlViewerParams;
import jpcsp.HLE.kernel.types.SceUtilityMsgDialogParams;
import jpcsp.HLE.kernel.types.SceUtilityNetconfParams;
import jpcsp.HLE.kernel.types.SceUtilityNpSigninParams;
import jpcsp.HLE.kernel.types.SceUtilityOskParams;
import jpcsp.HLE.kernel.types.SceUtilitySavedataParam;
import jpcsp.HLE.kernel.types.SceUtilityScreenshotParams;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.Resource;
import jpcsp.State;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.format.PSF;
import jpcsp.hardware.MemoryStick;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceUtility
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceUtility");
    public static final String SYSTEMPARAM_SETTINGS_OPTION_NICKNAME = "emu.sysparam.nickname";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL = "emu.sysparam.adhocchannel";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE = "emu.sysparam.wlanpowersave";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_DATE_FORMAT = "emu.sysparam.dateformat";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_TIME_FORMAT = "emu.sysparam.timeformat";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_TIME_ZONE = "emu.sysparam.timezone";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_DAYLIGHT_SAVING_TIME = "emu.sysparam.daylightsavings";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_LANGUAGE = "emu.impose.language";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_BUTTON_PREFERENCE = "emu.impose.button";
    public static final int PSP_SYSTEMPARAM_ID_STRING_NICKNAME = 1;
    public static final int PSP_SYSTEMPARAM_ID_INT_ADHOC_CHANNEL = 2;
    public static final int PSP_SYSTEMPARAM_ID_INT_WLAN_POWERSAVE = 3;
    public static final int PSP_SYSTEMPARAM_ID_INT_DATE_FORMAT = 4;
    public static final int PSP_SYSTEMPARAM_ID_INT_TIME_FORMAT = 5;
    public static final int PSP_SYSTEMPARAM_ID_INT_TIMEZONE = 6;
    public static final int PSP_SYSTEMPARAM_ID_INT_DAYLIGHTSAVINGS = 7;
    public static final int PSP_SYSTEMPARAM_ID_INT_LANGUAGE = 8;
    public static final int PSP_SYSTEMPARAM_ID_INT_BUTTON_PREFERENCE = 9;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_JAPANESE = 0;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_ENGLISH = 1;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_FRENCH = 2;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_SPANISH = 3;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_GERMAN = 4;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_ITALIAN = 5;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_DUTCH = 6;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_PORTUGUESE = 7;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_RUSSIAN = 8;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_KOREAN = 9;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_CHINESE_TRADITIONAL = 10;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_CHINESE_SIMPLIFIED = 11;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_YYYYMMDD = 0;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_MMDDYYYY = 1;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_DDMMYYYY = 2;
    public static final int PSP_SYSTEMPARAM_TIME_FORMAT_24HR = 0;
    public static final int PSP_SYSTEMPARAM_TIME_FORMAT_12HR = 1;
    public static final int PSP_SYSTEMPARAM_BUTTON_CIRCLE = 0;
    public static final int PSP_SYSTEMPARAM_BUTTON_CROSS = 1;
    public static final int PSP_UTILITY_DIALOG_STATUS_NONE = 0;
    public static final int PSP_UTILITY_DIALOG_STATUS_INIT = 1;
    public static final int PSP_UTILITY_DIALOG_STATUS_VISIBLE = 2;
    public static final int PSP_UTILITY_DIALOG_STATUS_QUIT = 3;
    public static final int PSP_UTILITY_DIALOG_STATUS_FINISHED = 4;
    public static final int PSP_UTILITY_DIALOG_RESULT_OK = 0;
    public static final int PSP_UTILITY_DIALOG_RESULT_CANCELED = 1;
    public static final int PSP_UTILITY_DIALOG_RESULT_ABORTED = 2;
    public static final int PSP_NETPARAM_NAME = 0;
    public static final int PSP_NETPARAM_SSID = 1;
    public static final int PSP_NETPARAM_SECURE = 2;
    public static final int PSP_NETPARAM_WEPKEY = 3;
    public static final int PSP_NETPARAM_IS_STATIC_IP = 4;
    public static final int PSP_NETPARAM_IP = 5;
    public static final int PSP_NETPARAM_NETMASK = 6;
    public static final int PSP_NETPARAM_ROUTE = 7;
    public static final int PSP_NETPARAM_MANUAL_DNS = 8;
    public static final int PSP_NETPARAM_PRIMARYDNS = 9;
    public static final int PSP_NETPARAM_SECONDARYDNS = 10;
    public static final int PSP_NETPARAM_PROXY_USER = 11;
    public static final int PSP_NETPARAM_PROXY_PASS = 12;
    public static final int PSP_NETPARAM_USE_PROXY = 13;
    public static final int PSP_NETPARAM_PROXY_SERVER = 14;
    public static final int PSP_NETPARAM_PROXY_PORT = 15;
    public static final int PSP_NETPARAM_UNKNOWN1 = 16;
    public static final int PSP_NETPARAM_UNKNOWN2 = 17;
    protected static final int maxLineLengthForDialog = 80;
    protected static final int[] fontHeightSavedataList = new int[]{12, 12, 12, 12, 12, 12, 9, 8, 7, 6};
    protected GameSharingUtilityDialogState gameSharingState;
    protected UtilityDialogState netplayDialogState;
    protected NetconfUtilityDialogState netconfState;
    protected SavedataUtilityDialogState savedataState;
    protected MsgDialogUtilityDialogState msgDialogState;
    protected OskUtilityDialogState oskState;
    protected UtilityDialogState npSigninState;
    protected UtilityDialogState PS3ScanState;
    protected UtilityDialogState rssReaderState;
    protected UtilityDialogState rssSubscriberState;
    protected ScreenshotUtilityDialogState screenshotState;
    protected HtmlViewerUtilityDialogState htmlViewerState;
    protected UtilityDialogState savedataErrState;
    protected GamedataInstallUtilityDialogState gamedataInstallState;
    private static final String dummyNetParamName = "NetConf #%d";
    private static final int numberNetConfigurations = 1;

    @Override
    public String getName() {
        return "sceUtility";
    }

    @Override
    public void start() {
        this.gameSharingState = new GameSharingUtilityDialogState("sceUtilityGameSharing");
        this.netplayDialogState = new NotImplementedUtilityDialogState("sceNetplayDialog");
        this.netconfState = new NetconfUtilityDialogState("sceUtilityNetconf");
        this.savedataState = new SavedataUtilityDialogState("sceUtilitySavedata");
        this.msgDialogState = new MsgDialogUtilityDialogState("sceUtilityMsgDialog");
        this.oskState = new OskUtilityDialogState("sceUtilityOsk");
        this.npSigninState = new NpSigninUtilityDialogState("sceUtilityNpSignin");
        this.PS3ScanState = new NotImplementedUtilityDialogState("sceUtilityPS3Scan");
        this.rssReaderState = new NotImplementedUtilityDialogState("sceUtilityRssReader");
        this.rssSubscriberState = new NotImplementedUtilityDialogState("sceUtilityRssSubscriber");
        this.screenshotState = new ScreenshotUtilityDialogState("sceUtilityScreenshot");
        this.htmlViewerState = new HtmlViewerUtilityDialogState("sceUtilityHtmlViewer");
        this.savedataErrState = new NotImplementedUtilityDialogState("sceUtilitySavedataErr");
        this.gamedataInstallState = new GamedataInstallUtilityDialogState("sceUtilityGamedataInstall");
        super.start();
    }

    public static String getSystemParamNickname() {
        return Settings.getInstance().readString(SYSTEMPARAM_SETTINGS_OPTION_NICKNAME);
    }

    public static int getSystemParamAdhocChannel() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL, 0);
    }

    public static int getSystemParamWlanPowersave() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE, 0);
    }

    public static int getSystemParamDateFormat() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_DATE_FORMAT, 0);
    }

    public static int getSystemParamTimeFormat() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_TIME_FORMAT, 0);
    }

    public static int getSystemParamTimeZone() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_TIME_ZONE, 0);
    }

    public static int getSystemParamDaylightSavingTime() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_DAYLIGHT_SAVING_TIME, 0);
    }

    public static int getSystemParamLanguage() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_LANGUAGE, 1);
    }

    public static int getSystemParamButtonPreference() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_BUTTON_PREFERENCE, 1);
    }

    protected static String getNetParamName(int id) {
        if (id == 0) {
            return "";
        }
        return String.format(dummyNetParamName, id);
    }

    protected static String formatMessageForDialog(String message) {
        StringBuilder formattedMessage = new StringBuilder();
        int i = 0;
        while (i < message.length()) {
            String rest = message.substring(i);
            int newLineIndex = rest.indexOf("\n");
            if (newLineIndex >= 0 && newLineIndex < 80) {
                formattedMessage.append(rest.substring(0, newLineIndex + 1));
                i += newLineIndex + 1;
                continue;
            }
            if (rest.length() > 80) {
                int lastSpace = rest.lastIndexOf(32, 80);
                rest = rest.substring(0, lastSpace >= 0 ? lastSpace : 80);
                formattedMessage.append(rest);
                i += rest.length() + 1;
                formattedMessage.append("\n");
                continue;
            }
            formattedMessage.append(rest);
            i += rest.length();
        }
        return formattedMessage.toString();
    }

    private static int count(String s, String find) {
        int count = 0;
        int i = 0;
        while ((i = s.indexOf(find, i)) >= 0) {
            ++count;
            i += find.length();
        }
        return count;
    }

    private static int computeMemoryStickRequiredSpaceKb(int sizeByte) {
        int sizeKb = Utilities.getSizeKb(sizeByte);
        int sectorSizeKb = MemoryStick.getSectorSizeKb();
        int numberSectors = (sizeKb + sectorSizeKb - 1) / sectorSizeKb;
        return numberSectors * sectorSizeKb;
    }

    @HLEFunction(nid=-997001391, version=150)
    public void sceUtilityGameSharingInitStart(Processor processor) {
        this.gameSharingState.executeInitStart(processor);
    }

    @HLEFunction(nid=-272173041, version=150)
    public void sceUtilityGameSharingShutdownStart(Processor processor) {
        this.gameSharingState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=2018711597, version=150)
    public void sceUtilityGameSharingUpdate(Processor processor) {
        this.gameSharingState.executeUpdate(processor);
    }

    @HLEFunction(nid=-1805032461, version=150)
    public void sceUtilityGameSharingGetStatus(Processor processor) {
        this.gameSharingState.executeGetStatus(processor);
    }

    @HLEFunction(nid=987040487, version=150)
    public void sceNetplayDialogInitStart(Processor processor) {
        this.netplayDialogState.executeInitStart(processor);
    }

    @HLEFunction(nid=-1133813098, version=150)
    public void sceNetplayDialogShutdownStart(Processor processor) {
        this.netplayDialogState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=1098640724, version=150)
    public void sceNetplayDialogUpdate(Processor processor) {
        this.netplayDialogState.executeUpdate(processor);
    }

    @HLEFunction(nid=-1227954793, version=150)
    public void sceNetplayDialogGetStatus(Processor processor) {
        this.netplayDialogState.executeGetStatus(processor);
    }

    @HLEFunction(nid=1303504697, version=150)
    public void sceUtilityNetconfInitStart(Processor processor) {
        this.netconfState.executeInitStart(processor);
    }

    @HLEFunction(nid=-125741578, version=150)
    public void sceUtilityNetconfShutdownStart(Processor processor) {
        this.netconfState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-1847128523, version=150)
    public void sceUtilityNetconfUpdate(Processor processor) {
        this.netconfState.executeUpdate(processor);
    }

    @HLEFunction(nid=1664264761, version=150)
    public void sceUtilityNetconfGetStatus(Processor processor) {
        this.netconfState.executeGetStatus(processor);
    }

    @HLEFunction(nid=1355074903, version=150)
    public void sceUtilitySavedataInitStart(Processor processor) {
        this.savedataState.executeInitStart(processor);
    }

    @HLEFunction(nid=-1752124612, version=150)
    public void sceUtilitySavedataShutdownStart(Processor processor) {
        this.savedataState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-726048773, version=150)
    public void sceUtilitySavedataUpdate(Processor processor) {
        this.savedataState.executeUpdate(processor);
    }

    @HLEFunction(nid=-2005607456, version=150)
    public void sceUtilitySavedataGetStatus(Processor processor) {
        this.savedataState.executeGetStatus(processor);
    }

    @HLEFunction(nid=697684000, version=150)
    public void sceUtilitySavedataErrInitStart(Processor processor) {
        this.savedataErrState.executeInitStart(processor);
    }

    @HLEFunction(nid=-1238744991, version=150)
    public void sceUtilitySavedataErrShutdownStart(Processor processor) {
        this.savedataErrState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-317739720, version=150)
    public void sceUtilitySavedataErrUpdate(Processor processor) {
        this.savedataErrState.executeUpdate(processor);
    }

    @HLEFunction(nid=-2000915450, version=150)
    public void sceUtilitySavedataErrGetStatus(Processor processor) {
        this.savedataErrState.executeGetStatus(processor);
    }

    @HLEFunction(nid=718856761, version=150)
    public void sceUtilityMsgDialogInitStart(Processor processor) {
        this.msgDialogState.executeInitStart(processor);
    }

    @HLEFunction(nid=1739535400, version=150)
    public void sceUtilityMsgDialogShutdownStart(Processor processor) {
        this.msgDialogState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-1778637509, version=150)
    public void sceUtilityMsgDialogUpdate(Processor processor) {
        this.msgDialogState.executeUpdate(processor);
    }

    @HLEFunction(nid=-1709403689, version=150)
    public void sceUtilityMsgDialogGetStatus(Processor processor) {
        this.msgDialogState.executeGetStatus(processor);
    }

    @HLEFunction(nid=-165241982, version=150)
    public void sceUtilityOskInitStart(Processor processor) {
        this.oskState.executeInitStart(processor);
    }

    @HLEFunction(nid=1039854505, version=150)
    public void sceUtilityOskShutdownStart(Processor processor) {
        this.oskState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=1267058785, version=150)
    public void sceUtilityOskUpdate(Processor processor) {
        this.oskState.executeUpdate(processor);
    }

    @HLEFunction(nid=-201891817, version=150)
    public void sceUtilityOskGetStatus(Processor processor) {
        this.oskState.executeGetStatus(processor);
    }

    @HLEFunction(nid=382741232, version=150)
    public void sceUtilityNpSigninInitStart(Processor processor) {
        this.npSigninState.executeInitStart(processor);
    }

    @HLEFunction(nid=-509831210, version=150)
    public void sceUtilityNpSigninShutdownStart(Processor processor) {
        this.npSigninState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-201603726, version=150)
    public void sceUtilityNpSigninUpdate(Processor processor) {
        this.npSigninState.executeUpdate(processor);
    }

    @HLEFunction(nid=-2035557605, version=150)
    public void sceUtilityNpSigninGetStatus(Processor processor) {
        this.npSigninState.executeGetStatus(processor);
    }

    @HLEFunction(nid=1107761795, version=150)
    public void sceUtilityPS3ScanInitStart(Processor processor) {
        this.PS3ScanState.executeInitStart(processor);
    }

    @HLEFunction(nid=-780532365, version=150)
    public void sceUtilityPS3ScanShutdownStart(Processor processor) {
        this.PS3ScanState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-665662002, version=150)
    public void sceUtilityPS3ScanUpdate(Processor processor) {
        this.PS3ScanState.executeUpdate(processor);
    }

    @HLEFunction(nid=-1993245553, version=150)
    public void sceUtilityPS3ScanGetStatus(Processor processor) {
        this.PS3ScanState.executeGetStatus(processor);
    }

    @HLEFunction(nid=-2117843194, version=150)
    public void sceUtilityRssReaderInitStart(Processor processor) {
        this.rssReaderState.executeInitStart(processor);
    }

    @HLEFunction(nid=-1325694987, version=150)
    public void sceUtilityRssReaderContStart(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented: sceUtilityRssReaderContStart");
        cpu.gpr[2] = -2146369533;
    }

    @HLEFunction(nid=-407406376, version=150)
    public void sceUtilityRssReaderShutdownStart(Processor processor) {
        this.rssReaderState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=1867971023, version=150)
    public void sceUtilityRssReaderUpdate(Processor processor) {
        this.rssReaderState.executeUpdate(processor);
    }

    @HLEFunction(nid=-2094617851, version=150)
    public void sceUtilityRssReaderGetStatus(Processor processor) {
        this.rssReaderState.executeGetStatus(processor);
    }

    @HLEFunction(nid=1258983397, version=150)
    public void sceUtilityRssSubscriberInitStart(Processor processor) {
        this.rssSubscriberState.executeInitStart(processor);
    }

    @HLEFunction(nid=111445593, version=150)
    public void sceUtilityRssSubscriberShutdownStart(Processor processor) {
        this.rssSubscriberState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-1601904554, version=150)
    public void sceUtilityRssSubscriberUpdate(Processor processor) {
        this.rssSubscriberState.executeUpdate(processor);
    }

    @HLEFunction(nid=731256635, version=150)
    public void sceUtilityRssSubscriberGetStatus(Processor processor) {
        this.rssSubscriberState.executeGetStatus(processor);
    }

    @HLEFunction(nid=38908212, version=150)
    public void sceUtilityScreenshotInitStart(Processor processor) {
        this.screenshotState.executeInitStart(processor);
    }

    @HLEFunction(nid=-2036319705, version=150)
    public void sceUtilityScreenshotContStart(Processor processor) {
        this.screenshotState.executeContStart(processor);
    }

    @HLEFunction(nid=-102760308, version=150)
    public void sceUtilityScreenshotShutdownStart(Processor processor) {
        this.screenshotState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=-1425523031, version=150)
    public void sceUtilityScreenshotUpdate(Processor processor) {
        this.screenshotState.executeUpdate(processor);
    }

    @HLEFunction(nid=-669427785, version=150)
    public void sceUtilityScreenshotGetStatus(Processor processor) {
        this.screenshotState.executeGetStatus(processor);
    }

    @HLEFunction(nid=-842814911, version=150)
    public void sceUtilityHtmlViewerInitStart(Processor processor) {
        this.htmlViewerState.executeInitStart(processor);
    }

    @HLEFunction(nid=-171044556, version=150)
    public void sceUtilityHtmlViewerShutdownStart(Processor processor) {
        this.htmlViewerState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=95402468, version=150)
    public void sceUtilityHtmlViewerUpdate(Processor processor) {
        this.htmlViewerState.executeUpdate(processor);
    }

    @HLEFunction(nid=-1113073516, version=150)
    public void sceUtilityHtmlViewerGetStatus(Processor processor) {
        this.htmlViewerState.executeGetStatus(processor);
    }

    @HLEFunction(nid=615264747, version=150)
    public void sceUtilityGamedataInstallInitStart(Processor processor) {
        this.gamedataInstallState.executeInitStart(processor);
    }

    @HLEFunction(nid=853749195, version=150)
    public void sceUtilityGamedataInstallShutdownStart(Processor processor) {
        this.gamedataInstallState.executeShutdownStart(processor);
    }

    @HLEFunction(nid=1257034105, version=150)
    public void sceUtilityGamedataInstallUpdate(Processor processor) {
        this.gamedataInstallState.executeUpdate(processor);
    }

    @HLEFunction(nid=-1249995303, version=150)
    public void sceUtilityGamedataInstallGetStatus(Processor processor) {
        this.gamedataInstallState.executeGetStatus(processor);
    }

    @HLEFunction(nid=1170310406, version=150)
    public void sceUtilitySetSystemParamInt(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int id = cpu.gpr[4];
        int value_addr = cpu.gpr[5];
        if (!Memory.isAddressGood(value_addr)) {
            log.warn((Object)("sceUtilitySetSystemParamInt(id=" + id + ",value=0x" + Integer.toHexString(value_addr) + ") bad address"));
            cpu.gpr[2] = -1;
        } else {
            log.debug((Object)("sceUtilitySetSystemParamInt(id=" + id + ",value=0x" + Integer.toHexString(value_addr) + ")"));
            cpu.gpr[2] = 0;
            switch (id) {
                case 2: {
                    Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL, mem.read32(value_addr));
                    break;
                }
                case 3: {
                    Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE, mem.read32(value_addr));
                    break;
                }
                case 4: {
                    Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_DATE_FORMAT, mem.read32(value_addr));
                    break;
                }
                case 5: {
                    Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_TIME_FORMAT, mem.read32(value_addr));
                    break;
                }
                case 6: {
                    Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_TIME_ZONE, mem.read32(value_addr));
                    break;
                }
                case 7: {
                    Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_DAYLIGHT_SAVING_TIME, mem.read32(value_addr));
                    break;
                }
                case 8: {
                    Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_LANGUAGE, mem.read32(value_addr));
                    break;
                }
                case 9: {
                    Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_BUTTON_PREFERENCE, mem.read32(value_addr));
                    break;
                }
                default: {
                    log.warn((Object)("UNIMPLEMENTED: sceUtilitySetSystemParamInt(id=" + id + ",value=0x" + Integer.toHexString(value_addr) + ") unhandled id"));
                    cpu.gpr[2] = -1;
                }
            }
        }
    }

    @HLEFunction(nid=1105397364, version=150)
    public void sceUtilitySetSystemParamString(Processor processor) {
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        int str_addr = cpu.gpr[5];
        if (!Memory.isAddressGood(str_addr)) {
            log.warn((Object)("sceUtilitySetSystemParamString(id=" + id + ",str=0x" + Integer.toHexString(str_addr) + ") bad address"));
            cpu.gpr[2] = -1;
        } else {
            log.debug((Object)("sceUtilitySetSystemParamString(id=" + id + ",str=0x" + Integer.toHexString(str_addr) + ")"));
            cpu.gpr[2] = 0;
            switch (id) {
                case 1: {
                    Settings.getInstance().writeString(SYSTEMPARAM_SETTINGS_OPTION_NICKNAME, Utilities.readStringZ(str_addr));
                    break;
                }
                default: {
                    log.warn((Object)("UNIMPLEMENTED: sceUtilitySetSystemParamString(id=" + id + ",str=0x" + Integer.toHexString(str_addr) + ") unhandled id"));
                    cpu.gpr[2] = -1;
                }
            }
        }
    }

    @HLEFunction(nid=-1512430586, version=150)
    public void sceUtilityGetSystemParamInt(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int id = cpu.gpr[4];
        int value_addr = cpu.gpr[5];
        if (!Memory.isAddressGood(value_addr)) {
            log.warn((Object)("sceUtilityGetSystemParamInt(id=" + id + ",value=0x" + Integer.toHexString(value_addr) + ") bad address"));
            cpu.gpr[2] = -1;
        } else {
            log.debug((Object)("sceUtilityGetSystemParamInt(id=" + id + ",value=0x" + Integer.toHexString(value_addr) + ")"));
            cpu.gpr[2] = 0;
            switch (id) {
                case 2: {
                    mem.write32(value_addr, sceUtility.getSystemParamAdhocChannel());
                    break;
                }
                case 3: {
                    mem.write32(value_addr, sceUtility.getSystemParamWlanPowersave());
                    break;
                }
                case 4: {
                    mem.write32(value_addr, sceUtility.getSystemParamDateFormat());
                    break;
                }
                case 5: {
                    mem.write32(value_addr, sceUtility.getSystemParamTimeFormat());
                    break;
                }
                case 6: {
                    mem.write32(value_addr, sceUtility.getSystemParamTimeZone());
                    break;
                }
                case 7: {
                    mem.write32(value_addr, sceUtility.getSystemParamDaylightSavingTime());
                    break;
                }
                case 8: {
                    mem.write32(value_addr, sceUtility.getSystemParamLanguage());
                    break;
                }
                case 9: {
                    mem.write32(value_addr, sceUtility.getSystemParamLanguage());
                    break;
                }
                default: {
                    log.warn((Object)("UNIMPLEMENTED: sceUtilityGetSystemParamInt(id=" + id + ",value=0x" + Integer.toHexString(value_addr) + ") unhandled id"));
                    cpu.gpr[2] = -1;
                }
            }
        }
    }

    @HLEFunction(nid=884441923, version=150)
    public void sceUtilityGetSystemParamString(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int id = cpu.gpr[4];
        int str_addr = cpu.gpr[5];
        int len = cpu.gpr[6];
        if (!Memory.isAddressGood(str_addr)) {
            log.warn((Object)("sceUtilityGetSystemParamString(id=" + id + ",str=0x" + Integer.toHexString(str_addr) + ",len=" + len + ") bad address"));
            cpu.gpr[2] = -1;
        } else {
            log.debug((Object)("sceUtilityGetSystemParamString(id=" + id + ",str=0x" + Integer.toHexString(str_addr) + ",len=" + len + ")"));
            cpu.gpr[2] = 0;
            switch (id) {
                case 1: {
                    Utilities.writeStringNZ(mem, str_addr, len, sceUtility.getSystemParamNickname());
                    break;
                }
                default: {
                    log.warn((Object)("UNIMPLEMENTED:sceUtilityGetSystemParamString(id=" + id + ",str=0x" + Integer.toHexString(str_addr) + ",len=" + len + ") unhandled id"));
                    cpu.gpr[2] = -1;
                }
            }
        }
    }

    @HLEFunction(nid=1592681800, version=150)
    public void sceUtilityCheckNetParam(Processor processor) {
        boolean available;
        CpuState cpu = processor.cpu;
        int id = cpu.gpr[4];
        boolean bl = available = id >= 0 && id <= 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUtilityCheckNetParam(id=%d) available %b", id, available));
        }
        cpu.gpr[2] = available ? 0 : -2146367999;
    }

    @HLEFunction(nid=1129139002, version=150)
    public void sceUtilityGetNetParam(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int id = cpu.gpr[4];
        int param = cpu.gpr[5];
        int data = cpu.gpr[6];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUtilityGetNetParam(id=%d, param=%d, data=0x%08X)", id, param, data));
        }
        if (id < 0 || id > 1) {
            log.warn((Object)String.format("sceUtilityGetNetParam invalid id=%d", id));
            cpu.gpr[2] = -2146367999;
        } else if (!Memory.isAddressGood(data)) {
            log.warn((Object)String.format("sceUtilityGetNetParam invalid data address 0x%08X", data));
            cpu.gpr[2] = -1;
        } else {
            cpu.gpr[2] = 0;
            switch (param) {
                case 0: {
                    Utilities.writeStringZ(mem, data, sceUtility.getNetParamName(id));
                    break;
                }
                case 1: {
                    Utilities.writeStringZ(mem, data, sceNetApctl.getSSID());
                    break;
                }
                case 2: {
                    mem.write32(data, 1);
                    break;
                }
                case 3: {
                    Utilities.writeStringZ(mem, data, "XXXXXXXXXXXXXXXXX");
                    break;
                }
                case 4: {
                    mem.write32(data, 0);
                    break;
                }
                case 5: {
                    Utilities.writeStringZ(mem, data, sceNetApctl.getLocalHostIP());
                    break;
                }
                case 6: {
                    Utilities.writeStringZ(mem, data, sceNetApctl.getSubnetMask());
                    break;
                }
                case 7: {
                    Utilities.writeStringZ(mem, data, sceNetApctl.getGateway());
                    break;
                }
                case 8: {
                    mem.write32(data, 0);
                    break;
                }
                case 9: {
                    Utilities.writeStringZ(mem, data, sceNetApctl.getPrimaryDNS());
                    break;
                }
                case 10: {
                    Utilities.writeStringZ(mem, data, sceNetApctl.getSecondaryDNS());
                    break;
                }
                default: {
                    log.warn((Object)String.format("sceUtilityGetNetParam invalid data address 0x%08X", data));
                    cpu.gpr[2] = -2146367996;
                }
            }
        }
    }

    @HLEFunction(nid=1340941528, version=150)
    public void sceUtilityGetNetParamLatestID(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int idAddr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUtilityGetNetParamLatestID: idAddr=0x%08X", idAddr));
        }
        if (Memory.isAddressGood(idAddr)) {
            mem.write32(idAddr, 1);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2146367996;
        }
    }

    protected static class SavedataListTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8867168909834783380L;
        private int numberRows;
        private ImageIcon[] icons;
        private String[] descriptions;
        private int fontHeight = 12;

        public SavedataListTableModel(String[] saveNames, SceUtilitySavedataParam savedataParams) {
            this.numberRows = saveNames == null ? 0 : saveNames.length;
            this.icons = new ImageIcon[this.numberRows];
            this.descriptions = new String[this.numberRows];
            for (int i = 0; i < this.numberRows; ++i) {
                Image image;
                if (saveNames[i] != null) {
                    String sfoFileName;
                    SeekableDataInput sfoDataInput;
                    String iconFileName = savedataParams.getFileName(saveNames[i], "ICON0.PNG");
                    SeekableDataInput iconDataInput = Modules.IoFileMgrForUserModule.getFile(iconFileName, 1);
                    if (iconDataInput != null) {
                        try {
                            int length = (int)iconDataInput.length();
                            byte[] iconBuffer = new byte[length];
                            iconDataInput.readFully(iconBuffer);
                            iconDataInput.close();
                            this.icons[i] = new ImageIcon(iconBuffer);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if ((sfoDataInput = Modules.IoFileMgrForUserModule.getFile(sfoFileName = savedataParams.getFileName(saveNames[i], "PARAM.SFO"), 1)) != null) {
                        try {
                            int length = (int)sfoDataInput.length();
                            byte[] sfoBuffer = new byte[length];
                            sfoDataInput.readFully(sfoBuffer);
                            sfoDataInput.close();
                            PSF psf = new PSF();
                            psf.read(ByteBuffer.wrap(sfoBuffer));
                            String title = psf.getString("TITLE");
                            String detail = psf.getString("SAVEDATA_DETAIL");
                            String savedataTitle = psf.getString("SAVEDATA_TITLE");
                            SceIoStat sfoStat = Modules.IoFileMgrForUserModule.statFile(sfoFileName);
                            Calendar cal = Calendar.getInstance();
                            ScePspDateTime pspTime = sfoStat.mtime;
                            cal.set(pspTime.year, pspTime.month, pspTime.day, pspTime.hour, pspTime.minute, pspTime.second);
                            this.descriptions[i] = String.format("%1$s\n%4$tF %4$tR\n%2$s\n%3$s", title, savedataTitle, detail, cal);
                            int numberLines = 1 + sceUtility.count(this.descriptions[i], "\n");
                            if (numberLines < fontHeightSavedataList.length) {
                                this.setFontHeight(fontHeightSavedataList[numberLines]);
                            } else {
                                this.setFontHeight(fontHeightSavedataList[fontHeightSavedataList.length - 1]);
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                if (this.icons[i] == null) {
                    this.icons[i] = new ImageIcon(this.getClass().getResource("/jpcsp/images/icon0.png"));
                }
                if (this.descriptions[i] == null) {
                    this.descriptions[i] = Resource.get("NotPresent");
                }
                if (this.icons[i] == null || (image = this.icons[i].getImage()).getWidth(null) <= 144 && image.getHeight(null) <= 80) continue;
                image = image.getScaledInstance(144, 80, 4);
                this.icons[i].setImage(image);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.numberRows;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.icons[rowIndex];
            }
            return this.descriptions[rowIndex];
        }

        public int getFontHeight() {
            return this.fontHeight;
        }

        public void setFontHeight(int fontHeight) {
            this.fontHeight = fontHeight;
        }
    }

    protected static class SavedataListTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -2460343777558549264L;
        private int fontHeight = 12;

        public SavedataListTableColumnModel() {
            this.setColumnMargin(0);
            CellRenderer cellRenderer = new CellRenderer();
            TableColumn tableColumn = new TableColumn(0, 144, cellRenderer, null);
            tableColumn.setHeaderValue(Resource.get("icon"));
            tableColumn.setMaxWidth(144);
            tableColumn.setMinWidth(144);
            TableColumn tableColumn2 = new TableColumn(1, 100, cellRenderer, null);
            tableColumn2.setHeaderValue(Resource.get("title"));
            this.addColumn(tableColumn);
            this.addColumn(tableColumn2);
        }

        public void setFontHeight(int fontHeight) {
            this.fontHeight = fontHeight;
        }

        private final class CellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 6230063075762638253L;

            private CellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
                if (obj instanceof Icon) {
                    this.setIcon((Icon)obj);
                } else {
                    if (obj instanceof String) {
                        JTextArea textArea = new JTextArea((String)obj);
                        textArea.setFont(new Font("SansSerif", 0, SavedataListTableColumnModel.this.fontHeight));
                        if (isSelected) {
                            textArea.setForeground(table.getSelectionForeground());
                            textArea.setBackground(table.getSelectionBackground());
                        } else {
                            textArea.setForeground(table.getForeground());
                            textArea.setBackground(table.getBackground());
                        }
                        return textArea;
                    }
                    this.setIcon(null);
                }
                return super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            }
        }
    }

    protected static class OskDialog
    extends UtilityDialog {
        private static final long serialVersionUID = 1155047781007677923L;
        protected JTextField textField;

        public OskDialog(SceUtilityOskParams oskParams, OskUtilityDialogState oskState) {
            this.createDialog(oskState, oskParams.oskData.desc);
            this.textField = new JTextField(oskParams.oskData.inText);
            this.messagePane.add(this.textField);
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(this.closeActionListener);
            okButton.setActionCommand("OK");
            this.buttonPane.add(okButton);
            this.setDefaultButton(okButton);
            this.endDialog();
        }
    }

    protected static class MsgDialog
    extends UtilityDialog {
        private static final long serialVersionUID = 3823899730551154698L;
        protected SceUtilityMsgDialogParams msgDialogParams;

        public MsgDialog(SceUtilityMsgDialogParams msgDialogParams, MsgDialogUtilityDialogState msgDialogState) {
            this.msgDialogParams = msgDialogParams;
            this.createDialog(msgDialogState, msgDialogParams.message);
            if (msgDialogParams.isOptionYesNo()) {
                JButton yesButton = new JButton("Yes");
                JButton noButton = new JButton("No");
                yesButton.addActionListener(this.closeActionListener);
                yesButton.setActionCommand("YES");
                noButton.addActionListener(this.closeActionListener);
                noButton.setActionCommand("NO");
                this.confirmButtonActionCommand = "YES";
                this.cancelButtonActionCommand = "NO";
                this.buttonPane.add(yesButton);
                this.buttonPane.add(noButton);
                if (msgDialogParams.isOptionYesNoDefaultYes()) {
                    this.setDefaultButton(yesButton);
                } else if (msgDialogParams.isOptionYesNoDefaultNo()) {
                    this.setDefaultButton(noButton);
                }
            } else if (msgDialogParams.isOptionOk()) {
                JButton okButton = new JButton("Ok");
                okButton.addActionListener(this.closeActionListener);
                okButton.setActionCommand("OK");
                this.buttonPane.add(okButton);
                this.setDefaultButton(okButton);
            } else if (msgDialogParams.mode == 1) {
                JButton okButton = new JButton("Ok");
                okButton.addActionListener(this.closeActionListener);
                okButton.setActionCommand("OK");
                this.buttonPane.add(okButton);
                this.setDefaultButton(okButton);
            } else if (msgDialogParams.mode == 0) {
                String errorMessage = String.format("Error 0x%08X", msgDialogParams.errorValue);
                JLabel errorMessageLabel = new JLabel(errorMessage);
                this.messagePane.add(errorMessageLabel);
                JButton okButton = new JButton("Ok");
                okButton.addActionListener(this.closeActionListener);
                okButton.setActionCommand("OK");
                this.buttonPane.add(okButton);
                this.setDefaultButton(okButton);
            }
            this.endDialog();
        }
    }

    protected static class SavedataDialog
    extends UtilityDialog {
        private static final long serialVersionUID = 3753863112417187248L;
        private final JTable table;
        private SavedataUtilityDialogState savedataDialogState;
        private SceUtilitySavedataParam savedataParams;
        private final String[] saveNames;

        public SavedataDialog(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState, String[] saveNames) {
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.saveNames = saveNames;
            this.createDialog(savedataDialogState, null);
            this.dialog.setTitle(Resource.get("SaveDataList"));
            this.dialog.setSize(Settings.getInstance().readWindowSize(savedataDialogState.name, 400, 401));
            final JButton selectButton = new JButton(Resource.get("Select"));
            selectButton.setActionCommand("OK");
            this.setDefaultButton(selectButton);
            CancelButton cancelButton = new CancelButton(this.dialog);
            cancelButton.setActionCommand("ESC");
            cancelButton.addActionListener(this.closeActionListener);
            SavedataListTableModel savedataListTableModel = new SavedataListTableModel(saveNames, savedataParams);
            SavedataListTableColumnModel savedataListTableColumnModel = new SavedataListTableColumnModel();
            savedataListTableColumnModel.setFontHeight(savedataListTableModel.getFontHeight());
            this.table = new JTable(savedataListTableModel, savedataListTableColumnModel);
            this.table.setRowHeight(80);
            this.table.setRowSelectionAllowed(true);
            this.table.setColumnSelectionAllowed(false);
            this.table.setSelectionMode(0);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    selectButton.setEnabled(!((ListSelectionModel)event.getSource()).isSelectionEmpty());
                }
            });
            this.table.setFont(new Font("SansSerif", 0, fontHeightSavedataList[0]));
            JScrollPane listScroll = new JScrollPane(this.table);
            GroupLayout layout = new GroupLayout(this.dialog.getRootPane());
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(listScroll).addGroup(layout.createSequentialGroup().addComponent(selectButton).addComponent(cancelButton)));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(listScroll).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(selectButton).addComponent(cancelButton)));
            this.dialog.getRootPane().setLayout(layout);
            selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (SavedataDialog.this.updateSelection()) {
                        SavedataDialog.this.processActionCommand(event.getActionCommand());
                        SavedataDialog.this.dispose();
                    }
                }
            });
            int selectedRow = 0;
            block0 : switch (savedataParams.focus) {
                case 1: {
                    selectedRow = 0;
                    break;
                }
                case 2: {
                    selectedRow = this.table.getRowCount() - 1;
                    break;
                }
                case 3: {
                    long latestTimestamp = Long.MIN_VALUE;
                    for (int i = 0; i < saveNames.length; ++i) {
                        long timestamp = this.getTimestamp(saveNames[i]);
                        if (timestamp <= latestTimestamp) continue;
                        latestTimestamp = timestamp;
                        selectedRow = i;
                    }
                    break;
                }
                case 4: {
                    long oldestTimestamp = Long.MAX_VALUE;
                    for (int i = 0; i < saveNames.length; ++i) {
                        long timestamp = this.getTimestamp(saveNames[i]);
                        if (timestamp >= oldestTimestamp) continue;
                        oldestTimestamp = timestamp;
                        selectedRow = i;
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < saveNames.length; ++i) {
                        if (!this.isEmpty(saveNames[i])) continue;
                        selectedRow = i;
                        break block0;
                    }
                    break;
                }
                case 8: {
                    for (int i = saveNames.length - 1; i >= 0; --i) {
                        if (!this.isEmpty(saveNames[i])) continue;
                        selectedRow = i;
                        break block0;
                    }
                    break;
                }
            }
            if (selectedRow >= 0 && selectedRow < this.table.getRowCount()) {
                this.table.changeSelection(selectedRow, this.table.getSelectedColumn(), false, false);
            }
            this.endDialog();
        }

        private boolean isEmpty(String saveName) {
            return !this.savedataParams.isPresent(this.savedataParams.gameName, saveName);
        }

        private long getTimestamp(String saveName) {
            return this.savedataParams.getTimestamp(this.savedataParams.gameName, saveName);
        }

        private boolean updateSelection() {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0 && selectedRow < this.saveNames.length) {
                this.savedataDialogState.saveListSelection = this.saveNames[selectedRow];
                return true;
            }
            return false;
        }

        @Override
        public void checkController() {
            int selectedRow = this.table.getSelectedRow();
            if (this.isDownPressed()) {
                ++selectedRow;
            } else if (this.isUpPressed()) {
                --selectedRow;
            } else if (this.isButtonPressed(256)) {
                selectedRow = 0;
            } else if (this.isButtonPressed(512)) {
                selectedRow = this.table.getRowCount() - 1;
            }
            if (selectedRow != this.table.getSelectedRow()) {
                selectedRow = Math.min(selectedRow, this.table.getRowCount() - 1);
                selectedRow = Math.max(selectedRow, 0);
                this.table.changeSelection(selectedRow, this.table.getSelectedColumn(), false, false);
            }
            if (this.updateSelection() || this.isCancelButtonPressed()) {
                super.checkController();
            }
        }
    }

    protected static abstract class UtilityDialog
    extends JComponent {
        private static final long serialVersionUID = -993546461292372048L;
        protected JDialog dialog;
        protected int buttonPressed;
        protected JPanel messagePane;
        protected JPanel buttonPane;
        protected ActionListener closeActionListener;
        protected static final String actionCommandOK = "OK";
        protected static final String actionCommandYES = "YES";
        protected static final String actionCommandNO = "NO";
        protected static final String actionCommandESC = "ESC";
        protected UtilityDialogState utilityDialogState;
        protected String confirmButtonActionCommand = "OK";
        protected String cancelButtonActionCommand = "ESC";
        protected long pressedTimestamp;
        protected static final int repeatDelay = 200000;
        protected boolean downPressedButton;
        protected boolean downPressedAnalog;
        protected boolean upPressedButton;
        protected boolean upPressedAnalog;

        protected UtilityDialog() {
        }

        protected void createDialog(UtilityDialogState utilityDialogState, String message) {
            this.utilityDialogState = utilityDialogState;
            String title = String.format("Message from %s", State.title);
            this.dialog = new JDialog((Frame)null, title, false);
            this.dialog.setSize(Settings.getInstance().readWindowSize(utilityDialogState.name, 200, 100));
            this.dialog.setLocation(Settings.getInstance().readWindowPos(utilityDialogState.name));
            this.dialog.setDefaultCloseOperation(2);
            this.messagePane = new JPanel();
            this.messagePane.setBorder(new EmptyBorder(5, 10, 5, 10));
            this.messagePane.setLayout(new BoxLayout(this.messagePane, 1));
            if (message != null) {
                message = sceUtility.formatMessageForDialog(message);
                while (message.length() > 0) {
                    int newLinePosition = message.indexOf("\n");
                    JLabel label = new JLabel();
                    label.setHorizontalAlignment(0);
                    label.setAlignmentX(0.5f);
                    if (newLinePosition < 0) {
                        label.setText(message);
                        message = "";
                    } else {
                        String messagePart = message.substring(0, newLinePosition);
                        label.setText(messagePart);
                        message = message.substring(newLinePosition + 1);
                    }
                    this.messagePane.add(label);
                }
            }
            if (JDialog.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
                this.dialog.setUndecorated(true);
                this.getRootPane().setWindowDecorationStyle(3);
            }
            this.buttonPane = new JPanel();
            this.buttonPane.setBorder(new EmptyBorder(5, 10, 5, 10));
            this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
            this.closeActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    UtilityDialog.this.processActionCommand(event.getActionCommand());
                    UtilityDialog.this.dispose();
                }
            };
        }

        protected void dispose() {
            this.dialog.dispose();
            Emulator.getMainGUI().endWindowDialog();
        }

        protected void processActionCommand(String actionCommand) {
            this.buttonPressed = actionCommandYES.equals(actionCommand) ? 1 : (actionCommandNO.equals(actionCommand) ? 2 : (actionCommandOK.equals(actionCommand) ? 1 : (actionCommandESC.equals(actionCommand) ? 3 : 0)));
        }

        protected void endDialog() {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(this.messagePane);
            contentPane.add(this.buttonPane);
            this.dialog.pack();
            Emulator.getMainGUI().startWindowDialog(this.dialog);
        }

        protected void setDefaultButton(JButton button) {
            this.dialog.getRootPane().setDefaultButton(button);
        }

        @Override
        public void setVisible(boolean flag) {
            this.dialog.setVisible(flag);
        }

        @Override
        public boolean isVisible() {
            return this.dialog.isVisible();
        }

        @Override
        public Point getLocation() {
            return this.dialog.getLocation();
        }

        @Override
        public Dimension getSize() {
            return this.dialog.getSize();
        }

        protected boolean isButtonPressed(int button) {
            Controller controller = State.controller;
            return (controller.getButtons() & button) == button;
        }

        protected boolean isConfirmButtonPressed() {
            return this.isButtonPressed(sceUtility.getSystemParamButtonPreference() == 0 ? 8192 : 16384);
        }

        protected boolean isCancelButtonPressed() {
            return this.isButtonPressed(sceUtility.getSystemParamButtonPreference() == 0 ? 16384 : 8192);
        }

        private int getControllerLy() {
            return State.controller.getLy() & 0xFF;
        }

        private int getControllerAnalogCenter() {
            return 128;
        }

        private void checkRepeat() {
            if (this.pressedTimestamp != 0L && SystemTimeManager.getSystemTime() - this.pressedTimestamp > 200000L) {
                this.upPressedAnalog = false;
                this.upPressedButton = false;
                this.downPressedAnalog = false;
                this.downPressedButton = false;
                this.pressedTimestamp = 0L;
            }
        }

        protected boolean isUpPressed() {
            this.checkRepeat();
            if (this.upPressedButton || this.upPressedAnalog) {
                if (!this.isButtonPressed(16)) {
                    this.upPressedButton = false;
                }
                if (this.getControllerLy() >= this.getControllerAnalogCenter()) {
                    this.upPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(16)) {
                this.upPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() < this.getControllerAnalogCenter()) {
                this.upPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isDownPressed() {
            this.checkRepeat();
            if (this.downPressedButton || this.downPressedAnalog) {
                if (!this.isButtonPressed(64)) {
                    this.downPressedButton = false;
                }
                if (this.getControllerLy() <= this.getControllerAnalogCenter()) {
                    this.downPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(64)) {
                this.downPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() > this.getControllerAnalogCenter()) {
                this.downPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        public void checkController() {
            if (this.isConfirmButtonPressed()) {
                this.processActionCommand(this.confirmButtonActionCommand);
                this.dispose();
            } else if (this.isCancelButtonPressed()) {
                this.processActionCommand(this.cancelButtonActionCommand);
                this.dispose();
            }
        }
    }

    protected static class HtmlViewerUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityHtmlViewerParams htmlViewerParams;

        public HtmlViewerUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.htmlViewerParams = new SceUtilityHtmlViewerParams();
            return this.htmlViewerParams;
        }
    }

    protected static class NpSigninUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityNpSigninParams npSigninParams;

        public NpSigninUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.npSigninParams = new SceUtilityNpSigninParams();
            return this.npSigninParams;
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            return false;
        }
    }

    protected static class GamedataInstallUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityGamedataInstallParams gamedataInstallParams;

        public GamedataInstallUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.gamedataInstallParams = new SceUtilityGamedataInstallParams();
            return this.gamedataInstallParams;
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            return false;
        }
    }

    protected static class ScreenshotUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityScreenshotParams screenshotParams;

        public ScreenshotUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            return false;
        }

        protected void executeContStart(Processor processor) {
            CpuState cpu = processor.cpu;
            Memory mem = Memory.getInstance();
            this.paramsAddr = cpu.gpr[4];
            if (!Memory.isAddressGood(this.paramsAddr)) {
                log.error((Object)String.format("%sContStart bad address 0x%08X", this.name, this.paramsAddr));
                cpu.gpr[2] = -1;
            } else {
                this.params = this.createParams();
                this.params.read(mem, this.paramsAddr);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("%sContStart %s", this.name, this.params.toString()));
                }
                if (this.screenshotParams.isContModeOn()) {
                    this.status = 1;
                    cpu.gpr[2] = 0;
                } else {
                    cpu.gpr[2] = -2146364887;
                }
            }
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.screenshotParams = new SceUtilityScreenshotParams();
            return this.screenshotParams;
        }
    }

    protected static class NetconfUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityNetconfParams netconfParams;

        public NetconfUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            boolean keepVisible = false;
            if (this.netconfParams.netAction == 0 || this.netconfParams.netAction == 3) {
                int state = Modules.sceNetApctlModule.hleNetApctlGetState();
                if (state == 4) {
                    keepVisible = false;
                } else {
                    keepVisible = true;
                    if (state == 0) {
                        Modules.sceNetApctlModule.hleNetApctlConnect(1);
                    }
                }
            } else if (this.netconfParams.netAction == 2 || this.netconfParams.netAction == 4 || this.netconfParams.netAction == 5) {
                int state = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetState();
                if (state == 1) {
                    keepVisible = false;
                } else {
                    keepVisible = true;
                    if (state == 0 && this.netconfParams.netconfData != null) {
                        Modules.sceNetAdhocctlModule.hleNetAdhocctlConnect(this.netconfParams.netconfData.groupName);
                    }
                }
            }
            return keepVisible;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.netconfParams = new SceUtilityNetconfParams();
            return this.netconfParams;
        }
    }

    protected static class GameSharingUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityGameSharingParams gameSharingParams;

        public GameSharingUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.gameSharingParams = new SceUtilityGameSharingParams();
            return this.gameSharingParams;
        }
    }

    protected static class OskUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityOskParams oskParams;
        protected OskDialog oskDialog;

        public OskUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            Memory mem = Processor.memory;
            if (!this.isDialogOpen()) {
                this.oskDialog = new OskDialog(this.oskParams, this);
                this.openDialog(this.oskDialog);
            } else if (!this.isDialogActive()) {
                if (this.oskDialog.buttonPressed == 1) {
                    this.oskParams.oskData.result = 2;
                    this.oskParams.oskData.outText = this.oskDialog.textField.getText();
                    log.info((Object)("hleUtilityOskDisplay returning '" + this.oskParams.oskData.outText + "'"));
                } else {
                    this.oskParams.oskData.result = 1;
                    this.oskParams.oskData.outText = this.oskDialog.textField.getText();
                    log.info((Object)"hleUtilityOskDisplay cancelled");
                }
                this.oskParams.base.result = 0;
                this.oskParams.write(mem);
                this.finishDialog();
            } else {
                this.oskDialog.checkController();
                this.updateDialog();
            }
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.oskParams = new SceUtilityOskParams();
            return this.oskParams;
        }
    }

    protected static class MsgDialogUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityMsgDialogParams msgDialogParams;
        protected MsgDialog msgDialog;

        public MsgDialogUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            Memory mem = Processor.memory;
            if (!this.isDialogOpen()) {
                this.msgDialog = new MsgDialog(this.msgDialogParams, this);
                this.openDialog(this.msgDialog);
            } else if (!this.isDialogActive()) {
                this.msgDialogParams.buttonPressed = this.msgDialog.buttonPressed;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceUtilityMsgDialog returning buttonPressed=%d", this.msgDialogParams.buttonPressed));
                }
                this.msgDialogParams.base.result = 0;
                this.msgDialogParams.write(mem);
                this.finishDialog();
            } else {
                this.msgDialog.checkController();
                this.updateDialog();
            }
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.msgDialogParams = new SceUtilityMsgDialogParams();
            return this.msgDialogParams;
        }
    }

    protected static class SavedataUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilitySavedataParam savedataParams;
        protected volatile String saveListSelection;

        public SavedataUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.savedataParams = new SceUtilitySavedataParam();
            return this.savedataParams;
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            Memory mem = Processor.memory;
            switch (this.savedataParams.mode) {
                case 0: 
                case 2: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.load(mem);
                        this.savedataParams.base.result = 0;
                        this.savedataParams.write(mem);
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368761;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368763;
                        log.error((Object)e);
                    }
                    break;
                }
                case 4: {
                    if (!this.isDialogOpen()) {
                        ArrayList<String> validNames = new ArrayList<String>();
                        for (int i = 0; i < this.savedataParams.saveNameList.length; ++i) {
                            this.savedataParams.saveName = this.savedataParams.saveNameList[i];
                            if (!this.savedataParams.isPresent()) continue;
                            validNames.add(this.savedataParams.saveName);
                        }
                        SavedataDialog savedataDialog = new SavedataDialog(this.savedataParams, this, validNames.toArray(new String[validNames.size()]));
                        this.openDialog(savedataDialog);
                        break;
                    }
                    if (!this.isDialogActive()) {
                        if (this.dialog.buttonPressed != 1) {
                            this.savedataParams.base.result = -2146368760;
                        } else if (this.saveListSelection == null) {
                            log.warn((Object)"Savedata MODE_LISTLOAD no save selected");
                            this.savedataParams.base.result = -2146368760;
                        } else {
                            this.savedataParams.saveName = this.saveListSelection;
                            try {
                                this.savedataParams.load(mem);
                                this.savedataParams.base.result = 0;
                                this.savedataParams.write(mem);
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = -2146368761;
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368763;
                                log.error((Object)e);
                            }
                        }
                        this.finishDialog();
                        break;
                    }
                    this.updateDialog();
                    break;
                }
                case 1: 
                case 3: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.save(mem);
                        this.savedataParams.base.result = 0;
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368635;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368635;
                        log.error((Object)e);
                    }
                    break;
                }
                case 5: {
                    if (!this.isDialogOpen()) {
                        SavedataDialog savedataDialog = new SavedataDialog(this.savedataParams, this, this.savedataParams.saveNameList);
                        this.openDialog(savedataDialog);
                        break;
                    }
                    if (!this.isDialogActive()) {
                        if (this.dialog.buttonPressed != 1) {
                            this.savedataParams.base.result = -2146368632;
                        } else if (this.saveListSelection == null) {
                            log.warn((Object)"Savedata MODE_LISTSAVE no save selected");
                            this.savedataParams.base.result = -2146368632;
                        } else {
                            this.savedataParams.saveName = this.saveListSelection;
                            try {
                                this.savedataParams.save(mem);
                                this.savedataParams.base.result = 0;
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = -2146368635;
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368635;
                                log.error((Object)e);
                            }
                        }
                        this.finishDialog();
                        break;
                    }
                    this.updateDialog();
                    break;
                }
                case 7: {
                    if (this.savedataParams.saveNameList != null) {
                        for (int i = 0; i < this.savedataParams.saveNameList.length; ++i) {
                            String save = this.savedataParams.getBasePath(this.savedataParams.saveNameList[i]);
                            if (!Modules.IoFileMgrForUserModule.rmdir(save, true)) continue;
                            log.debug((Object)("Savedata MODE_DELETE deleting " + save));
                        }
                        this.savedataParams.base.result = 0;
                        break;
                    }
                    if (!this.isDialogOpen()) {
                        String pattern = this.savedataParams.gameName + ".*";
                        String[] entries = Modules.IoFileMgrForUserModule.listFiles("ms0:/PSP/SAVEDATA/", pattern);
                        ArrayList<String> validNames = new ArrayList<String>();
                        for (int i = 0; entries != null && i < entries.length; ++i) {
                            String saveName = entries[i].substring(this.savedataParams.gameName.length());
                            if (!this.savedataParams.isPresent(this.savedataParams.gameName, saveName)) continue;
                            validNames.add(saveName);
                        }
                        SavedataDialog savedataDialog = new SavedataDialog(this.savedataParams, this, validNames.toArray(new String[validNames.size()]));
                        this.openDialog(savedataDialog);
                        break;
                    }
                    if (!this.isDialogActive()) {
                        if (this.dialog.buttonPressed != 1) {
                            this.savedataParams.base.result = -2146368696;
                        } else if (this.saveListSelection == null) {
                            log.warn((Object)"Savedata MODE_DELETE no save selected");
                            this.savedataParams.base.result = -2146368696;
                        } else {
                            String dirName = this.savedataParams.getBasePath(this.saveListSelection);
                            if (Modules.IoFileMgrForUserModule.rmdir(dirName, true)) {
                                log.debug((Object)("Savedata MODE_DELETE deleting " + dirName));
                                this.savedataParams.base.result = 0;
                            } else {
                                this.savedataParams.base.result = -2146368699;
                            }
                        }
                        this.finishDialog();
                        break;
                    }
                    this.updateDialog();
                    break;
                }
                case 8: {
                    int buffer3Addr;
                    int buffer2Addr;
                    int baseResult = 0;
                    String gameName = this.savedataParams.gameName;
                    String saveName = this.savedataParams.saveName;
                    int buffer1Addr = this.savedataParams.msFreeAddr;
                    if (Memory.isAddressGood(buffer1Addr)) {
                        String memoryStickFreeSpaceString = MemoryStick.getSizeKbString(MemoryStick.getFreeSizeKb());
                        mem.write32(buffer1Addr + 0, MemoryStick.getSectorSize());
                        mem.write32(buffer1Addr + 4, MemoryStick.getFreeSizeKb() / MemoryStick.getSectorSizeKb());
                        mem.write32(buffer1Addr + 8, MemoryStick.getFreeSizeKb());
                        Utilities.writeStringNZ(mem, buffer1Addr + 12, 8, memoryStickFreeSpaceString);
                        log.debug((Object)("Memory Stick Free Space = " + memoryStickFreeSpaceString));
                    }
                    if (Memory.isAddressGood(buffer2Addr = this.savedataParams.msDataAddr)) {
                        gameName = Utilities.readStringNZ(mem, buffer2Addr, 13);
                        if (this.savedataParams.isPresent(gameName, saveName = Utilities.readStringNZ(mem, buffer2Addr + 16, 20))) {
                            int savedataSizeKb = this.savedataParams.getSizeKb(gameName, saveName);
                            int savedataSize32Kb = MemoryStick.getSize32Kb(savedataSizeKb);
                            mem.write32(buffer2Addr + 36, savedataSizeKb / MemoryStick.getSectorSizeKb());
                            mem.write32(buffer2Addr + 40, savedataSizeKb);
                            Utilities.writeStringNZ(mem, buffer2Addr + 44, 8, MemoryStick.getSizeKbString(savedataSizeKb));
                            mem.write32(buffer2Addr + 52, savedataSize32Kb);
                            Utilities.writeStringNZ(mem, buffer2Addr + 56, 8, MemoryStick.getSizeKbString(savedataSize32Kb));
                            log.debug((Object)("Memory Stick Full Space = " + MemoryStick.getSizeKbString(savedataSizeKb)));
                        } else {
                            log.warn((Object)"Memory Stick Full Space = no data found!");
                            baseResult = -2146368569;
                        }
                    }
                    if (Memory.isAddressGood(buffer3Addr = this.savedataParams.utilityDataAddr)) {
                        int memoryStickRequiredSpaceKb = 0;
                        memoryStickRequiredSpaceKb += MemoryStick.getSectorSizeKb();
                        if (!this.savedataParams.overwrite) {
                            if (this.savedataParams.fileName != null) {
                                memoryStickRequiredSpaceKb += sceUtility.computeMemoryStickRequiredSpaceKb(this.savedataParams.dataSize);
                            }
                            memoryStickRequiredSpaceKb += sceUtility.computeMemoryStickRequiredSpaceKb(this.savedataParams.icon0FileData.size);
                            memoryStickRequiredSpaceKb += sceUtility.computeMemoryStickRequiredSpaceKb(this.savedataParams.icon1FileData.size);
                            memoryStickRequiredSpaceKb += sceUtility.computeMemoryStickRequiredSpaceKb(this.savedataParams.pic1FileData.size);
                            memoryStickRequiredSpaceKb += sceUtility.computeMemoryStickRequiredSpaceKb(this.savedataParams.snd0FileData.size);
                        }
                        String memoryStickRequiredSpaceString = MemoryStick.getSizeKbString(memoryStickRequiredSpaceKb);
                        int memoryStickRequiredSpace32Kb = MemoryStick.getSize32Kb(memoryStickRequiredSpaceKb);
                        String memoryStickRequiredSpace32KbString = MemoryStick.getSizeKbString(memoryStickRequiredSpace32Kb);
                        mem.write32(buffer3Addr + 0, memoryStickRequiredSpaceKb / MemoryStick.getSectorSizeKb());
                        mem.write32(buffer3Addr + 4, memoryStickRequiredSpaceKb);
                        Utilities.writeStringNZ(mem, buffer3Addr + 8, 8, memoryStickRequiredSpaceString);
                        mem.write32(buffer3Addr + 16, memoryStickRequiredSpace32Kb);
                        Utilities.writeStringNZ(mem, buffer3Addr + 20, 8, memoryStickRequiredSpace32KbString);
                        log.debug((Object)("Memory Stick Required Space = " + memoryStickRequiredSpaceString));
                    }
                    this.savedataParams.base.result = baseResult;
                    break;
                }
                case 10: {
                    String saveDir = this.savedataParams.getBasePath();
                    if (Modules.IoFileMgrForUserModule.rmdir(saveDir, true)) {
                        this.savedataParams.base.result = 0;
                        break;
                    }
                    log.warn((Object)"Savedata MODE_SINGLEDELETE directory not found!");
                    this.savedataParams.base.result = -2146368697;
                    break;
                }
                case 11: {
                    int buffer4Addr = this.savedataParams.idListAddr;
                    if (Memory.isAddressGood(buffer4Addr)) {
                        int maxEntries = mem.read32(buffer4Addr + 0);
                        int entriesAddr = mem.read32(buffer4Addr + 8);
                        String saveName = this.savedataParams.saveName;
                        String pattern = saveName.replace('?', '.');
                        pattern = pattern.replace("*", ".*");
                        pattern = this.savedataParams.gameName + pattern;
                        String[] entries = Modules.IoFileMgrForUserModule.listFiles("ms0:/PSP/SAVEDATA/", pattern);
                        int numEntries = entries == null ? 0 : entries.length;
                        numEntries = Math.min(numEntries, maxEntries);
                        for (int i = 0; i < numEntries; ++i) {
                            String filePath = "ms0:/PSP/SAVEDATA//" + entries[i];
                            SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(filePath);
                            int entryAddr = entriesAddr + i * 72;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                stat.ctime.write(mem, entryAddr + 4);
                                stat.atime.write(mem, entryAddr + 20);
                                stat.mtime.write(mem, entryAddr + 36);
                            }
                            String entryName = entries[i].substring(this.savedataParams.gameName.length());
                            Utilities.writeStringNZ(mem, entryAddr + 52, 20, entryName);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)String.format("MODE_LIST returning filePath=%s, stat=%s, entryName=%s at 0x%08X", filePath, stat, entryName, entryAddr));
                        }
                        mem.write32(buffer4Addr + 4, numEntries);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("MODE_LIST returning %d entries", numEntries));
                        }
                    }
                    this.savedataParams.base.result = 0;
                    break;
                }
                case 12: {
                    int buffer5Addr = this.savedataParams.fileListAddr;
                    if (!Memory.isAddressGood(buffer5Addr)) break;
                    int saveFileSecureEntriesAddr = mem.read32(buffer5Addr + 24);
                    int saveFileEntriesAddr = mem.read32(buffer5Addr + 28);
                    int systemEntriesAddr = mem.read32(buffer5Addr + 32);
                    String path = this.savedataParams.getBasePath(this.savedataParams.saveName);
                    String[] entries = Modules.IoFileMgrForUserModule.listFiles(path, null);
                    int maxNumEntries = entries == null ? 0 : entries.length;
                    int saveFileSecureNumEntries = 0;
                    int saveFileNumEntries = 0;
                    int systemFileNumEntries = 0;
                    for (int i = 0; i < maxNumEntries; ++i) {
                        String entryName;
                        int entryAddr;
                        String filePath = path + "/" + entries[i];
                        SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(filePath);
                        if (filePath.contains(".SFO") || filePath.contains("ICON") || filePath.contains("PIC") || filePath.contains("SND")) {
                            if (Memory.isAddressGood(systemEntriesAddr)) {
                                entryAddr = systemEntriesAddr + systemFileNumEntries * 80;
                                if (stat != null) {
                                    mem.write32(entryAddr + 0, stat.mode);
                                    mem.write64(entryAddr + 8, stat.size);
                                    stat.ctime.write(mem, entryAddr + 16);
                                    stat.atime.write(mem, entryAddr + 32);
                                    stat.mtime.write(mem, entryAddr + 48);
                                }
                                entryName = entries[i];
                                Utilities.writeStringNZ(mem, entryAddr + 64, 16, entryName);
                            }
                            ++systemFileNumEntries;
                            continue;
                        }
                        if (Memory.isAddressGood(saveFileSecureEntriesAddr)) {
                            entryAddr = saveFileSecureEntriesAddr + saveFileSecureNumEntries * 80;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                mem.write64(entryAddr + 8, stat.size);
                                stat.ctime.write(mem, entryAddr + 16);
                                stat.atime.write(mem, entryAddr + 32);
                                stat.mtime.write(mem, entryAddr + 48);
                            }
                            entryName = entries[i];
                            Utilities.writeStringNZ(mem, entryAddr + 64, 16, entryName);
                        }
                        ++saveFileSecureNumEntries;
                        if (Memory.isAddressGood(saveFileEntriesAddr)) {
                            entryAddr = saveFileEntriesAddr + saveFileNumEntries * 80;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                mem.write64(entryAddr + 8, stat.size);
                                stat.ctime.write(mem, entryAddr + 16);
                                stat.atime.write(mem, entryAddr + 32);
                                stat.mtime.write(mem, entryAddr + 48);
                            }
                            entryName = entries[i];
                            Utilities.writeStringNZ(mem, entryAddr + 64, 16, entryName);
                        }
                        ++saveFileNumEntries;
                    }
                    mem.write32(buffer5Addr + 12, saveFileSecureNumEntries);
                    mem.write32(buffer5Addr + 16, saveFileNumEntries);
                    mem.write32(buffer5Addr + 20, systemFileNumEntries);
                    if (entries == null) {
                        this.savedataParams.base.result = -2146368729;
                        break;
                    }
                    this.savedataParams.base.result = 0;
                    break;
                }
                case 13: 
                case 14: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.save(mem);
                        this.savedataParams.base.result = 0;
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368731;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 15: 
                case 16: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.singleRead(mem);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("MODE_READ/MODE_READSECURE reading %s", Utilities.getMemoryDump(this.savedataParams.dataBuf, this.savedataParams.dataSize, 4, 16)));
                        }
                        this.savedataParams.base.result = 0;
                        this.savedataParams.write(mem);
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368729;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 17: 
                case 18: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.singleWrite(mem);
                        this.savedataParams.base.result = 0;
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368731;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 21: {
                    if (this.savedataParams.fileName != null) {
                        String save = "ms0/PSP/SAVEDATA/" + State.discId + this.savedataParams.saveName + "/" + this.savedataParams.fileName;
                        File f = new File(save);
                        if (f != null) {
                            log.debug((Object)("Savedata MODE_DELETEDATA deleting " + save));
                            f = new File(save);
                            f.delete();
                        }
                        this.savedataParams.base.result = 0;
                        break;
                    }
                    log.warn((Object)"Savedata MODE_DELETEDATA no data found!");
                    this.savedataParams.base.result = -2146368729;
                    break;
                }
                case 22: {
                    int buffer6Addr = this.savedataParams.sizeAddr;
                    boolean isPresent = this.savedataParams.isPresent();
                    if (Memory.isAddressGood(buffer6Addr)) {
                        int sizeKb;
                        String fileName;
                        long size;
                        int entryAddr;
                        int i;
                        int saveFileSecureNumEntries = mem.read32(buffer6Addr + 0);
                        int saveFileNumEntries = mem.read32(buffer6Addr + 4);
                        int saveFileSecureEntriesAddr = mem.read32(buffer6Addr + 8);
                        int saveFileEntriesAddr = mem.read32(buffer6Addr + 12);
                        int totalSizeKb = 0;
                        for (i = 0; i < saveFileSecureNumEntries; ++i) {
                            entryAddr = saveFileSecureEntriesAddr + i * 24;
                            size = mem.read64(entryAddr);
                            fileName = Utilities.readStringNZ(entryAddr + 8, 16);
                            sizeKb = Utilities.getSizeKb(size);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("   Secure File '%s', size %d (%d KB)", fileName, size, sizeKb));
                            }
                            totalSizeKb += sizeKb;
                        }
                        for (i = 0; i < saveFileNumEntries; ++i) {
                            entryAddr = saveFileEntriesAddr + i * 24;
                            size = mem.read64(entryAddr);
                            fileName = Utilities.readStringNZ(entryAddr + 8, 16);
                            sizeKb = Utilities.getSizeKb(size);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("   File '%s', size %d (%d KB)", fileName, size, sizeKb));
                            }
                            totalSizeKb += sizeKb;
                        }
                        int freeSizeKb = MemoryStick.getFreeSizeKb();
                        String memoryStickFreeSpaceString = MemoryStick.getSizeKbString(freeSizeKb);
                        mem.write32(buffer6Addr + 16, MemoryStick.getSectorSize());
                        mem.write32(buffer6Addr + 20, freeSizeKb / MemoryStick.getSectorSizeKb());
                        mem.write32(buffer6Addr + 24, freeSizeKb);
                        Utilities.writeStringNZ(mem, buffer6Addr + 28, 8, memoryStickFreeSpaceString);
                        if (totalSizeKb > freeSizeKb) {
                            int neededSizeKb = totalSizeKb - freeSizeKb;
                            mem.write32(buffer6Addr + 36, neededSizeKb);
                            Utilities.writeStringNZ(mem, buffer6Addr + 40, 8, MemoryStick.getSizeKbString(neededSizeKb));
                            if (isPresent) {
                                mem.write32(buffer6Addr + 48, neededSizeKb);
                                Utilities.writeStringNZ(mem, buffer6Addr + 52, 8, MemoryStick.getSizeKbString(neededSizeKb));
                            }
                        } else {
                            mem.write32(buffer6Addr + 36, 0);
                            if (isPresent) {
                                mem.write32(buffer6Addr + 48, 0);
                            }
                        }
                    }
                    if (MemoryStick.getStateMs() != 1) {
                        this.savedataParams.base.result = -2146368735;
                        break;
                    }
                    if (!isPresent) {
                        this.savedataParams.base.result = -2146368729;
                        break;
                    }
                    this.savedataParams.base.result = 0;
                    break;
                }
                default: {
                    log.warn((Object)("Savedata - Unsupported mode " + this.savedataParams.mode));
                    this.savedataParams.base.result = -1;
                }
            }
            this.savedataParams.base.writeResult(mem);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleUtilitySavedataDisplay result: 0x%08X", this.savedataParams.base.result));
            }
            return false;
        }
    }

    protected static class NotImplementedUtilityDialogState
    extends UtilityDialogState {
        public NotImplementedUtilityDialogState(String name) {
            super(name);
        }

        @Override
        public void executeInitStart(Processor processor) {
            CpuState cpu = processor.cpu;
            log.warn((Object)String.format("Unimplemented: %sInitStart params=0x%08X", this.name, cpu.gpr[4]));
            cpu.gpr[2] = -2146369533;
        }

        @Override
        public void executeShutdownStart(Processor processor) {
            CpuState cpu = processor.cpu;
            log.warn((Object)("Unimplemented: " + this.name + "ShutdownStart"));
            cpu.gpr[2] = -2146369533;
        }

        @Override
        public void executeGetStatus(Processor processor) {
            CpuState cpu = processor.cpu;
            log.warn((Object)("Unimplemented: " + this.name + "GetStatus"));
            cpu.gpr[2] = -2146369533;
        }

        @Override
        protected boolean executeUpdateVisible(Processor processor) {
            CpuState cpu = processor.cpu;
            log.warn((Object)("Unimplemented: " + this.name + "Update"));
            cpu.gpr[2] = -2146369533;
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            return null;
        }
    }

    protected static abstract class UtilityDialogState {
        protected String name;
        protected pspAbstractMemoryMappedStructure params;
        protected int paramsAddr;
        protected int status;
        protected int result;
        protected UtilityDialog dialog;
        protected int drawSpeed;

        public UtilityDialogState(String name) {
            this.name = name;
            this.status = 0;
            this.result = 0;
        }

        protected void openDialog(UtilityDialog dialog) {
            this.status = 2;
            this.dialog = dialog;
            dialog.setVisible(true);
        }

        protected boolean isDialogOpen() {
            return this.dialog != null;
        }

        protected void updateDialog() {
            int delayMicros = 16666;
            if (this.drawSpeed > 0) {
                delayMicros /= this.drawSpeed;
            }
            Modules.ThreadManForUserModule.hleKernelDelayThread(delayMicros, false);
        }

        protected boolean isDialogActive() {
            return this.isDialogOpen() && this.dialog.isVisible();
        }

        protected void finishDialog() {
            if (this.dialog != null) {
                Settings.getInstance().writeWindowPos(this.name, this.dialog.getLocation());
                Settings.getInstance().writeWindowSize(this.name, this.dialog.getSize());
                this.dialog = null;
            }
            this.status = 3;
        }

        public void executeInitStart(Processor processor) {
            CpuState cpu = processor.cpu;
            Memory mem = Memory.getInstance();
            this.paramsAddr = cpu.gpr[4];
            if (!Memory.isAddressGood(this.paramsAddr)) {
                log.error((Object)String.format("%sInitStart bad address 0x%08X", this.name, this.paramsAddr));
                cpu.gpr[2] = -1;
            } else if (this.status != 0 && this.status != 4) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sInitStart already started status=%d", this.name, this.status));
                }
                cpu.gpr[2] = -1;
            } else {
                this.params = this.createParams();
                this.params.read(mem, this.paramsAddr);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("%sInitStart %s", this.name, this.params.toString()));
                }
                this.status = 1;
                cpu.gpr[2] = 0;
            }
        }

        private boolean isReadyForVisible() {
            return State.controller.getButtons() == 0;
        }

        public void executeGetStatus(Processor processor) {
            CpuState cpu = processor.cpu;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + "GetStatus status " + this.status));
            }
            cpu.gpr[2] = this.status;
            if (this.status == 4) {
                this.status = 0;
            } else if (this.status == 1 && this.isReadyForVisible()) {
                this.status = 2;
            }
        }

        public void executeShutdownStart(Processor processor) {
            CpuState cpu = processor.cpu;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + "ShutdownStart"));
            }
            this.status = 4;
            cpu.gpr[2] = 0;
        }

        public void executeUpdate(Processor processor) {
            CpuState cpu = processor.cpu;
            this.drawSpeed = cpu.gpr[4];
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + "Update drawSpeed=" + this.drawSpeed));
            }
            cpu.gpr[2] = 0;
            if (this.status == 1 && this.isReadyForVisible()) {
                this.status = 2;
            } else if (this.status == 2) {
                this.params.read(Memory.getInstance(), this.paramsAddr);
                boolean keepVisible = this.executeUpdateVisible(processor);
                if (this.status == 2 && this.isDialogOpen()) {
                    this.dialog.checkController();
                }
                if (this.status == 2 && !this.isDialogOpen() && !keepVisible) {
                    this.status = 3;
                }
            }
        }

        public void abort() {
            this.status = 4;
            this.result = 2;
        }

        public void cancel() {
            this.status = 4;
            this.result = 1;
        }

        protected abstract boolean executeUpdateVisible(Processor var1);

        protected abstract pspAbstractMemoryMappedStructure createParams();
    }
}

