/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules271;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.HLE.modules.sceMpeg;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceJpeg
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceJpeg");
    protected int jpegWidth = 480;
    protected int jpegHeight = 272;

    @Override
    public String getName() {
        return "sceJpeg";
    }

    protected static int getWidthHeight(int width, int height) {
        return width << 16 | height;
    }

    protected void dumpJpegImage(TPointer jpegBuffer, int jpegBufferSize) {
        byte[] buffer = new byte[jpegBufferSize];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(jpegBuffer.getAddress(), jpegBufferSize, 1);
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)memoryReader.readNext();
        }
        try {
            FileOutputStream os = new FileOutputStream(String.format("%s%cImage%08X.jpeg", Settings.getInstance().readString("emu.tmppath"), Character.valueOf(File.separatorChar), jpegBuffer.getAddress()));
            ((OutputStream)os).write(buffer, 2, buffer.length - 2);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @HLEFunction(nid=79015426, version=271)
    public int sceJpegMJpegCsc(TPointer imageBuffer, TPointer yCbCrBuffer, int widthHeight, int bufferWidth) {
        int height = widthHeight & 0xFFF;
        int width = widthHeight >> 16 & 0xFFF;
        int pixelFormat = 3;
        log.warn((Object)String.format("Unimplemented sceJpegMJpegCsc imageBuffer=%s, yCbCrBuffer=%s, widthHeight=0x%08X(width=%d, height=%d), bufferWidth=%d", imageBuffer, yCbCrBuffer, widthHeight, width, height, bufferWidth));
        sceMpeg.generateFakeImage(imageBuffer.getAddress(), bufferWidth, width, height, pixelFormat);
        VideoEngine.getInstance().addVideoTexture(imageBuffer.getAddress(), imageBuffer.getAddress() + bufferWidth * height * sceDisplay.getPixelFormatBytes(pixelFormat));
        return 0;
    }

    @HLEFunction(nid=1219887799, version=271)
    public int sceJpegDeleteMJpeg() {
        log.warn((Object)String.format("Ignoring sceJpegDeleteMJpeg", new Object[0]));
        return 0;
    }

    @HLEFunction(nid=2100247935, version=271)
    public int sceJpegFinishMJpeg() {
        log.warn((Object)String.format("Ignoring sceJpegFinishMJpeg", new Object[0]));
        return 0;
    }

    @HLEFunction(nid=-1846618052, version=271)
    public int sceJpegDecodeMJpegYCbCr(TPointer jpegBuffer, int jpegBufferSize, TPointer yCbCrBuffer, int yCbCrBufferSize, int unknown) {
        log.warn((Object)String.format("Unimplemented sceJpegDecodeMJpegYCbCr jpegBuffer=%s, jpegBufferSize=%d, yCbCrBuffer=%s, yCbCrBufferSize=%d, unknown=%d", jpegBuffer, jpegBufferSize, yCbCrBuffer, yCbCrBufferSize, unknown));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegDecodeMJpegYCbCr jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        int width = this.jpegWidth;
        int height = this.jpegHeight;
        return sceJpeg.getWidthHeight(width, height);
    }

    @HLEFunction(nid=-1656273252, version=271)
    public int sceJpegCreateMJpeg(int width, int height) {
        log.warn((Object)String.format("Unimplemented sceJpegCreateMJpeg width=%d, height=%d", width, height));
        this.jpegWidth = width;
        this.jpegHeight = height;
        return 0;
    }

    @HLEFunction(nid=-1398902554, version=271)
    public int sceJpegInitMJpeg() {
        log.warn((Object)String.format("Ignoring sceJpegInitMJpeg", new Object[0]));
        return 0;
    }

    @HLEFunction(nid=79248623, version=271)
    public int sceJpegDecodeMJpeg(TPointer jpegBuffer, int jpegBufferSize, TPointer imageBuffer, int unknown) {
        log.warn((Object)String.format("Unimplemented sceJpegDecodeMJpeg jpegBuffer=%s, jpegBufferSize=%d, imageBuffer=%s, unknown=%d", jpegBuffer, jpegBufferSize, imageBuffer, unknown));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegDecodeMJpeg jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        int width = this.jpegWidth;
        int height = this.jpegHeight;
        int bufferWidth = width;
        int pixelFormat = 3;
        sceMpeg.generateFakeImage(imageBuffer.getAddress(), bufferWidth, width, height, pixelFormat);
        VideoEngine.getInstance().addVideoTexture(imageBuffer.getAddress(), imageBuffer.getAddress() + bufferWidth * height * sceDisplay.getPixelFormatBytes(pixelFormat));
        return sceJpeg.getWidthHeight(width, height);
    }

    @HLEFunction(nid=-1892962286, version=271)
    public int sceJpeg_8F2BB012(TPointer jpegBuffer, int jpegBufferSize, @CanBeNull TPointer32 unknown1, int unknown2) {
        log.warn((Object)String.format("Unimplemented sceJpeg_8F2BB012 jpegBuffer=%s, jpegBufferSize=%d, unknown1=%s, unknown2=%d", jpegBuffer, jpegBufferSize, unknown1, unknown2));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpeg_8F2BB012 jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
            this.dumpJpegImage(jpegBuffer, jpegBufferSize);
        }
        if (!unknown1.isNull()) {
            unknown1.setValue(131586);
        }
        int yCbCrBufferSize = 49152;
        return yCbCrBufferSize;
    }

    @HLEFunction(nid=1743842692, version=271)
    public int sceJpeg_67F0ED84(TPointer imageBuffer, TPointer sourceBuffer, int widthHeight, int bufferWidth, int unknown) {
        int height = widthHeight & 0xFFF;
        int width = widthHeight >> 16 & 0xFFF;
        int pixelFormat = 3;
        log.warn((Object)String.format("Unimplemented sceJpeg_67F0ED84 imageBuffer=%s, sourceBuffer=%s, widthHeight=0x%08X(width=%d, height=%d), bufferWidth=%d, unknown=0x%08X", imageBuffer, sourceBuffer, widthHeight, width, height, bufferWidth, unknown));
        sceMpeg.generateFakeImage(imageBuffer.getAddress(), bufferWidth, width, height, pixelFormat);
        VideoEngine.getInstance().addVideoTexture(imageBuffer.getAddress(), imageBuffer.getAddress() + bufferWidth * height * sceDisplay.getPixelFormatBytes(pixelFormat));
        return 0;
    }
}

