/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.connector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.State;
import jpcsp.connector.Connector;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.util.Utilities;

public class PGDFileConnector {
    public static final String encryptedFileName = "PGDfile.raw";
    public static final String decryptedFileName = "PGDfile.raw.decrypted";
    public String id;

    public String getBaseDirectory(String id) {
        return String.format("%s%s%cPGD%c%s%c", Connector.baseDirectory, State.discId, Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar), id, Character.valueOf(File.separatorChar));
    }

    public String generateID(int startSector) {
        return String.format("File-%d", startSector);
    }

    public String getCompleteFileName(String fileName) {
        String completeFileName = String.format("%s%s", this.getBaseDirectory(this.id), fileName);
        return completeFileName;
    }

    protected void generateCommandFile(String keyHex) {
        try {
            PrintWriter command = new PrintWriter(String.format("%s%s", this.getBaseDirectory(this.id), "command.txt"));
            command.println("DecryptPGD");
            command.println("ms0:/tmp/PGDfile.raw " + keyHex);
            command.println("Exit");
            command.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public SeekableDataInput loadDecryptedPGDFile(String fileName) {
        SeekableRandomFile fileInput = null;
        SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(fileName);
        if (stat != null) {
            int startSector = stat.getReserved(0);
            this.id = this.generateID(startSector);
            String decryptedCompleteFileName = this.getCompleteFileName(decryptedFileName);
            File decryptedFile = new File(decryptedCompleteFileName);
            if (decryptedFile.canRead() && decryptedFile.length() > 0L) {
                try {
                    fileInput = new SeekableRandomFile(decryptedFile, "r");
                    Modules.log.info((Object)("Using decrypted file " + decryptedCompleteFileName));
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return fileInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractPGDFile(String fileName, SeekableDataInput fileInput, String keyHex) {
        Modules.log.info((Object)String.format("decryptPGDFile(fileName='%s', key=%s)", fileName, keyHex));
        SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(fileName);
        if (stat != null) {
            int startSector = stat.getReserved(0);
            this.id = this.generateID(startSector);
            new File(this.getBaseDirectory(this.id)).mkdirs();
            this.generateCommandFile(keyHex);
            FileOutputStream outputFile = null;
            try {
                int length;
                outputFile = new FileOutputStream(this.getCompleteFileName(encryptedFileName));
                byte[] buffer = new byte[102400];
                long fileLength = fileInput.length();
                for (long readLength = 0L; readLength < fileLength; readLength += (long)length) {
                    long restLength = fileLength - readLength;
                    length = buffer.length;
                    if (restLength < (long)length) {
                        length = (int)restLength;
                    }
                    fileInput.readFully(buffer, 0, length);
                    ((OutputStream)outputFile).write(buffer, 0, length);
                }
                fileInput.seek(0L);
                String msg = "";
                msg = msg + "This application contains a PGD file.\n";
                msg = msg + "Copy the following 2 files\n";
                msg = msg + "    " + this.getCompleteFileName(encryptedFileName) + "\n";
                msg = msg + "    " + this.getBaseDirectory(this.id) + "command.txt" + "\n";
                msg = msg + "to your PSP under\n";
                msg = msg + "    ms0:/tmp/\n";
                msg = msg + "and run the 'Jpcsp Connector 3xx' on your PSP.\n";
                msg = msg + "Decrypting might take a while on your PSP.\n";
                msg = msg + "When the JpcspConnector is done, copy back the PSP file\n";
                msg = msg + "    ms0:/tmp/PGDfile.raw.decrypted\n";
                msg = msg + "to Jpcsp\n";
                msg = msg + "    " + this.getCompleteFileName(decryptedFileName) + "\n";
                msg = msg + "Afterwards, you can delete the files on your PSP.\n";
                msg = msg + "Now run the application again in Jpcsp.\n";
                JOptionPane.showMessageDialog(null, msg);
            }
            catch (IOException e) {
                try {
                    Modules.log.error((Object)e);
                }
                catch (Throwable throwable) {
                    Utilities.close(outputFile);
                    throw throwable;
                }
                Utilities.close(outputFile);
            }
            Utilities.close(outputFile);
        }
    }
}

