/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.graphics.RE.BaseRenderingEngineFunction;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.ShaderContext;
import jpcsp.graphics.RE.ShaderContextUBO;
import jpcsp.graphics.RE.ShaderProgram;
import jpcsp.graphics.RE.ShaderProgramManager;
import jpcsp.graphics.Uniforms;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.textures.FBTexture;
import jpcsp.graphics.textures.GETexture;
import jpcsp.graphics.textures.Texture;
import jpcsp.graphics.textures.TextureCache;
import jpcsp.settings.Settings;
import jpcsp.util.CpuDurationStatistics;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;

public class REShader
extends BaseRenderingEngineFunction {
    protected static final int ACTIVE_TEXTURE_NORMAL = 0;
    protected static final int ACTIVE_TEXTURE_CLUT = 1;
    protected static final int ACTIVE_TEXTURE_FRAMEBUFFER = 2;
    protected static final float[] positionScale = new float[]{1.0f, 127.0f, 32767.0f, 1.0f};
    protected static final float[] normalScale = new float[]{1.0f, 127.0f, 32767.0f, 1.0f};
    protected static final float[] textureScale = new float[]{1.0f, 128.0f, 32768.0f, 1.0f};
    protected static final float[] weightScale = new float[]{1.0f, 128.0f, 32768.0f, 1.0f};
    protected static final String attributeNameTexture = "pspTexture";
    protected static final String attributeNameColor = "pspColor";
    protected static final String attributeNameNormal = "pspNormal";
    protected static final String attributeNamePosition = "pspPosition";
    protected static final String attributeNameWeights1 = "pspWeights1";
    protected static final String attributeNameWeights2 = "pspWeights2";
    protected ShaderContext shaderContext;
    protected ShaderProgram defaultShaderProgram;
    protected ShaderProgram defaultSpriteShaderProgram;
    protected int numberOfWeightsForShader;
    protected static final int spriteGeometryShaderInputType = 1;
    protected static final int spriteGeometryShaderOutputType = 4;
    protected boolean useGeometryShader;
    protected boolean useUniformBufferObject = true;
    protected boolean useNativeClut;
    protected boolean useShaderDepthTest = false;
    protected boolean useShaderStencilTest = false;
    protected boolean useShaderColorMask = false;
    protected boolean useShaderAlphaTest = false;
    protected boolean useShaderBlendTest = false;
    protected boolean useRenderToTexture = false;
    protected int clutTextureId = -1;
    protected ByteBuffer clutBuffer;
    protected DurationStatistics textureCacheLookupStatistics = new CpuDurationStatistics("Lookup in TextureCache for CLUTs");
    protected String shaderStaticDefines;
    protected String shaderDummyDynamicDefines;
    protected int shaderVersion = 120;
    protected ShaderProgramManager shaderProgramManager;
    protected boolean useDynamicShaders;
    protected ShaderProgram currentShaderProgram;
    protected StringBuilder infoLogs;
    protected GETexture fbTexture;
    protected boolean stencilTestFlag;
    protected int viewportWidth;
    protected int viewportHeight;
    protected FBTexture renderTexture;

    public REShader(IRenderingEngine proxy) {
        super(proxy);
        this.initShader();
    }

    protected void initShader() {
        log.info((Object)"Using shaders with Skinning");
        this.useDynamicShaders = Settings.getInstance().readBool("emu.enabledynamicshaders");
        if (this.useDynamicShaders) {
            log.info((Object)"Using dynamic shaders");
            this.shaderProgramManager = new ShaderProgramManager();
        }
        this.useGeometryShader = Settings.getInstance().readBool("emu.useGeometryShader");
        if (!this.re.isExtensionAvailable("GL_ARB_geometry_shader4")) {
            this.useGeometryShader = false;
        }
        if (this.useGeometryShader) {
            log.info((Object)"Using Geometry Shader for SPRITES");
        }
        if (!ShaderContextUBO.useUBO(this.re)) {
            this.useUniformBufferObject = false;
        }
        if (this.useUniformBufferObject) {
            log.info((Object)"Using Uniform Buffer Object (UBO)");
        }
        this.useNativeClut = Settings.getInstance().readBool("emu.enablenativeclut");
        if (this.useNativeClut) {
            if (!super.canNativeClut(0)) {
                log.warn((Object)"Disabling Native Color Lookup Tables (CLUT)");
                this.useNativeClut = false;
            } else {
                log.info((Object)"Using Native Color Lookup Tables (CLUT)");
            }
        }
        this.useShaderStencilTest = Settings.getInstance().readBool("emu.enableshaderstenciltest");
        this.useShaderColorMask = Settings.getInstance().readBool("emu.enableshadercolormask");
        this.shaderContext = this.useUniformBufferObject ? new ShaderContextUBO(this.re) : new ShaderContext();
        if (this.useShaderStencilTest) {
            this.useShaderAlphaTest = true;
            this.useShaderBlendTest = true;
            this.useShaderDepthTest = true;
        }
        if (this.useShaderStencilTest || this.useShaderBlendTest || this.useShaderColorMask) {
            if (this.re.isFramebufferObjectAvailable()) {
                this.useRenderToTexture = true;
                log.info((Object)"Rendering to a texture");
            } else {
                log.info((Object)"Not rendering to a texture, FBO's are not supported by your graphics card. This will have a negative performance impact.");
            }
        }
        this.initShadersDefines();
        this.loadShaders();
        if (this.defaultShaderProgram == null) {
            return;
        }
        this.shaderContext.setColorDoubling(1.0f);
        this.shaderContext.setTex(0);
        this.shaderContext.setFbTex(2);
        if (this.useNativeClut) {
            this.shaderContext.setClut(1);
            this.shaderContext.setUtex(0);
            this.clutBuffer = ByteBuffer.allocateDirect(16384).order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    protected boolean isValidShader() {
        return this.defaultShaderProgram != null;
    }

    protected static void addDefine(StringBuilder defines, String name, String value) {
        defines.append(String.format("#define %s %s%s", name, REShader.escapeString(value), System.getProperty("line.separator")));
    }

    protected static void addDefine(StringBuilder defines, String name, int value) {
        REShader.addDefine(defines, name, Integer.toString(value));
    }

    protected static void addDefine(StringBuilder defines, String name, boolean value) {
        REShader.addDefine(defines, name, value ? 1 : 0);
    }

    protected void replace(StringBuilder s, String oldText, String newText) {
        int offset = s.indexOf(oldText);
        if (offset >= 0) {
            s.replace(offset, offset + oldText.length(), newText);
        }
    }

    protected static String escapeString(String s) {
        return s.replace('\n', ' ');
    }

    protected int getAvailableShadingLanguageVersion() {
        int availableVersion = 0;
        String shadingLanguageVersion = this.re.getShadingLanguageVersion();
        if (shadingLanguageVersion == null) {
            return availableVersion;
        }
        Matcher matcher = Pattern.compile("(\\d+)\\.(\\d+).*").matcher(shadingLanguageVersion);
        if (!matcher.matches()) {
            log.error((Object)String.format("Cannot parse Shading Language Version '%s'", shadingLanguageVersion));
            return availableVersion;
        }
        try {
            int majorNumber = Integer.parseInt(matcher.group(1));
            int minorNumber = Integer.parseInt(matcher.group(2));
            availableVersion = majorNumber * 100 + minorNumber;
        }
        catch (NumberFormatException e) {
            log.error((Object)String.format("Cannot parse Shading Language Version '%s'", shadingLanguageVersion));
        }
        return availableVersion;
    }

    protected void initShadersDefines() {
        StringBuilder staticDefines = new StringBuilder();
        if (this.getAvailableShadingLanguageVersion() >= 140) {
            this.shaderVersion = Math.max(140, this.shaderVersion);
        }
        REShader.addDefine(staticDefines, "USE_GEOMETRY_SHADER", this.useGeometryShader);
        REShader.addDefine(staticDefines, "USE_UBO", this.useUniformBufferObject);
        if (this.useUniformBufferObject) {
            this.shaderVersion = Math.max(140, this.shaderVersion);
            REShader.addDefine(staticDefines, "UBO_STRUCTURE", ((ShaderContextUBO)this.shaderContext).getShaderUniformText());
        }
        REShader.addDefine(staticDefines, "USE_NATIVE_CLUT", this.useNativeClut);
        if (this.useNativeClut) {
            this.shaderVersion = Math.max(130, this.shaderVersion);
        }
        if (this.useShaderStencilTest || this.useShaderBlendTest || this.useShaderColorMask) {
            this.shaderVersion = Math.max(130, this.shaderVersion);
        }
        boolean useBitOperators = this.re.isExtensionAvailable("GL_EXT_gpu_shader4");
        REShader.addDefine(staticDefines, "USE_BIT_OPERATORS", useBitOperators);
        if (!useBitOperators) {
            log.info((Object)"Extension GL_EXT_gpu_shader4 not available: not using bit operators in shader");
        }
        this.shaderStaticDefines = staticDefines.toString();
        this.shaderDummyDynamicDefines = ShaderProgram.getDummyDynamicDefines();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Using shader version %d, available shading language version %d", this.shaderVersion, this.getAvailableShadingLanguageVersion()));
        }
    }

    protected void preprocessShader(StringBuilder src, ShaderProgram shaderProgram) {
        boolean useDynamicDefines;
        StringBuilder defines = new StringBuilder(this.shaderStaticDefines);
        if (shaderProgram != null) {
            defines.append(shaderProgram.getDynamicDefines());
            useDynamicDefines = true;
        } else {
            defines.append(this.shaderDummyDynamicDefines);
            useDynamicDefines = false;
        }
        REShader.addDefine(defines, "USE_DYNAMIC_DEFINES", useDynamicDefines);
        this.replace(src, "// INSERT VERSION", String.format("#version %d", this.shaderVersion));
        this.replace(src, "// INSERT DEFINES", defines.toString());
    }

    protected boolean loadShader(int shader, String resourceName, boolean silentError, ShaderProgram shaderProgram) {
        boolean compiled;
        StringBuilder src = new StringBuilder();
        try {
            InputStream resourceStream = this.getClass().getResourceAsStream(resourceName);
            if (resourceStream == null) {
                return false;
            }
            src.append(Utilities.toString(resourceStream, true));
        }
        catch (IOException e) {
            log.error((Object)e);
            return false;
        }
        this.preprocessShader(src, shaderProgram);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Compiling shader %d from %s:\n%s", shader, resourceName, src.toString()));
        }
        if ((compiled = this.re.compilerShader(shader, src.toString())) || !silentError) {
            this.addShaderInfoLog(shader);
        }
        return compiled;
    }

    protected boolean linkShaderProgram(int program) {
        boolean linked = this.re.linkProgram(program);
        this.addProgramInfoLog(program);
        this.re.setUniform(this.re.getUniformLocation(program, Uniforms.tex.getUniformString()), 0);
        boolean validated = this.re.validateProgram(program);
        this.addProgramInfoLog(program);
        return linked && validated;
    }

    protected ShaderProgram createShader(boolean hasGeometryShader, ShaderProgram shaderProgram) {
        this.infoLogs = new StringBuilder();
        int programId = this.tryCreateShader(hasGeometryShader, shaderProgram);
        if (programId == -1) {
            this.printInfoLog(true);
            shaderProgram = null;
        } else {
            if (shaderProgram == null) {
                shaderProgram = new ShaderProgram();
            }
            shaderProgram.setProgramId(this.re, programId);
            this.printInfoLog(false);
        }
        return shaderProgram;
    }

    private int tryCreateShader(boolean hasGeometryShader, ShaderProgram shaderProgram) {
        int vertexShader = this.re.createShader(0);
        int fragmentShader = this.re.createShader(1);
        if (!this.loadShader(vertexShader, "/jpcsp/graphics/shader.vert", false, shaderProgram)) {
            return -1;
        }
        if (!this.loadShader(fragmentShader, "/jpcsp/graphics/shader.frag", false, shaderProgram)) {
            return -1;
        }
        int program = this.re.createProgram();
        this.re.attachShader(program, vertexShader);
        this.re.attachShader(program, fragmentShader);
        if (hasGeometryShader) {
            int geometryShader = this.re.createShader(2);
            boolean compiled = this.loadShader(geometryShader, "/jpcsp/graphics/shader-150.geom", false, shaderProgram);
            if (compiled) {
                log.info((Object)"Using Geometry Shader shader-150.geom");
            } else {
                compiled = this.loadShader(geometryShader, "/jpcsp/graphics/shader-120.geom", false, shaderProgram);
                if (compiled) {
                    log.info((Object)"Using Geometry Shader shader-120.geom");
                }
            }
            if (!compiled) {
                return -1;
            }
            this.re.attachShader(program, geometryShader);
            this.re.setProgramParameter(program, 0, 1);
            this.re.setProgramParameter(program, 1, 4);
            this.re.setProgramParameter(program, 2, 4);
        }
        int index = 0;
        this.re.bindAttribLocation(program, index++, attributeNamePosition);
        this.re.bindAttribLocation(program, index++, attributeNameTexture);
        this.re.bindAttribLocation(program, index++, attributeNameColor);
        this.re.bindAttribLocation(program, index++, attributeNameNormal);
        this.re.bindAttribLocation(program, index++, attributeNameWeights1);
        this.re.bindAttribLocation(program, index++, attributeNameWeights2);
        boolean linked = this.linkShaderProgram(program);
        if (!linked) {
            return -1;
        }
        this.re.useProgram(program);
        if (log.isDebugEnabled()) {
            int shaderAttribWeights1 = this.re.getAttribLocation(program, attributeNameWeights1);
            int shaderAttribWeights2 = this.re.getAttribLocation(program, attributeNameWeights2);
            int shaderAttribPosition = this.re.getAttribLocation(program, attributeNamePosition);
            int shaderAttribNormal = this.re.getAttribLocation(program, attributeNameNormal);
            int shaderAttribColor = this.re.getAttribLocation(program, attributeNameColor);
            int shaderAttribTexture = this.re.getAttribLocation(program, attributeNameTexture);
            log.debug((Object)String.format("Program %d attribute locations: weights1=%d, weights2=%d, position=%d, normal=%d, color=%d, texture=%d", program, shaderAttribWeights1, shaderAttribWeights2, shaderAttribPosition, shaderAttribNormal, shaderAttribColor, shaderAttribTexture));
        }
        for (Uniforms uniform : Uniforms.values()) {
            uniform.allocateId(this.re, program);
        }
        this.shaderContext.initShaderProgram(this.re, program);
        return program;
    }

    protected void loadShaders() {
        this.defaultShaderProgram = this.createShader(false, null);
        if (this.defaultShaderProgram != null) {
            if (this.useGeometryShader) {
                this.defaultSpriteShaderProgram = this.createShader(true, null);
            }
            this.defaultShaderProgram.use(this.re);
        }
        if (this.defaultSpriteShaderProgram == null) {
            this.useGeometryShader = false;
        }
    }

    public static boolean useShaders(IRenderingEngine re) {
        if (!Settings.getInstance().readBool("emu.useshaders")) {
            return false;
        }
        if (!re.isShaderAvailable()) {
            log.info((Object)"Shaders are not available on your computer. They have been automatically disabled.");
            return false;
        }
        REShader reTestShader = new REShader(re);
        if (!reTestShader.isValidShader()) {
            log.warn((Object)"Shaders do not run correctly on your computer. They have been automatically disabled.");
            return false;
        }
        return true;
    }

    protected void printInfoLog(boolean isError) {
        if (this.infoLogs != null && this.infoLogs.length() > 0) {
            if (isError) {
                log.error((Object)("Shader error log: " + this.infoLogs));
            } else {
                String infoLog = this.infoLogs.toString();
                infoLog = infoLog.replace("Vertex shader was successfully compiled to run on hardware.\n", "");
                infoLog = infoLog.replace("Fragment shader was successfully compiled to run on hardware.\n", "");
                infoLog = infoLog.replace("Geometry shader was successfully compiled to run on hardware.\n", "");
                infoLog = infoLog.replace("Fragment shader(s) linked, vertex shader(s) linked. \n", "");
                infoLog = infoLog.replace("Vertex shader(s) linked, fragment shader(s) linked. \n", "");
                infoLog = infoLog.replace("Vertex shader(s) linked, fragment shader(s) linked.\n", "");
                if ((infoLog = infoLog.replace("Validation successful.\n", "")).length() > 0) {
                    log.warn((Object)("Shader log: " + infoLog));
                }
            }
        }
    }

    protected void addInfoLog(String infoLog) {
        if (infoLog != null && infoLog.length() > 0) {
            this.infoLogs.append(infoLog);
        }
    }

    protected void addShaderInfoLog(int shader) {
        String infoLog = this.re.getShaderInfoLog(shader);
        this.addInfoLog(infoLog);
    }

    protected void addProgramInfoLog(int program) {
        String infoLog = this.re.getProgramInfoLog(program);
        this.addInfoLog(infoLog);
    }

    protected boolean setShaderFlag(int flag, int value) {
        boolean setFlag = true;
        switch (flag) {
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.shaderContext.setLightEnabled(flag - 11, value);
                setFlag = false;
                break;
            }
            case 17: {
                this.shaderContext.setCtestEnable(value);
                setFlag = false;
                break;
            }
            case 10: {
                this.shaderContext.setLightingEnable(value);
                setFlag = false;
                break;
            }
            case 9: {
                this.shaderContext.setTexEnable(value);
                break;
            }
            case 1: {
                if (!this.useShaderDepthTest) break;
                this.shaderContext.setDepthTestEnable(value);
                break;
            }
            case 3: {
                if (!this.useShaderStencilTest) break;
                this.shaderContext.setStencilTestEnable(value);
                this.stencilTestFlag = value != 0;
                this.setAlphaMask(this.stencilTestFlag);
                setFlag = false;
                break;
            }
            case 0: {
                if (!this.useShaderAlphaTest) break;
                this.shaderContext.setAlphaTestEnable(value);
                setFlag = false;
                break;
            }
            case 4: {
                if (!this.useShaderBlendTest) break;
                this.shaderContext.setBlendTestEnable(value);
                setFlag = false;
            }
        }
        return setFlag;
    }

    @Override
    public void exit() {
        super.exit();
    }

    @Override
    public void enableFlag(int flag) {
        if (this.canUpdateFlag(flag) && this.setShaderFlag(flag, 1)) {
            super.enableFlag(flag);
        }
    }

    @Override
    public void disableFlag(int flag) {
        if (this.canUpdateFlag(flag) && this.setShaderFlag(flag, 0)) {
            super.disableFlag(flag);
        }
    }

    @Override
    public void setDepthRange(float zpos, float zscale, float near, float far) {
        this.shaderContext.setZPos(zpos);
        this.shaderContext.setZScale(zscale);
        super.setDepthRange(zpos, zscale, near, far);
    }

    @Override
    public void setLightMode(int mode) {
        this.shaderContext.setLightMode(mode);
        super.setLightMode(mode);
    }

    @Override
    public void setLightType(int light, int type, int kind) {
        this.shaderContext.setLightType(light, type);
        this.shaderContext.setLightKind(light, kind);
        super.setLightType(light, type, kind);
    }

    @Override
    public void setTextureEnvironmentMapping(int u, int v) {
        this.shaderContext.setTexShade(0, u);
        this.shaderContext.setTexShade(1, v);
        super.setTextureEnvironmentMapping(u, v);
    }

    @Override
    public void setColorTestFunc(int func) {
        this.shaderContext.setCtestFunc(func);
        super.setColorTestFunc(func);
    }

    @Override
    public void setColorTestMask(int[] values) {
        this.shaderContext.setCtestMsk(0, values[0]);
        this.shaderContext.setCtestMsk(1, values[1]);
        this.shaderContext.setCtestMsk(2, values[2]);
        super.setColorTestMask(values);
    }

    @Override
    public void setColorTestReference(int[] values) {
        this.shaderContext.setCtestRef(0, values[0]);
        this.shaderContext.setCtestRef(1, values[1]);
        this.shaderContext.setCtestRef(2, values[2]);
        super.setColorTestReference(values);
    }

    @Override
    public void setTextureFunc(int func, boolean alphaUsed, boolean colorDoubled) {
        this.shaderContext.setTexEnvMode(0, func);
        this.shaderContext.setTexEnvMode(1, alphaUsed ? 1 : 0);
        this.shaderContext.setColorDoubling(colorDoubled ? 2.0f : 1.0f);
        super.setTextureFunc(func, alphaUsed, colorDoubled);
    }

    @Override
    public int setBones(int count, float[] values) {
        this.shaderContext.setNumberBones(count);
        this.shaderContext.setBoneMatrix(count, values);
        this.numberOfWeightsForShader = count;
        super.setBones(count, values);
        return this.numberOfWeightsForShader;
    }

    @Override
    public void setTextureMapMode(int mode, int proj) {
        this.shaderContext.setTexMapMode(mode);
        this.shaderContext.setTexMapProj(proj);
        super.setTextureMapMode(mode, proj);
    }

    @Override
    public void setColorMaterial(boolean ambient, boolean diffuse, boolean specular) {
        this.shaderContext.setMatFlags(0, ambient ? 1 : 0);
        this.shaderContext.setMatFlags(1, diffuse ? 1 : 0);
        this.shaderContext.setMatFlags(2, specular ? 1 : 0);
        super.setColorMaterial(ambient, diffuse, specular);
    }

    @Override
    public void startDisplay() {
        this.re.useProgram(this.defaultShaderProgram.getProgramId());
        if (this.useRenderToTexture) {
            sceDisplay display = Modules.sceDisplayModule;
            int width = display.getWidthFb();
            int height = display.getHeightFb();
            int bufferWidth = display.getBufferWidthFb();
            int pixelFormat = display.getPixelFormatFb();
            if (this.renderTexture != null && !this.renderTexture.isCompatible(width, height, bufferWidth, pixelFormat)) {
                this.renderTexture.delete(this.re);
                this.renderTexture = null;
            }
            if (this.renderTexture == null) {
                this.renderTexture = new FBTexture(display.getTopAddrFb(), bufferWidth, width, height, pixelFormat);
                this.renderTexture.bind(this.re, false);
                this.re.bindActiveTexture(2, this.renderTexture.getTextureId());
            } else {
                this.renderTexture.bind(this.re, false);
            }
        }
        super.startDisplay();
        super.disableClientState(0);
        super.disableClientState(1);
        super.disableClientState(2);
        super.disableClientState(3);
    }

    @Override
    public void endDisplay() {
        if (this.useRenderToTexture) {
            this.renderTexture.copyTextureToScreen(this.re);
        }
        this.re.useProgram(0);
        super.endDisplay();
    }

    @Override
    public void enableClientState(int type) {
        switch (type) {
            case 3: {
                this.re.enableVertexAttribArray(this.currentShaderProgram.getShaderAttribPosition());
                if (this.numberOfWeightsForShader > 0) {
                    this.re.enableVertexAttribArray(this.currentShaderProgram.getShaderAttribWeights1());
                    if (this.numberOfWeightsForShader > 4) {
                        this.re.enableVertexAttribArray(this.currentShaderProgram.getShaderAttribWeights2());
                        break;
                    }
                    this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribWeights2());
                    break;
                }
                this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribWeights1());
                this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribWeights2());
                break;
            }
            case 2: {
                this.re.enableVertexAttribArray(this.currentShaderProgram.getShaderAttribNormal());
                break;
            }
            case 1: {
                this.re.enableVertexAttribArray(this.currentShaderProgram.getShaderAttribColor());
                break;
            }
            case 0: {
                this.re.enableVertexAttribArray(this.currentShaderProgram.getShaderAttribTexture());
            }
        }
    }

    @Override
    public void disableClientState(int type) {
        switch (type) {
            case 3: {
                this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribPosition());
                this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribWeights1());
                this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribWeights2());
                break;
            }
            case 2: {
                this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribNormal());
                break;
            }
            case 1: {
                this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribColor());
                break;
            }
            case 0: {
                this.re.disableVertexAttribArray(this.currentShaderProgram.getShaderAttribTexture());
            }
        }
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (size > 0) {
            this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribWeights1(), Math.min(size, 4), type, false, stride, bufferSize, buffer);
            if (size > 4) {
                this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribWeights2(), size - 4, type, false, stride, bufferSize, buffer);
            }
        }
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, long offset) {
        if (size > 0) {
            this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribWeights1(), Math.min(size, 4), type, false, stride, offset);
            if (size > 4) {
                this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribWeights2(), size - 4, type, false, stride, offset + (long)(sizeOfType[type] * 4));
            }
        }
    }

    @Override
    public boolean canAllNativeVertexInfo() {
        return true;
    }

    @Override
    public boolean canNativeSpritesPrimitive() {
        return this.useGeometryShader;
    }

    @Override
    public void setVertexInfo(VertexInfo vinfo, boolean allNativeVertexInfo, boolean useVertexColor, boolean useTexture, int type) {
        if (allNativeVertexInfo) {
            this.shaderContext.setWeightScale(weightScale[vinfo.weight]);
            this.shaderContext.setVinfoTexture(useTexture ? (vinfo.texture != 0 ? vinfo.texture : 3) : 0);
            this.shaderContext.setTextureScale(vinfo.transform2D ? 1.0f : textureScale[vinfo.texture]);
            this.shaderContext.setVinfoColor(useVertexColor ? vinfo.color : 8);
            this.shaderContext.setVinfoNormal(vinfo.normal);
            this.shaderContext.setNormalScale(vinfo.transform2D ? 1.0f : normalScale[vinfo.normal]);
            this.shaderContext.setVinfoPosition(vinfo.position);
            this.shaderContext.setPositionScale(vinfo.transform2D ? 1.0f : positionScale[vinfo.position]);
        } else {
            this.shaderContext.setWeightScale(1.0f);
            this.shaderContext.setVinfoTexture(useTexture ? 3 : 0);
            this.shaderContext.setTextureScale(1.0f);
            this.shaderContext.setVinfoColor(useVertexColor ? 0 : 8);
            this.shaderContext.setVinfoNormal(vinfo == null || vinfo.normal == 0 ? 0 : 3);
            this.shaderContext.setNormalScale(1.0f);
            this.shaderContext.setVinfoPosition(vinfo != null && vinfo.position == 0 ? 0 : 3);
            this.shaderContext.setPositionScale(1.0f);
        }
        this.shaderContext.setVinfoTransform2D(vinfo == null || vinfo.transform2D ? 1 : 0);
        this.setCurrentShaderProgram(type);
        super.setVertexInfo(vinfo, allNativeVertexInfo, useVertexColor, useTexture, type);
    }

    private void setCurrentShaderProgram(int type) {
        ShaderProgram shaderProgram;
        boolean hasGeometryShader;
        boolean bl = hasGeometryShader = type == 6;
        if (this.useDynamicShaders) {
            shaderProgram = this.shaderProgramManager.getShaderProgram(this.shaderContext, hasGeometryShader);
            if (shaderProgram.getProgramId() == -1) {
                shaderProgram = this.createShader(hasGeometryShader, shaderProgram);
                if (VideoEngine.log.isDebugEnabled()) {
                    VideoEngine.log.debug((Object)("Created shader " + shaderProgram));
                }
                if (shaderProgram == null) {
                    VideoEngine.log.error((Object)"Cannot create shader");
                    return;
                }
            }
            shaderProgram.use(this.re);
        } else {
            shaderProgram = hasGeometryShader ? this.defaultSpriteShaderProgram : this.defaultShaderProgram;
        }
        shaderProgram.use(this.re);
        if (VideoEngine.log.isTraceEnabled()) {
            VideoEngine.log.trace((Object)("Using shader " + shaderProgram));
        }
        this.currentShaderProgram = shaderProgram;
    }

    private boolean isFbTextureNeeded() {
        if (this.useShaderDepthTest && this.shaderContext.getDepthTestEnable() != 0) {
            return true;
        }
        if (this.useShaderStencilTest && this.shaderContext.getStencilTestEnable() != 0) {
            return true;
        }
        if (this.useShaderBlendTest && this.shaderContext.getBlendTestEnable() != 0) {
            return true;
        }
        return this.useShaderColorMask && this.shaderContext.getColorMaskEnable() != 0;
    }

    private void loadFbTexture() {
        if (!this.isFbTextureNeeded()) {
            return;
        }
        int width = this.viewportWidth;
        int height = this.viewportHeight;
        int bufferWidth = this.context.fbw;
        int pixelFormat = this.context.psm;
        if (this.useRenderToTexture && this.renderTexture.getResizedWidth() >= width && this.renderTexture.getResizedHeight() >= height && this.renderTexture.getBufferWidth() >= bufferWidth && this.renderTexture.getPixelFormat() == pixelFormat) {
            this.re.bindActiveTexture(2, this.renderTexture.getTextureId());
            return;
        }
        if (this.fbTexture != null && !this.fbTexture.isCompatible(width, height, bufferWidth, pixelFormat)) {
            this.fbTexture.delete(this.re);
            this.fbTexture = null;
        }
        if (this.fbTexture == null) {
            this.fbTexture = new GETexture(Modules.sceDisplayModule.getTopAddrGe(), bufferWidth, width, height, pixelFormat, true);
        }
        this.re.setActiveTexture(2);
        this.fbTexture.copyScreenToTexture(this.re);
        this.re.setActiveTexture(0);
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribPosition(), size, type, false, stride, bufferSize, buffer);
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, long offset) {
        this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribPosition(), size, type, false, stride, offset);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribColor(), size, type, false, stride, bufferSize, buffer);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, long offset) {
        this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribColor(), size, type, false, stride, offset);
    }

    @Override
    public void setNormalPointer(int type, int stride, int bufferSize, Buffer buffer) {
        this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribNormal(), 3, type, false, stride, bufferSize, buffer);
    }

    @Override
    public void setNormalPointer(int type, int stride, long offset) {
        this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribNormal(), 3, type, false, stride, offset);
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribTexture(), size, type, false, stride, bufferSize, buffer);
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, long offset) {
        this.re.setVertexAttribPointer(this.currentShaderProgram.getShaderAttribTexture(), size, type, false, stride, offset);
    }

    @Override
    public void drawArrays(int type, int first, int count) {
        if (type == 6) {
            type = 1;
        }
        this.shaderContext.setUniforms(this.re, this.currentShaderProgram.getProgramId());
        this.loadFbTexture();
        super.drawArrays(type, first, count);
    }

    @Override
    public void drawArraysBurstMode(int type, int first, int count) {
        if (type == 6) {
            type = 1;
        }
        this.loadFbTexture();
        super.drawArraysBurstMode(type, first, count);
    }

    @Override
    public boolean canNativeClut(int textureAddress) {
        return this.useNativeClut;
    }

    private int getClutIndexHint(int pixelFormat, int numEntries) {
        if (this.context.tex_clut_start == 0 && this.context.tex_clut_mask == numEntries - 1) {
            int currentBit = 0;
            if (this.context.tex_clut_shift == currentBit) {
                return 1;
            }
            block0 : switch (pixelFormat) {
                case 11: {
                    currentBit += 5;
                    break;
                }
                case 12: {
                    currentBit += 5;
                    break;
                }
                case 13: {
                    currentBit += 4;
                    break;
                }
                case 14: {
                    currentBit += 8;
                    break;
                }
                default: {
                    switch (this.context.tex_clut_mode) {
                        case 0: {
                            currentBit += 5;
                            break block0;
                        }
                        case 1: {
                            currentBit += 5;
                            break block0;
                        }
                        case 2: {
                            currentBit += 4;
                            break block0;
                        }
                        case 3: {
                            currentBit += 8;
                        }
                    }
                }
            }
            if (this.context.tex_clut_shift == currentBit) {
                return 2;
            }
            block12 : switch (pixelFormat) {
                case 11: {
                    currentBit += 6;
                    break;
                }
                case 12: {
                    currentBit += 5;
                    break;
                }
                case 13: {
                    currentBit += 4;
                    break;
                }
                case 14: {
                    currentBit += 8;
                    break;
                }
                default: {
                    switch (this.context.tex_clut_mode) {
                        case 0: {
                            currentBit += 6;
                            break block12;
                        }
                        case 1: {
                            currentBit += 5;
                            break block12;
                        }
                        case 2: {
                            currentBit += 4;
                            break block12;
                        }
                        case 3: {
                            currentBit += 8;
                        }
                    }
                }
            }
            if (this.context.tex_clut_shift == currentBit) {
                return 3;
            }
            block24 : switch (pixelFormat) {
                case 11: {
                    currentBit += 5;
                    break;
                }
                case 12: {
                    currentBit += 5;
                    break;
                }
                case 13: {
                    currentBit += 4;
                    break;
                }
                case 14: {
                    currentBit += 8;
                    break;
                }
                default: {
                    switch (this.context.tex_clut_mode) {
                        case 0: {
                            currentBit += 5;
                            break block24;
                        }
                        case 1: {
                            currentBit += 5;
                            break block24;
                        }
                        case 2: {
                            currentBit += 4;
                            break block24;
                        }
                        case 3: {
                            currentBit += 8;
                        }
                    }
                }
            }
            if (this.context.tex_clut_shift == currentBit) {
                return 4;
            }
        }
        return 0;
    }

    private void loadClut(int pixelFormat) {
        int numEntries = VideoEngine.getInstance().getClutNumEntries();
        int clutPixelFormat = this.context.tex_clut_mode;
        int bytesPerEntry = sizeOfTextureType[clutPixelFormat];
        this.shaderContext.setClutShift(this.context.tex_clut_shift);
        this.shaderContext.setClutMask(this.context.tex_clut_mask);
        this.shaderContext.setClutOffset(this.context.tex_clut_start << 4);
        this.shaderContext.setMipmapShareClut(this.context.mipmapShareClut);
        this.shaderContext.setClutIndexHint(this.getClutIndexHint(pixelFormat, numEntries));
        int[] clut32 = bytesPerEntry == 4 ? VideoEngine.getInstance().readClut32(0) : null;
        short[] clut16 = bytesPerEntry == 2 ? VideoEngine.getInstance().readClut16(0) : null;
        TextureCache textureCache = TextureCache.getInstance();
        this.textureCacheLookupStatistics.start();
        Texture texture = textureCache.getTexture(this.context.tex_clut_addr, numEntries, numEntries, 1, clutPixelFormat, 0, 0, 0, 0, 0, 0, 0, false, clut16, clut32);
        this.textureCacheLookupStatistics.end();
        if (texture == null) {
            texture = new Texture(textureCache, this.context.tex_clut_addr, numEntries, numEntries, 1, clutPixelFormat, 0, 0, 0, 0, 0, 0, 0, false, clut16, clut32);
            textureCache.addTexture(this.re, texture);
        }
        int textureId = texture.getTextureId(this.re);
        if (texture == null || !texture.isLoaded()) {
            this.re.setActiveTexture(1);
            this.re.bindTexture(textureId);
            this.clutBuffer.clear();
            if (clut32 != null) {
                this.clutBuffer.asIntBuffer().put(clut32, 0, numEntries);
            } else {
                this.clutBuffer.asShortBuffer().put(clut16, 0, numEntries);
            }
            this.re.setPixelStore(numEntries, bytesPerEntry);
            this.re.setTextureMipmapMagFilter(0);
            this.re.setTextureMipmapMinFilter(0);
            this.re.setTextureMipmapMinLevel(0);
            this.re.setTextureMipmapMaxLevel(0);
            this.re.setTextureWrapMode(1, 1);
            int clutSize = bytesPerEntry * numEntries;
            this.re.setTexImage(0, clutPixelFormat, numEntries, 1, clutPixelFormat, clutPixelFormat, clutSize, this.clutBuffer);
            if (texture != null) {
                texture.setIsLoaded();
            }
            this.re.setActiveTexture(0);
        } else {
            this.re.bindActiveTexture(1, textureId);
        }
    }

    @Override
    public void setTextureFormat(int pixelFormat, boolean swizzle) {
        if (isTextureTypeIndexed[pixelFormat]) {
            if (pixelFormat == 4) {
                pixelFormat = this.context.tex_clut_mode;
            } else if (!this.useNativeClut) {
                pixelFormat = this.context.tex_clut_mode;
            } else {
                this.loadClut(pixelFormat);
            }
        }
        this.shaderContext.setTexPixelFormat(pixelFormat);
        super.setTextureFormat(pixelFormat, swizzle);
    }

    @Override
    public void setVertexColor(float[] color) {
        this.shaderContext.setVertexColor(color);
        super.setVertexColor(color);
    }

    @Override
    public void setDepthFunc(int func) {
        if (this.useShaderDepthTest) {
            this.shaderContext.setDepthFunc(func);
        }
        super.setDepthFunc(func);
    }

    @Override
    public void setDepthMask(boolean depthWriteEnabled) {
        if (this.useShaderDepthTest) {
            this.shaderContext.setDepthMask(depthWriteEnabled ? 255 : 0);
        }
        super.setDepthMask(depthWriteEnabled);
    }

    @Override
    public void setStencilFunc(int func, int ref, int mask) {
        if (this.useShaderStencilTest) {
            this.shaderContext.setStencilFunc(func);
            this.shaderContext.setStencilRef(ref & mask);
            this.shaderContext.setStencilMask(mask);
        }
        super.setStencilFunc(func, ref, mask);
    }

    @Override
    public void setStencilOp(int fail, int zfail, int zpass) {
        if (this.useShaderStencilTest) {
            this.shaderContext.setStencilOpFail(fail);
            this.shaderContext.setStencilOpZFail(zfail);
            this.shaderContext.setStencilOpZPass(zpass);
        }
        super.setStencilOp(fail, zfail, zpass);
    }

    @Override
    public void bindTexture(int texture) {
        super.bindTexture(texture);
    }

    @Override
    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
        if (this.useShaderColorMask) {
            this.shaderContext.setColorMask(redMask, greenMask, blueMask, alphaMask);
            this.shaderContext.setNotColorMask(~redMask & 0xFF, ~greenMask & 0xFF, ~blueMask & 0xFF, ~alphaMask & 0xFF);
            this.shaderContext.setColorMaskEnable(redMask != 0 || greenMask != 0 || blueMask != 0 || alphaMask != 0 ? 1 : 0);
            this.proxy.setColorMask(redMask, greenMask, blueMask, alphaMask);
            this.re.setColorMask(redMask != 255, greenMask != 255, blueMask != 255, this.stencilTestFlag);
        } else {
            super.setColorMask(redMask, greenMask, blueMask, alphaMask);
        }
    }

    @Override
    public void setAlphaFunc(int func, int ref) {
        if (this.useShaderAlphaTest) {
            this.shaderContext.setAlphaTestFunc(func);
            this.shaderContext.setAlphaTestRef(ref);
        }
        super.setAlphaFunc(func, ref);
    }

    @Override
    public void setBlendEquation(int mode) {
        if (this.useShaderBlendTest) {
            this.shaderContext.setBlendEquation(mode);
        }
        super.setBlendEquation(mode);
    }

    @Override
    public void setBlendFunc(int src, int dst) {
        if (this.useShaderBlendTest) {
            this.shaderContext.setBlendSrc(src);
            this.shaderContext.setBlendDst(dst);
            this.proxy.setBlendFunc(src, dst);
        } else {
            super.setBlendFunc(src, dst);
        }
    }

    @Override
    public void setBlendSFix(int sfix, float[] color) {
        if (this.useShaderBlendTest) {
            this.shaderContext.setBlendSFix(color);
            this.proxy.setBlendSFix(sfix, color);
        } else {
            super.setBlendSFix(sfix, color);
        }
    }

    @Override
    public void setBlendDFix(int dfix, float[] color) {
        if (this.useShaderBlendTest) {
            this.shaderContext.setBlendDFix(color);
            this.proxy.setBlendDFix(dfix, color);
        } else {
            super.setBlendDFix(dfix, color);
        }
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        this.viewportWidth = width;
        this.viewportHeight = height;
        super.setViewport(x, y, width, height);
    }
}

