/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.graphics.RE.software.BasePrimitiveRenderer;
import jpcsp.graphics.RE.software.ColorDepth;
import jpcsp.graphics.RE.software.IRandomTextureAccess;
import jpcsp.graphics.RE.software.IRendererWriter;
import jpcsp.graphics.RE.software.Lighting;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.RE.software.PixelState;
import jpcsp.graphics.RE.software.PrimarySecondaryColors;
import jpcsp.graphics.RE.software.PrimitiveState;
import jpcsp.graphics.RE.software.RESoftware;
import jpcsp.graphics.RE.software.Rasterizer;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;

public class RendererTemplate {
    public static boolean hasMemInt;
    public static boolean needSourceDepthRead;
    public static boolean needDestinationDepthRead;
    public static boolean needDepthWrite;
    public static boolean needTextureUV;
    public static boolean simpleTextureUV;
    public static boolean swapTextureUV;
    public static boolean needScissoringX;
    public static boolean needScissoringY;
    public static boolean transform2D;
    public static boolean clearMode;
    public static boolean clearModeColor;
    public static boolean clearModeStencil;
    public static boolean clearModeDepth;
    public static int nearZ;
    public static int farZ;
    public static boolean colorTestFlagEnabled;
    public static int colorTestFunc;
    public static boolean alphaTestFlagEnabled;
    public static int alphaFunc;
    public static int alphaRef;
    public static boolean stencilTestFlagEnabled;
    public static int stencilFunc;
    public static int stencilRef;
    public static int stencilOpFail;
    public static int stencilOpZFail;
    public static int stencilOpZPass;
    public static boolean depthTestFlagEnabled;
    public static int depthFunc;
    public static boolean blendFlagEnabled;
    public static int blendEquation;
    public static int blendSrc;
    public static int blendDst;
    public static int sfix;
    public static int dfix;
    public static boolean colorLogicOpFlagEnabled;
    public static int logicOp;
    public static int colorMask;
    public static boolean depthMask;
    public static boolean textureFlagEnabled;
    public static boolean useVertexTexture;
    public static boolean lightingFlagEnabled;
    public static boolean sameVertexColor;
    public static boolean setVertexPrimaryColor;
    public static boolean primaryColorSetGlobally;
    public static boolean isTriangle;
    public static boolean matFlagAmbient;
    public static boolean matFlagDiffuse;
    public static boolean matFlagSpecular;
    public static boolean useVertexColor;
    public static boolean textureColorDoubled;
    public static int lightMode;
    public static int texMapMode;
    public static int texProjMapMode;
    public static float texTranslateX;
    public static float texTranslateY;
    public static float texScaleX;
    public static float texScaleY;
    public static int texWrapS;
    public static int texWrapT;
    public static int textureFunc;
    public static boolean textureAlphaUsed;
    public static int psm;
    public static int texMagFilter;
    public static boolean needTextureWrapU;
    public static boolean needTextureWrapV;
    public static boolean needSourceDepthClamp;
    public static boolean isLogTraceEnabled;
    public static boolean collectStatistics;
    private static final boolean resampleTextureForMag = true;
    private static DurationStatistics statistics;

    public RendererTemplate() {
        if (collectStatistics && statistics == null) {
            statistics = new DurationStatistics(String.format("Duration %s", this.getClass().getName()));
        }
    }

    public static boolean isRendererWriterNative(int[] memInt, int psm) {
        return memInt != null && psm == 3;
    }

    public DurationStatistics getStatistics() {
        return statistics;
    }

    public void render(BasePrimitiveRenderer renderer) {
        RendererTemplate.doRender(renderer);
    }

    private static void doRenderStart(BasePrimitiveRenderer renderer) {
        if (isLogTraceEnabled) {
            PrimitiveState prim = renderer.prim;
            String comment = isTriangle ? (transform2D ? "Triangle doRender 2D" : "Triangle doRender 3D") : (transform2D ? "Sprite doRender 2D" : "Sprite doRender 3D");
            VideoEngine.log.trace((Object)String.format("%s (%d,%d)-(%d,%d) skip=%d", comment, prim.pxMin, prim.pyMin, prim.pxMax, prim.pyMax, renderer.imageWriterSkipEOL));
        }
        renderer.preRender();
        if (collectStatistics) {
            if (isTriangle) {
                if (transform2D) {
                    RESoftware.triangleRender2DStatistics.start();
                } else {
                    RESoftware.triangleRender3DStatistics.start();
                }
            } else {
                RESoftware.spriteRenderStatistics.start();
            }
            statistics.start();
        }
    }

    private static void doRenderEnd(BasePrimitiveRenderer renderer) {
        if (collectStatistics) {
            statistics.end();
            if (isTriangle) {
                if (transform2D) {
                    RESoftware.triangleRender2DStatistics.end();
                } else {
                    RESoftware.triangleRender3DStatistics.end();
                }
            } else {
                RESoftware.spriteRenderStatistics.end();
            }
        }
        renderer.postRender();
    }

    private static IRandomTextureAccess resampleTexture(BasePrimitiveRenderer renderer) {
        IRandomTextureAccess textureAccess = renderer.textureAccess;
        renderer.prim.needResample = false;
        if (textureFlagEnabled && (!transform2D || useVertexTexture) && !clearMode && texMagFilter == 1) {
            PrimitiveState prim = renderer.prim;
            if (needTextureUV && simpleTextureUV && transform2D) {
                if (renderer.cachedTexture != null && (Math.abs(prim.uStep) != 1.0f || Math.abs(prim.vStep) != 1.0f)) {
                    prim.resampleFactorWidth = 1.0f / Math.abs(prim.uStep);
                    prim.resampleFactorHeight = 1.0f / Math.abs(prim.vStep);
                    if (renderer.cachedTexture.canResample(prim.resampleFactorWidth, prim.resampleFactorHeight)) {
                        prim.needResample = true;
                        prim.uStart *= prim.resampleFactorWidth;
                        prim.vStart *= prim.resampleFactorHeight;
                        prim.uStep = prim.uStep < 0.0f ? -1.0f : 1.0f;
                        prim.vStep = prim.vStep < 0.0f ? -1.0f : 1.0f;
                    } else if (isLogTraceEnabled) {
                        VideoEngine.log.trace((Object)String.format("Cannot resample with factors %f, %f", Float.valueOf(prim.resampleFactorWidth), Float.valueOf(prim.resampleFactorHeight)));
                    }
                }
            } else if (!transform2D && renderer.cachedTexture != null) {
                prim.resampleFactorWidth = 2.0f;
                prim.resampleFactorHeight = 2.0f;
                prim.needResample = renderer.cachedTexture.canResample(prim.resampleFactorWidth, prim.resampleFactorHeight);
            }
        }
        return textureAccess;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void doRender(BasePrimitiveRenderer renderer) {
        PixelState pixel = renderer.pixel;
        PrimitiveState prim = renderer.prim;
        IRendererWriter rendererWriter = renderer.rendererWriter;
        Lighting lighting = renderer.lighting;
        IRandomTextureAccess textureAccess = RendererTemplate.resampleTexture(renderer);
        RendererTemplate.doRenderStart(renderer);
        int stencilRefAlpha = 0;
        if (stencilTestFlagEnabled && !clearMode && stencilRef != 0 && (stencilOpFail == 2 || stencilOpZFail == 2 || stencilOpZPass == 2)) {
            stencilRefAlpha = renderer.stencilRef << 24;
        }
        int stencilRefMasked = renderer.stencilRef & renderer.stencilMask;
        int notColorMask = -1;
        if (!clearMode && colorMask != 0) {
            notColorMask = ~renderer.colorMask;
        }
        int textureWidthMask = renderer.textureWidth - 1;
        int textureHeightMask = renderer.textureHeight - 1;
        float textureWidthFloat = renderer.textureWidth;
        float textureHeightFloat = renderer.textureHeight;
        int alphaRef = renderer.alphaRef;
        int primSourceDepth = (int)prim.p2z;
        float u = prim.uStart;
        float v = prim.vStart;
        ColorDepth colorDepth = new ColorDepth();
        PrimarySecondaryColors colors = new PrimarySecondaryColors();
        Rasterizer.Range range = null;
        Rasterizer rasterizer = null;
        float t1uw = 0.0f;
        float t1vw = 0.0f;
        float t2uw = 0.0f;
        float t2vw = 0.0f;
        float t3uw = 0.0f;
        float t3vw = 0.0f;
        if (isTriangle) {
            if (transform2D) {
                t1uw = prim.t1u;
                t1vw = prim.t1v;
                t2uw = prim.t2u;
                t2vw = prim.t2v;
                t3uw = prim.t3u;
                t3vw = prim.t3v;
            } else {
                t1uw = prim.t1u * prim.p1wInverted;
                t1vw = prim.t1v * prim.p1wInverted;
                t2uw = prim.t2u * prim.p2wInverted;
                t2vw = prim.t2v * prim.p2wInverted;
                t3uw = prim.t3u * prim.p3wInverted;
                t3vw = prim.t3v * prim.p3wInverted;
            }
            range = new Rasterizer.Range();
            if (prim.destinationWidth >= 4 && prim.destinationHeight >= 4) {
                rasterizer = new Rasterizer(prim.p1x, prim.p1y, prim.p2x, prim.p2y, prim.p3x, prim.p3y, prim.pyMin, prim.pyMax);
                rasterizer.setY(prim.pyMin);
            }
        }
        int fbIndex = 0;
        int depthIndex = 0;
        int depthOffset = 0;
        int[] memInt = renderer.memInt;
        if (hasMemInt && psm == 3) {
            fbIndex = renderer.fbAddress >> 2;
            depthIndex = renderer.depthAddress >> 2;
            depthOffset = renderer.depthAddress >> 1 & 1;
        }
        int sourceColor = 0;
        int sourceDepth = 0;
        int destinationColor = 0;
        int destinationDepth = 0;
        int primaryColor = renderer.primaryColor;
        int secondaryColor = 0;
        float pixelU = 0.0f;
        float pixelV = 0.0f;
        boolean needResample = prim.needResample;
        int y = prim.pyMin;
        while (true) {
            block331: {
                int endX;
                int startX;
                block330: {
                    if (y > prim.pyMax) {
                        RendererTemplate.doRenderEnd(renderer);
                        return;
                    }
                    startX = prim.pxMin;
                    endX = prim.pxMax;
                    if (isTriangle && rasterizer != null) {
                        rasterizer.getNextRange(range);
                        startX = Utilities.max(range.xMin, startX);
                        endX = Utilities.min(range.xMax, endX);
                        if (isLogTraceEnabled) {
                            VideoEngine.log.trace((Object)String.format("Rasterizer line (%d-%d,%d)", startX, endX, y));
                        }
                    }
                    if (!isTriangle || startX <= endX) break block330;
                    if (hasMemInt && psm == 3) {
                        fbIndex += prim.destinationWidth + renderer.imageWriterSkipEOL;
                        if (needDepthWrite || needDestinationDepthRead) {
                            depthIndex += (depthOffset += prim.destinationWidth + renderer.depthWriterSkipEOL) >> 1;
                            depthOffset &= 1;
                        }
                        break block331;
                    } else {
                        rendererWriter.skip(prim.destinationWidth + renderer.imageWriterSkipEOL, prim.destinationWidth + renderer.depthWriterSkipEOL);
                    }
                    break block331;
                }
                if (needTextureUV && simpleTextureUV) {
                    if (swapTextureUV) {
                        v = prim.vStart;
                    } else {
                        u = prim.uStart;
                    }
                }
                if (isTriangle) {
                    int startSkip = startX - prim.pxMin;
                    if (startSkip > 0) {
                        if (hasMemInt && psm == 3) {
                            fbIndex += startSkip;
                            if (needDepthWrite || needDestinationDepthRead) {
                                depthIndex += (depthOffset += startSkip) >> 1;
                                depthOffset &= 1;
                            }
                        } else {
                            rendererWriter.skip(startSkip, startSkip);
                        }
                        if (simpleTextureUV) {
                            if (swapTextureUV) {
                                v += (float)startSkip * prim.vStep;
                            } else {
                                u += (float)startSkip * prim.uStep;
                            }
                        }
                    }
                    prim.computeTriangleWeights(pixel, startX, y);
                }
                for (int x = startX; x <= endX; ++x) {
                    block329: {
                        block343: {
                            block342: {
                                block341: {
                                    int alpha;
                                    block340: {
                                        block339: {
                                            block338: {
                                                block337: {
                                                    block336: {
                                                        block333: {
                                                            block335: {
                                                                block334: {
                                                                    block332: {
                                                                        if (!isTriangle || pixel.isInsideTriangle()) break block332;
                                                                        if (isLogTraceEnabled) {
                                                                            VideoEngine.log.trace((Object)String.format("Pixel (%d,%d) outside triangle (%f, %f, %f)", x, y, Float.valueOf(pixel.triangleWeight1), Float.valueOf(pixel.triangleWeight2), Float.valueOf(pixel.triangleWeight3)));
                                                                        }
                                                                        if (hasMemInt && psm == 3) {
                                                                            ++fbIndex;
                                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                                depthIndex += ++depthOffset >> 1;
                                                                                depthOffset &= 1;
                                                                            }
                                                                            break block329;
                                                                        } else {
                                                                            rendererWriter.skip(1, 1);
                                                                        }
                                                                        break block329;
                                                                    }
                                                                    if (transform2D) {
                                                                        pixel.newPixel2D();
                                                                    } else {
                                                                        pixel.newPixel3D();
                                                                    }
                                                                    if (!transform2D) break block333;
                                                                    if (!needScissoringX || !needScissoringY) break block334;
                                                                    if (x >= renderer.scissorX1 && x <= renderer.scissorX2 && y >= renderer.scissorY1 && y <= renderer.scissorY2) break block333;
                                                                    if (hasMemInt && psm == 3) {
                                                                        ++fbIndex;
                                                                        if (needDepthWrite || needDestinationDepthRead) {
                                                                            depthIndex += ++depthOffset >> 1;
                                                                            depthOffset &= 1;
                                                                        }
                                                                        break block329;
                                                                    } else {
                                                                        rendererWriter.skip(1, 1);
                                                                    }
                                                                    break block329;
                                                                }
                                                                if (!needScissoringX) break block335;
                                                                if (x >= renderer.scissorX1 && x <= renderer.scissorX2) break block333;
                                                                if (hasMemInt && psm == 3) {
                                                                    ++fbIndex;
                                                                    if (needDepthWrite || needDestinationDepthRead) {
                                                                        depthIndex += ++depthOffset >> 1;
                                                                        depthOffset &= 1;
                                                                    }
                                                                    break block329;
                                                                } else {
                                                                    rendererWriter.skip(1, 1);
                                                                }
                                                                break block329;
                                                            }
                                                            if (!needScissoringY || y >= renderer.scissorY1 && y <= renderer.scissorY2) break block333;
                                                            if (hasMemInt && psm == 3) {
                                                                ++fbIndex;
                                                                if (needDepthWrite || needDestinationDepthRead) {
                                                                    depthIndex += ++depthOffset >> 1;
                                                                    depthOffset &= 1;
                                                                }
                                                                break block329;
                                                            } else {
                                                                rendererWriter.skip(1, 1);
                                                            }
                                                            break block329;
                                                        }
                                                        if (needSourceDepthRead) {
                                                            sourceDepth = isTriangle ? Utilities.round(pixel.getTriangleWeightedValue(prim.p1z, prim.p2z, prim.p3z)) : primSourceDepth;
                                                        }
                                                        if (transform2D || clearMode || !needSourceDepthRead || nearZ == 0 && farZ == 65535 || sourceDepth >= renderer.nearZ && sourceDepth <= renderer.farZ) break block336;
                                                        if (hasMemInt && psm == 3) {
                                                            ++fbIndex;
                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                depthIndex += ++depthOffset >> 1;
                                                                depthOffset &= 1;
                                                            }
                                                            break block329;
                                                        } else {
                                                            rendererWriter.skip(1, 1);
                                                        }
                                                        break block329;
                                                    }
                                                    if (hasMemInt && psm == 3) {
                                                        destinationColor = memInt[fbIndex];
                                                        if (needDestinationDepthRead) {
                                                            destinationDepth = depthOffset == 0 ? memInt[depthIndex] & 0xFFFF : memInt[depthIndex] >>> 16;
                                                        }
                                                    } else {
                                                        rendererWriter.readCurrent(colorDepth);
                                                        destinationColor = colorDepth.color;
                                                        if (needDestinationDepthRead) {
                                                            destinationDepth = colorDepth.depth;
                                                        }
                                                    }
                                                    if (!stencilTestFlagEnabled || clearMode) break block337;
                                                    switch (stencilFunc) {
                                                        case 0: {
                                                            if (stencilOpFail != 0) {
                                                                destinationColor = RendererTemplate.stencilOpFail(destinationColor, stencilRefAlpha);
                                                            }
                                                            if (hasMemInt && psm == 3) {
                                                                ++fbIndex;
                                                                if (needDepthWrite || needDestinationDepthRead) {
                                                                    depthIndex += ++depthOffset >> 1;
                                                                    depthOffset &= 1;
                                                                }
                                                                break block329;
                                                            } else {
                                                                rendererWriter.skip(1, 1);
                                                            }
                                                            break block329;
                                                        }
                                                        case 1: {
                                                            break;
                                                        }
                                                        case 2: {
                                                            if ((PixelColor.getAlpha(destinationColor) & renderer.stencilMask) == stencilRefMasked) break;
                                                            if (isLogTraceEnabled) {
                                                                VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), stencil test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                            }
                                                            if (stencilOpFail != 0) {
                                                                destinationColor = RendererTemplate.stencilOpFail(destinationColor, stencilRefAlpha);
                                                            }
                                                            if (hasMemInt && psm == 3) {
                                                                ++fbIndex;
                                                                if (needDepthWrite || needDestinationDepthRead) {
                                                                    depthIndex += ++depthOffset >> 1;
                                                                    depthOffset &= 1;
                                                                }
                                                                break block329;
                                                            } else {
                                                                rendererWriter.skip(1, 1);
                                                            }
                                                            break block329;
                                                        }
                                                        case 3: {
                                                            if ((PixelColor.getAlpha(destinationColor) & renderer.stencilMask) != stencilRefMasked) break;
                                                            if (isLogTraceEnabled) {
                                                                VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), stencil test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                            }
                                                            if (stencilOpFail != 0) {
                                                                destinationColor = RendererTemplate.stencilOpFail(destinationColor, stencilRefAlpha);
                                                            }
                                                            if (hasMemInt && psm == 3) {
                                                                ++fbIndex;
                                                                if (needDepthWrite || needDestinationDepthRead) {
                                                                    depthIndex += ++depthOffset >> 1;
                                                                    depthOffset &= 1;
                                                                }
                                                                break block329;
                                                            } else {
                                                                rendererWriter.skip(1, 1);
                                                            }
                                                            break block329;
                                                        }
                                                        case 4: {
                                                            if ((PixelColor.getAlpha(destinationColor) & renderer.stencilMask) < stencilRefMasked) break;
                                                            if (isLogTraceEnabled) {
                                                                VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), stencil test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                            }
                                                            if (stencilOpFail != 0) {
                                                                destinationColor = RendererTemplate.stencilOpFail(destinationColor, stencilRefAlpha);
                                                            }
                                                            if (hasMemInt && psm == 3) {
                                                                ++fbIndex;
                                                                if (needDepthWrite || needDestinationDepthRead) {
                                                                    depthIndex += ++depthOffset >> 1;
                                                                    depthOffset &= 1;
                                                                }
                                                                break block329;
                                                            } else {
                                                                rendererWriter.skip(1, 1);
                                                            }
                                                            break block329;
                                                        }
                                                        case 5: {
                                                            if ((PixelColor.getAlpha(destinationColor) & renderer.stencilMask) <= stencilRefMasked) break;
                                                            if (isLogTraceEnabled) {
                                                                VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), stencil test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                            }
                                                            if (stencilOpFail != 0) {
                                                                destinationColor = RendererTemplate.stencilOpFail(destinationColor, stencilRefAlpha);
                                                            }
                                                            if (hasMemInt && psm == 3) {
                                                                ++fbIndex;
                                                                if (needDepthWrite || needDestinationDepthRead) {
                                                                    depthIndex += ++depthOffset >> 1;
                                                                    depthOffset &= 1;
                                                                }
                                                                break block329;
                                                            } else {
                                                                rendererWriter.skip(1, 1);
                                                            }
                                                            break block329;
                                                        }
                                                        case 6: {
                                                            if ((PixelColor.getAlpha(destinationColor) & renderer.stencilMask) > stencilRefMasked) break;
                                                            if (isLogTraceEnabled) {
                                                                VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), stencil test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                            }
                                                            if (stencilOpFail != 0) {
                                                                destinationColor = RendererTemplate.stencilOpFail(destinationColor, stencilRefAlpha);
                                                            }
                                                            if (hasMemInt && psm == 3) {
                                                                ++fbIndex;
                                                                if (needDepthWrite || needDestinationDepthRead) {
                                                                    depthIndex += ++depthOffset >> 1;
                                                                    depthOffset &= 1;
                                                                }
                                                                break block329;
                                                            } else {
                                                                rendererWriter.skip(1, 1);
                                                            }
                                                            break block329;
                                                        }
                                                        case 7: {
                                                            if ((PixelColor.getAlpha(destinationColor) & renderer.stencilMask) >= stencilRefMasked) break;
                                                            if (isLogTraceEnabled) {
                                                                VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), stencil test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                            }
                                                            if (stencilOpFail != 0) {
                                                                destinationColor = RendererTemplate.stencilOpFail(destinationColor, stencilRefAlpha);
                                                            }
                                                            if (hasMemInt && psm == 3) {
                                                                ++fbIndex;
                                                                if (needDepthWrite || needDestinationDepthRead) {
                                                                    depthIndex += ++depthOffset >> 1;
                                                                    depthOffset &= 1;
                                                                }
                                                                break block329;
                                                            } else {
                                                                rendererWriter.skip(1, 1);
                                                            }
                                                            break block329;
                                                        }
                                                    }
                                                }
                                                if (!depthTestFlagEnabled || clearMode) break block338;
                                                switch (depthFunc) {
                                                    case 0: {
                                                        if (stencilTestFlagEnabled && stencilOpZFail != 0) {
                                                            destinationColor = RendererTemplate.stencilOpZFail(destinationColor, stencilRefAlpha);
                                                        }
                                                        if (hasMemInt && psm == 3) {
                                                            ++fbIndex;
                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                depthIndex += ++depthOffset >> 1;
                                                                depthOffset &= 1;
                                                            }
                                                            break block329;
                                                        } else {
                                                            rendererWriter.skip(1, 1);
                                                        }
                                                        break block329;
                                                    }
                                                    case 1: {
                                                        break;
                                                    }
                                                    case 2: {
                                                        if (sourceDepth == destinationDepth) break;
                                                        if (stencilTestFlagEnabled && stencilOpZFail != 0) {
                                                            destinationColor = RendererTemplate.stencilOpZFail(destinationColor, stencilRefAlpha);
                                                        }
                                                        if (isLogTraceEnabled) {
                                                            VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), depth test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                        }
                                                        if (hasMemInt && psm == 3) {
                                                            ++fbIndex;
                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                depthIndex += ++depthOffset >> 1;
                                                                depthOffset &= 1;
                                                            }
                                                            break block329;
                                                        } else {
                                                            rendererWriter.skip(1, 1);
                                                        }
                                                        break block329;
                                                    }
                                                    case 3: {
                                                        if (sourceDepth != destinationDepth) break;
                                                        if (stencilTestFlagEnabled && stencilOpZFail != 0) {
                                                            destinationColor = RendererTemplate.stencilOpZFail(destinationColor, stencilRefAlpha);
                                                        }
                                                        if (isLogTraceEnabled) {
                                                            VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), depth test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                        }
                                                        if (hasMemInt && psm == 3) {
                                                            ++fbIndex;
                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                depthIndex += ++depthOffset >> 1;
                                                                depthOffset &= 1;
                                                            }
                                                            break block329;
                                                        } else {
                                                            rendererWriter.skip(1, 1);
                                                        }
                                                        break block329;
                                                    }
                                                    case 4: {
                                                        if (sourceDepth < destinationDepth) break;
                                                        if (stencilTestFlagEnabled && stencilOpZFail != 0) {
                                                            destinationColor = RendererTemplate.stencilOpZFail(destinationColor, stencilRefAlpha);
                                                        }
                                                        if (isLogTraceEnabled) {
                                                            VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), depth test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                        }
                                                        if (hasMemInt && psm == 3) {
                                                            ++fbIndex;
                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                depthIndex += ++depthOffset >> 1;
                                                                depthOffset &= 1;
                                                            }
                                                            break block329;
                                                        } else {
                                                            rendererWriter.skip(1, 1);
                                                        }
                                                        break block329;
                                                    }
                                                    case 5: {
                                                        if (sourceDepth <= destinationDepth) break;
                                                        if (stencilTestFlagEnabled && stencilOpZFail != 0) {
                                                            destinationColor = RendererTemplate.stencilOpZFail(destinationColor, stencilRefAlpha);
                                                        }
                                                        if (isLogTraceEnabled) {
                                                            VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), depth test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                        }
                                                        if (hasMemInt && psm == 3) {
                                                            ++fbIndex;
                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                depthIndex += ++depthOffset >> 1;
                                                                depthOffset &= 1;
                                                            }
                                                            break block329;
                                                        } else {
                                                            rendererWriter.skip(1, 1);
                                                        }
                                                        break block329;
                                                    }
                                                    case 6: {
                                                        if (sourceDepth > destinationDepth) break;
                                                        if (stencilTestFlagEnabled && stencilOpZFail != 0) {
                                                            destinationColor = RendererTemplate.stencilOpZFail(destinationColor, stencilRefAlpha);
                                                        }
                                                        if (isLogTraceEnabled) {
                                                            VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), depth test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                        }
                                                        if (hasMemInt && psm == 3) {
                                                            ++fbIndex;
                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                depthIndex += ++depthOffset >> 1;
                                                                depthOffset &= 1;
                                                            }
                                                            break block329;
                                                        } else {
                                                            rendererWriter.skip(1, 1);
                                                        }
                                                        break block329;
                                                    }
                                                    case 7: {
                                                        if (sourceDepth >= destinationDepth) break;
                                                        if (stencilTestFlagEnabled && stencilOpZFail != 0) {
                                                            destinationColor = RendererTemplate.stencilOpZFail(destinationColor, stencilRefAlpha);
                                                        }
                                                        if (isLogTraceEnabled) {
                                                            VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), depth test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                        }
                                                        if (hasMemInt && psm == 3) {
                                                            ++fbIndex;
                                                            if (needDepthWrite || needDestinationDepthRead) {
                                                                depthIndex += ++depthOffset >> 1;
                                                                depthOffset &= 1;
                                                            }
                                                            break block329;
                                                        } else {
                                                            rendererWriter.skip(1, 1);
                                                        }
                                                        break block329;
                                                    }
                                                }
                                            }
                                            if (setVertexPrimaryColor && isTriangle) {
                                                primaryColor = sameVertexColor ? pixel.c3 : pixel.getTriangleColorWeightedValue();
                                            }
                                            if (lightingFlagEnabled && !transform2D && useVertexColor && isTriangle) {
                                                if (matFlagAmbient) {
                                                    pixel.materialAmbient = primaryColor;
                                                }
                                                if (matFlagDiffuse) {
                                                    pixel.materialDiffuse = primaryColor;
                                                }
                                                if (matFlagSpecular) {
                                                    pixel.materialSpecular = primaryColor;
                                                }
                                            }
                                            if (lightingFlagEnabled && !transform2D) {
                                                lighting.applyLighting(colors, pixel);
                                                primaryColor = colors.primaryColor;
                                                secondaryColor = colors.secondaryColor;
                                            }
                                            if (needTextureUV) {
                                                if (simpleTextureUV) {
                                                    pixelU = u;
                                                    pixelV = v;
                                                } else {
                                                    pixelU = pixel.getTriangleWeightedValue(t1uw, t2uw, t3uw);
                                                    pixelV = pixel.getTriangleWeightedValue(t1vw, t2vw, t3vw);
                                                    if (!transform2D) {
                                                        float weightInverted = 1.0f / pixel.getTriangleWeightedValue(prim.p1wInverted, prim.p2wInverted, prim.p3wInverted);
                                                        pixelU *= weightInverted;
                                                        pixelV *= weightInverted;
                                                    }
                                                }
                                            }
                                            if (textureFlagEnabled && (!transform2D || useVertexTexture) && !clearMode) {
                                                if (!transform2D) {
                                                    switch (texMapMode) {
                                                        case 0: {
                                                            if (texScaleX != 1.0f) {
                                                                pixelU *= renderer.texScaleX;
                                                            }
                                                            if (texTranslateX != 0.0f) {
                                                                pixelU += renderer.texTranslateX;
                                                            }
                                                            if (texScaleY != 1.0f) {
                                                                pixelV *= renderer.texScaleY;
                                                            }
                                                            if (texTranslateY == 0.0f) break;
                                                            pixelV += renderer.texTranslateY;
                                                            break;
                                                        }
                                                        case 1: {
                                                            switch (texProjMapMode) {
                                                                case 0: {
                                                                    float[] V = pixel.getV();
                                                                    pixelU = V[0] * pixel.textureMatrix[0] + V[1] * pixel.textureMatrix[4] + V[2] * pixel.textureMatrix[8] + pixel.textureMatrix[12];
                                                                    pixelV = V[0] * pixel.textureMatrix[1] + V[1] * pixel.textureMatrix[5] + V[2] * pixel.textureMatrix[9] + pixel.textureMatrix[13];
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    float tu = pixelU;
                                                                    float tv = pixelV;
                                                                    pixelU = tu * pixel.textureMatrix[0] + tv * pixel.textureMatrix[4] + pixel.textureMatrix[12];
                                                                    pixelV = tu * pixel.textureMatrix[1] + tv * pixel.textureMatrix[5] + pixel.textureMatrix[13];
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    float[] normalizedN = pixel.getNormalizedN();
                                                                    pixelU = normalizedN[0] * pixel.textureMatrix[0] + normalizedN[1] * pixel.textureMatrix[4] + normalizedN[2] * pixel.textureMatrix[8] + pixel.textureMatrix[12];
                                                                    pixelV = normalizedN[0] * pixel.textureMatrix[1] + normalizedN[1] * pixel.textureMatrix[5] + normalizedN[2] * pixel.textureMatrix[9] + pixel.textureMatrix[13];
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    float[] N = pixel.getN();
                                                                    pixelU = N[0] * pixel.textureMatrix[0] + N[1] * pixel.textureMatrix[4] + N[2] * pixel.textureMatrix[8] + pixel.textureMatrix[12];
                                                                    pixelV = N[0] * pixel.textureMatrix[1] + N[1] * pixel.textureMatrix[5] + N[2] * pixel.textureMatrix[9] + pixel.textureMatrix[13];
                                                                    break;
                                                                }
                                                            }
                                                            break;
                                                        }
                                                        case 2: {
                                                            float Pv;
                                                            float Pu;
                                                            float[] Ve = new float[3];
                                                            float[] Ne = new float[3];
                                                            float[] Lu = new float[3];
                                                            float[] Lv = new float[3];
                                                            pixel.getVe(Ve);
                                                            pixel.getNormalizedNe(Ne);
                                                            for (int i = 0; i < 3; ++i) {
                                                                Lu[i] = renderer.envMapLightPosU[i] - Ve[i] * renderer.envMapLightPosU[3];
                                                                Lv[i] = renderer.envMapLightPosV[i] - Ve[i] * renderer.envMapLightPosV[3];
                                                            }
                                                            if (renderer.envMapDiffuseLightU) {
                                                                Utilities.normalize3(Lu, Lu);
                                                                Pu = Utilities.dot3(Ne, Lu);
                                                            } else {
                                                                Lu[2] = Lu[2] + 1.0f;
                                                                Utilities.normalize3(Lu, Lu);
                                                                Pu = (float)Math.pow(Utilities.dot3(Ne, Lu), renderer.envMapShininess);
                                                            }
                                                            if (renderer.envMapDiffuseLightV) {
                                                                Utilities.normalize3(Lv, Lv);
                                                                Pv = Utilities.dot3(Ne, Lv);
                                                            } else {
                                                                Lv[2] = Lv[2] + 1.0f;
                                                                Utilities.normalize3(Lv, Lv);
                                                                Pv = (float)Math.pow(Utilities.dot3(Ne, Lv), renderer.envMapShininess);
                                                            }
                                                            pixelU = (Pu + 1.0f) * 0.5f;
                                                            pixelV = (Pv + 1.0f) * 0.5f;
                                                            break;
                                                        }
                                                    }
                                                }
                                                if (texMagFilter == 1 && needResample) {
                                                    textureAccess = renderer.cachedTexture.resample(prim.resampleFactorWidth, prim.resampleFactorHeight);
                                                    textureWidthMask = textureAccess.getWidth() - 1;
                                                    textureHeightMask = textureAccess.getHeight() - 1;
                                                    textureWidthFloat = textureAccess.getWidth();
                                                    textureHeightFloat = textureAccess.getHeight();
                                                    needResample = false;
                                                }
                                                if (needTextureWrapU) {
                                                    switch (texWrapS) {
                                                        case 0: {
                                                            if (transform2D) {
                                                                pixelU = Utilities.wrap(pixelU, textureWidthMask);
                                                                break;
                                                            }
                                                            pixelU = Utilities.wrap(pixelU);
                                                            break;
                                                        }
                                                        case 1: {
                                                            if (transform2D) {
                                                                pixelU = Utilities.clamp(pixelU, 0.0f, textureWidthMask);
                                                                break;
                                                            }
                                                            pixelU = Utilities.clamp(pixelU, 0.0f, 0.99999f);
                                                            break;
                                                        }
                                                    }
                                                }
                                                if (needTextureWrapV) {
                                                    switch (texWrapT) {
                                                        case 0: {
                                                            if (transform2D) {
                                                                pixelV = Utilities.wrap(pixelV, textureHeightMask);
                                                                break;
                                                            }
                                                            pixelV = Utilities.wrap(pixelV);
                                                            break;
                                                        }
                                                        case 1: {
                                                            if (transform2D) {
                                                                pixelV = Utilities.clamp(pixelV, 0.0f, textureHeightMask);
                                                                break;
                                                            }
                                                            pixelV = Utilities.clamp(pixelV, 0.0f, 0.99999f);
                                                            break;
                                                        }
                                                    }
                                                }
                                                sourceColor = transform2D ? textureAccess.readPixel(Utilities.pixelToTexel(pixelU), Utilities.pixelToTexel(pixelV)) : textureAccess.readPixel(Utilities.pixelToTexel(pixelU * textureWidthFloat), Utilities.pixelToTexel(pixelV * textureHeightFloat));
                                                switch (textureFunc) {
                                                    case 0: {
                                                        if (textureAlphaUsed) {
                                                            sourceColor = PixelColor.multiply(sourceColor, primaryColor);
                                                            break;
                                                        }
                                                        sourceColor = PixelColor.multiply(sourceColor | 0xFF000000, primaryColor);
                                                        break;
                                                    }
                                                    case 1: {
                                                        int r;
                                                        int g;
                                                        int b;
                                                        int a;
                                                        if (textureAlphaUsed) {
                                                            alpha = PixelColor.getAlpha(sourceColor);
                                                            a = PixelColor.getAlpha(primaryColor);
                                                            b = PixelColor.combineComponent(PixelColor.getBlue(primaryColor), PixelColor.getBlue(sourceColor), alpha);
                                                            g = PixelColor.combineComponent(PixelColor.getGreen(primaryColor), PixelColor.getGreen(sourceColor), alpha);
                                                            r = PixelColor.combineComponent(PixelColor.getRed(primaryColor), PixelColor.getRed(sourceColor), alpha);
                                                            sourceColor = PixelColor.getColor(a, b, g, r);
                                                            break;
                                                        }
                                                        sourceColor = sourceColor & 0xFFFFFF | primaryColor & 0xFF000000;
                                                        break;
                                                    }
                                                    case 2: {
                                                        int r;
                                                        int g;
                                                        int b;
                                                        int a;
                                                        if (textureAlphaUsed) {
                                                            a = PixelColor.multiplyComponent(PixelColor.getAlpha(sourceColor), PixelColor.getAlpha(primaryColor));
                                                            b = PixelColor.combineComponent(PixelColor.getBlue(primaryColor), renderer.texEnvColorB, PixelColor.getBlue(sourceColor));
                                                            g = PixelColor.combineComponent(PixelColor.getGreen(primaryColor), renderer.texEnvColorG, PixelColor.getGreen(sourceColor));
                                                            r = PixelColor.combineComponent(PixelColor.getRed(primaryColor), renderer.texEnvColorR, PixelColor.getRed(sourceColor));
                                                            sourceColor = PixelColor.getColor(a, b, g, r);
                                                            break;
                                                        }
                                                        a = PixelColor.getAlpha(primaryColor);
                                                        b = PixelColor.combineComponent(PixelColor.getBlue(primaryColor), renderer.texEnvColorB, PixelColor.getBlue(sourceColor));
                                                        g = PixelColor.combineComponent(PixelColor.getGreen(primaryColor), renderer.texEnvColorG, PixelColor.getGreen(sourceColor));
                                                        r = PixelColor.combineComponent(PixelColor.getRed(primaryColor), renderer.texEnvColorR, PixelColor.getRed(sourceColor));
                                                        sourceColor = PixelColor.getColor(a, b, g, r);
                                                        break;
                                                    }
                                                    case 3: {
                                                        if (textureAlphaUsed) break;
                                                        sourceColor = sourceColor & 0xFFFFFF | primaryColor & 0xFF000000;
                                                        break;
                                                    }
                                                    case 4: {
                                                        int a;
                                                        if (textureAlphaUsed) {
                                                            a = PixelColor.multiplyComponent(PixelColor.getAlpha(sourceColor), PixelColor.getAlpha(primaryColor));
                                                            sourceColor = PixelColor.setAlpha(PixelColor.addBGR(sourceColor, primaryColor), a);
                                                            break;
                                                        }
                                                        sourceColor = PixelColor.add(sourceColor & 0xFFFFFF, primaryColor);
                                                        break;
                                                    }
                                                }
                                                if (textureColorDoubled) {
                                                    if (!transform2D && lightingFlagEnabled && lightMode == 1) {
                                                        sourceColor = PixelColor.doubleColor(sourceColor);
                                                        secondaryColor = PixelColor.doubleColor(secondaryColor);
                                                    } else {
                                                        sourceColor = PixelColor.doubleColor(sourceColor);
                                                    }
                                                }
                                                if (!transform2D && lightingFlagEnabled && lightMode == 1) {
                                                    sourceColor = PixelColor.add(sourceColor, secondaryColor);
                                                }
                                            } else {
                                                if (textureColorDoubled) {
                                                    if (!transform2D && lightingFlagEnabled && lightMode == 1) {
                                                        primaryColor = PixelColor.doubleColor(primaryColor);
                                                        secondaryColor = PixelColor.doubleColor(secondaryColor);
                                                    } else if (!primaryColorSetGlobally) {
                                                        primaryColor = PixelColor.doubleColor(primaryColor);
                                                    }
                                                }
                                                sourceColor = !transform2D && lightingFlagEnabled && lightMode == 1 ? PixelColor.add(primaryColor, secondaryColor) : primaryColor;
                                            }
                                            if (!colorTestFlagEnabled || clearMode) break block339;
                                            switch (colorTestFunc) {
                                                case 1: {
                                                    break;
                                                }
                                                case 0: {
                                                    if (hasMemInt && psm == 3) {
                                                        ++fbIndex;
                                                        if (needDepthWrite || needDestinationDepthRead) {
                                                            depthIndex += ++depthOffset >> 1;
                                                            depthOffset &= 1;
                                                        }
                                                        break block329;
                                                    } else {
                                                        rendererWriter.skip(1, 1);
                                                    }
                                                    break block329;
                                                }
                                                case 2: {
                                                    if ((sourceColor & renderer.colorTestMsk) == renderer.colorTestRef) break;
                                                    if (hasMemInt && psm == 3) {
                                                        ++fbIndex;
                                                        if (needDepthWrite || needDestinationDepthRead) {
                                                            depthIndex += ++depthOffset >> 1;
                                                            depthOffset &= 1;
                                                        }
                                                        break block329;
                                                    } else {
                                                        rendererWriter.skip(1, 1);
                                                    }
                                                    break block329;
                                                }
                                                case 3: {
                                                    if ((sourceColor & renderer.colorTestMsk) != renderer.colorTestRef) break;
                                                    if (hasMemInt && psm == 3) {
                                                        ++fbIndex;
                                                        if (needDepthWrite || needDestinationDepthRead) {
                                                            depthIndex += ++depthOffset >> 1;
                                                            depthOffset &= 1;
                                                        }
                                                        break block329;
                                                    } else {
                                                        rendererWriter.skip(1, 1);
                                                    }
                                                    break block329;
                                                }
                                            }
                                        }
                                        if (!alphaTestFlagEnabled || clearMode) break block340;
                                        switch (alphaFunc) {
                                            case 1: {
                                                break;
                                            }
                                            case 0: {
                                                if (hasMemInt && psm == 3) {
                                                    ++fbIndex;
                                                    if (needDepthWrite || needDestinationDepthRead) {
                                                        depthIndex += ++depthOffset >> 1;
                                                        depthOffset &= 1;
                                                    }
                                                    break block329;
                                                } else {
                                                    rendererWriter.skip(1, 1);
                                                }
                                                break block329;
                                            }
                                            case 2: {
                                                if (PixelColor.getAlpha(sourceColor) == alphaRef) break;
                                                if (isLogTraceEnabled) {
                                                    VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), alpha test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                }
                                                if (hasMemInt && psm == 3) {
                                                    ++fbIndex;
                                                    if (needDepthWrite || needDestinationDepthRead) {
                                                        depthIndex += ++depthOffset >> 1;
                                                        depthOffset &= 1;
                                                    }
                                                    break block329;
                                                } else {
                                                    rendererWriter.skip(1, 1);
                                                }
                                                break block329;
                                            }
                                            case 3: {
                                                if (PixelColor.getAlpha(sourceColor) != alphaRef) break;
                                                if (isLogTraceEnabled) {
                                                    VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), alpha test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                }
                                                if (hasMemInt && psm == 3) {
                                                    ++fbIndex;
                                                    if (needDepthWrite || needDestinationDepthRead) {
                                                        depthIndex += ++depthOffset >> 1;
                                                        depthOffset &= 1;
                                                    }
                                                    break block329;
                                                } else {
                                                    rendererWriter.skip(1, 1);
                                                }
                                                break block329;
                                            }
                                            case 4: {
                                                if (PixelColor.getAlpha(sourceColor) < alphaRef) break;
                                                if (isLogTraceEnabled) {
                                                    VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), alpha test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                }
                                                if (hasMemInt && psm == 3) {
                                                    ++fbIndex;
                                                    if (needDepthWrite || needDestinationDepthRead) {
                                                        depthIndex += ++depthOffset >> 1;
                                                        depthOffset &= 1;
                                                    }
                                                    break block329;
                                                } else {
                                                    rendererWriter.skip(1, 1);
                                                }
                                                break block329;
                                            }
                                            case 5: {
                                                if (RendererTemplate.alphaRef >= 255 || PixelColor.getAlpha(sourceColor) <= alphaRef) break;
                                                if (isLogTraceEnabled) {
                                                    VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), alpha test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                }
                                                if (hasMemInt && psm == 3) {
                                                    ++fbIndex;
                                                    if (needDepthWrite || needDestinationDepthRead) {
                                                        depthIndex += ++depthOffset >> 1;
                                                        depthOffset &= 1;
                                                    }
                                                    break block329;
                                                } else {
                                                    rendererWriter.skip(1, 1);
                                                }
                                                break block329;
                                            }
                                            case 6: {
                                                if (PixelColor.getAlpha(sourceColor) > alphaRef) break;
                                                if (isLogTraceEnabled) {
                                                    VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), alpha test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                }
                                                if (hasMemInt && psm == 3) {
                                                    ++fbIndex;
                                                    if (needDepthWrite || needDestinationDepthRead) {
                                                        depthIndex += ++depthOffset >> 1;
                                                        depthOffset &= 1;
                                                    }
                                                    break block329;
                                                } else {
                                                    rendererWriter.skip(1, 1);
                                                }
                                                break block329;
                                            }
                                            case 7: {
                                                if (RendererTemplate.alphaRef <= 0 || PixelColor.getAlpha(sourceColor) >= alphaRef) break;
                                                if (isLogTraceEnabled) {
                                                    VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), alpha test failed, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                                                }
                                                if (hasMemInt && psm == 3) {
                                                    ++fbIndex;
                                                    if (needDepthWrite || needDestinationDepthRead) {
                                                        depthIndex += ++depthOffset >> 1;
                                                        depthOffset &= 1;
                                                    }
                                                    break block329;
                                                } else {
                                                    rendererWriter.skip(1, 1);
                                                }
                                                break block329;
                                            }
                                        }
                                    }
                                    if (blendFlagEnabled && !clearMode) {
                                        switch (blendEquation) {
                                            case 0: {
                                                if (blendSrc == 10 && sfix == 0xFFFFFF && blendDst == 10 && dfix == 0) break;
                                                if (blendSrc == 10 && sfix == 0xFFFFFF && blendDst == 10 && dfix == 0xFFFFFF) {
                                                    sourceColor = PixelColor.add(sourceColor, destinationColor & 0xFFFFFF);
                                                    break;
                                                }
                                                if (blendSrc == 2 && blendDst == 3) {
                                                    int srcAlpha = sourceColor >>> 24;
                                                    if (srcAlpha == 0) {
                                                        sourceColor = sourceColor & 0xFF000000 | destinationColor & 0xFFFFFF;
                                                        break;
                                                    }
                                                    if (srcAlpha == 255) break;
                                                    int oneMinusSrcAlpha = 255 - srcAlpha;
                                                    int filteredSrc = PixelColor.multiplyBGR(sourceColor, srcAlpha, srcAlpha, srcAlpha);
                                                    int filteredDst = PixelColor.multiplyBGR(destinationColor, oneMinusSrcAlpha, oneMinusSrcAlpha, oneMinusSrcAlpha);
                                                    sourceColor = PixelColor.setBGR(sourceColor, PixelColor.addBGR(filteredSrc, filteredDst));
                                                    break;
                                                }
                                                int filteredSrc = PixelColor.multiplyBGR(sourceColor, RendererTemplate.blendSrc(sourceColor, destinationColor, renderer.sfix));
                                                int filteredDst = PixelColor.multiplyBGR(destinationColor, RendererTemplate.blendDst(sourceColor, destinationColor, renderer.dfix));
                                                sourceColor = PixelColor.setBGR(sourceColor, PixelColor.addBGR(filteredSrc, filteredDst));
                                                break;
                                            }
                                            case 1: {
                                                int filteredSrc = PixelColor.multiplyBGR(sourceColor, RendererTemplate.blendSrc(sourceColor, destinationColor, renderer.sfix));
                                                int filteredDst = PixelColor.multiplyBGR(destinationColor, RendererTemplate.blendDst(sourceColor, destinationColor, renderer.dfix));
                                                sourceColor = PixelColor.setBGR(sourceColor, PixelColor.substractBGR(filteredSrc, filteredDst));
                                                break;
                                            }
                                            case 2: {
                                                int filteredSrc = PixelColor.multiplyBGR(sourceColor, RendererTemplate.blendSrc(sourceColor, destinationColor, renderer.sfix));
                                                int filteredDst = PixelColor.multiplyBGR(destinationColor, RendererTemplate.blendDst(sourceColor, destinationColor, renderer.dfix));
                                                sourceColor = PixelColor.setBGR(sourceColor, PixelColor.substractBGR(filteredDst, filteredSrc));
                                                break;
                                            }
                                            case 3: {
                                                sourceColor = PixelColor.setBGR(sourceColor, PixelColor.minBGR(sourceColor, destinationColor));
                                                break;
                                            }
                                            case 4: {
                                                sourceColor = PixelColor.setBGR(sourceColor, PixelColor.maxBGR(sourceColor, destinationColor));
                                                break;
                                            }
                                            case 5: {
                                                sourceColor = PixelColor.setBGR(sourceColor, PixelColor.absBGR(sourceColor, destinationColor));
                                                break;
                                            }
                                        }
                                    }
                                    if (stencilTestFlagEnabled && !clearMode) {
                                        switch (stencilOpZPass) {
                                            case 0: {
                                                sourceColor = sourceColor & 0xFFFFFF | destinationColor & 0xFF000000;
                                                break;
                                            }
                                            case 1: {
                                                sourceColor &= 0xFFFFFF;
                                                break;
                                            }
                                            case 2: {
                                                if (stencilRef == 0) {
                                                    sourceColor &= 0xFFFFFF;
                                                    break;
                                                }
                                                sourceColor = sourceColor & 0xFFFFFF | stencilRefAlpha;
                                                break;
                                            }
                                            case 3: {
                                                sourceColor = sourceColor & 0xFFFFFF | ~destinationColor & 0xFF000000;
                                                break;
                                            }
                                            case 4: {
                                                alpha = destinationColor & 0xFF000000;
                                                if (alpha != -16777216) {
                                                    alpha += 0x1000000;
                                                }
                                                sourceColor = sourceColor & 0xFFFFFF | alpha;
                                                break;
                                            }
                                            case 5: {
                                                alpha = destinationColor & 0xFF000000;
                                                if (alpha != 0) {
                                                    alpha -= 0x1000000;
                                                }
                                                sourceColor = sourceColor & 0xFFFFFF | alpha;
                                                break;
                                            }
                                        }
                                    } else if (!clearMode) {
                                        sourceColor = sourceColor & 0xFFFFFF | destinationColor & 0xFF000000;
                                    }
                                    if (colorLogicOpFlagEnabled && !clearMode) {
                                        switch (logicOp) {
                                            case 0: {
                                                sourceColor = 0;
                                                break;
                                            }
                                            case 1: {
                                                sourceColor &= destinationColor;
                                                break;
                                            }
                                            case 2: {
                                                sourceColor &= ~destinationColor;
                                                break;
                                            }
                                            case 3: {
                                                break;
                                            }
                                            case 4: {
                                                sourceColor = ~sourceColor & destinationColor;
                                                break;
                                            }
                                            case 5: {
                                                sourceColor = destinationColor;
                                                break;
                                            }
                                            case 6: {
                                                sourceColor ^= destinationColor;
                                                break;
                                            }
                                            case 7: {
                                                sourceColor |= destinationColor;
                                                break;
                                            }
                                            case 8: {
                                                sourceColor = ~(sourceColor | destinationColor);
                                                break;
                                            }
                                            case 9: {
                                                sourceColor = ~(sourceColor ^ destinationColor);
                                                break;
                                            }
                                            case 10: {
                                                sourceColor = ~destinationColor;
                                                break;
                                            }
                                            case 11: {
                                                sourceColor |= ~destinationColor;
                                                break;
                                            }
                                            case 12: {
                                                sourceColor ^= 0xFFFFFFFF;
                                                break;
                                            }
                                            case 13: {
                                                sourceColor = ~sourceColor | destinationColor;
                                                break;
                                            }
                                            case 14: {
                                                sourceColor = ~(sourceColor & destinationColor);
                                                break;
                                            }
                                            case 15: {
                                                sourceColor = -1;
                                                break;
                                            }
                                        }
                                    }
                                    if (!clearMode) break block341;
                                    if (clearModeColor) {
                                        if (!clearModeStencil) {
                                            sourceColor = sourceColor & 0xFFFFFF | destinationColor & 0xFF000000;
                                        }
                                        break block342;
                                    } else {
                                        sourceColor = clearModeStencil ? sourceColor & 0xFF000000 | destinationColor & 0xFFFFFF : destinationColor;
                                    }
                                    break block342;
                                }
                                if (colorMask != 0) {
                                    sourceColor = sourceColor & notColorMask | destinationColor & colorMask;
                                }
                            }
                            if (needDepthWrite) {
                                if (clearMode) {
                                    if (!clearModeDepth) {
                                        sourceDepth = destinationDepth;
                                    }
                                } else if (!depthTestFlagEnabled) {
                                    sourceDepth = destinationDepth;
                                } else if (!depthMask) {
                                    sourceDepth = destinationDepth;
                                }
                            }
                            if (isLogTraceEnabled) {
                                VideoEngine.log.trace((Object)String.format("Pixel (%d,%d), passed=true, tex (%f, %f), source=0x%08X, dest=0x%08X, prim=0x%08X, sec=0x%08X, sourceDepth=%d, destDepth=%d", x, y, Float.valueOf(pixelU), Float.valueOf(pixelV), sourceColor, destinationColor, primaryColor, secondaryColor, sourceDepth, destinationDepth));
                            }
                            if (needDepthWrite && needSourceDepthClamp) {
                                sourceDepth = Math.max(0, Math.min(sourceDepth, 65535));
                            }
                            if (!hasMemInt || psm != 3) break block343;
                            memInt[fbIndex] = sourceColor;
                            ++fbIndex;
                            if (needDepthWrite) {
                                if (depthOffset == 0) {
                                    memInt[depthIndex] = memInt[depthIndex] & 0xFFFF0000 | sourceDepth & 0xFFFF;
                                    depthOffset = 1;
                                    break block329;
                                } else {
                                    memInt[depthIndex] = memInt[depthIndex] & 0xFFFF | sourceDepth << 16;
                                    ++depthIndex;
                                    depthOffset = 0;
                                }
                                break block329;
                            } else if (needDestinationDepthRead) {
                                depthIndex += ++depthOffset >> 1;
                                depthOffset &= 1;
                            }
                            break block329;
                        }
                        if (needDepthWrite) {
                            colorDepth.color = sourceColor;
                            colorDepth.depth = sourceDepth;
                            rendererWriter.writeNext(colorDepth);
                        } else {
                            rendererWriter.writeNextColor(sourceColor);
                        }
                    }
                    if (needTextureUV && simpleTextureUV) {
                        if (swapTextureUV) {
                            v += prim.vStep;
                        } else {
                            u += prim.uStep;
                        }
                    }
                    if (!isTriangle) continue;
                    prim.deltaXTriangleWeigths(pixel);
                }
                int skip = prim.pxMax - endX;
                if (hasMemInt && psm == 3) {
                    fbIndex += skip + renderer.imageWriterSkipEOL;
                    if (needDepthWrite || needDestinationDepthRead) {
                        depthIndex += (depthOffset += skip + renderer.depthWriterSkipEOL) >> 1;
                        depthOffset &= 1;
                    }
                } else {
                    rendererWriter.skip(skip + renderer.imageWriterSkipEOL, skip + renderer.depthWriterSkipEOL);
                }
            }
            if (needTextureUV && simpleTextureUV) {
                if (swapTextureUV) {
                    u += prim.uStep;
                } else {
                    v += prim.vStep;
                }
            }
            ++y;
        }
    }

    protected static int stencilOpFail(int destination, int stencilRefAlpha) {
        switch (stencilOpFail) {
            case 0: {
                return destination;
            }
            case 1: {
                return destination & 0xFFFFFF;
            }
            case 2: {
                if (stencilRef == 0) {
                    return destination & 0xFFFFFF;
                }
                return destination & 0xFFFFFF | stencilRefAlpha;
            }
            case 3: {
                return destination ^ 0xFF000000;
            }
            case 4: {
                int alpha = destination & 0xFF000000;
                if (alpha != -16777216) {
                    alpha += 0x1000000;
                }
                return destination & 0xFFFFFF | alpha;
            }
            case 5: {
                int alpha = destination & 0xFF000000;
                if (alpha != 0) {
                    alpha -= 0x1000000;
                }
                return destination & 0xFFFFFF | alpha;
            }
        }
        return destination;
    }

    protected static int stencilOpZFail(int destination, int stencilRefAlpha) {
        switch (stencilOpZFail) {
            case 0: {
                return destination;
            }
            case 1: {
                return destination & 0xFFFFFF;
            }
            case 2: {
                if (stencilRef == 0) {
                    return destination & 0xFFFFFF;
                }
                return destination & 0xFFFFFF | stencilRefAlpha;
            }
            case 3: {
                return destination ^ 0xFF000000;
            }
            case 4: {
                int alpha = destination & 0xFF000000;
                if (alpha != -16777216) {
                    alpha += 0x1000000;
                }
                return destination & 0xFFFFFF | alpha;
            }
            case 5: {
                int alpha = destination & 0xFF000000;
                if (alpha != 0) {
                    alpha -= 0x1000000;
                }
                return destination & 0xFFFFFF | alpha;
            }
        }
        return destination;
    }

    protected static int blendSrc(int source, int destination, int fix) {
        switch (blendSrc) {
            case 0: {
                return source;
            }
            case 1: {
                return -1 - source;
            }
            case 2: {
                int alpha = PixelColor.getAlpha(source);
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 3: {
                int alpha = 255 - PixelColor.getAlpha(source);
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 4: {
                int alpha = PixelColor.getAlpha(destination);
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 5: {
                int alpha = 255 - PixelColor.getAlpha(destination);
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 6: {
                int alpha = PixelColor.doubleComponent(PixelColor.getAlpha(source));
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 7: {
                int alpha = 255 - PixelColor.doubleComponent(PixelColor.getAlpha(source));
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 8: {
                int alpha = PixelColor.doubleComponent(PixelColor.getAlpha(destination));
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 9: {
                int alpha = 255 - PixelColor.doubleComponent(PixelColor.getAlpha(destination));
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 10: {
                return fix;
            }
        }
        return source;
    }

    protected static int blendDst(int source, int destination, int fix) {
        switch (blendDst) {
            case 0: {
                return destination;
            }
            case 1: {
                return -1 - destination;
            }
            case 2: {
                int alpha = PixelColor.getAlpha(source);
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 3: {
                int alpha = 255 - PixelColor.getAlpha(source);
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 4: {
                int alpha = PixelColor.getAlpha(destination);
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 5: {
                int alpha = 255 - PixelColor.getAlpha(destination);
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 6: {
                int alpha = PixelColor.doubleComponent(PixelColor.getAlpha(source));
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 7: {
                int alpha = 255 - PixelColor.doubleComponent(PixelColor.getAlpha(source));
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 8: {
                int alpha = PixelColor.doubleComponent(PixelColor.getAlpha(destination));
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 9: {
                int alpha = 255 - PixelColor.doubleComponent(PixelColor.getAlpha(destination));
                return PixelColor.getColorBGR(alpha, alpha, alpha);
            }
            case 10: {
                return fix;
            }
        }
        return destination;
    }
}

