/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.textures;

import java.util.HashMap;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.textures.GEIndexedTexture;
import jpcsp.graphics.textures.GEResizedTexture;
import jpcsp.graphics.textures.GETexture;

public class GETextureManager {
    private static GETextureManager instance;
    private HashMap<Long, GETexture> geTextures = new HashMap();

    public static GETextureManager getInstance() {
        if (instance == null) {
            instance = new GETextureManager();
        }
        return instance;
    }

    private Long getKey(int address, int bufferWidth, int width, int height, int pixelFormat) {
        return (long)address + ((long)bufferWidth << 30) + ((long)width << 40) + ((long)height << 50) + ((long)pixelFormat << 60);
    }

    public GETexture checkGETexture(int address, int bufferWidth, int width, int height, int pixelFormat) {
        Long key = this.getKey(address, bufferWidth, width, height, pixelFormat);
        return this.geTextures.get(key);
    }

    private GETexture checkGETexturePSM8888(int address, int bufferWidth, int width, int height, int pixelFormat) {
        GETexture geTexture = null;
        if (pixelFormat == 3 && (geTexture = this.checkGETexture(address, bufferWidth << 1, width, height, 0)) != null) {
            Long key = this.getKey(address, bufferWidth, width, height, pixelFormat);
            this.geTextures.remove(key);
        }
        return geTexture;
    }

    public GETexture getGETexture(IRenderingEngine re, int address, int bufferWidth, int width, int height, int pixelFormat, boolean useViewportResize) {
        GETexture geTexture = this.checkGETexturePSM8888(address, bufferWidth, width, height, pixelFormat);
        if (geTexture == null) {
            geTexture = this.checkGETexture(address, bufferWidth, width, height, pixelFormat);
        }
        if (geTexture == null) {
            Long key = this.getKey(address, bufferWidth, width, height, pixelFormat);
            geTexture = new GETexture(address, bufferWidth, width, height, pixelFormat, useViewportResize);
            this.geTextures.put(key, geTexture);
        }
        return geTexture;
    }

    public GETexture getGEResizedTexture(IRenderingEngine re, GETexture baseGETexture, int address, int bufferWidth, int width, int height, int pixelFormat) {
        GETexture geTexture = this.checkGETexturePSM8888(address, bufferWidth, width, height, pixelFormat);
        if (geTexture == null) {
            geTexture = this.checkGETexture(address, bufferWidth, width, height, pixelFormat);
        }
        if (geTexture == null) {
            Long key = this.getKey(address, bufferWidth, width, height, pixelFormat);
            geTexture = new GEResizedTexture(baseGETexture, address, bufferWidth, width, height, pixelFormat);
            this.geTextures.put(key, geTexture);
        }
        return geTexture;
    }

    public GETexture getGEIndexedTexture(IRenderingEngine re, GETexture baseGETexture, int address, int bufferWidth, int width, int height, int pixelFormat) {
        GETexture geTexture = this.checkGETexture(address, bufferWidth, width, height, pixelFormat);
        if (geTexture == null) {
            Long key = this.getKey(address, bufferWidth, width, height, pixelFormat);
            geTexture = new GEIndexedTexture(baseGETexture, address, bufferWidth, width, height, pixelFormat);
            this.geTextures.put(key, geTexture);
        }
        return geTexture;
    }

    public void reset(IRenderingEngine re) {
        for (GETexture geTexture : this.geTextures.values()) {
            geTexture.delete(re);
        }
        this.geTextures.clear();
    }
}

