/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.Memory;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.PdpObject;
import jpcsp.util.Utilities;

public abstract class PtpObject
extends PdpObject {
    private pspNetMacAddress destMacAddress;
    private int destPort;
    private int retryDelay;
    private int retryCount;
    private int queue;
    private int sentData;
    protected static final int BLOCKED_OPERATION_POLLING_MICROS = 10000;
    private AdhocMessage receivedMessage;
    private int receivedMessageOffset;

    public PtpObject(PtpObject ptpObject) {
        super(ptpObject);
        this.destMacAddress = ptpObject.destMacAddress;
        this.destPort = ptpObject.destPort;
        this.retryDelay = ptpObject.retryDelay;
        this.retryCount = ptpObject.retryCount;
        this.queue = ptpObject.queue;
    }

    public PtpObject(INetworkAdapter networkAdapter) {
        super(networkAdapter);
    }

    public pspNetMacAddress getDestMacAddress() {
        return this.destMacAddress;
    }

    public void setDestMacAddress(pspNetMacAddress destMacAddress) {
        this.destMacAddress = destMacAddress;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int destPort) {
        this.destPort = destPort;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public int getSentData() {
        return this.sentData;
    }

    @Override
    public void openSocket() throws UnknownHostException, IOException {
        if (this.socket == null) {
            super.openSocket();
            if (this.getDestMacAddress() != null) {
                int realDestPort = Modules.sceNetAdhocModule.getRealPortFromClientPort(this.getDestMacAddress().macAddress, this.getDestPort());
                SocketAddress socketAddress = Modules.sceNetAdhocModule.getSocketAddress(this.getDestMacAddress().macAddress, realDestPort);
                this.socket.connect(socketAddress, realDestPort);
            }
        }
    }

    public int open() {
        int result = 0;
        try {
            this.openSocket();
        }
        catch (BindException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"open", (Throwable)e);
            }
            result = -2143222006;
        }
        catch (SocketException e) {
            log.error((Object)"open", (Throwable)e);
        }
        catch (UnknownHostException e) {
            log.error((Object)"open", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"open", (Throwable)e);
        }
        return result;
    }

    public int listen() {
        int result = 0;
        try {
            this.openSocket();
        }
        catch (BindException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"listen", (Throwable)e);
            }
            result = -2143222006;
        }
        catch (SocketException e) {
            log.error((Object)"listen", (Throwable)e);
        }
        catch (UnknownHostException e) {
            log.error((Object)"listen", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"listen", (Throwable)e);
        }
        return result;
    }

    public int accept(int peerMacAddr, int peerPortAddr, int timeout, int nonblock) {
        int result = 0;
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
        if (this.pollAccept(peerMacAddr, peerPortAddr, thread)) {
            result = thread.cpuContext.gpr[2];
        } else if (nonblock != 0) {
            result = -2143222007;
        } else {
            BlockedPtpAccept blockedPtpAction = new BlockedPtpAccept(this, peerMacAddr, peerPortAddr, timeout);
            blockedPtpAction.blockCurrentThread();
        }
        return result;
    }

    public int connect(int timeout, int nonblock) {
        int result = 0;
        if (!this.pollConnect(Modules.ThreadManForUserModule.getCurrentThread())) {
            if (nonblock != 0) {
                result = -2143222007;
            } else {
                BlockedPtpConnect blockedPtpAction = new BlockedPtpConnect(this, timeout);
                blockedPtpAction.blockCurrentThread();
            }
        }
        return result;
    }

    @Override
    public void send(AdhocMessage adhocMessage) throws IOException {
        adhocMessage.setFromMacAddress(this.getMacAddress().macAddress);
        adhocMessage.setToMacAddress(this.getDestMacAddress().macAddress);
        this.send(adhocMessage, this.getDestPort());
    }

    public int send(int data, TPointer32 dataSizeAddr, int timeout, int nonblock) {
        int result = 0;
        try {
            AdhocMessage adhocMessage = this.networkAdapter.createAdhocPtpMessage(data, dataSizeAddr.getValue());
            this.send(adhocMessage);
        }
        catch (IOException e) {
            result = -2143222004;
            log.error((Object)"send returning ERROR_NET_ADHOC_DISCONNECTED", (Throwable)e);
        }
        return result;
    }

    public int recv(TPointer data, TPointer32 dataLengthAddr, int timeout, int nonblock) {
        int result = 0;
        try {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            if (this.pollRecv(data, dataLengthAddr, thread)) {
                result = thread.cpuContext.gpr[2];
            } else if (nonblock != 0) {
                result = -2143222007;
            } else {
                BlockedPtpRecv blockedPdpAction = new BlockedPtpRecv(this, data, dataLengthAddr, timeout);
                blockedPdpAction.blockCurrentThread();
            }
        }
        catch (IOException e) {
            result = -2143222004;
            log.error((Object)"recv", (Throwable)e);
        }
        return result;
    }

    protected boolean pollRecv(TPointer data, TPointer32 dataLengthAddr, SceKernelThreadInfo thread) throws IOException {
        int length = dataLengthAddr.getValue();
        boolean completed = false;
        if (length > 0) {
            if (this.getRcvdData() <= 0 || this.receivedMessage != null) {
                this.update();
            }
            if (this.getRcvdData() > 0) {
                if (length > this.getRcvdData()) {
                    length = this.getRcvdData();
                }
                dataLengthAddr.setValue(length);
                Memory mem = Memory.getInstance();
                mem.memcpy(data.getAddress(), this.buffer.addr, length);
                if (this.getRcvdData() > length) {
                    mem.memmove(this.buffer.addr, this.buffer.addr + length, this.getRcvdData() - length);
                }
                this.rcvdData -= length;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Returned received data: %d bytes", length));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("Returned data: %s", Utilities.getMemoryDump(data.getAddress(), length)));
                    }
                }
                PtpObject.setReturnValue(thread, 0);
                completed = true;
            }
        }
        return completed;
    }

    private int addReceivedMessage(AdhocMessage adhocMessage, int offset) {
        int length = Math.min(adhocMessage.getDataLength() - offset, this.getBufSize() - this.getRcvdData());
        int addr = this.buffer.addr + this.getRcvdData();
        adhocMessage.writeDataToMemory(addr, offset, length);
        this.rcvdData += length;
        if (log.isDebugEnabled()) {
            if (offset == 0) {
                log.debug((Object)String.format("Successfully received message (length=%d, rcvdData=%d) %s", length, this.getRcvdData(), adhocMessage));
            } else {
                log.debug((Object)String.format("Appending received message (offset=%d, length=%d, rcvdData=%d) %s", offset, length, this.getRcvdData(), adhocMessage));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Message data: %s", Utilities.getMemoryDump(addr, length)));
            }
        }
        return length;
    }

    @Override
    public void update() throws IOException {
        while (this.getRcvdData() < this.getBufSize()) {
            if (this.receivedMessage != null) {
                this.receivedMessageOffset += this.addReceivedMessage(this.receivedMessage, this.receivedMessageOffset);
                if (this.receivedMessageOffset < this.receivedMessage.getDataLength()) continue;
                this.receivedMessage = null;
                this.receivedMessageOffset = 0;
                continue;
            }
            try {
                this.openSocket();
                this.socket.setTimeout(1);
                byte[] bytes = new byte[65536];
                int length = this.socket.receive(bytes, bytes.length);
                int receivedPort = this.socket.getReceivedPort();
                InetAddress receivedAddress = this.socket.getReceivedAddress();
                AdhocMessage adhocMessage = this.createAdhocMessage(bytes, length);
                if (this.isForMe(adhocMessage, receivedPort, receivedAddress)) {
                    this.receivedMessage = adhocMessage;
                    this.receivedMessageOffset = 0;
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Received message not for me: %s", adhocMessage));
            }
            catch (SocketException e) {
                log.error((Object)"update", (Throwable)e);
                break;
            }
            catch (SocketTimeoutException e) {
                break;
            }
        }
    }

    @Override
    protected AdhocMessage createAdhocMessage(byte[] message, int length) {
        return this.networkAdapter.createAdhocPtpMessage(message, length);
    }

    protected abstract boolean pollAccept(int var1, int var2, SceKernelThreadInfo var3);

    protected abstract boolean pollConnect(SceKernelThreadInfo var1);

    public abstract boolean canAccept();

    public abstract boolean canConnect();

    @Override
    public String toString() {
        return String.format("PtpObject[id=%d, srcMacAddress=%s, srcPort=%d, destMacAddress=%s, destPort=%d, bufSize=%d, retryDelay=%d, retryCount=%d, queue=%d, rcvdData=%d]", this.getId(), this.getMacAddress(), this.getPort(), this.getDestMacAddress(), this.getDestPort(), this.getBufSize(), this.getRetryDelay(), this.getRetryCount(), this.getQueue(), this.getRcvdData());
    }

    protected static class BlockedPtpRecv
    extends BlockedPtpAction {
        protected final TPointer data;
        protected final TPointer32 dataLengthAddr;

        protected BlockedPtpRecv(PtpObject ptpObject, TPointer data, TPointer32 dataLengthAddr, int timeout) {
            super(ptpObject, timeout);
            this.data = data;
            this.dataLengthAddr = dataLengthAddr;
        }

        @Override
        protected boolean poll() throws IOException {
            return this.ptpObject.pollRecv(this.data, this.dataLengthAddr, this.thread);
        }

        @Override
        protected int getExceptionResult(IOException e) {
            return -2143221995;
        }
    }

    protected static class BlockedPtpConnect
    extends BlockedPtpAction {
        public BlockedPtpConnect(PtpObject ptpObject, int timeout) {
            super(ptpObject, timeout);
        }

        @Override
        protected boolean poll() throws IOException {
            return this.ptpObject.pollConnect(this.thread);
        }

        @Override
        protected int getExceptionResult(IOException e) {
            return -2143221992;
        }
    }

    protected static class BlockedPtpAccept
    extends BlockedPtpAction {
        private final int peerMacAddr;
        private final int peerPortAddr;

        public BlockedPtpAccept(PtpObject ptpObject, int peerMacAddr, int peerPortAddr, int timeout) {
            super(ptpObject, timeout);
            this.peerMacAddr = peerMacAddr;
            this.peerPortAddr = peerPortAddr;
        }

        @Override
        protected boolean poll() throws IOException {
            return this.ptpObject.pollAccept(this.peerMacAddr, this.peerPortAddr, this.thread);
        }

        @Override
        protected int getExceptionResult(IOException e) {
            return -2143221995;
        }
    }

    protected static abstract class BlockedPtpAction
    extends PdpObject.BlockedPdpAction {
        protected final PtpObject ptpObject;

        protected BlockedPtpAction(PtpObject ptpObject, int timeout) {
            super(ptpObject, timeout);
            this.ptpObject = ptpObject;
        }
    }
}

