/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.test_utils.TestUtils;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import junit.framework.TestCase;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTest
extends TestCase {
    private final String mSampleFile = "fixtures/testfile.flv";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Test
    public void testContainerOpenAndClose() {
        this.log.debug("About to change logging level");
        Global.setFFmpegLoggingLevel((int)50);
        IContainer container = null;
        IContainerFormat fmt = null;
        int retval = -1;
        container = IContainer.make();
        fmt = IContainerFormat.make();
        retval = fmt.setInputFormat("flv");
        ContainerTest.assertTrue((String)"could not set input format", (retval >= 0 ? 1 : 0) != 0);
        retval = fmt.setOutputFormat("flv", null, null);
        ContainerTest.assertTrue((String)"could not set output format", (retval >= 0 ? 1 : 0) != 0);
        container.delete();
        container = null;
        container = IContainer.make();
        retval = container.open("file:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv", IContainer.Type.WRITE, fmt);
        ContainerTest.assertTrue((String)"could not open file for writing", (retval >= 0 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.open("file:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv", IContainer.Type.WRITE, null);
        ContainerTest.assertTrue((String)"could not open file for writing", (retval >= 0 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.open("file:fixtures/testfile.flv", IContainer.Type.READ, fmt);
        ContainerTest.assertTrue((String)"could not open file for writing", (retval >= 0 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.open("file:fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file for writing", (retval >= 0 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close file", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCorrectNumberOfStreams() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        int numStreams = container.getNumStreams();
        ContainerTest.assertTrue((String)("incorrect number of streams: " + numStreams), (numStreams == 2 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close the file", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWriteHeaderAndTrailer() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open(((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv", IContainer.Type.WRITE, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        IStream stream = container.addNewStream(0);
        IStreamCoder coder = stream.getStreamCoder();
        coder.setCodec(ICodec.ID.CODEC_ID_MP3);
        coder.setSampleRate(22050);
        coder.setChannels(1);
        retval = coder.open();
        ContainerTest.assertTrue((String)"could not open coder", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeHeader();
        ContainerTest.assertTrue((String)"could not write header", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeTrailer();
        ContainerTest.assertTrue((String)"could not write header", (retval >= 0 ? 1 : 0) != 0);
        retval = coder.close();
        ContainerTest.assertTrue((String)"could not close coder", (retval >= 0 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close the file", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWriteTrailerWithNoWriteHeaderDoesNotCrashJVM() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open(((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv", IContainer.Type.WRITE, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeTrailer();
        ContainerTest.assertTrue((String)"could not write header", (retval < 0 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close the file", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOpenFileSetsInputContainer() {
        IContainer container = null;
        IContainerFormat fmt = null;
        int retval = -1;
        container = IContainer.make();
        retval = container.open("file:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv", IContainer.Type.WRITE, null);
        ContainerTest.assertTrue((String)"could not open file for writing", (retval >= 0 ? 1 : 0) != 0);
        fmt = container.getContainerFormat();
        ContainerTest.assertNotNull((Object)fmt);
        ContainerTest.assertEquals((String)"flv", (String)fmt.getOutputFormatShortName());
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.open("file:fixtures/testfile.flv", IContainer.Type.READ, fmt);
        ContainerTest.assertTrue((String)"could not open file for writing", (retval >= 0 ? 1 : 0) != 0);
        fmt = container.getContainerFormat();
        ContainerTest.assertNotNull((Object)fmt);
        ContainerTest.assertEquals((String)"flv", (String)fmt.getInputFormatShortName());
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close file", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamMetaData() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.queryStreamMetaData();
        ContainerTest.assertTrue((String)"could not query stream meta data", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamMetaDataFailsIfFileNotOpen() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.queryStreamMetaData();
        ContainerTest.assertTrue((String)"could query stream meta data", (retval < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetDuration() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        ContainerTest.assertEquals((String)"unexpected duration", (double)1.49264E8, (double)container.getDuration(), (double)30000.0);
    }

    @Test
    public void testGetStartTime() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        ContainerTest.assertEquals((String)"unexpected start time", (long)0L, (long)container.getStartTime());
    }

    @Test
    public void testGetFileSize() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        ContainerTest.assertEquals((String)"unexpected filesize", (long)4546420L, (long)container.getFileSize());
    }

    @Test
    public void testGetBitRate() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.mp3", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        ContainerTest.assertEquals((String)"unexpected bit rate", (float)127999.0f, (float)container.getBitRate(), (float)1000.0f);
    }

    @Test
    public void testReadPackets() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        long packetsRead = 0L;
        IPacket packet = IPacket.make();
        while (container.readNextPacket(packet) >= 0) {
            if (!packet.isComplete()) continue;
            ++packetsRead;
        }
        ContainerTest.assertEquals((String)"got unexpected number of packets in file", (long)7950L, (long)packetsRead);
    }

    @Test
    public void testReadPacketAddsTimeBase() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        IPacket packet = IPacket.make();
        for (int i = 0; i < 3; ++i) {
            ContainerTest.assertTrue((container.readNextPacket(packet) >= 0 ? 1 : 0) != 0);
            IRational timebase = packet.getTimeBase();
            ContainerTest.assertNotNull((Object)timebase);
            ContainerTest.assertEquals((int)1, (int)timebase.getNumerator());
            ContainerTest.assertEquals((int)1000, (int)timebase.getDenominator());
        }
        container.close();
    }

    @Test
    public void testSeekKeyFrame() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.seekKeyFrame(0, 20000L, 1);
        ContainerTest.assertTrue((String)"could not seek to key frame", (retval >= 0 ? 1 : 0) != 0);
        long packetsRead = 0L;
        IPacket packet = IPacket.make();
        while (container.readNextPacket(packet) >= 0) {
            if (!packet.isComplete()) continue;
            ++packetsRead;
        }
        ContainerTest.assertEquals((String)"got unexpected number of packets in file", (long)6905L, (long)packetsRead);
    }

    @Test
    public void testSeekKeyFrame2() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.seekKeyFrame(0, 18000L, 20000L, 21000L, 0);
        ContainerTest.assertTrue((String)"could not seek to key frame", (retval >= 0 ? 1 : 0) != 0);
        long packetsRead = 0L;
        IPacket packet = IPacket.make();
        while (container.readNextPacket(packet) >= 0) {
            if (!packet.isComplete()) continue;
            ++packetsRead;
        }
        ContainerTest.assertEquals((String)"got unexpected number of packets in file", (long)6905L, (long)packetsRead);
    }

    @Test
    public void testSeekKeyFrameWithNegativeStream() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.seekKeyFrame(-1, 20000000L, 1);
        long packetsRead = 0L;
        IPacket packet = IPacket.make();
        while (container.readNextPacket(packet) >= 0) {
            if (!packet.isComplete()) continue;
            ++packetsRead;
        }
        ContainerTest.assertEquals((String)"got unexpected number of packets in file", (long)6905L, (long)packetsRead);
    }

    @Test
    public void testSeekKeyFrameWithInvalidStream() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.seekKeyFrame(2, 20000L, 1);
        ContainerTest.assertTrue((String)"should fail as only 2 strems in this file", (retval < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAndSetProperty() {
        IContainer container = IContainer.make();
        int numProperties = container.getNumProperties();
        ContainerTest.assertTrue((String)"should be able to set properties before opening", (numProperties > 0 ? 1 : 0) != 0);
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        ContainerTest.assertEquals((String)"should have same properties", (int)numProperties, (int)container.getNumProperties());
        long probeSize = container.getPropertyAsLong("probesize");
        this.log.debug("probesize: {}", (Object)probeSize);
        ContainerTest.assertTrue((String)"should have a non-zero probesize", (probeSize > 0L ? 1 : 0) != 0);
        ContainerTest.assertTrue((String)"should succeed", (container.setProperty("probesize", 53535353L) >= 0 ? 1 : 0) != 0);
        ContainerTest.assertEquals((String)"should be equal", (long)53535353L, (long)container.getPropertyAsLong("probesize"));
        ContainerTest.assertTrue((String)"should fail", (container.setProperty("notapropertyatall", 15L) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetFlags() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        int flags = container.getFlags();
        ContainerTest.assertEquals((String)("container should have no flags: " + flags), (int)flags, (int)0);
        container.close();
    }

    @Test
    public void testSetFlags() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        int flags = container.getFlags();
        ContainerTest.assertEquals((String)("container should have no flags: " + flags), (int)flags, (int)0);
        boolean genPts = container.getFlag(IContainer.Flags.FLAG_GENPTS);
        ContainerTest.assertTrue((String)"should be false", (!genPts ? 1 : 0) != 0);
        container.setFlag(IContainer.Flags.FLAG_GENPTS, true);
        genPts = container.getFlag(IContainer.Flags.FLAG_GENPTS);
        ContainerTest.assertTrue((String)"should be true", (boolean)genPts);
        container.close();
    }

    @Test
    public void testWriteTrailerAfterCodecClosingFails() {
        IContainer container = IContainer.make();
        int retval = container.open("file:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv", IContainer.Type.WRITE, null);
        ContainerTest.assertTrue((String)"could not open file for writing", (retval >= 0 ? 1 : 0) != 0);
        IStream stream = container.addNewStream(0);
        IStreamCoder coder = stream.getStreamCoder();
        coder.setCodec(ICodec.ID.CODEC_ID_MP3);
        coder.setChannels(1);
        coder.setSampleRate(22050);
        retval = coder.open();
        ContainerTest.assertTrue((String)"could not open audio codec", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeHeader();
        ContainerTest.assertTrue((String)"could not write header", (retval >= 0 ? 1 : 0) != 0);
        retval = coder.close();
        ContainerTest.assertTrue((String)"could not close audio codec", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeTrailer();
        ContainerTest.assertTrue((String)"this should fail", (retval < 0 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close file", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetURL() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        ContainerTest.assertEquals((String)"should be the same", (String)"fixtures/testfile.flv", (String)container.getURL());
    }

    @Test
    public void testGetURLEmptyContainer() {
        IContainer container = IContainer.make();
        ContainerTest.assertNull((String)"should be null", (Object)container.getURL());
        int retval = container.open("", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"should fail", (retval < 0 ? 1 : 0) != 0);
        ContainerTest.assertNull((String)"should be null", (Object)container.getURL());
    }

    @Test
    public void testFlushPacket() {
        IContainer container = IContainer.make();
        int retval = container.open("file:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv", IContainer.Type.WRITE, null);
        ContainerTest.assertTrue((String)"could not open file for writing", (retval >= 0 ? 1 : 0) != 0);
        IStream stream = container.addNewStream(0);
        IStreamCoder coder = stream.getStreamCoder();
        coder.setCodec(ICodec.ID.CODEC_ID_MP3);
        coder.setChannels(1);
        coder.setSampleRate(22050);
        retval = coder.open();
        ContainerTest.assertTrue((String)"could not open audio codec", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeHeader();
        ContainerTest.assertTrue((String)"could not write header", (retval >= 0 ? 1 : 0) != 0);
        retval = container.flushPackets();
        ContainerTest.assertTrue((String)"could not flush packets", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeTrailer();
        ContainerTest.assertTrue((String)"this should fail", (retval >= 0 ? 1 : 0) != 0);
        retval = coder.close();
        ContainerTest.assertTrue((String)"could not close audio codec", (retval >= 0 ? 1 : 0) != 0);
        retval = container.close();
        ContainerTest.assertTrue((String)"could not close file", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWriteFailsOnReadOnlyContainers() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeHeader();
        ContainerTest.assertTrue((String)"should fail on read only file", (retval < 0 ? 1 : 0) != 0);
        IPacket pkt = IPacket.make();
        retval = container.writePacket(pkt);
        ContainerTest.assertTrue((String)"should fail on read only file", (retval < 0 ? 1 : 0) != 0);
        retval = container.writeTrailer();
        ContainerTest.assertTrue((String)"should fail on read only file", (retval < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIssue97Regression() {
        IContainer container = IContainer.make();
        int retval = -1;
        retval = container.open(((Object)((Object)this)).getClass().getName() + "_" + TestUtils.getNameOfCallingMethod() + ".mp3", IContainer.Type.WRITE, null);
        ContainerTest.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        retval = container.writeHeader();
        ContainerTest.assertTrue((String)"should fail instead of core dumping", (retval < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSDPData() {
        IContainerFormat format = IContainerFormat.make();
        format.setOutputFormat("rtp", null, null);
        IContainer container = IContainer.make();
        container.open("rtp://127.0.0.1:23832", IContainer.Type.WRITE, format);
        IStream stream = container.addNewStream(0);
        IStreamCoder coder = stream.getStreamCoder();
        coder.setCodec(ICodec.ID.CODEC_ID_H263);
        coder.setWidth(352);
        coder.setHeight(288);
        coder.setPixelType(IPixelFormat.Type.YUV420P);
        coder.setTimeBase(IRational.make((int)1, (int)90000));
        coder.open();
        IBuffer buffer = IBuffer.make(null, (int)4192);
        int len = container.createSDPData(buffer);
        ContainerTest.assertTrue((len > 1 ? 1 : 0) != 0);
        byte[] stringBuf = new byte[len - 1];
        buffer.get(0, stringBuf, 0, stringBuf.length);
        String sdp = new String(stringBuf);
        ContainerTest.assertNotNull((Object)sdp);
        this.log.debug("SDP({}) = {}", (Object)sdp.length(), (Object)sdp);
        String otherSdp = container.createSDPData();
        ContainerTest.assertEquals((String)sdp, (String)otherSdp);
    }
}

