/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String sampleFile = "fixtures/testfile.flv";
    private IStream mStream = null;
    private IContainer mContainer = null;

    @Before
    public void setUp() {
        this.log.debug("Executing test case: {}", (Object)this.getName());
        if (this.mContainer != null) {
            this.mContainer.delete();
        }
        this.mContainer = IContainer.make();
        if (this.mStream != null) {
            this.mStream.delete();
        }
        this.mStream = null;
    }

    @Test
    public void testGetStream() {
        this.helperGetStream(1);
    }

    @Test
    public void testStreamGetters() {
        this.helperGetStream(0);
        IRational rational = null;
        long val = 0L;
        val = this.mStream.getIndex();
        this.log.debug("Index: {}", (Object)val);
        val = this.mStream.getId();
        this.log.debug("ID: {}", (Object)val);
        rational = this.mStream.getFrameRate();
        this.log.debug("Frame Rate: {}", (Object)rational.getDouble());
        rational = this.mStream.getTimeBase();
        this.log.debug("Time Base: {}", (Object)rational.getDouble());
        val = this.mStream.getStartTime();
        this.log.debug("Start Time: {}", (Object)val);
        val = this.mStream.getDuration();
        this.log.debug("Duration: {}", (Object)val);
        val = this.mStream.getCurrentDts();
        this.log.debug("Current Dts: {}", (Object)val);
        val = this.mStream.getNumFrames();
        this.log.debug("Number of Frames: {}", (Object)val);
        val = this.mStream.getNumIndexEntries();
        this.log.debug("Number of Index Entries: {}", (Object)val);
    }

    public void testGetStreamCoder() {
        this.helperGetStream(0);
        IStreamCoder coder = null;
        coder = this.mStream.getStreamCoder();
        StreamTest.assertTrue((coder != null ? 1 : 0) != 0);
    }

    public void testGetSampleAspectRatio() {
        this.helperGetStream(0);
        IRational sample = this.mStream.getSampleAspectRatio();
        StreamTest.assertNotNull((Object)sample);
        StreamTest.assertEquals((int)0, (int)sample.getNumerator());
        StreamTest.assertEquals((int)0, (int)sample.getNumerator());
    }

    public void testSetSampleAspectRatio() {
        this.helperGetStream(0);
        IRational newVal = IRational.make((int)3, (int)2);
        this.mStream.setSampleAspectRatio(newVal);
        IRational sample = this.mStream.getSampleAspectRatio();
        StreamTest.assertNotNull((Object)sample);
        StreamTest.assertEquals((int)3, (int)sample.getNumerator());
        StreamTest.assertEquals((int)2, (int)sample.getDenominator());
    }

    public void testSetSampleAspectRatioNullIgnored() {
        this.helperGetStream(0);
        IRational newVal = IRational.make((int)3, (int)2);
        this.mStream.setSampleAspectRatio(newVal);
        IRational sample = this.mStream.getSampleAspectRatio();
        StreamTest.assertNotNull((Object)sample);
        StreamTest.assertEquals((int)3, (int)sample.getNumerator());
        StreamTest.assertEquals((int)2, (int)sample.getDenominator());
        newVal = null;
        this.mStream.setSampleAspectRatio(newVal);
        sample = this.mStream.getSampleAspectRatio();
        StreamTest.assertNotNull((Object)sample);
        StreamTest.assertEquals((int)3, (int)sample.getNumerator());
        StreamTest.assertEquals((int)2, (int)sample.getDenominator());
    }

    public void testGetLanguage() {
        this.helperGetStream(0);
        String lang = this.mStream.getLanguage();
        StreamTest.assertNull((Object)lang);
    }

    public void testSetLanguage() {
        this.helperGetStream(0);
        String lang = this.mStream.getLanguage();
        StreamTest.assertNull((Object)lang);
        this.mStream.setLanguage("jpn");
        StreamTest.assertEquals((String)"jpn", (String)this.mStream.getLanguage());
    }

    public void testSetLanguageNull() {
        this.helperGetStream(0);
        this.mStream.setLanguage("jpn");
        StreamTest.assertEquals((String)"jpn", (String)this.mStream.getLanguage());
        this.mStream.setLanguage(null);
        StreamTest.assertNull((Object)this.mStream.getLanguage());
    }

    public void testSetLanguageEmptyString() {
        this.helperGetStream(0);
        this.mStream.setLanguage("jpn");
        StreamTest.assertEquals((String)"jpn", (String)this.mStream.getLanguage());
        this.mStream.setLanguage("");
        StreamTest.assertNull((Object)this.mStream.getLanguage());
    }

    public void testSetLanguageFourCharacterString() {
        this.helperGetStream(0);
        this.mStream.setLanguage("1234");
        StreamTest.assertEquals((String)"1234", (String)this.mStream.getLanguage());
    }

    public void testSetLanguageFiveCharacterString() {
        this.helperGetStream(0);
        this.mStream.setLanguage("12345");
        StreamTest.assertEquals((String)"1234", (String)this.mStream.getLanguage());
    }

    private void helperGetStream(int index) {
        int retval = -1;
        retval = this.mContainer.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        StreamTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        StreamTest.assertTrue((this.mContainer.getNumStreams() == 2 ? 1 : 0) != 0);
        this.mStream = this.mContainer.getStream((long)index);
        StreamTest.assertTrue((this.mStream != null ? 1 : 0) != 0);
        StreamTest.assertTrue((this.mStream.getIndex() == index ? 1 : 0) != 0);
    }

    @Test
    public void testGetParseType() {
        int retval = -1;
        retval = this.mContainer.open("fixtures/testfile.mp3", IContainer.Type.READ, null);
        StreamTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        StreamTest.assertEquals((int)1, (int)this.mContainer.getNumStreams());
        this.mStream = this.mContainer.getStream(0L);
        StreamTest.assertEquals((Object)IStream.ParseType.PARSE_FULL, (Object)this.mStream.getParseType());
        this.mStream.setParseType(IStream.ParseType.PARSE_NONE);
        StreamTest.assertEquals((Object)IStream.ParseType.PARSE_NONE, (Object)this.mStream.getParseType());
        this.helperGetStream(0);
        StreamTest.assertEquals((Object)IStream.ParseType.PARSE_NONE, (Object)this.mStream.getParseType());
    }
}

