/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.FfmpegIO;
import com.xuggle.xuggler.io.FfmpegIOHandle;
import com.xuggle.xuggler.io.FileProtocolHandler;
import com.xuggle.xuggler.io.FileProtocolHandlerFactory;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.IURLProtocolHandlerFactory;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FileProtocolHandlerTest
extends TestCase {
    private IURLProtocolHandlerFactory factory = null;
    private IURLProtocolHandler handler = null;
    private final String sampleFile = "fixtures/testfile.flv";
    private final String fileProtocolString = "file";
    private final String ffmpegioProtocolString = "xugglerfile";

    @Before
    public void setUp() {
        this.factory = new FileProtocolHandlerFactory();
        this.handler = null;
    }

    @After
    public void tearDown() {
        this.handler = null;
    }

    @Test
    public void testInvalidFileOpenForReading() {
        String badReadFile = "/tmp/garbage-file-k200cski2loiudjhsl2";
        int flags = 0;
        int retval = 0;
        this.handler = new FileProtocolHandler(badReadFile);
        FileProtocolHandlerTest.assertTrue((this.handler != null ? 1 : 0) != 0);
        retval = this.handler.open(null, flags);
        FileProtocolHandlerTest.assertTrue((retval == -1 ? 1 : 0) != 0);
        retval = this.handler.open(badReadFile, flags);
        FileProtocolHandlerTest.assertTrue((retval == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testValidFFMPEGURLFileOpenForReading() {
        int flags = 0;
        String url = "xugglerfile:fixtures/testfile.flv";
        int retval = -1;
        this.handler = this.factory.getHandler("xugglerfile", "xugglerfile:fixtures/testfile.flv", flags);
        FileProtocolHandlerTest.assertTrue((String)"could not find a handler using the factory", (this.handler != null ? 1 : 0) != 0);
        retval = this.handler.open(null, flags);
        FileProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = this.handler.open("xugglerfile:fixtures/testfile.flv", flags);
        FileProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        this.handler = new FileProtocolHandler();
        retval = this.handler.open(null, flags);
        FileProtocolHandlerTest.assertTrue((retval == -1 ? 1 : 0) != 0);
        retval = this.handler.open("xugglerfile:fixtures/testfile.flv", flags);
        FileProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        this.handler = new FileProtocolHandler("xugglerfile:fixtures/testfile.flv");
        retval = this.handler.open(null, flags);
        FileProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = this.handler.open("xugglerfile:fixtures/testfile.flv", flags);
        FileProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)"xugglerfile:fixtures/testfile.flv", (int)flags);
        FileProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        FileProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidFileOpenForWriting() {
        String badWriteFile = "/notavalidrootdir/garbage-file-k200cski2loiudjhsl2";
        this.handler = new FileProtocolHandler(badWriteFile);
        int retval = 0;
        retval = this.handler.open(null, 1);
        FileProtocolHandlerTest.assertTrue((retval == -1 ? 1 : 0) != 0);
        retval = this.handler.open(badWriteFile, 1);
        FileProtocolHandlerTest.assertTrue((retval == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFileRead() {
        this.handler = new FileProtocolHandler();
        int retval = 0;
        retval = this.handler.open("file:fixtures/testfile.flv", 0);
        FileProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        long bytesRead = 0L;
        long totalBytes = this.handler.seek(0L, 65536);
        byte[] buffer = new byte[1024];
        while ((retval = this.handler.read(buffer, buffer.length)) > 0) {
            bytesRead += (long)retval;
        }
        FileProtocolHandlerTest.assertEquals((long)totalBytes, (long)bytesRead);
        retval = this.handler.close();
        FileProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFileWrite() {
        String copyFile = "file:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv";
        this.handler = new FileProtocolHandler();
        int retval = 0;
        retval = this.handler.open(copyFile, 1);
        FileProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        FileProtocolHandler reader = new FileProtocolHandler("fixtures/testfile.flv");
        retval = reader.open(null, 0);
        long bytesWritten = 0L;
        long totalBytes = reader.seek(0L, 65536);
        byte[] buffer = new byte[1024];
        while ((retval = reader.read(buffer, buffer.length)) > 0) {
            FileProtocolHandlerTest.assertTrue(((retval = this.handler.write(buffer, retval)) >= 0 ? 1 : 0) != 0);
            bytesWritten += (long)retval;
        }
        FileProtocolHandlerTest.assertTrue((bytesWritten == totalBytes ? 1 : 0) != 0);
        retval = reader.close();
        FileProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        retval = this.handler.close();
        FileProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFFMPEGUrlRead() {
        this.testFFMPEGUrlReadTestFile("fixtures/testfile.flv");
    }

    @Test
    public void testFFMPEGIOUrlRead() {
        this.testFFMPEGUrlReadTestFile("xugglerfile:fixtures/testfile.flv");
    }

    private void testFFMPEGUrlReadTestFile(String filename) {
        long retval = 0L;
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)filename, (int)0);
        FileProtocolHandlerTest.assertTrue((String)("url_open(" + filename + ") failed: " + retval), (retval >= 0L ? 1 : 0) != 0);
        long bytesRead = 0L;
        byte[] buffer = new byte[1024];
        while ((retval = (long)FfmpegIO.url_read((FfmpegIOHandle)handle, (byte[])buffer, (int)buffer.length)) > 0L) {
            bytesRead += retval;
        }
        long fileSize = FileProtocolHandlerTest.getFileSize("fixtures/testfile.flv");
        FileProtocolHandlerTest.assertTrue((String)"getFileSize failed", (bytesRead == fileSize ? 1 : 0) != 0);
        long position = 0L;
        retval = FfmpegIO.url_seek((FfmpegIOHandle)handle, (long)position, (int)65536);
        FileProtocolHandlerTest.assertTrue((String)("url_seek 1 failed: " + retval), (bytesRead == retval || retval == -1L ? 1 : 0) != 0);
        retval = FfmpegIO.url_seek((FfmpegIOHandle)handle, (long)position, (int)2);
        FileProtocolHandlerTest.assertTrue((String)("url_seek 2 failed: " + retval), (retval >= 0L ? 1 : 0) != 0);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        FileProtocolHandlerTest.assertTrue((String)("url_close failed: " + retval), (retval >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultUrlWrite() {
        this.testFFMPEGUrlWriteTestFile("file:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv");
    }

    @Test
    public void testFfmpegIoUrlWrite() {
        this.testFFMPEGUrlWriteTestFile("xugglerfile:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv");
    }

    private void testFFMPEGUrlWriteTestFile(String filename) {
        int retval = 0;
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)filename, (int)1);
        FileProtocolHandlerTest.assertTrue((String)("url_open failed: " + retval), (retval >= 0 ? 1 : 0) != 0);
        byte[] buffer = new byte[]{70, 76, 86, 0};
        retval = FfmpegIO.url_write((FfmpegIOHandle)handle, (byte[])buffer, (int)buffer.length);
        FileProtocolHandlerTest.assertTrue((String)("url_write failed: " + retval), (retval == buffer.length ? 1 : 0) != 0);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        FileProtocolHandlerTest.assertTrue((String)("url_close failed: " + retval), (retval >= 0 ? 1 : 0) != 0);
    }

    private static long getFileSize(String filename) {
        FileProtocolHandler handler = new FileProtocolHandler();
        int retval = 0;
        retval = handler.open(filename, 0);
        FileProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        long totalBytes = handler.seek(0L, 65536);
        FileProtocolHandlerTest.assertTrue((totalBytes >= 0L ? 1 : 0) != 0);
        retval = handler.close();
        FileProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        return totalBytes;
    }
}

