/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.FfmpegIO;
import com.xuggle.xuggler.io.FfmpegIOHandle;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.NullProtocolHandler;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NullProtocolHandlerTest
extends TestCase {
    private IURLProtocolHandler writeHandle = null;
    private final String sampleFile = "fixtures/testfile.flv";
    private final String nullProtocolString = "xugglernull";

    @Before
    public void setUp() {
        this.writeHandle = null;
    }

    @After
    public void tearDown() {
        this.writeHandle = null;
    }

    @Test
    public void testCreate() {
        NullProtocolHandlerTest.assertNotNull((Object)new NullProtocolHandler());
    }

    @Test
    public void testCanOpenAnyFile() {
        String badReadFile = "/tmp/garbage-file-k200cski2loiudjhsl2";
        int flags = 0;
        int retval = 0;
        this.writeHandle = new NullProtocolHandler();
        NullProtocolHandlerTest.assertTrue((this.writeHandle != null ? 1 : 0) != 0);
        retval = this.writeHandle.open(null, flags);
        NullProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = this.writeHandle.open(badReadFile, flags);
        NullProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testValidFFMPEGURLFileOpenForReading() {
        int flags = 0;
        String url = "xugglernull:fixtures/testfile.flv";
        int retval = -1;
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)"xugglernull:fixtures/testfile.flv", (int)flags);
        NullProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        NullProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidFileOpenForWriting() {
        int flags = 2;
        String url = "xugglernull:foo";
        int retval = -1;
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)"xugglernull:foo", (int)flags);
        NullProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        NullProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFileRead() {
        this.writeHandle = new NullProtocolHandler();
        String filename = "xugglernull:fixtures/testfile.flv";
        int retval = 0;
        retval = this.writeHandle.open(filename, 0);
        NullProtocolHandlerTest.assertTrue((String)("Could not open file: " + filename), (retval >= 0 ? 1 : 0) != 0);
        long bytesRead = 0L;
        long totalBytes = this.writeHandle.seek(0L, 65536);
        byte[] buffer = new byte[1024];
        while ((retval = this.writeHandle.read(buffer, buffer.length)) > 0) {
            bytesRead += (long)retval;
        }
        NullProtocolHandlerTest.assertEquals((long)0L, (long)totalBytes);
        NullProtocolHandlerTest.assertEquals((long)totalBytes, (long)bytesRead);
        retval = this.writeHandle.close();
        NullProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFileWrite() {
        String copyFile = "xugglernull:" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv";
        FfmpegIOHandle writeHandle = new FfmpegIOHandle();
        int retval = -1;
        retval = FfmpegIO.url_open((FfmpegIOHandle)writeHandle, (String)copyFile, (int)1);
        NullProtocolHandlerTest.assertTrue((String)("could not open url: " + copyFile), (retval >= 0 ? 1 : 0) != 0);
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)"fixtures/testfile.flv", (int)0);
        NullProtocolHandlerTest.assertTrue((String)"could not open url: fixtures/testfile.flv", (retval == 0 ? 1 : 0) != 0);
        long bytesWritten = 0L;
        long bytesRead = 0L;
        byte[] buffer = new byte[1024];
        while ((retval = FfmpegIO.url_read((FfmpegIOHandle)handle, (byte[])buffer, (int)buffer.length)) > 0) {
            bytesRead += (long)retval;
            NullProtocolHandlerTest.assertTrue(((retval = FfmpegIO.url_write((FfmpegIOHandle)writeHandle, (byte[])buffer, (int)retval)) >= 0 ? 1 : 0) != 0);
            bytesWritten += (long)retval;
        }
        NullProtocolHandlerTest.assertTrue((bytesRead > 0L ? 1 : 0) != 0);
        NullProtocolHandlerTest.assertEquals((long)bytesRead, (long)bytesWritten);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        NullProtocolHandlerTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = FfmpegIO.url_close((FfmpegIOHandle)writeHandle);
        NullProtocolHandlerTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
    }
}

