/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.video;

import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class ConverterFactoryTest {
    public static final int TEST_WIDTH = 48;
    public static final int TEST_HEIGHT = 48;
    private final ConverterFactory.Type mConverterType;
    private final IPixelFormat.Type mPixelType;
    public static final IPixelFormat.Type[] mIncludedPixelTypes = new IPixelFormat.Type[]{IPixelFormat.Type.ARGB, IPixelFormat.Type.BGR24, IPixelFormat.Type.YUV420P};
    public static final IPixelFormat.Type[] mExcludePixelTypes = new IPixelFormat.Type[]{IPixelFormat.Type.NONE, IPixelFormat.Type.PAL8, IPixelFormat.Type.XVMC_MPEG2_MC, IPixelFormat.Type.XVMC_MPEG2_IDCT, IPixelFormat.Type.UYYVYY411, IPixelFormat.Type.BGR4, IPixelFormat.Type.RGB4, IPixelFormat.Type.NV12, IPixelFormat.Type.NV21, IPixelFormat.Type.VDPAU_H264, IPixelFormat.Type.VDPAU_MPEG1, IPixelFormat.Type.VDPAU_MPEG2, IPixelFormat.Type.VDPAU_WMV3, IPixelFormat.Type.VDPAU_VC1, IPixelFormat.Type.RGB48BE, IPixelFormat.Type.RGB48LE, IPixelFormat.Type.RGB565BE, IPixelFormat.Type.RGB555BE, IPixelFormat.Type.BGR565BE, IPixelFormat.Type.BGR555BE, IPixelFormat.Type.VAAPI_MOCO, IPixelFormat.Type.VAAPI_IDCT, IPixelFormat.Type.VAAPI_VLD, IPixelFormat.Type.NB};

    public ConverterFactoryTest(ConverterFactory.Type converterType, IPixelFormat.Type pixelType) {
        this.mConverterType = converterType;
        this.mPixelType = pixelType;
        System.out.println("Testing " + this.mConverterType + ", " + this.mPixelType);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> converterTypes() {
        Vector<Object[]> parameters = new Vector<Object[]>();
        for (IPixelFormat.Type pixelType : mIncludedPixelTypes) {
            for (ConverterFactory.Type converterType : ConverterFactory.getRegisteredConverters()) {
                Object[] tuple = new Object[]{converterType, pixelType};
                parameters.add(tuple);
            }
        }
        return parameters;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVideoPictureToImageNullInput() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new IllegalArgumentException();
        }
        IConverter c = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mConverterType.getPictureType(), (int)48, (int)48);
        c.toImage(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImageToVideoPictureNullInput() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new IllegalArgumentException();
        }
        IConverter c = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mConverterType.getPictureType(), (int)48, (int)48);
        c.toPicture(null, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVideoPictureToImageIncompletePicture() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new IllegalArgumentException();
        }
        IConverter c = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mConverterType.getPictureType(), (int)48, (int)48);
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)this.mConverterType.getPictureType(), (int)48, (int)48);
        c.toImage(picture);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVideoPictureToImageWrongFormat() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new IllegalArgumentException();
        }
        IConverter c = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)48, (int)48);
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.GRAY16BE, (int)48, (int)48);
        c.toImage(picture);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImageToVideoPictureWrongFormatInput() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new IllegalArgumentException();
        }
        IConverter c = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)48, (int)48);
        BufferedImage image = new BufferedImage(48, 48, 1);
        c.toPicture(image, 0L);
    }

    @Test
    public void testImageToImageSolidColor() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        int w = 48;
        int h = 48;
        int gray = Color.GRAY.getRGB();
        IConverter converter = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mPixelType, (int)w, (int)h);
        BufferedImage image1 = new BufferedImage(w, h, this.mConverterType.getImageType());
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                image1.setRGB(x, y, gray);
            }
        }
        BufferedImage image2 = converter.toImage(converter.toPicture(image1, 0L));
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel1 = image1.getRGB(x, y);
                int pixel2 = image2.getRGB(x, y);
                String message = this.testPixels(this.mConverterType.getPictureType() == converter.getPictureType(), pixel1, pixel2, x, y, converter.getPictureType());
                Assert.assertNull((String)message, (Object)message);
            }
        }
    }

    @Test
    public void testImageToImageSolidColorWithResize() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        int w1 = 48;
        int h1 = 48;
        int w2 = 96;
        int h2 = 96;
        int gray = Color.GRAY.getRGB();
        IConverter converter1 = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mPixelType, (int)w2, (int)h2, (int)w1, (int)h1);
        IConverter converter2 = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mPixelType, (int)w2, (int)h2, (int)w2, (int)h2);
        BufferedImage image1 = new BufferedImage(w1, h1, this.mConverterType.getImageType());
        for (int x = 0; x < w1; ++x) {
            for (int y = 0; y < h1; ++y) {
                image1.setRGB(x, y, gray);
            }
        }
        IVideoPicture picutre = converter1.toPicture(image1, 0L);
        BufferedImage image2 = converter2.toImage(picutre);
        Assert.assertEquals((String)"image2 wrong width", (int)w2, (int)image2.getWidth());
        Assert.assertEquals((String)"image2 wrong height", (int)h2, (int)image2.getHeight());
        for (int x = 0; x < w1; ++x) {
            for (int y = 0; y < h1; ++y) {
                int pixel1 = image1.getRGB(x, y);
                int pixel2 = image2.getRGB(x * 2, y * 2);
                String message = this.testPixels(false, pixel1, pixel2, x, y, converter1.getPictureType());
                Assert.assertNull((String)message, (Object)message);
            }
        }
    }

    @Ignore
    @Test
    public void testImageToImageSolidColorWithCustomSizes() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        int w = 63;
        int h = 48;
        int gray = Color.GRAY.getRGB();
        IConverter converter = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mPixelType, (int)w, (int)h);
        BufferedImage image1 = new BufferedImage(w, h, this.mConverterType.getImageType());
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                image1.setRGB(x, y, gray);
            }
        }
        BufferedImage image2 = converter.toImage(converter.toPicture(image1, 0L));
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel1 = image1.getRGB(x, y);
                int pixel2 = image2.getRGB(x, y);
                String message = this.testPixels(this.mConverterType.getPictureType() == converter.getPictureType(), pixel1, pixel2, x, y, converter.getPictureType());
                Assert.assertNull((String)message, (Object)message);
            }
        }
    }

    @Test
    public void testImageToImageRandomColor() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        int w = 48;
        int h = 48;
        Random rnd = new Random();
        IConverter converter = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mConverterType.getPictureType(), (int)w, (int)h);
        BufferedImage image1 = new BufferedImage(w, h, this.mConverterType.getImageType());
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                Color c = new Color(rnd.nextInt(255), rnd.nextInt(255), rnd.nextInt(255));
                image1.setRGB(x, y, c.getRGB());
            }
        }
        BufferedImage image2 = converter.toImage(converter.toPicture(image1, 0L));
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel1 = image1.getRGB(x, y);
                int pixel2 = image2.getRGB(x, y);
                String message = this.testPixels(this.mConverterType.getPictureType() == converter.getPictureType(), pixel1, pixel2, x, y, converter.getPictureType());
                Assert.assertNull((String)message, (Object)message);
            }
        }
    }

    @Test
    public void testPictureToPictureWithRotate() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        int size = 48;
        int black = Color.BLACK.getRGB();
        int white = Color.WHITE.getRGB();
        IConverter converter = ConverterFactory.createConverter((String)this.mConverterType.getDescriptor(), (IPixelFormat.Type)this.mConverterType.getPictureType(), (int)size, (int)size);
        BufferedImage image1 = new BufferedImage(size, size, this.mConverterType.getImageType());
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                int color = x % 2 == 0 ? black : white;
                image1.setRGB(x, y, color);
            }
        }
        BufferedImage image2 = converter.toImage(converter.toPicture(image1, 0L));
        AffineTransform t = AffineTransform.getRotateInstance(1.5707963267948966, image2.getWidth() / 2, image2.getHeight() / 2);
        AffineTransformOp ato = new AffineTransformOp(t, 3);
        BufferedImage image3 = new BufferedImage(size, size, this.mConverterType.getImageType());
        image3 = ato.filter(image2, image3);
        BufferedImage image4 = converter.toImage(converter.toPicture(image3, 0L));
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                int pixel1 = y % 2 == 0 ? black : white;
                int pixel2 = image4.getRGB(x, y);
                String message = this.testPixels(this.mConverterType.getPictureType() == converter.getPictureType(), pixel1, pixel2, x, y, converter.getPictureType());
                Assert.assertNull((String)message, (Object)message);
            }
        }
    }

    private String testPixels(boolean exact, int pixel1, int pixel2, int x, int y, IPixelFormat.Type pixelType) {
        String message = "Color value missmatch whith pixel type " + pixelType + ", converter " + this.mConverterType + ", at pixel (" + x + "," + y + ").  Value is " + pixel2 + " but should be " + pixel1 + ".";
        if (exact) {
            return pixel1 == pixel2 ? null : message;
        }
        int margin = 8;
        Color c1 = new Color(pixel1);
        Color c2 = new Color(pixel2);
        if (!(ConverterFactoryTest.closeEnough(c1.getRed(), c2.getRed(), margin) && ConverterFactoryTest.closeEnough(c1.getGreen(), c2.getGreen(), margin) && ConverterFactoryTest.closeEnough(c1.getBlue(), c2.getBlue(), margin))) {
            System.out.println("missmatch at: (" + x + "x" + y + ")");
            System.out.println("red:   " + c1.getRed() + " vs. " + c2.getRed());
            System.out.println("green: " + c1.getGreen() + " vs. " + c2.getGreen());
            System.out.println("blue:  " + c1.getBlue() + " vs. " + c2.getBlue());
            return message;
        }
        return null;
    }

    private static boolean closeEnough(int v1, int v2, int margin) {
        return Math.abs(v2 - v1) <= margin;
    }
}

