/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericRange
extends AbstractNumericRange<Double> {
    protected double _min;
    protected double _max;

    public NumericRange() {
        this(0.0, 1.0);
    }

    public NumericRange(double d, double d2) {
        this._min = Math.min(d, d2);
        this._max = Math.max(d, d2);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public double getMin() {
        return this._min;
    }

    public void setMin(double d) {
        double d2 = this._min;
        if (d2 == d) {
            return;
        }
        assert (d <= this._max);
        this._min = d;
        this.firePropertyChange("min", d2, d);
    }

    public double getMax() {
        return this._max;
    }

    public void setMax(double d) {
        double d2 = this._max;
        if (d2 == d) {
            return;
        }
        assert (d >= this._min);
        this._max = d;
        this.firePropertyChange("max", d2, d);
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public void adjust(Double d, Double d2) {
        this.setMin(d);
        this.setMax(d2);
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    @Override
    public boolean contains(Double d) {
        return d != null && d >= this._min && d <= this._max;
    }

    public boolean equals(Object object) {
        if (object instanceof NumericRange) {
            NumericRange numericRange = (NumericRange)object;
            return this._min == numericRange._min && this._max == numericRange._max;
        }
        return false;
    }

    public String toString() {
        return String.format("#<NumericRange min=%f max=%f>", this._min, this._max);
    }
}

