/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import java.util.Arrays;
import jpcsp.Allegrex.BcuState;

public class FpuState
extends BcuState {
    public float[] fpr;
    public Fcr31 fcr31;

    @Override
    public void reset() {
        Arrays.fill(this.fpr, 0.0f);
        this.fcr31.reset();
    }

    @Override
    public void resetAll() {
        super.resetAll();
        Arrays.fill(this.fpr, 0.0f);
        this.fcr31.reset();
    }

    public FpuState() {
        this.fpr = new float[32];
        this.fcr31 = new Fcr31();
    }

    public void copy(FpuState that) {
        super.copy(that);
        System.arraycopy(that.fpr, 0, this.fpr, 0, this.fpr.length);
        this.fcr31.copy(that.fcr31);
    }

    public FpuState(FpuState that) {
        super(that);
        this.fpr = (float[])that.fpr.clone();
        this.fcr31 = new Fcr31(that.fcr31);
    }

    public void doMFC1(int rt, int c1dr) {
        if (rt != 0) {
            this.gpr[rt] = Float.floatToRawIntBits(this.fpr[c1dr]);
        }
    }

    public void doCFC1(int rt, int c1cr) {
        if (rt != 0) {
            switch (c1cr) {
                case 0: {
                    this.gpr[rt] = 0;
                    break;
                }
                case 31: {
                    this.gpr[rt] = (this.fcr31.fs ? 0x1000000 : 0) | (this.fcr31.c ? 0x800000 : 0) | this.fcr31.rm & 3;
                    break;
                }
                default: {
                    this.doUNK("Unsupported cfc1 instruction for fcr" + Integer.toString(c1cr));
                }
            }
        }
    }

    public void doMTC1(int rt, int c1dr) {
        this.fpr[c1dr] = Float.intBitsToFloat(this.gpr[rt]);
    }

    public void doCTC1(int rt, int c1cr) {
        switch (c1cr) {
            case 31: {
                int bits = this.gpr[rt] & 0x1800003;
                this.fcr31.rm = bits & 3;
                this.fcr31.fs = (bits >> 24 & 1) != 0;
                this.fcr31.c = (bits >> 23 & 1) != 0;
                break;
            }
            default: {
                this.doUNK("Unsupported ctc1 instruction for fcr" + Integer.toString(c1cr));
            }
        }
    }

    public boolean doBC1F(int simm16) {
        this.npc = !this.fcr31.c ? FpuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBC1T(int simm16) {
        this.npc = this.fcr31.c ? FpuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBC1FL(int simm16) {
        if (!this.fcr31.c) {
            this.npc = FpuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public boolean doBC1TL(int simm16) {
        if (this.fcr31.c) {
            this.npc = FpuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public void doADDS(int fd, int fs, int ft) {
        this.fpr[fd] = this.fpr[fs] + this.fpr[ft];
    }

    public void doSUBS(int fd, int fs, int ft) {
        this.fpr[fd] = this.fpr[fs] - this.fpr[ft];
    }

    public void doMULS(int fd, int fs, int ft) {
        this.fpr[fd] = this.fpr[fs] * this.fpr[ft];
    }

    public void doDIVS(int fd, int fs, int ft) {
        this.fpr[fd] = this.fpr[fs] / this.fpr[ft];
    }

    public void doSQRTS(int fd, int fs) {
        this.fpr[fd] = (float)Math.sqrt(this.fpr[fs]);
    }

    public void doABSS(int fd, int fs) {
        this.fpr[fd] = Math.abs(this.fpr[fs]);
    }

    public void doMOVS(int fd, int fs) {
        this.fpr[fd] = this.fpr[fs];
    }

    public void doNEGS(int fd, int fs) {
        this.fpr[fd] = 0.0f - this.fpr[fs];
    }

    public void doROUNDWS(int fd, int fs) {
        this.fpr[fd] = Float.intBitsToFloat(Math.round(this.fpr[fs]));
    }

    public void doTRUNCWS(int fd, int fs) {
        this.fpr[fd] = Float.intBitsToFloat((int)this.fpr[fs]);
    }

    public void doCEILWS(int fd, int fs) {
        this.fpr[fd] = Float.intBitsToFloat((int)Math.ceil(this.fpr[fs]));
    }

    public void doFLOORWS(int fd, int fs) {
        this.fpr[fd] = Float.intBitsToFloat((int)Math.floor(this.fpr[fs]));
    }

    public void doCVTSW(int fd, int fs) {
        this.fpr[fd] = Float.floatToRawIntBits(this.fpr[fs]);
    }

    public void doCVTWS(int fd, int fs) {
        switch (this.fcr31.rm) {
            case 1: {
                this.fpr[fd] = Float.intBitsToFloat((int)this.fpr[fs]);
                break;
            }
            case 2: {
                this.fpr[fd] = Float.intBitsToFloat((int)Math.ceil(this.fpr[fs]));
                break;
            }
            case 3: {
                this.fpr[fd] = Float.intBitsToFloat((int)Math.floor(this.fpr[fs]));
                break;
            }
            default: {
                this.fpr[fd] = Float.intBitsToFloat((int)Math.rint(this.fpr[fs]));
            }
        }
    }

    public void doCCONDS(int fs, int ft, int cond) {
        float x = this.fpr[fs];
        float y = this.fpr[ft];
        if (Float.isNaN(x) || Float.isNaN(y)) {
            this.fcr31.c = (cond & 1) != 0;
        } else {
            boolean equal = (cond & 2) != 0 && x == y;
            boolean less = (cond & 4) != 0 && x < y;
            this.fcr31.c = less || equal;
        }
    }

    public void doLWC1(int ft, int rs, int simm16) {
        this.fpr[ft] = Float.intBitsToFloat(memory.read32(this.gpr[rs] + simm16));
    }

    public void doSWC1(int ft, int rs, int simm16) {
        memory.write32(this.gpr[rs] + simm16, Float.floatToRawIntBits(this.fpr[ft]));
    }

    public class Fcr31 {
        public int rm;
        public boolean c;
        public boolean fs;

        public void reset() {
            this.rm = 0;
            this.c = false;
            this.fs = false;
        }

        public Fcr31() {
            this.reset();
        }

        public Fcr31(Fcr31 that) {
            this.rm = that.rm;
            this.c = that.c;
            this.fs = that.fs;
        }

        public void copy(Fcr31 that) {
            this.rm = that.rm;
            this.c = that.c;
            this.fs = that.fs;
        }
    }

    public static final class Fcr0 {
        public static final int imp = 0;
        public static final int rev = 0;
    }
}

