/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import java.util.Iterator;
import jpcsp.Debugger.StepFrame;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.ThreadManForUser;

public class DumpDebugState {
    public static void dumpDebugState() {
        DumpDebugState.log("------------------------------------------------------------");
        if (DumpDebugState.isGameLoaded()) {
            DumpDebugState.dumpCurrentFrame();
            DumpDebugState.dumpThreads();
            Modules.SysMemUserForUserModule.dumpSysMemInfo();
        } else {
            DumpDebugState.log("No game loaded");
        }
        DumpDebugState.log("------------------------------------------------------------");
    }

    public static void dumpThreads() {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            DumpDebugState.log("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            DumpDebugState.log(String.format("Thread Name: '%s' ID: 0x%04X Module ID: 0x%04X", thread.name, thread.uid, thread.moduleid));
            DumpDebugState.log(String.format("Thread Status: 0x%08X %s", thread.status, thread.getStatusName()));
            DumpDebugState.log(String.format("Thread Attr: 0x%08X Current Priority: 0x%02X Initial Priority: 0x%02X", thread.attr, thread.currentPriority, thread.initPriority));
            DumpDebugState.log(String.format("Thread Entry: 0x%08X Stack: 0x%08X - 0x%08X Stack Size: 0x%08X", thread.entry_addr, thread.getStackAddr(), thread.getStackAddr() + thread.stackSize, thread.stackSize));
            DumpDebugState.log(String.format("Thread Run Clocks: %d Exit Code: 0x%08X", thread.runClocks, thread.exitStatus));
            DumpDebugState.log(String.format("Thread Wait Type: %s Us: %d Forever: %s", thread.getWaitName(), thread.wait.micros, thread.wait.forever));
        }
    }

    public static void dumpCurrentFrame() {
        StepFrame frame = new StepFrame();
        frame.make(Emulator.getProcessor().cpu);
        DumpDebugState.log(frame.getMessage());
    }

    private static boolean isGameLoaded() {
        return Modules.ThreadManForUserModule.getCurrentThreadID() != -1;
    }

    public static void log(String msg) {
        System.err.println(msg);
        Modules.log.error((Object)msg);
    }
}

