/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.emulator;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.Memory;
import jpcsp.autotests.AutoTestsOutput;

public class EmulatorVirtualFileSystem
extends AbstractVirtualFileSystem {
    public static final int EMULATOR_DEVCTL__GET_HAS_DISPLAY = 1;
    public static final int EMULATOR_DEVCTL__SEND_OUTPUT = 2;
    public static final int EMULATOR_DEVCTL__IS_EMULATOR = 3;

    @Override
    public int ioDevctl(String deviceName, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        switch (command) {
            case 1: {
                if (!outputPointer.isAddressGood() || outputLength < 4) {
                    return super.ioDevctl(deviceName, command, inputPointer, inputLength, outputPointer, outputLength);
                }
                outputPointer.setValue32(1);
                break;
            }
            case 2: {
                AutoTestsOutput.appendString(new String(Memory.getInstance().readChunk(inputPointer.getAddress(), inputLength).array()));
                break;
            }
            case 3: {
                break;
            }
            default: {
                return super.ioDevctl(deviceName, command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return 0;
    }
}

