/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelFplInfo;
import jpcsp.HLE.kernel.types.SceKernelFplOptParam;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class FplManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelFplInfo> fplMap;
    private FplWaitStateChecker fplWaitStateChecker;
    private static final int PSP_FPL_ATTR_FIFO = 0;
    private static final int PSP_FPL_ATTR_PRIORITY = 256;
    private static final int PSP_FPL_ATTR_MASK = 16895;
    private static final int PSP_FPL_ATTR_ADDR_HIGH = 16384;
    public static final FplManager singleton = new FplManager();

    public void reset() {
        this.fplMap = new HashMap();
        this.fplWaitStateChecker = new FplWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelFplInfo fpl = this.fplMap.get(thread.wait.Fpl_id);
        if (fpl != null) {
            --fpl.numWaitThreads;
            if (fpl.numWaitThreads < 0) {
                log.warn((Object)("removing waiting thread " + Integer.toHexString(thread.uid) + ", fpl " + Integer.toHexString(fpl.uid) + " numWaitThreads underflowed"));
                fpl.numWaitThreads = 0;
            }
            return true;
        }
        return false;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352152;
        } else {
            log.warn((Object)"FPL deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(7)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onFplDeletedCancelled(int fid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(7) || thread.wait.Fpl_id != fid) continue;
            thread.cpuContext.gpr[2] = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onFplDeleted(int fid) {
        this.onFplDeletedCancelled(fid, -2147352139);
    }

    private void onFplCancelled(int fid) {
        this.onFplDeletedCancelled(fid, -2147352151);
    }

    private void onFplFree(SceKernelFplInfo info) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        if ((info.attr & 0x100) == 0) {
            Iterator<SceKernelThreadInfo> it = threadMan.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(7) || thread.wait.Fpl_id != info.uid) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onFplFree waking thread %s", thread.toString()));
                }
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        } else if ((info.attr & 0x100) == 256) {
            Iterator<SceKernelThreadInfo> it = threadMan.iteratorByPriority();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(7) || thread.wait.Fpl_id != info.uid) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onFplFree waking thread %s", thread.toString()));
                }
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private int tryAllocateFpl(SceKernelFplInfo info) {
        int block;
        int addr = 0;
        if (info.freeBlocks == 0 || (block = info.findFreeBlock()) == -1) {
            log.warn((Object)("tryAllocateFpl no free blocks (numBlocks=" + info.numBlocks + ")"));
            return 0;
        }
        addr = info.allocateBlock(block);
        return addr;
    }

    public void sceKernelCreateFpl(int name_addr, int partitionid, int attr, int blocksize, int blocks, int opt_addr) {
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Processor.memory;
        String name = Utilities.readStringZ(name_addr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCreateFpl(name='" + name + "',partition=" + partitionid + ",attr=0x" + Integer.toHexString(attr) + ",blocksize=0x" + Integer.toHexString(blocksize) + ",blocks=" + blocks + ",opt=0x" + Integer.toHexString(opt_addr) + ")"));
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        int memAlign = 4;
        if (Memory.isAddressGood(opt_addr)) {
            int optsize = mem.read32(opt_addr);
            if (optsize >= 4 && optsize <= 8) {
                SceKernelFplOptParam optParams = new SceKernelFplOptParam();
                optParams.read(mem, opt_addr);
                if (optParams.align > 0) {
                    memAlign = optParams.align;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceKernelCreateFpl options: struct size=" + optParams.sizeof() + ", alignment=0x" + Integer.toHexString(optParams.align)));
                }
            } else {
                log.warn((Object)("sceKernelCreateFpl option at 0x" + Integer.toHexString(opt_addr) + " (size=" + optsize + ")"));
            }
        }
        if ((attr & 0xFFFFBE00) != 0) {
            log.warn((Object)("sceKernelCreateFpl bad attr value 0x" + Integer.toHexString(attr)));
            cpu.gpr[2] = -2147352175;
        } else if (blocksize == 0) {
            log.warn((Object)"sceKernelCreateFpl bad blocksize, cannot be 0");
            cpu.gpr[2] = -2147352137;
        } else {
            SceKernelFplInfo info = SceKernelFplInfo.tryCreateFpl(name, partitionid, attr, blocksize, blocks, memType, memAlign);
            if (info != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceKernelCreateFpl '" + name + "' assigned uid " + Integer.toHexString(info.uid)));
                }
                this.fplMap.put(info.uid, info);
                cpu.gpr[2] = info.uid;
            } else {
                cpu.gpr[2] = -2147352176;
            }
        }
    }

    public void sceKernelDeleteFpl(int uid) {
        CpuState cpu = Emulator.getProcessor().cpu;
        String msg = "sceKernelDeleteFpl(uid=0x" + Integer.toHexString(uid) + ")";
        SceKernelFplInfo info = this.fplMap.remove(uid);
        if (info == null) {
            log.warn((Object)(msg + " unknown uid"));
            cpu.gpr[2] = -2147352163;
        } else {
            msg = msg + " '" + info.name + "'";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            if (info.freeBlocks < info.numBlocks) {
                log.warn((Object)(msg + " " + (info.numBlocks - info.freeBlocks) + " unfreed blocks, continuing"));
            }
            info.deleteSysMemInfo();
            cpu.gpr[2] = 0;
            this.onFplDeleted(uid);
        }
    }

    private void hleKernelAllocateFpl(int uid, int data_addr, int timeout_addr, boolean wait, boolean doCallbacks) {
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleKernelAllocateFpl uid=0x" + Integer.toHexString(uid) + " data_addr=0x" + Integer.toHexString(data_addr) + " timeout_addr=0x" + Integer.toHexString(timeout_addr) + " callbacks=" + doCallbacks));
        }
        SceUidManager.checkUidPurpose(uid, "ThreadMan-Fpl", true);
        SceKernelFplInfo fpl = this.fplMap.get(uid);
        if (fpl == null) {
            log.warn((Object)("hleKernelAllocateFpl unknown uid=0x" + Integer.toHexString(uid)));
            Emulator.getProcessor().cpu.gpr[2] = -2147352163;
        } else {
            int addr = this.tryAllocateFpl(fpl);
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            if (addr == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("hleKernelAllocateFpl - '" + fpl.name + "' fast check failed"));
                }
                if (wait) {
                    ++fpl.numWaitThreads;
                    SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
                    currentThread.wait.Fpl_id = uid;
                    currentThread.wait.Fpl_dataAddr = data_addr;
                    threadMan.hleKernelThreadEnterWaitState(7, uid, this.fplWaitStateChecker, timeout_addr, doCallbacks);
                } else {
                    cpu.gpr[2] = -2147352153;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("hleKernelAllocateFpl - '" + fpl.name + "' fast check succeeded"));
                }
                mem.write32(data_addr, addr);
                cpu.gpr[2] = 0;
            }
        }
    }

    public void sceKernelAllocateFpl(int uid, int data_addr, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelAllocateFpl redirecting to hleKernelAllocateFpl(callbacks=false)");
        }
        this.hleKernelAllocateFpl(uid, data_addr, timeout_addr, true, false);
    }

    public void sceKernelAllocateFplCB(int uid, int data_addr, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelAllocateFplCB redirecting to hleKernelAllocateFpl(callbacks=true)");
        }
        this.hleKernelAllocateFpl(uid, data_addr, timeout_addr, true, true);
    }

    public void sceKernelTryAllocateFpl(int uid, int data_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelTryAllocateFpl redirecting to hleKernelAllocateFpl");
        }
        this.hleKernelAllocateFpl(uid, data_addr, 0, false, false);
    }

    public void sceKernelFreeFpl(int uid, int data_addr) {
        SceKernelFplInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelFreeFpl(uid=0x" + Integer.toHexString(uid) + ",data=0x" + Integer.toHexString(data_addr) + ")"));
        }
        if ((info = this.fplMap.get(uid)) == null) {
            log.warn((Object)"sceKernelFreeFpl unknown uid");
            cpu.gpr[2] = -2147352163;
        } else {
            int block = info.findBlockByAddress(data_addr);
            if (block == -1) {
                log.warn((Object)("sceKernelFreeFpl unknown block address=0x" + Integer.toHexString(data_addr)));
                cpu.gpr[2] = -2147352138;
            } else {
                info.freeBlock(block);
                cpu.gpr[2] = 0;
                this.onFplFree(info);
            }
        }
    }

    public void sceKernelCancelFpl(int uid, int numWaitThreadAddr) {
        SceKernelFplInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCancelFpl(uid=0x" + Integer.toHexString(uid) + ",numWaitThreadAddr=0x" + Integer.toHexString(numWaitThreadAddr) + ")"));
        }
        if ((info = this.fplMap.get(uid)) == null) {
            log.warn((Object)("sceKernelCancelFpl unknown uid=0x" + Integer.toHexString(uid)));
            cpu.gpr[2] = -2147352163;
        } else {
            Memory mem = Memory.getInstance();
            if (Memory.isAddressGood(numWaitThreadAddr)) {
                mem.write32(numWaitThreadAddr, info.numWaitThreads);
            }
            cpu.gpr[2] = 0;
            this.onFplCancelled(uid);
        }
    }

    public void sceKernelReferFplStatus(int uid, int info_addr) {
        SceKernelFplInfo info;
        CpuState cpu = Emulator.getProcessor().cpu;
        Memory mem = Processor.memory;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReferFplStatus(uid=0x" + Integer.toHexString(uid) + ",info_addr=0x" + Integer.toHexString(info_addr) + ")"));
        }
        if ((info = this.fplMap.get(uid)) == null) {
            log.warn((Object)("sceKernelReferFplStatus unknown uid=0x" + Integer.toHexString(uid)));
            cpu.gpr[2] = -2147352163;
        } else {
            info.write(mem, info_addr);
            cpu.gpr[2] = 0;
        }
    }

    private FplManager() {
    }

    private class FplWaitStateChecker
    implements IWaitStateChecker {
        private FplWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelFplInfo fpl = (SceKernelFplInfo)FplManager.this.fplMap.get(wait.Fpl_id);
            if (fpl == null) {
                thread.cpuContext.gpr[2] = -2147352163;
                return false;
            }
            if (FplManager.this.tryAllocateFpl(fpl) != 0) {
                --fpl.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                return false;
            }
            return true;
        }
    }
}

