/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelLwMutexInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class LwMutexManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelLwMutexInfo> lwMutexMap;
    private LwMutexWaitStateChecker lwMutexWaitStateChecker;
    private static final int PSP_LWMUTEX_ATTR_FIFO = 0;
    private static final int PSP_LWMUTEX_ATTR_PRIORITY = 256;
    private static final int PSP_LWMUTEX_ATTR_ALLOW_RECURSIVE = 512;
    public static final LwMutexManager singleton = new LwMutexManager();

    public void reset() {
        this.lwMutexMap = new HashMap();
        this.lwMutexWaitStateChecker = new LwMutexWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelLwMutexInfo info = this.lwMutexMap.get(thread.wait.LwMutex_id);
        if (info != null) {
            --info.numWaitThreads;
            if (info.numWaitThreads < 0) {
                log.warn((Object)("removing waiting thread " + Integer.toHexString(thread.uid) + ", lwmutex " + Integer.toHexString(info.uid) + " numWaitThreads underflowed"));
                info.numWaitThreads = 0;
            }
            return true;
        }
        return false;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352152;
        } else {
            log.warn((Object)"LwMutex deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext.gpr[2] = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext.gpr[2] = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(13)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onLwMutexDeleted(int lwmid) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(13) || thread.wait.LwMutex_id != lwmid) continue;
            thread.cpuContext.gpr[2] = -2147352139;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onLwMutexModified(SceKernelLwMutexInfo info) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        if ((info.attr & 0x100) == 0) {
            Iterator<SceKernelThreadInfo> it = Modules.ThreadManForUserModule.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(13) || thread.wait.LwMutex_id != info.uid || !this.tryLockLwMutex(info, thread.wait.LwMutex_count, thread)) continue;
                info.threadid = thread.uid;
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        } else if ((info.attr & 0x100) == 256) {
            Iterator<SceKernelThreadInfo> it = Modules.ThreadManForUserModule.iteratorByPriority();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(13) || thread.wait.LwMutex_id != info.uid || !this.tryLockLwMutex(info, thread.wait.LwMutex_count, thread)) continue;
                info.threadid = thread.uid;
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        }
        if (reschedule) {
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        }
    }

    private boolean tryLockLwMutex(SceKernelLwMutexInfo info, int count, SceKernelThreadInfo thread) {
        if (info.lockedCount == 0) {
            info.threadid = thread.uid;
            info.lockedCount += count;
            return true;
        }
        if (info.threadid == thread.uid && (info.attr & 0x200) == 512) {
            info.lockedCount += count;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int hleKernelLockLwMutex(int uid, int count, int timeout_addr, boolean wait, boolean doCallbacks) {
        SceKernelLwMutexInfo info = this.lwMutexMap.get(uid);
        if (info == null) {
            log.warn((Object)String.format("hleKernelLockLwMutex uid=%d, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b -  - unknown UID", uid, count, timeout_addr, wait, doCallbacks));
            return -2147352118;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
        if (this.tryLockLwMutex(info, count, currentThread)) {
            if (!log.isDebugEnabled()) return 0;
            log.debug((Object)String.format("hleKernelLockLwMutex %s, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - fast check succeeded", info.toString(), count, timeout_addr, wait, doCallbacks));
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelLockLwMutex %s, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - fast check failed", info.toString(), count, timeout_addr, wait, doCallbacks));
        }
        if (wait && info.threadid != currentThread.uid) {
            ++info.numWaitThreads;
            currentThread.wait.LwMutex_id = uid;
            currentThread.wait.LwMutex_count = count;
            threadMan.hleKernelThreadEnterWaitState(13, uid, this.lwMutexWaitStateChecker, timeout_addr, doCallbacks);
            return 0;
        }
        if ((info.attr & 0x200) == 512) return -2147352117;
        return -2147352113;
    }

    public int sceKernelCreateLwMutex(int workAreaAddr, int name_addr, int attr, int count, int option_addr) {
        Memory mem = Processor.memory;
        String name = Utilities.readStringNZ(mem, name_addr, 32);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCreateLwMutex (workAreaAddr='" + Integer.toHexString(workAreaAddr) + "', name='" + name + "', attr=0x" + Integer.toHexString(attr) + ", count=0x" + Integer.toHexString(count) + ", option_addr=0x" + Integer.toHexString(option_addr) + ")"));
        }
        SceKernelLwMutexInfo info = new SceKernelLwMutexInfo(workAreaAddr, name, count, attr);
        this.lwMutexMap.put(info.uid, info);
        if (count > 0) {
            info.threadid = Modules.ThreadManForUserModule.getCurrentThreadID();
        }
        return 0;
    }

    public int sceKernelDeleteLwMutex(int workAreaAddr) {
        SceKernelLwMutexInfo info;
        Memory mem = Processor.memory;
        int uid = mem.read32(workAreaAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelDeleteLwMutex (workAreaAddr='" + Integer.toHexString(workAreaAddr) + ")"));
        }
        if ((info = this.lwMutexMap.remove(uid)) == null) {
            log.warn((Object)("sceKernelDeleteLwMutex unknown UID " + Integer.toHexString(uid)));
            return -2147352118;
        }
        mem.write32(workAreaAddr, 0);
        this.onLwMutexDeleted(uid);
        return 0;
    }

    public int sceKernelLockLwMutex(int workAreaAddr, int count, int timeout_addr) {
        Memory mem = Processor.memory;
        int uid = mem.read32(workAreaAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelLockLwMutex redirecting to hleKernelLockLwMutex");
        }
        return this.hleKernelLockLwMutex(uid, count, timeout_addr, true, false);
    }

    public int sceKernelLockLwMutexCB(int workAreaAddr, int count, int timeout_addr) {
        Memory mem = Processor.memory;
        int uid = mem.read32(workAreaAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelLockLwMutexCB redirecting to hleKernelLockLwMutex");
        }
        return this.hleKernelLockLwMutex(uid, count, timeout_addr, true, true);
    }

    public int sceKernelTryLockLwMutex(int workAreaAddr, int count) {
        Memory mem = Processor.memory;
        int uid = mem.read32(workAreaAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelTryLockLwMutex redirecting to hleKernelLockLwMutex");
        }
        return this.hleKernelLockLwMutex(uid, count, 0, false, false);
    }

    public int sceKernelUnlockLwMutex(int workAreaAddr, int count) {
        SceKernelLwMutexInfo info;
        Memory mem = Processor.memory;
        int uid = mem.read32(workAreaAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelUnlockLwMutex (workAreaAddr=0x" + Integer.toHexString(workAreaAddr) + ", count=" + count + ")"));
        }
        if ((info = this.lwMutexMap.get(uid)) == null) {
            log.warn((Object)"sceKernelUnlockLwMutex unknown uid");
            return -2147352118;
        }
        if (info.lockedCount == 0) {
            log.debug((Object)"sceKernelUnlockLwMutex not locked");
            return -2147352116;
        }
        if (info.lockedCount < 0) {
            log.warn((Object)"sceKernelUnlockLwMutex underflow");
            return -2147352114;
        }
        info.lockedCount -= count;
        if (info.lockedCount == 0) {
            this.onLwMutexModified(info);
        }
        return 0;
    }

    public int sceKernelReferLwMutexStatus(int workAreaAddr, int addr) {
        SceKernelLwMutexInfo info;
        Memory mem = Processor.memory;
        int uid = mem.read32(workAreaAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReferLwMutexStatus (workAreaAddr=0x" + Integer.toHexString(workAreaAddr) + ", addr=0x" + addr + ")"));
        }
        if ((info = this.lwMutexMap.get(uid)) == null) {
            log.warn((Object)("sceKernelReferLwMutexStatus unknown UID " + Integer.toHexString(uid)));
            return -2147352118;
        }
        if (!Memory.isAddressGood(addr)) {
            log.warn((Object)("sceKernelReferLwMutexStatus bad address 0x" + Integer.toHexString(addr)));
            return -1;
        }
        info.write(mem, addr);
        return 0;
    }

    public int sceKernelReferLwMutexStatusByID(int uid, int addr) {
        SceKernelLwMutexInfo info;
        Memory mem = Processor.memory;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReferLwMutexStatus (uid=0x" + Integer.toHexString(uid) + ", addr=0x" + addr + ")"));
        }
        if ((info = this.lwMutexMap.get(uid)) == null) {
            log.warn((Object)("sceKernelReferLwMutexStatus unknown UID " + Integer.toHexString(uid)));
            return -2147352118;
        }
        if (!Memory.isAddressGood(addr)) {
            log.warn((Object)("sceKernelReferLwMutexStatus bad address 0x" + Integer.toHexString(addr)));
            return -1;
        }
        info.write(mem, addr);
        return 0;
    }

    private LwMutexManager() {
    }

    private class LwMutexWaitStateChecker
    implements IWaitStateChecker {
        private LwMutexWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelLwMutexInfo info = (SceKernelLwMutexInfo)LwMutexManager.this.lwMutexMap.get(wait.LwMutex_id);
            if (info == null) {
                thread.cpuContext.gpr[2] = -2147352118;
                return false;
            }
            if (LwMutexManager.this.tryLockLwMutex(info, wait.LwMutex_count, thread)) {
                --info.numWaitThreads;
                thread.cpuContext.gpr[2] = 0;
                return false;
            }
            return true;
        }
    }
}

