/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import org.apache.log4j.Logger;

public class SystemTimeManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    public static final SystemTimeManager singleton = new SystemTimeManager();

    public void reset() {
    }

    public static long hleSysClock2USec(long sysclocks) {
        return sysclocks;
    }

    public static int hleSysClock2USec32(long sysclocks) {
        long micros64 = SystemTimeManager.hleSysClock2USec(sysclocks);
        int micros32 = (int)micros64;
        if (micros64 > Integer.MAX_VALUE) {
            micros32 = Integer.MAX_VALUE;
        } else if (micros64 < Integer.MIN_VALUE) {
            micros32 = Integer.MIN_VALUE;
        }
        return micros32;
    }

    public int sceKernelUSec2SysClock(int usec, TPointer64 sysClockAddr) {
        sysClockAddr.setValue(usec);
        return 0;
    }

    public long sceKernelUSec2SysClockWide(int usec) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelUSec2SysClockWide usec=%d", usec));
        }
        return (long)usec & 0xFFFFFFFFL;
    }

    public int sceKernelSysClock2USec(TPointer64 sysClockAddr, TPointer32 secAddr, TPointer32 microSecAddr) {
        long sysClock = sysClockAddr.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelSysClock2USec sysClockAddr=%s(%d), secAddr=%s, microSecAddr=%s", sysClockAddr, sysClock, secAddr, microSecAddr));
        }
        secAddr.setValue((int)(sysClock / 1000000L));
        microSecAddr.setValue((int)(sysClock % 1000000L));
        return 0;
    }

    public int sceKernelSysClock2USecWide(long sysClock, TPointer32 secAddr, TPointer32 microSecAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelSysClock2USecWide sysClock=%d, secAddr=%s, microSecAddr=%s", sysClock, secAddr, microSecAddr));
        }
        secAddr.setValue((int)(sysClock / 1000000L));
        microSecAddr.setValue((int)(sysClock % 1000000L));
        return 0;
    }

    public static long getSystemTime() {
        return Emulator.getClock().microTime();
    }

    public int sceKernelGetSystemTime(TPointer64 time_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetSystemTime pointer=%s", time_addr));
        }
        long systemTime = SystemTimeManager.getSystemTime();
        time_addr.setValue(systemTime);
        return 0;
    }

    public long sceKernelGetSystemTimeWide() {
        long systemTime = SystemTimeManager.getSystemTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelGetSystemTimeWide ret:" + systemTime));
        }
        return systemTime;
    }

    public int sceKernelGetSystemTimeLow() {
        long systemTime = SystemTimeManager.getSystemTime();
        return (int)(systemTime & 0xFFFFFFFFL);
    }

    private SystemTimeManager() {
    }
}

