/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.Memory;

public class SceMpegRingbuffer {
    public int packets;
    public int packetsRead;
    public int packetsWritten;
    public int packetsFree;
    public int packetSize;
    public int data;
    public int callback_addr;
    public int callback_args;
    public int dataUpperBound;
    public int semaID;
    public int mpeg;

    public SceMpegRingbuffer(int packets, int data, int size, int callback_addr, int callback_args) {
        this.packets = packets;
        this.packetsRead = 0;
        this.packetsWritten = 0;
        this.packetsFree = 0;
        this.packetSize = 2048;
        this.data = data;
        this.callback_addr = callback_addr;
        this.callback_args = callback_args;
        this.dataUpperBound = data + packets * 2048;
        this.semaID = -1;
        this.mpeg = 0;
        if (this.dataUpperBound > data + size) {
            this.dataUpperBound = data + size;
            Modules.log.warn((Object)("SceMpegRingbuffer clamping dataUpperBound to " + this.dataUpperBound));
        }
    }

    private SceMpegRingbuffer() {
    }

    public static SceMpegRingbuffer fromMem(Memory mem, int address) {
        SceMpegRingbuffer ringbuffer = new SceMpegRingbuffer();
        ringbuffer.read(mem, address);
        return ringbuffer;
    }

    public void reset() {
        this.packetsRead = 0;
        this.packetsWritten = 0;
        this.packetsFree = this.packets;
    }

    public boolean isEmpty() {
        return this.packetsFree == this.packets;
    }

    public void read(Memory mem, int address) {
        this.packets = mem.read32(address);
        this.packetsRead = mem.read32(address + 4);
        this.packetsWritten = mem.read32(address + 8);
        this.packetsFree = mem.read32(address + 12);
        this.packetSize = mem.read32(address + 16);
        this.data = mem.read32(address + 20);
        this.callback_addr = mem.read32(address + 24);
        this.callback_args = mem.read32(address + 28);
        this.dataUpperBound = mem.read32(address + 32);
        this.semaID = mem.read32(address + 36);
        this.mpeg = mem.read32(address + 40);
    }

    public void write(Memory mem, int address) {
        mem.write32(address, this.packets);
        mem.write32(address + 4, this.packetsRead);
        mem.write32(address + 8, this.packetsWritten);
        mem.write32(address + 12, this.packetsFree);
        mem.write32(address + 16, this.packetSize);
        mem.write32(address + 20, this.data);
        mem.write32(address + 24, this.callback_addr);
        mem.write32(address + 28, this.callback_args);
        mem.write32(address + 32, this.dataUpperBound);
        mem.write32(address + 36, this.semaID);
        mem.write32(address + 40, this.mpeg);
    }

    public String toString() {
        return String.format("SceMpegRingbuffer(packets=%d, packetsRead=%d, packetsWritten=%d, packetsFree=%d, packetSize=%d)", this.packets, this.packetsRead, this.packetsWritten, this.packetsFree, this.packetSize);
    }
}

