/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.hardware.Interrupts;
import org.apache.log4j.Logger;

public class Kernel_Library
extends HLEModule {
    protected static Logger log = Modules.getLogger("Kernel_Library");
    private final int flagInterruptsEnabled = 1;
    private final int flagInterruptsDisabled = 0;

    @Override
    public String getName() {
        return "Kernel_Library";
    }

    @HLEFunction(nid=153708788, version=150)
    public int sceKernelCpuSuspendIntr() {
        int returnValue;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCpuSuspendIntr interruptsEnabled=" + Interrupts.isInterruptsEnabled()));
        }
        if (Interrupts.isInterruptsEnabled()) {
            returnValue = 1;
            Interrupts.disableInterrupts();
        } else {
            returnValue = 0;
        }
        return returnValue;
    }

    @HLEFunction(nid=1594938374, version=150)
    public void sceKernelCpuResumeIntr(int flagInterrupts) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCpuResumeIntr flag=" + flagInterrupts));
        }
        if (flagInterrupts == 1) {
            Interrupts.enableInterrupts();
        } else if (flagInterrupts == 0) {
            Interrupts.disableInterrupts();
        } else {
            log.warn((Object)("sceKernelCpuResumeIntr unknown flag value " + flagInterrupts));
        }
    }

    @HLEFunction(nid=998535981, version=150)
    public void sceKernelCpuResumeIntrWithSync(int flagInterrupts) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelCpuResumeIntrWithSync redirecting to sceKernelCpuResumeIntr");
        }
        this.sceKernelCpuResumeIntr(flagInterrupts);
    }

    @HLEFunction(nid=1201714985, version=150)
    public boolean sceKernelIsCpuIntrSuspended(int flagInterrupts) {
        log.warn((Object)("sceKernelIsCpuIntrSuspended flag=" + flagInterrupts));
        return flagInterrupts == 0;
    }

    @HLEFunction(nid=-1252898350, version=150)
    public boolean sceKernelIsCpuIntrEnable() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelIsCpuIntrEnable interruptsEnabled=" + Interrupts.isInterruptsEnabled()));
        }
        return Interrupts.isInterruptsEnabled();
    }
}

