/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class LoadCoreForKernel
extends HLEModule {
    private static Logger log = Modules.getLogger("LoadCoreForKernel");

    @Override
    public String getName() {
        return "LoadCoreForKernel";
    }

    @HLEFunction(nid=-1394461578, version=150)
    public void sceKernelCheckPspConfig(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelCheckPspConfig [0xACE23476]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=2078360092, version=150)
    public void sceKernelCheckExecFile(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelCheckExecFile [0x7BE1421C]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1080541454, version=150)
    public void sceKernelProbeExecutableObject(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelProbeExecutableObject [0xBF983EF2]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1885923002, version=150)
    public void sceKernelLoadExecutableObject(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelLoadExecutableObject [0x7068E6BA]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1260978484, version=150)
    public void sceKernelApplyElfRelSection(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelApplyElfRelSection [0xB4D6FECC]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1420502645, version=150)
    public void sceKernelApplyPspRelSection(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelApplyPspRelSection [0x54AB2675]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=693302700, version=150)
    public void sceKernelDcacheWBinvAll(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelDcacheWBinvAll [0x2952F5AC]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-663250234, version=150)
    public void sceKernelIcacheClearAll(Processor processor) {
        CpuState cpu = processor.cpu;
        log.trace((Object)"IGNORING:sceKernelIcacheClearAll");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1717135888, version=150)
    public void sceKernelRegisterLibrary(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelRegisterLibrary [0x99A695F0]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1483973407, version=150)
    public void sceKernelRegisterLibraryForUser(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelRegisterLibraryForUser [0x5873A31F]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=189154578, version=150)
    public void sceKernelReleaseLibrary(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelReleaseLibrary [0x0B464512]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1682992906, version=150)
    public void sceKernelCanReleaseLibrary(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelCanReleaseLibrary [0x9BAF90F6]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=242617786, version=150)
    public void sceKernelLinkLibraryEntries(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelLinkLibraryEntries [0x0E760DBA]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=232912384, version=150)
    public void sceKernelLinkLibraryEntriesForUser(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelLinkLibraryEntriesForUser [0x0DE1F600]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-635762262, version=150)
    public void sceKernelUnLinkLibraryEntries(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelUnLinkLibraryEntries [0xDA1B09AA]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-912403334, version=150)
    public void sceKernelQueryLoadCoreCB(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelQueryLoadCoreCB [0xC99DD47A]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1634716877, version=150)
    public void sceKernelSetBootCallbackLevel(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelSetBootCallbackLevel [0x616FCCCD]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1386769441, version=150)
    public void sceKernelGetModuleFromUID(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelGetModuleFromUID [0x52A86C21]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-854639700, version=150)
    public void sceKernelCreateModule(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelCreateModule [0xCD0F3BAC]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1797484994, version=150)
    public void sceKernelDeleteModule(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelDeleteModule [0x6B2371C2]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1920300338, version=150)
    public void sceKernelAssignModule(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelAssignModule [0x8D8A8ACE]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1342617644, version=150)
    public void sceKernelCreateAssignModule(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelCreateAssignModule [0xAFF947D4]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-1367576970, version=150)
    public void sceKernelRegisterModule(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelRegisterModule [0xAE7C6E76]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1959723034, version=150)
    public void sceKernelReleaseModule(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelReleaseModule [0x74CF001A]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=-813022799, version=150)
    public void sceKernelFindModuleByName(Processor processor) {
        CpuState cpu = processor.cpu;
        int modulename_addr = cpu.gpr[4];
        String name = Utilities.readStringZ(modulename_addr);
        log.debug((Object)("sceKernelFindModuleByName name='" + name + "'"));
        SceModule module = Managers.modules.getModuleByName(name);
        if (module != null) {
            cpu.gpr[2] = module.address;
        } else {
            log.warn((Object)("sceKernelFindModuleByName not found module name='" + name + "'"));
            cpu.gpr[2] = 0;
        }
        if (!Modules.ThreadManForUserModule.isKernelMode()) {
            log.error((Object)"kernel mode required (sceKernelFindModuleByName)");
            Emulator.PauseEmu();
        }
    }

    @HLEFunction(nid=-74784131, version=150)
    public void sceKernelFindModuleByAddress(Processor processor) {
        CpuState cpu = processor.cpu;
        int address = cpu.gpr[4];
        log.debug((Object)("sceKernelFindModuleByAddress address=" + String.format("0x%08X", address)));
        SceModule module = Managers.modules.getModuleByAddress(address);
        if (module != null) {
            log.debug((Object)("sceKernelFindModuleByAddress found module '" + module.modname + "'"));
            cpu.gpr[2] = module.address;
        } else {
            log.warn((Object)("sceKernelFindModuleByAddress not found module address=0x" + Integer.toHexString(address)));
            cpu.gpr[2] = 0;
        }
        if (!Modules.ThreadManForUserModule.isKernelMode()) {
            log.error((Object)"kernel mode required (sceKernelFindModuleByAddress)");
            Emulator.PauseEmu();
        }
    }

    @HLEFunction(nid=-857431721, version=150)
    public void sceKernelFindModuleByUID(Processor processor) {
        CpuState cpu = processor.cpu;
        int uid = cpu.gpr[4];
        log.debug((Object)("sceKernelFindModuleByUID uid=0x" + Integer.toHexString(uid)));
        SceModule module = Managers.modules.getModuleByUID(uid);
        if (module != null) {
            log.debug((Object)("sceKernelFindModuleByUID found module '" + module.modname + "'"));
            cpu.gpr[2] = module.address;
        } else {
            log.warn((Object)("sceKernelFindModuleByUID not found module uid=0x" + Integer.toHexString(uid)));
            cpu.gpr[2] = 0;
        }
        if (!Modules.ThreadManForUserModule.isKernelMode()) {
            log.error((Object)"kernel mode required (sceKernelFindModuleByUID)");
            Emulator.PauseEmu();
        }
    }

    @HLEFunction(nid=-1835312023, version=150)
    public void sceKernelGetModuleListWithAlloc(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelGetModuleListWithAlloc [0x929B5C69]");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=98112987, version=150)
    public void sceKernelGetModuleIdListForKernel(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"Unimplemented NID function sceKernelGetModuleIdListForKernel [0x05D915DB]");
        cpu.gpr[2] = -559038242;
    }
}

