/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class LoadExecForUser
extends HLEModule {
    protected static Logger log = Modules.getLogger("LoadExecForUser");
    protected int registeredExitCallbackUid;

    @Override
    public String getName() {
        return "LoadExecForUser";
    }

    public void triggerExitCallback() {
        Modules.ThreadManForUserModule.hleKernelNotifyCallback(5, 0);
    }

    @HLEFunction(nid=-1120989036, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadExec(PspString filename, @CanBeNull TPointer32 option_addr) {
        int optSize;
        String name = filename.getString();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceKernelLoadExec file=%s optionAddr=%s", filename, option_addr));
        }
        Modules.SysMemUserForUserModule.reset();
        byte[] arguments = null;
        int argSize = 0;
        if (!option_addr.isNull() && (optSize = option_addr.getValue(0)) >= 16) {
            argSize = option_addr.getValue(4);
            int argAddr = option_addr.getValue(8);
            int keyAddr = option_addr.getValue(12);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelLoadExec params: optSize=%d, argSize=%d, argAddr=0x%08X, keyAddr=0x%08X: %s", optSize, argSize, argAddr, keyAddr, Utilities.getMemoryDump(argAddr, argSize)));
            }
            arguments = new byte[argSize];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(argAddr, argSize, 1);
            for (int i = 0; i < argSize; ++i) {
                arguments[i] = (byte)memoryReader.readNext();
            }
        }
        try {
            SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(name, 1);
            if (moduleInput != null) {
                byte[] moduleBytes = new byte[(int)moduleInput.length()];
                moduleInput.readFully(moduleBytes);
                moduleInput.close();
                ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                SceModule module = Emulator.getInstance().load(name, moduleBuffer, true);
                Emulator.getClock().resume();
                int pathIndex = name.lastIndexOf("/");
                if (pathIndex >= 0) {
                    Modules.IoFileMgrForUserModule.setHost0Path(name.substring(0, pathIndex + 1));
                }
                if ((module.fileFormat & 1) != 1) {
                    log.warn((Object)"sceKernelLoadExec - failed, target is not an ELF");
                    throw new SceKernelErrorException(-2147352244);
                }
                SceKernelThreadInfo rootThread = Modules.ThreadManForUserModule.getCurrentThread();
                if (argSize > 0) {
                    IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(rootThread.cpuContext.gpr[5], argSize, 1);
                    for (int i = 0; i < argSize; ++i) {
                        memoryWriter.writeNext(arguments[i] & 0xFF);
                    }
                    memoryWriter.flush();
                }
                rootThread.cpuContext.gpr[4] = argSize;
            }
        }
        catch (GeneralJpcspException e) {
            log.error((Object)("General Error : " + e.getMessage()));
            Emulator.PauseEmu();
        }
        catch (IOException e) {
            log.error((Object)("sceKernelLoadExec - Error while loading module " + name + ": " + e.getMessage()));
            throw new SceKernelErrorException(-2147352249);
        }
        return 0;
    }

    @HLEFunction(nid=717854027, version=150, checkInsideInterrupt=true)
    public int sceKernelExitGameWithStatus(int status) {
        log.info((Object)("Program exit detected with status=" + status + " (sceKernelExitGameWithStatus)"));
        Emulator.PauseEmuWithStatus(status);
        RuntimeContext.reset();
        Modules.ThreadManForUserModule.stop();
        return 0;
    }

    @HLEFunction(nid=89598559, version=150, checkInsideInterrupt=true)
    public int sceKernelExitGame() {
        log.info((Object)"Program exit detected (sceKernelExitGame)");
        Emulator.PauseEmu();
        RuntimeContext.reset();
        Modules.ThreadManForUserModule.stop();
        return 0;
    }

    @HLEFunction(nid=1254455619, version=150, checkInsideInterrupt=true)
    public int sceKernelRegisterExitCallback(int uid) {
        log.info((Object)("sceKernelRegisterExitCallback SceUID=" + Integer.toHexString(uid)));
        if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(5, uid)) {
            this.registeredExitCallbackUid = uid;
        }
        return 0;
    }
}

